/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventClientException;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.IdentityEventServerException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.model.ChallengeQuestion;
import org.wso2.carbon.identity.recovery.model.UserChallengeAnswer;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class ChallengeAnswerValidationHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(ChallengeAnswerValidationHandler.class);

    public String getName() {
        return "challengeAnswerValidation";
    }

    public int getPriority(MessageContext messageContext) {
        return 50;
    }

    public void handleEvent(Event event) throws IdentityEventException {
        String eventName = event.getEventName();
        Map eventProperties = event.getEventProperties();
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        User user = (User)eventProperties.get("USER");
        UserChallengeAnswer[] userChallengeAnswers = (UserChallengeAnswer[])eventProperties.get("userChallengeAnswers");
        Map existingQuestionAndAnswers = (Map)eventProperties.get("userOldChallengeAnswers");
        user.setUserStoreDomain(userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName"));
        if ("PRE_SET_CHALLENGE_QUESTION_ANSWERS".equals(eventName)) {
            try {
                this.validateChallengeAnswers(user, userChallengeAnswers, existingQuestionAndAnswers);
            }
            catch (IdentityRecoveryClientException e) {
                throw new IdentityEventClientException(e.getErrorCode(), e.getMessage(), (Throwable)((Object)e));
            }
            catch (IdentityRecoveryServerException e) {
                throw new IdentityEventServerException(e.getErrorCode(), e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    private void validateChallengeAnswers(User user, UserChallengeAnswer[] userChallengeAnswers, Map<String, String> existingQuestionAndAnswers) throws IdentityEventException, IdentityRecoveryClientException, IdentityRecoveryServerException {
        Map<String, List<UserChallengeAnswer>> challengeAnswers = this.filterChallengeAnswers(userChallengeAnswers, existingQuestionAndAnswers);
        List<UserChallengeAnswer> existingChallengeAnswers = challengeAnswers.get("userOldChallengeAnswers");
        List<UserChallengeAnswer> newChallengeAnswers = challengeAnswers.get("userNewChallengeAnswers");
        this.validateChallengeAnswerRegex(user.getTenantDomain(), newChallengeAnswers);
        if (Boolean.parseBoolean(Utils.getConnectorConfig("Recovery.Question.Answer.Uniqueness", user.getTenantDomain()))) {
            this.validateChallengeAnswerUniqueness(newChallengeAnswers, existingChallengeAnswers);
        }
    }

    private Map<String, List<UserChallengeAnswer>> filterChallengeAnswers(UserChallengeAnswer[] userChallengeAnswers, Map<String, String> existingQuestionAndAnswers) {
        HashMap<String, List<UserChallengeAnswer>> challengeAnswers = new HashMap<String, List<UserChallengeAnswer>>();
        ArrayList<UserChallengeAnswer> existingChallengeAnswers = new ArrayList<UserChallengeAnswer>();
        ArrayList<UserChallengeAnswer> newChallengeAnswers = new ArrayList<UserChallengeAnswer>();
        String separator = IdentityUtil.getProperty((String)"Recovery.Question.Password.Separator");
        for (UserChallengeAnswer userChallengeAnswer : userChallengeAnswers) {
            ChallengeQuestion challengeQuestion = userChallengeAnswer.getQuestion();
            if (!StringUtils.isNotBlank((String)challengeQuestion.getQuestionSetId()) || !StringUtils.isNotBlank((String)challengeQuestion.getQuestion()) || !StringUtils.isNotBlank((String)userChallengeAnswer.getAnswer())) continue;
            String oldValue = existingQuestionAndAnswers.get(challengeQuestion.getQuestionSetId().trim());
            if (StringUtils.isNotBlank((String)oldValue) && oldValue.contains(separator)) {
                String oldAnswer = oldValue.split(separator)[1];
                if (oldAnswer.trim().equals(userChallengeAnswer.getAnswer().trim())) {
                    existingChallengeAnswers.add(userChallengeAnswer);
                    continue;
                }
                newChallengeAnswers.add(userChallengeAnswer);
                continue;
            }
            newChallengeAnswers.add(userChallengeAnswer);
        }
        challengeAnswers.put("userOldChallengeAnswers", existingChallengeAnswers);
        challengeAnswers.put("userNewChallengeAnswers", newChallengeAnswers);
        return challengeAnswers;
    }

    private void validateChallengeAnswerRegex(String tenantDomain, List<UserChallengeAnswer> newChallengeAnswers) throws IdentityRecoveryClientException, IdentityEventException {
        for (UserChallengeAnswer userChallengeAnswer : newChallengeAnswers) {
            String challengeQuestion = userChallengeAnswer.getQuestion().getQuestion();
            if (userChallengeAnswer.getAnswer().matches(Utils.getConnectorConfig("Recovery.Question.Answer.Regex", tenantDomain))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("The challenge question answer for the question, '%s' is not in the expected format.", challengeQuestion));
            }
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_ANSWER_FORMAT, challengeQuestion);
        }
    }

    private void validateChallengeAnswerUniqueness(List<UserChallengeAnswer> newChallengeAnswers, List<UserChallengeAnswer> existingChallengeAnswers) throws IdentityRecoveryServerException, IdentityRecoveryClientException {
        HashSet<String> uniqueChallengeAnswerHashSet = new HashSet<String>();
        for (UserChallengeAnswer existingChallengeAnswer : existingChallengeAnswers) {
            uniqueChallengeAnswerHashSet.add(existingChallengeAnswer.getAnswer().trim());
        }
        for (UserChallengeAnswer userChallengeAnswer : newChallengeAnswers) {
            String hashedNewChallengeAnswer;
            String challengeQuestion = userChallengeAnswer.getQuestion().getQuestion();
            try {
                hashedNewChallengeAnswer = Utils.doHash(userChallengeAnswer.getAnswer().trim().toLowerCase());
            }
            catch (UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_HASHING_ALGO, null);
            }
            if (uniqueChallengeAnswerHashSet.add(hashedNewChallengeAnswer)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("The challenge question answer is not unique. The given answer for the challenge question '%s' has been used more than once.", challengeQuestion));
            }
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NOT_UNIQUE_ANSWER, challengeQuestion);
        }
    }
}

