/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.handler.UserEmailVerificationHandler;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class AdminForcedPasswordResetHandler
extends UserEmailVerificationHandler {
    private static final Log log = LogFactory.getLog(AdminForcedPasswordResetHandler.class);

    @Override
    public void handleEvent(Event event) throws IdentityEventException {
        String eventName = event.getEventName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling event : " + eventName));
        }
        Map eventProperties = event.getEventProperties();
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        if ("PRE_SET_USER_CLAIMS".equals(eventName)) {
            this.handleClaimUpdate(eventProperties, userStoreManager);
        }
        if ("PRE_AUTHENTICATION".equals(eventName)) {
            this.handleAuthenticate(eventProperties, userStoreManager);
        }
    }

    protected void handleClaimUpdate(Map<String, Object> eventProperties, UserStoreManager userStoreManager) throws IdentityEventException {
        boolean adminPasswordResetRecoveryLink;
        boolean adminPasswordResetOTP;
        User user = this.getUser(eventProperties, userStoreManager);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PreAuthenticate - AdminForcedPasswordResetHandler for : " + user.toString()));
        }
        Map claims = (Map)eventProperties.get("USER_CLAIMS");
        boolean adminPasswordResetOffline = Boolean.parseBoolean(Utils.getConnectorConfig("Recovery.AdminPasswordReset.Offline", user.getTenantDomain()));
        boolean isAdminPasswordReset = adminPasswordResetOffline | (adminPasswordResetOTP = Boolean.parseBoolean(Utils.getConnectorConfig("Recovery.AdminPasswordReset.OTP", user.getTenantDomain()))) | (adminPasswordResetRecoveryLink = Boolean.parseBoolean(Utils.getConnectorConfig("Recovery.AdminPasswordReset.RecoveryLink", user.getTenantDomain())));
        if (isAdminPasswordReset && Boolean.valueOf((String)claims.get("http://wso2.org/claims/identity/adminForcedPasswordReset")).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"http://wso2.org/claims/identity/adminForcedPasswordReset update request.");
            }
            claims.remove("http://wso2.org/claims/identity/adminForcedPasswordReset");
            String OTP = this.generateOTPValue();
            String notificationType = "";
            RecoveryScenarios recoveryScenario = RecoveryScenarios.ADMIN_FORCED_PASSWORD_RESET_VIA_OTP;
            if (adminPasswordResetOffline) {
                if (claims.containsKey("http://wso2.org/claims/oneTimePassword")) {
                    claims.remove("http://wso2.org/claims/oneTimePassword");
                }
                this.setUserClaim("http://wso2.org/claims/oneTimePassword", OTP, userStoreManager, user);
            }
            if (adminPasswordResetOTP) {
                notificationType = "adminforcedpasswordresetwithotp".toString();
            }
            if (adminPasswordResetRecoveryLink) {
                OTP = UUIDGenerator.generateUUID();
                recoveryScenario = RecoveryScenarios.ADMIN_FORCED_PASSWORD_RESET_VIA_EMAIL_LINK;
                notificationType = "adminforcedpasswordreset".toString();
            }
            if (claims.containsKey("http://wso2.org/claims/identity/accountLocked")) {
                claims.remove("http://wso2.org/claims/identity/accountLocked");
            }
            this.setRecoveryData(user, recoveryScenario, RecoverySteps.UPDATE_PASSWORD, OTP);
            this.lockAccountOnAdminPasswordReset(user, userStoreManager);
            if (adminPasswordResetOTP | adminPasswordResetRecoveryLink) {
                try {
                    this.triggerNotification(user, notificationType, OTP, Utils.getArbitraryProperties());
                }
                catch (IdentityRecoveryException e) {
                    throw new IdentityEventException("Error while sending  notification ", (Throwable)((Object)e));
                }
            }
        }
    }

    protected void handleAuthenticate(Map<String, Object> eventProperties, UserStoreManager userStoreManager) throws IdentityEventException {
        UserRecoveryData userRecoveryData;
        User user = this.getUser(eventProperties, userStoreManager);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PreAuthenticate - AdminForcedPasswordResetHandler for user : " + user.toString()));
        }
        if ((userRecoveryData = this.getRecoveryData(user)) != null) {
            Enum recoveryScenario = userRecoveryData.getRecoveryScenario();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handling recovery scenario : " + recoveryScenario.toString() + " for user : " + user.toString()));
            }
            String errorCode = null;
            String errorMsg = "User : " + user.toString();
            boolean isForcedPasswordReset = false;
            if (RecoveryScenarios.ADMIN_FORCED_PASSWORD_RESET_VIA_EMAIL_LINK.equals(recoveryScenario)) {
                errorCode = "17006";
                errorMsg = errorMsg + " needs to reset the password using the given link in email";
                isForcedPasswordReset = true;
            } else if (RecoveryScenarios.ADMIN_FORCED_PASSWORD_RESET_VIA_OTP.equals(recoveryScenario)) {
                String credential = (String)eventProperties.get("CREDENTIAL");
                isForcedPasswordReset = true;
                if (userRecoveryData.getSecret().equals(credential)) {
                    errorCode = "17007";
                    errorMsg = errorMsg + " has given correct OTP";
                } else {
                    errorCode = "17008";
                    errorMsg = errorMsg + " has given in-correct OTP";
                }
            }
            if (isForcedPasswordReset) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMsg);
                }
                IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext(errorCode);
                IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                throw new IdentityEventException(errorMsg);
            }
        }
    }

    private void lockAccountOnAdminPasswordReset(User user, UserStoreManager userStoreManager) throws IdentityEventException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Locking user account on admin forced password reset: " + user.getUserName()));
        }
        HashMap<String, String> userClaims = new HashMap<String, String>();
        userClaims.put("http://wso2.org/claims/identity/accountLocked", Boolean.TRUE.toString());
        userClaims.put("http://wso2.org/claims/identity/accountState", "PENDING_FUPR");
        this.setUserClaims(userClaims, user, userStoreManager);
    }

    protected void setUserClaims(Map<String, String> userClaims, User user, UserStoreManager userStoreManager) throws IdentityEventException {
        try {
            userStoreManager.setUserClaimValues(user.getUserName(), userClaims, null);
        }
        catch (UserStoreException e) {
            throw new IdentityEventException("Error while setting user claim value :" + user.getUserName(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "adminForcedPasswordReset";
    }

    @Override
    public String getFriendlyName() {
        return "Admin Forced Password Reset";
    }

    @Override
    public int getPriority(MessageContext messageContext) {
        return 27;
    }

    private String generateOTPValue() {
        char[] chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < 6; ++i) {
            sb.append(chars[rnd.nextInt(chars.length)]);
        }
        return sb.toString();
    }
}

