/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.handler;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.signup.UserSelfRegistrationManager;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class AccountConfirmationValidationHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(AccountConfirmationValidationHandler.class);
    public static final String ACCOUNT_LOCKED_CLAIM = "http://wso2.org/claims/identity/accountLocked";

    public String getName() {
        return "accountConfirmationValidation";
    }

    public String getFriendlyName() {
        return "Account Confirmation Validation";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        Map eventProperties = event.getEventProperties();
        String userName = (String)eventProperties.get("user-name");
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        String tenantDomain = (String)eventProperties.get("tenant-domain");
        String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        User user = new User();
        user.setUserName(userName);
        user.setTenantDomain(tenantDomain);
        user.setUserStoreDomain(domainName);
        boolean enable = Boolean.parseBoolean(Utils.getConnectorConfig("SelfRegistration.Enable", user.getTenantDomain()));
        if (!enable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Self signup feature is disabled in the tenant: " + tenantDomain));
            }
            return;
        }
        if ("POST_AUTHENTICATION".equals(event.getEventName())) {
            boolean isAccountLocked;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handling PostAuthenticate for " + user));
            }
            try {
                if (this.isAuthPolicyAccountExistCheck() && !this.isUserExistsInDomain(userStoreManager, userName)) {
                    IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17001");
                    IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                    return;
                }
                Map values = userStoreManager.getUserClaimValues(userName, new String[]{ACCOUNT_LOCKED_CLAIM}, "default");
                isAccountLocked = Boolean.parseBoolean((String)values.get(ACCOUNT_LOCKED_CLAIM));
            }
            catch (UserStoreException e) {
                throw new IdentityEventException("Error while retrieving account lock claim value", (Throwable)e);
            }
            if (((Boolean)event.getEventProperties().get("OPERATION_STATUS")).booleanValue() && isAccountLocked && !this.isUserAccountConfirmed(user)) {
                IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17005");
                IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
                throw new IdentityEventException("17005", "User : " + userName + " not confirmed yet.");
            }
        }
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
    }

    public int getPriority(MessageContext messageContext) {
        return 50;
    }

    private boolean isUserAccountConfirmed(User user) throws IdentityEventException {
        boolean userConfirmed = false;
        try {
            userConfirmed = UserSelfRegistrationManager.getInstance().isUserConfirmed(user);
        }
        catch (IdentityRecoveryException e) {
            throw new IdentityEventException("Error occurred while checking whether this user is confirmed or not, " + e.getMessage(), (Throwable)((Object)e));
        }
        return userConfirmed;
    }

    private boolean isUserExistsInDomain(UserStoreManager userStoreManager, String userName) throws UserStoreException {
        boolean isExists = false;
        if (userStoreManager.isExistingUser(userName)) {
            isExists = true;
        }
        return isExists;
    }

    private boolean isAuthPolicyAccountExistCheck() {
        String authPolicyAccountExistCheck = IdentityUtil.getProperty((String)"AuthenticationPolicy.CheckAccountExist");
        return authPolicyAccountExistCheck == null || Boolean.parseBoolean(authPolicyAccountExistCheck);
    }
}

