/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.connector;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;

public class UserEmailVerificationConfigImpl
implements IdentityConnectorConfig {
    private static final String connectorName = "user-email-verification";
    private static final String CATEGORY = "User Onboarding";
    private static final String FRIENDLY_NAME = "Ask Password";
    private static final String LIST_PURPOSE_PROPERTY_KEY = "_url_listPurposeJITProvisioning";
    private static final String SYSTEM_PURPOSE_GROUP = "JIT";
    private static final String JIT_PURPOSE_GROUP_TYPE = "SYSTEM";
    private static final String CALLBACK_URL = "/carbon/idpmgt/idp-mgt-edit-local.jsp?category=User Onboarding&subCategory=Ask Password";
    private static final String CONSENT_LIST_URL = "/carbon/consent/list-purposes.jsp?purposeGroup=JIT&purposeGroupType=SYSTEM";

    public String getName() {
        return connectorName;
    }

    public String getFriendlyName() {
        return FRIENDLY_NAME;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("EmailVerification.Enable", "Enable user email verification");
        nameMapping.put("EmailVerification.LockOnCreation", "Enable account lock on creation");
        nameMapping.put("EmailVerification.Notification.InternallyManage", "Manage notifications sending internally");
        nameMapping.put("EmailVerification.ExpiryTime", "Email verification code expiry time");
        nameMapping.put("EmailVerification.AskPassword.ExpiryTime", "Ask password code expiry time");
        nameMapping.put("EmailVerification.AskPassword.PasswordGenerator", "Temporary password generation extension class");
        nameMapping.put(LIST_PURPOSE_PROPERTY_KEY, "Manage JIT provisioning purposes");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("EmailVerification.Enable", "A verification notification will be triggered during user creation.");
        descriptionMapping.put("EmailVerification.LockOnCreation", "The user account will be locked during user creation.");
        descriptionMapping.put("EmailVerification.Notification.InternallyManage", "Disable if the client application handles notification sending.");
        descriptionMapping.put("EmailVerification.ExpiryTime", "Set the time span that the verification e-mail would be valid, in minutes. (For infinite validity period, set -1)");
        descriptionMapping.put("EmailVerification.AskPassword.ExpiryTime", "Set the time span that the ask password e-mail would be valid, in minutes. (For infinite validity period, set -1)");
        descriptionMapping.put("EmailVerification.AskPassword.PasswordGenerator", "Temporary password generation extension point in ask password feature.)");
        descriptionMapping.put(LIST_PURPOSE_PROPERTY_KEY, "Click here to manage just in time provisioning purposes.");
        return descriptionMapping;
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("EmailVerification.Enable");
        properties.add("EmailVerification.LockOnCreation");
        properties.add("EmailVerification.Notification.InternallyManage");
        properties.add("EmailVerification.ExpiryTime");
        properties.add("EmailVerification.AskPassword.ExpiryTime");
        properties.add("EmailVerification.AskPassword.PasswordGenerator");
        properties.add(LIST_PURPOSE_PROPERTY_KEY);
        return properties.toArray(new String[0]);
    }

    public Properties getDefaultPropertyValues(String tenantDomain) throws IdentityGovernanceException {
        String enableEmailVerification = "false";
        String enableEmailAccountLockOnCreation = "true";
        String enableNotificationInternallyManage = "true";
        String emailVerificationCodeExpiry = "1440";
        String askPasswordCodeExpiry = "1440";
        String askPasswordTempPassExtension = "org.wso2.carbon.user.mgt.common.DefaultPasswordGenerator";
        String emailVerificationProperty = IdentityUtil.getProperty((String)"EmailVerification.Enable");
        String emailVerificationCodeExpiryProperty = IdentityUtil.getProperty((String)"EmailVerification.ExpiryTime");
        String askPasswordCodeExpiryProperty = IdentityUtil.getProperty((String)"EmailVerification.AskPassword.ExpiryTime");
        String askPasswordTempPasswordProperty = IdentityUtil.getProperty((String)"EmailVerification.AskPassword.PasswordGenerator");
        String lockOnCreationProperty = IdentityUtil.getProperty((String)"EmailVerification.LockOnCreation");
        String notificationInternallyManagedProperty = IdentityUtil.getProperty((String)"EmailVerification.Notification.InternallyManage");
        if (StringUtils.isNotEmpty((String)emailVerificationProperty)) {
            enableEmailVerification = emailVerificationProperty;
        }
        if (StringUtils.isNotEmpty((String)lockOnCreationProperty)) {
            enableEmailAccountLockOnCreation = lockOnCreationProperty;
        }
        if (StringUtils.isNotEmpty((String)notificationInternallyManagedProperty)) {
            enableNotificationInternallyManage = notificationInternallyManagedProperty;
        }
        if (StringUtils.isNotEmpty((String)emailVerificationCodeExpiryProperty)) {
            emailVerificationCodeExpiry = emailVerificationCodeExpiryProperty;
        }
        if (StringUtils.isNotEmpty((String)askPasswordCodeExpiryProperty)) {
            askPasswordCodeExpiry = askPasswordCodeExpiryProperty;
        }
        if (StringUtils.isNotBlank((String)askPasswordTempPasswordProperty)) {
            askPasswordTempPassExtension = askPasswordTempPasswordProperty;
        }
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("EmailVerification.Enable", enableEmailVerification);
        defaultProperties.put("EmailVerification.ExpiryTime", emailVerificationCodeExpiry);
        defaultProperties.put("EmailVerification.AskPassword.ExpiryTime", askPasswordCodeExpiry);
        defaultProperties.put("EmailVerification.LockOnCreation", enableEmailAccountLockOnCreation);
        defaultProperties.put("EmailVerification.Notification.InternallyManage", enableNotificationInternallyManage);
        defaultProperties.put("EmailVerification.AskPassword.PasswordGenerator", askPasswordTempPassExtension);
        try {
            defaultProperties.put(LIST_PURPOSE_PROPERTY_KEY, "/carbon/consent/list-purposes.jsp?purposeGroup=JIT&purposeGroupType=SYSTEM&callback=" + URLEncoder.encode(CALLBACK_URL, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IdentityGovernanceException("Error while url encoding callback url: /carbon/idpmgt/idp-mgt-edit-local.jsp?category=User Onboarding&subCategory=Ask Password", (Throwable)e);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)defaultProperties);
        return properties;
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        return null;
    }
}

