/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;

public class UserClaimUpdateConfigImpl
implements IdentityConnectorConfig {
    private static final String CONNECTOR_NAME = "user-claim-update";
    private static final String CATEGORY = "Other Settings";
    private static final String FRIENDLY_NAME = "User Claim Update";
    private static final String SUB_CATEGORY = "DEFAULT";
    private static final String DEFAULT_EMAIL_VERIFICATION_ON_UPDATE_CODE_EXPIRY_TIME = "1440";
    private static final String DEFAULT_ENABLE_VALUE_FOR_EMAIL_VERIFICATION_ON_UPDATE = "false";
    private static final String DEFAULT_MOBILE_NUM_VERIFICATION_ON_UPDATE_SMS_OTP_EXPIRY_TIME = "5";
    private static final String DEFAULT_ENABLE_VALUE_FOR_MOBILE_NUMBER_VERIFICATION_ON_UPDATE = "false";
    private static final String USER_CLAIM_UPDATE_ELEMENT = "UserClaimUpdate";
    private static final String ENABLE_ELEMENT = "Enable";
    private static final String CLAIM_ELEMENT = "Claim";
    private static final String CLAIM_URI = "uri";
    private static final String VERIFICATION_CODE_ELEMENT = "VerificationCode";
    private static final String EXPIRY_TIME_ELEMENT = "ExpiryTime";
    private static final String VERIFICATION_ON_UPDATE_ELEMENT = "VerificationOnUpdate";
    private static String enableEmailVerificationOnUpdateProperty = null;
    private static String emailVerificationOnUpdateCodeExpiryProperty = null;
    private static String enableMobileNumVerificationOnUpdateProperty = null;
    private static String mobileNumVerificationOnUpdateCodeExpiryProperty = null;

    public String getName() {
        return CONNECTOR_NAME;
    }

    public String getFriendlyName() {
        return FRIENDLY_NAME;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getSubCategory() {
        return SUB_CATEGORY;
    }

    public int getOrder() {
        return 0;
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("UserClaimUpdate.Email.EnableVerification", "Enable user email verification on update");
        nameMapping.put("UserClaimUpdate.Email.VerificationCode.ExpiryTime", "Email verification on update link expiry time");
        nameMapping.put("UserClaimUpdate.MobileNumber.EnableVerification", "Enable user mobile number verification on update");
        nameMapping.put("UserClaimUpdate.MobileNumber.VerificationCode.ExpiryTime", "Mobile number verification on update SMS OTP expiry time");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("UserClaimUpdate.Email.EnableVerification", "Trigger a verification notification when user's email address is updated.");
        descriptionMapping.put("UserClaimUpdate.Email.VerificationCode.ExpiryTime", "Validity time of the email confirmation link in minutes.");
        descriptionMapping.put("UserClaimUpdate.MobileNumber.EnableVerification", "Trigger a verification SMS OTP when user's mobile number is updated.");
        descriptionMapping.put("UserClaimUpdate.MobileNumber.VerificationCode.ExpiryTime", "Validity time of the mobile number confirmation OTP in minutes.");
        return descriptionMapping;
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("UserClaimUpdate.Email.EnableVerification");
        properties.add("UserClaimUpdate.Email.VerificationCode.ExpiryTime");
        properties.add("UserClaimUpdate.MobileNumber.EnableVerification");
        properties.add("UserClaimUpdate.MobileNumber.VerificationCode.ExpiryTime");
        return properties.toArray(new String[0]);
    }

    public Properties getDefaultPropertyValues(String tenantDomain) {
        String enableEmailVerificationOnUpdate = "false";
        String emailVerificationOnUpdateCodeExpiry = DEFAULT_EMAIL_VERIFICATION_ON_UPDATE_CODE_EXPIRY_TIME;
        String enableMobileNumVerificationOnUpdate = "false";
        String mobileNumVerificationOnUpdateCodeExpiry = DEFAULT_MOBILE_NUM_VERIFICATION_ON_UPDATE_SMS_OTP_EXPIRY_TIME;
        this.loadConfigurations();
        if (StringUtils.isNotBlank((String)enableEmailVerificationOnUpdateProperty)) {
            enableEmailVerificationOnUpdate = enableEmailVerificationOnUpdateProperty;
        }
        if (StringUtils.isNotBlank((String)emailVerificationOnUpdateCodeExpiryProperty)) {
            emailVerificationOnUpdateCodeExpiry = emailVerificationOnUpdateCodeExpiryProperty;
        }
        if (StringUtils.isNotBlank((String)enableMobileNumVerificationOnUpdateProperty)) {
            enableMobileNumVerificationOnUpdate = enableMobileNumVerificationOnUpdateProperty;
        }
        if (StringUtils.isNotBlank((String)mobileNumVerificationOnUpdateCodeExpiryProperty)) {
            mobileNumVerificationOnUpdateCodeExpiry = mobileNumVerificationOnUpdateCodeExpiryProperty;
        }
        Properties properties = new Properties();
        properties.put("UserClaimUpdate.Email.EnableVerification", enableEmailVerificationOnUpdate);
        properties.put("UserClaimUpdate.Email.VerificationCode.ExpiryTime", emailVerificationOnUpdateCodeExpiry);
        properties.put("UserClaimUpdate.MobileNumber.EnableVerification", enableMobileNumVerificationOnUpdate);
        properties.put("UserClaimUpdate.MobileNumber.VerificationCode.ExpiryTime", mobileNumVerificationOnUpdateCodeExpiry);
        return properties;
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        Properties properties = this.getDefaultPropertyValues(tenantDomain);
        HashMap<String, String> filteredDefaultProperties = new HashMap<String, String>();
        if (ArrayUtils.isNotEmpty((Object[])propertyNames)) {
            for (String propertyName : propertyNames) {
                if (!properties.containsKey(propertyName)) continue;
                filteredDefaultProperties.put(propertyName, properties.getProperty(propertyName));
            }
        }
        return filteredDefaultProperties;
    }

    private void loadConfigurations() {
        OMElement userClaimUpdate = IdentityConfigParser.getInstance().getConfigElement(USER_CLAIM_UPDATE_ELEMENT);
        Iterator claims = null;
        if (userClaimUpdate != null) {
            claims = userClaimUpdate.getChildrenWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", CLAIM_ELEMENT));
        }
        if (claims != null) {
            while (claims.hasNext()) {
                OMElement verificationCode;
                OMElement verificationOnUpdate;
                OMElement claim = (OMElement)claims.next();
                String claimURI = claim.getAttributeValue(new QName(CLAIM_URI));
                if ("http://wso2.org/claims/emailaddress".equals(claimURI)) {
                    verificationOnUpdate = claim.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", VERIFICATION_ON_UPDATE_ELEMENT));
                    if (verificationOnUpdate == null) continue;
                    enableEmailVerificationOnUpdateProperty = verificationOnUpdate.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", ENABLE_ELEMENT)).getText();
                    verificationCode = verificationOnUpdate.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", VERIFICATION_CODE_ELEMENT));
                    if (verificationCode == null) continue;
                    emailVerificationOnUpdateCodeExpiryProperty = verificationCode.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", EXPIRY_TIME_ELEMENT)).getText();
                    continue;
                }
                if (!"http://wso2.org/claims/mobile".equals(claimURI) || (verificationOnUpdate = claim.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", VERIFICATION_ON_UPDATE_ELEMENT))) == null) continue;
                enableMobileNumVerificationOnUpdateProperty = verificationOnUpdate.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", ENABLE_ELEMENT)).getText();
                verificationCode = verificationOnUpdate.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", VERIFICATION_CODE_ELEMENT));
                if (verificationCode == null) continue;
                mobileNumVerificationOnUpdateCodeExpiryProperty = verificationCode.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", EXPIRY_TIME_ELEMENT)).getText();
            }
        }
    }
}

