/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.connector;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;

public class SelfRegistrationConfigImpl
implements IdentityConnectorConfig {
    private static final String CONNECTOR_NAME = "self-sign-up";
    private static final String CATEGORY = "User Onboarding";
    private static final String FRIENDLY_NAME = "Self Registration";
    private static final String LIST_PURPOSE_PROPERTY_KEY = "_url_listPurposeSelfSignUp";
    private static final String SYSTEM_PURPOSE_GROUP = "SELF-SIGNUP";
    private static final String SIGNUP_PURPOSE_GROUP_TYPE = "SYSTEM";
    private static final String CALLBACK_URL = "/carbon/idpmgt/idp-mgt-edit-local.jsp?category=User Onboarding&subCategory=Self Registration";
    private static final String consentListURL = "/carbon/consent/list-purposes.jsp?purposeGroup=SELF-SIGNUP&purposeGroupType=SYSTEM";

    public String getName() {
        return CONNECTOR_NAME;
    }

    public String getFriendlyName() {
        return FRIENDLY_NAME;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("SelfRegistration.Enable", "User self registration");
        nameMapping.put("SelfRegistration.LockOnCreation", "Lock user account on creation");
        nameMapping.put("SelfRegistration.Notification.InternallyManage", "Manage notifications sending internally");
        nameMapping.put("SelfRegistration.ReCaptcha", "Prompt reCaptcha");
        nameMapping.put("SelfRegistration.VerificationCode.ExpiryTime", "User self registration verification link expiry time");
        nameMapping.put("SelfRegistration.VerificationCode.SMSOTP.ExpiryTime", "User self registration SMS OTP expiry time");
        nameMapping.put("SelfRegistration.CallbackRegex", "User self registration callback URL regex");
        nameMapping.put(LIST_PURPOSE_PROPERTY_KEY, "Manage Self-Sign-Up purposes");
        nameMapping.put("SelfRegistration.NotifyAccountConfirmation", "Send sign up confirmation email");
        nameMapping.put("SelfRegistration.ResendConfirmationReCaptcha", "Prompt reCaptcha on re-send confirmation");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("SelfRegistration.Enable", "Allow user's to self register to the system.");
        descriptionMapping.put("SelfRegistration.LockOnCreation", "Lock self registered user account until e-mail verification.");
        descriptionMapping.put("SelfRegistration.Notification.InternallyManage", "Disable if the client application handles notification sending");
        descriptionMapping.put("SelfRegistration.ReCaptcha", "Enable reCaptcha verification during self registration.");
        descriptionMapping.put("SelfRegistration.VerificationCode.ExpiryTime", "Specify the expiry time in minutes for the verification link.");
        descriptionMapping.put("SelfRegistration.VerificationCode.SMSOTP.ExpiryTime", "Specify the expiry time in minutes for the SMS OTP.");
        descriptionMapping.put("SelfRegistration.CallbackRegex", "This prefix will be used to validate the callback URL.");
        descriptionMapping.put(LIST_PURPOSE_PROPERTY_KEY, "Click here to manage Self-Sign-Up purposes");
        descriptionMapping.put("SelfRegistration.NotifyAccountConfirmation", "Enable sending notification for self sign up confirmation.");
        descriptionMapping.put("SelfRegistration.ResendConfirmationReCaptcha", "Prompt reCaptcha verification for resend confirmation");
        return descriptionMapping;
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("SelfRegistration.Enable");
        properties.add("SelfRegistration.LockOnCreation");
        properties.add("SelfRegistration.Notification.InternallyManage");
        properties.add("SelfRegistration.ReCaptcha");
        properties.add("SelfRegistration.VerificationCode.ExpiryTime");
        properties.add("SelfRegistration.VerificationCode.SMSOTP.ExpiryTime");
        properties.add("SelfRegistration.CallbackRegex");
        properties.add(LIST_PURPOSE_PROPERTY_KEY);
        properties.add("SelfRegistration.NotifyAccountConfirmation");
        properties.add("SelfRegistration.ResendConfirmationReCaptcha");
        return properties.toArray(new String[0]);
    }

    public Properties getDefaultPropertyValues(String tenantDomain) throws IdentityGovernanceException {
        String enableSelfSignUp = "false";
        String enableAccountLockOnCreation = "true";
        String enableNotificationInternallyManage = "true";
        String enableSelfRegistrationReCaptcha = "true";
        String verificationCodeExpiryTime = "1440";
        String verificationSMSOTPExpiryTime = "1";
        String selfRegistrationCallbackRegex = ".*";
        String enableSelfSignUpConfirmationNotification = "false";
        String enableResendConfirmationRecaptcha = "false";
        String selfSignUpProperty = IdentityUtil.getProperty((String)"SelfRegistration.Enable");
        String accountLockProperty = IdentityUtil.getProperty((String)"SelfRegistration.LockOnCreation");
        String notificationInternallyMangedProperty = IdentityUtil.getProperty((String)"SelfRegistration.Notification.InternallyManage");
        String reCaptchaProperty = IdentityUtil.getProperty((String)"SelfRegistration.ReCaptcha");
        String verificationCodeExpiryTimeProperty = IdentityUtil.getProperty((String)"SelfRegistration.VerificationCode.ExpiryTime");
        String verificationSMSOTPExpiryTimeProperty = IdentityUtil.getProperty((String)"SelfRegistration.VerificationCode.SMSOTP.ExpiryTime");
        String selfRegistrationCallbackRegexProperty = IdentityUtil.getProperty((String)"SelfRegistration.CallbackRegex");
        String selfSignUpConfirmationNotificationProperty = IdentityUtil.getProperty((String)"SelfRegistration.NotifyAccountConfirmation");
        String selfRegistrationResendConfirmationCaptchaProperty = IdentityUtil.getProperty((String)"SelfRegistration.ResendConfirmationReCaptcha");
        if (StringUtils.isNotEmpty((String)selfSignUpProperty)) {
            enableSelfSignUp = selfSignUpProperty;
        }
        if (StringUtils.isNotEmpty((String)accountLockProperty)) {
            enableAccountLockOnCreation = accountLockProperty;
        }
        if (StringUtils.isNotEmpty((String)notificationInternallyMangedProperty)) {
            enableNotificationInternallyManage = notificationInternallyMangedProperty;
        }
        if (StringUtils.isNotEmpty((String)reCaptchaProperty)) {
            enableSelfRegistrationReCaptcha = reCaptchaProperty;
        }
        if (StringUtils.isNotEmpty((String)verificationCodeExpiryTimeProperty)) {
            verificationCodeExpiryTime = verificationCodeExpiryTimeProperty;
        }
        if (StringUtils.isNotEmpty((String)verificationSMSOTPExpiryTimeProperty)) {
            verificationSMSOTPExpiryTime = verificationSMSOTPExpiryTimeProperty;
        }
        if (StringUtils.isNotEmpty((String)selfRegistrationCallbackRegexProperty)) {
            selfRegistrationCallbackRegex = selfRegistrationCallbackRegexProperty;
        }
        if (StringUtils.isNotEmpty((String)selfSignUpConfirmationNotificationProperty)) {
            enableSelfSignUpConfirmationNotification = selfSignUpConfirmationNotificationProperty;
        }
        if (StringUtils.isNotEmpty((String)selfRegistrationResendConfirmationCaptchaProperty)) {
            enableResendConfirmationRecaptcha = selfRegistrationResendConfirmationCaptchaProperty;
        }
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("SelfRegistration.Enable", enableSelfSignUp);
        defaultProperties.put("SelfRegistration.LockOnCreation", enableAccountLockOnCreation);
        defaultProperties.put("SelfRegistration.Notification.InternallyManage", enableNotificationInternallyManage);
        defaultProperties.put("SelfRegistration.ReCaptcha", enableSelfRegistrationReCaptcha);
        defaultProperties.put("SelfRegistration.VerificationCode.ExpiryTime", verificationCodeExpiryTime);
        defaultProperties.put("SelfRegistration.VerificationCode.SMSOTP.ExpiryTime", verificationSMSOTPExpiryTime);
        try {
            defaultProperties.put(LIST_PURPOSE_PROPERTY_KEY, "/carbon/consent/list-purposes.jsp?purposeGroup=SELF-SIGNUP&purposeGroupType=SYSTEM&callback=" + URLEncoder.encode(CALLBACK_URL, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IdentityGovernanceException("Error while encoding callback url: /carbon/idpmgt/idp-mgt-edit-local.jsp?category=User Onboarding&subCategory=Self Registration", (Throwable)e);
        }
        defaultProperties.put("SelfRegistration.CallbackRegex", selfRegistrationCallbackRegex);
        defaultProperties.put("SelfRegistration.NotifyAccountConfirmation", enableSelfSignUpConfirmationNotification);
        defaultProperties.put("SelfRegistration.ResendConfirmationReCaptcha", enableResendConfirmationRecaptcha);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)defaultProperties);
        return properties;
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        return null;
    }
}

