/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;

public class RecoveryConfigImpl
implements IdentityConnectorConfig {
    private static final String connectorName = "account-recovery";

    public String getName() {
        return connectorName;
    }

    public String getFriendlyName() {
        return "Account Recovery";
    }

    public String getCategory() {
        return "Account Management";
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("Recovery.Notification.Password.Enable", "Notification based password recovery");
        nameMapping.put("Recovery.Notification.InternallyManage", "Manage notifications sending internally");
        nameMapping.put("Recovery.ReCaptcha.Password.Enable", "Enable reCaptcha for password recovery");
        nameMapping.put("Recovery.Question.Password.Enable", "Security question based password recovery");
        nameMapping.put("Recovery.Question.Answer.Regex", "Security question answer regex");
        nameMapping.put("Recovery.Question.Answer.Uniqueness", "Enforce security question answer uniqueness");
        nameMapping.put("Recovery.Question.Password.MinAnswers", "Number of questions required for password recovery");
        nameMapping.put("Recovery.Notification.Username.Enable", "Username recovery");
        nameMapping.put("Recovery.ReCaptcha.Username.Enable", "Enable reCaptcha for username recovery");
        nameMapping.put("Recovery.ExpiryTime", "Recovery link expiry time");
        nameMapping.put("Recovery.Notification.Password.ExpiryTime.smsOtp", "SMS OTP expiry time");
        nameMapping.put("Recovery.Notification.Password.smsOtp.Regex", "SMS OTP regex");
        nameMapping.put("Recovery.NotifySuccess", "Notify when recovery success");
        nameMapping.put("Recovery.Question.Password.NotifyStart", "Notify when security questions based recovery starts");
        nameMapping.put("Recovery.Question.Password.ReCaptcha.Enable", "Enable reCaptcha for security questions based password recovery");
        nameMapping.put("Recovery.Question.Password.ReCaptcha.MaxFailedAttempts", "Max failed attempts for reCaptcha");
        nameMapping.put("Recovery.Question.Password.Forced.Enable", "Enable forced security questions");
        nameMapping.put("Recovery.Question.MinQuestionsToAnswer", "Minimum number of forced security questions to be answered");
        nameMapping.put("Recovery.CallbackRegex", "Recovery callback URL regex");
        nameMapping.put("Recovery.AutoLogin.Enable", "Enable Auto Login After Password Reset");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("Recovery.Notification.InternallyManage", "Disable if the client application handles notification sending");
        descriptionMapping.put("Recovery.Question.Answer.Regex", "Security question answer regex");
        descriptionMapping.put("Recovery.Question.Answer.Uniqueness", "Enforce security question answer uniqueness");
        descriptionMapping.put("Recovery.Question.Password.ReCaptcha.Enable", "Prompt reCaptcha for security question based password recovery");
        descriptionMapping.put("Recovery.Question.Password.Forced.Enable", "Force users to provide answers to security questions during sign in");
        descriptionMapping.put("Recovery.Question.MinQuestionsToAnswer", "Force users to provide answers to security questions during sign in if user has answered lesser than this value");
        descriptionMapping.put("Recovery.CallbackRegex", "Recovery callback URL regex");
        descriptionMapping.put("Recovery.Notification.Password.ExpiryTime.smsOtp", "Expiration time of the SMS OTP code for password recovery");
        descriptionMapping.put("Recovery.Notification.Password.smsOtp.Regex", "Regex for SMS OTP in format [allowed characters]{length}. Supported character ranges are a-z, A-Z, 0-9.");
        descriptionMapping.put("Recovery.AutoLogin.Enable", "User will be logged in automatically after completing the Password Reset wizard");
        return descriptionMapping;
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("Recovery.Notification.Password.Enable");
        properties.add("Recovery.ReCaptcha.Password.Enable");
        properties.add("Recovery.Question.Password.Enable");
        properties.add("Recovery.Question.Password.MinAnswers");
        properties.add("Recovery.Question.Answer.Regex");
        properties.add("Recovery.Question.Answer.Uniqueness");
        properties.add("Recovery.Question.Password.ReCaptcha.Enable");
        properties.add("Recovery.Question.Password.ReCaptcha.MaxFailedAttempts");
        properties.add("Recovery.Notification.Username.Enable");
        properties.add("Recovery.ReCaptcha.Username.Enable");
        properties.add("Recovery.Notification.InternallyManage");
        properties.add("Recovery.NotifySuccess");
        properties.add("Recovery.Question.Password.NotifyStart");
        properties.add("Recovery.ExpiryTime");
        properties.add("Recovery.Notification.Password.ExpiryTime.smsOtp");
        properties.add("Recovery.Notification.Password.smsOtp.Regex");
        properties.add("Recovery.Question.Password.Forced.Enable");
        properties.add("Recovery.Question.MinQuestionsToAnswer");
        properties.add("Recovery.CallbackRegex");
        properties.add("Recovery.AutoLogin.Enable");
        return properties.toArray(new String[0]);
    }

    public Properties getDefaultPropertyValues(String tenantDomain) throws IdentityGovernanceException {
        String enableNotificationBasedPasswordRecovery = "false";
        String enableQuestionBasedPasswordRecovery = "false";
        String minimumAnswers = "2";
        String challengeQuestionAnswerRegex = ".*";
        String enforceChallengeQuestionAnswerUniqueness = "false";
        String enableRecoveryQuestionPasswordReCaptcha = "true";
        String recoveryQuestionPasswordReCaptchaMaxFailedAttempts = "2";
        String enableUsernameRecovery = "false";
        String enableNotificationInternallyManage = "true";
        String expiryTime = "1440";
        String expiryTimeSMSOTP = "1";
        String smsOtpRegex = "[a-zA-Z0-9]{6}";
        String notifySuccess = "false";
        String notifyStart = "false";
        String enableForceChallengeQuestions = "false";
        String enablePasswordRecoveryReCaptcha = "false";
        String enableUsernameRecoveryReCaptcha = "false";
        String minimumForcedChallengeQuestionsAnswered = "";
        String recoveryCallbackRegex = ".*";
        String enableAdminPasswordResetAutoLoginProperty = "false";
        String notificationBasedPasswordRecovery = IdentityUtil.getProperty((String)"Recovery.Notification.Password.Enable");
        String questionBasedPasswordRecovery = IdentityUtil.getProperty((String)"Recovery.Question.Password.Enable");
        String miniMumAnswerProperty = IdentityUtil.getProperty((String)"Recovery.Question.Password.MinAnswers");
        String challengeQuestionAnswerRegexProperty = IdentityUtil.getProperty((String)"Recovery.Question.Answer.Regex");
        String challengeQuestionAnswerUniquenessProperty = IdentityUtil.getProperty((String)"Recovery.Question.Answer.Uniqueness");
        String recoveryQuestionPasswordReCaptcha = IdentityUtil.getProperty((String)"Recovery.Question.Password.ReCaptcha.Enable");
        String passwordReCaptchaMaxFailedAttempts = IdentityUtil.getProperty((String)"Recovery.Question.Password.ReCaptcha.MaxFailedAttempts");
        String usernameRecovery = IdentityUtil.getProperty((String)"Recovery.Notification.Username.Enable");
        String notificationInternallyManged = IdentityUtil.getProperty((String)"Recovery.Notification.InternallyManage");
        String expiryTimeProperty = IdentityUtil.getProperty((String)"Recovery.ExpiryTime");
        String expiryTimeSMSOTPProperty = IdentityUtil.getProperty((String)"Recovery.Notification.Password.ExpiryTime.smsOtp");
        String smsOtpRegexProperty = IdentityUtil.getProperty((String)"Recovery.Notification.Password.smsOtp.Regex");
        String notifySuccessProperty = IdentityUtil.getProperty((String)"Recovery.NotifySuccess");
        String notifyStartProperty = IdentityUtil.getProperty((String)"Recovery.Question.Password.NotifyStart");
        String forceChallengeQuestionsProperty = IdentityUtil.getProperty((String)"Recovery.Question.Password.Forced.Enable");
        String minimumForcedChallengeQuestionsAnsweredProperty = IdentityUtil.getProperty((String)"Recovery.Question.MinQuestionsToAnswer");
        String passwordRecoveryReCaptcha = IdentityUtil.getProperty((String)"Recovery.ReCaptcha.Password.Enable");
        String userNameRecoveryReCaptcha = IdentityUtil.getProperty((String)"Recovery.ReCaptcha.Username.Enable");
        String recoveryCallbackRegexProperty = IdentityUtil.getProperty((String)"Recovery.CallbackRegex");
        String adminPasswordResetAutoLoginProperty = IdentityUtil.getProperty((String)"Recovery.AutoLogin.Enable");
        if (StringUtils.isNotEmpty((String)expiryTimeSMSOTPProperty)) {
            expiryTimeSMSOTP = expiryTimeSMSOTPProperty;
        }
        if (StringUtils.isNotEmpty((String)smsOtpRegexProperty)) {
            smsOtpRegex = smsOtpRegexProperty;
        }
        if (StringUtils.isNotEmpty((String)notificationBasedPasswordRecovery)) {
            enableNotificationBasedPasswordRecovery = notificationBasedPasswordRecovery;
        }
        if (StringUtils.isNotEmpty((String)questionBasedPasswordRecovery)) {
            enableQuestionBasedPasswordRecovery = questionBasedPasswordRecovery;
        }
        if (StringUtils.isNotEmpty((String)challengeQuestionAnswerRegexProperty)) {
            challengeQuestionAnswerRegex = challengeQuestionAnswerRegexProperty;
        }
        if (StringUtils.isNotEmpty((String)challengeQuestionAnswerUniquenessProperty)) {
            enforceChallengeQuestionAnswerUniqueness = challengeQuestionAnswerUniquenessProperty;
        }
        if (StringUtils.isNotEmpty((String)notificationInternallyManged)) {
            enableNotificationInternallyManage = notificationInternallyManged;
        }
        if (StringUtils.isNotEmpty((String)miniMumAnswerProperty)) {
            minimumAnswers = miniMumAnswerProperty;
        }
        if (StringUtils.isNotEmpty((String)recoveryQuestionPasswordReCaptcha)) {
            enableRecoveryQuestionPasswordReCaptcha = recoveryQuestionPasswordReCaptcha;
        }
        if (StringUtils.isNotEmpty((String)passwordReCaptchaMaxFailedAttempts)) {
            recoveryQuestionPasswordReCaptchaMaxFailedAttempts = passwordReCaptchaMaxFailedAttempts;
        }
        if (StringUtils.isNotEmpty((String)usernameRecovery)) {
            enableUsernameRecovery = usernameRecovery;
        }
        if (StringUtils.isNotEmpty((String)expiryTimeProperty)) {
            expiryTime = expiryTimeProperty;
        }
        if (StringUtils.isNotEmpty((String)notifySuccessProperty)) {
            notifySuccess = notifySuccessProperty;
        }
        if (StringUtils.isNotEmpty((String)notifyStartProperty)) {
            notifyStart = notifyStartProperty;
        }
        if (StringUtils.isNotEmpty((String)forceChallengeQuestionsProperty)) {
            enableForceChallengeQuestions = forceChallengeQuestionsProperty;
        }
        if (StringUtils.isNotEmpty((String)minimumForcedChallengeQuestionsAnsweredProperty)) {
            minimumForcedChallengeQuestionsAnswered = minimumForcedChallengeQuestionsAnsweredProperty;
        }
        if (StringUtils.isNotEmpty((String)passwordRecoveryReCaptcha)) {
            enablePasswordRecoveryReCaptcha = passwordRecoveryReCaptcha;
        }
        if (StringUtils.isNotEmpty((String)userNameRecoveryReCaptcha)) {
            enableUsernameRecoveryReCaptcha = userNameRecoveryReCaptcha;
        }
        if (StringUtils.isNotEmpty((String)recoveryCallbackRegexProperty)) {
            recoveryCallbackRegex = recoveryCallbackRegexProperty;
        }
        if (StringUtils.isNotEmpty((String)adminPasswordResetAutoLoginProperty)) {
            enableAdminPasswordResetAutoLoginProperty = adminPasswordResetAutoLoginProperty;
        }
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("Recovery.Notification.Password.Enable", enableNotificationBasedPasswordRecovery);
        defaultProperties.put("Recovery.ReCaptcha.Password.Enable", enablePasswordRecoveryReCaptcha);
        defaultProperties.put("Recovery.Question.Password.Enable", enableQuestionBasedPasswordRecovery);
        defaultProperties.put("Recovery.Question.Password.MinAnswers", minimumAnswers);
        defaultProperties.put("Recovery.Question.Answer.Regex", challengeQuestionAnswerRegex);
        defaultProperties.put("Recovery.Question.Answer.Uniqueness", enforceChallengeQuestionAnswerUniqueness);
        defaultProperties.put("Recovery.Question.Password.ReCaptcha.Enable", enableRecoveryQuestionPasswordReCaptcha);
        defaultProperties.put("Recovery.Question.Password.ReCaptcha.MaxFailedAttempts", recoveryQuestionPasswordReCaptchaMaxFailedAttempts);
        defaultProperties.put("Recovery.Notification.Username.Enable", enableUsernameRecovery);
        defaultProperties.put("Recovery.ReCaptcha.Username.Enable", enableUsernameRecoveryReCaptcha);
        defaultProperties.put("Recovery.Notification.InternallyManage", enableNotificationInternallyManage);
        defaultProperties.put("Recovery.ExpiryTime", expiryTime);
        defaultProperties.put("Recovery.Notification.Password.ExpiryTime.smsOtp", expiryTimeSMSOTP);
        defaultProperties.put("Recovery.Notification.Password.smsOtp.Regex", smsOtpRegex);
        defaultProperties.put("Recovery.NotifySuccess", notifySuccess);
        defaultProperties.put("Recovery.Question.Password.NotifyStart", notifyStart);
        defaultProperties.put("Recovery.Question.Password.Forced.Enable", enableForceChallengeQuestions);
        defaultProperties.put("Recovery.Question.MinQuestionsToAnswer", minimumForcedChallengeQuestionsAnswered);
        defaultProperties.put("Recovery.CallbackRegex", recoveryCallbackRegex);
        defaultProperties.put("Recovery.AutoLogin.Enable", enableAdminPasswordResetAutoLoginProperty);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)defaultProperties);
        return properties;
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        return null;
    }
}

