/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.connector;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;

public class LiteRegistrationConfigImpl
implements IdentityConnectorConfig {
    private static final String connectorName = "lite-user-sign-up";
    private static final String CATEGORY = "User Onboarding";
    private static final String FRIENDLY_NAME = "Lite User Registration";
    private static final String LIST_PURPOSE_PROPERTY_KEY = "_url_listPurposeLiteUserSignUp";
    private static final String SYSTEM_PURPOSE_GROUP = "LITE-SIGNUP";
    private static final String SIGNUP_PURPOSE_GROUP_TYPE = "SYSTEM";
    private static final String CALLBACK_URL = "/carbon/idpmgt/idp-mgt-edit-local.jsp?category=User Onboarding&subCategory=Lite User Registration";
    private static final String consentListURL = "/carbon/consent/list-purposes.jsp?purposeGroup=LITE-SIGNUP&purposeGroupType=SYSTEM";

    public String getName() {
        return connectorName;
    }

    public String getFriendlyName() {
        return FRIENDLY_NAME;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("LiteRegistration.Enable", "Lite user registration");
        nameMapping.put("LiteRegistration.LockOnCreation", "Lock user account on creation");
        nameMapping.put("LiteRegistration.Notification.InternallyManage", "Manage notifications sending internally");
        nameMapping.put("LiteRegistration.ReCaptcha", "Prompt reCaptcha");
        nameMapping.put("LiteRegistration.VerificationCode.ExpiryTime", "Lite user registration verification link expiry time");
        nameMapping.put("LiteRegistration.VerificationCode.SMSOTP.ExpiryTime", "Lite user registration SMS OTP expiry time");
        nameMapping.put("LiteRegistration.CallbackRegex", "Lite user registration callback URL regex");
        nameMapping.put(LIST_PURPOSE_PROPERTY_KEY, "Manage Lite-Sign-Up purposes");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("LiteRegistration.Enable", "Allow user's to self register to the system without a password.");
        descriptionMapping.put("LiteRegistration.LockOnCreation", "Lock self registered user account until e-mail verification.");
        descriptionMapping.put("LiteRegistration.Notification.InternallyManage", "Disable if the client application handles notification sending");
        descriptionMapping.put("LiteRegistration.ReCaptcha", "Enable reCaptcha verification during self registration.");
        descriptionMapping.put("LiteRegistration.VerificationCode.ExpiryTime", "Specify the expiry time in minutes for the verification link.");
        descriptionMapping.put("LiteRegistration.VerificationCode.SMSOTP.ExpiryTime", "Specify the expiry time in minutes for the SMS OTP.");
        descriptionMapping.put("LiteRegistration.CallbackRegex", "This prefix will be used to validate the callback URL.");
        descriptionMapping.put(LIST_PURPOSE_PROPERTY_KEY, "Click here to manage Lite-Sign-Up purposes");
        return descriptionMapping;
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("LiteRegistration.Enable");
        properties.add("LiteRegistration.LockOnCreation");
        properties.add("LiteRegistration.Notification.InternallyManage");
        properties.add("LiteRegistration.ReCaptcha");
        properties.add("LiteRegistration.VerificationCode.ExpiryTime");
        properties.add("LiteRegistration.VerificationCode.SMSOTP.ExpiryTime");
        properties.add("LiteRegistration.CallbackRegex");
        properties.add(LIST_PURPOSE_PROPERTY_KEY);
        return properties.toArray(new String[0]);
    }

    public Properties getDefaultPropertyValues(String tenantDomain) throws IdentityGovernanceException {
        String enableLiteSignUp = "false";
        String enableAccountLockOnCreation = "true";
        String enableNotificationInternallyManage = "true";
        String enableLiteRegistrationReCaptcha = "true";
        String verificationCodeExpiryTime = "1440";
        String verificationSMSOTPExpiryTime = "1";
        String liteRegistrationCallbackRegex = ".*";
        String liteSignUpProperty = IdentityUtil.getProperty((String)"LiteRegistration.Enable");
        String accountLockProperty = IdentityUtil.getProperty((String)"LiteRegistration.LockOnCreation");
        String notificationInternallyMangedProperty = IdentityUtil.getProperty((String)"LiteRegistration.Notification.InternallyManage");
        String reCaptchaProperty = IdentityUtil.getProperty((String)"LiteRegistration.ReCaptcha");
        String verificationCodeExpiryTimeProperty = IdentityUtil.getProperty((String)"LiteRegistration.VerificationCode.ExpiryTime");
        String verificationSMSOTPExpiryTimeProperty = IdentityUtil.getProperty((String)"LiteRegistration.VerificationCode.SMSOTP.ExpiryTime");
        String selfRegistrationCallbackRegexProperty = IdentityUtil.getProperty((String)"LiteRegistration.CallbackRegex");
        if (StringUtils.isNotEmpty((String)liteSignUpProperty)) {
            enableLiteSignUp = liteSignUpProperty;
        }
        if (StringUtils.isNotEmpty((String)accountLockProperty)) {
            enableAccountLockOnCreation = accountLockProperty;
        }
        if (StringUtils.isNotEmpty((String)notificationInternallyMangedProperty)) {
            enableNotificationInternallyManage = notificationInternallyMangedProperty;
        }
        if (StringUtils.isNotEmpty((String)reCaptchaProperty)) {
            enableLiteRegistrationReCaptcha = reCaptchaProperty;
        }
        if (StringUtils.isNotEmpty((String)verificationCodeExpiryTimeProperty)) {
            verificationCodeExpiryTime = verificationCodeExpiryTimeProperty;
        }
        if (StringUtils.isNotEmpty((String)verificationSMSOTPExpiryTimeProperty)) {
            verificationSMSOTPExpiryTime = verificationSMSOTPExpiryTimeProperty;
        }
        if (StringUtils.isNotEmpty((String)selfRegistrationCallbackRegexProperty)) {
            liteRegistrationCallbackRegex = selfRegistrationCallbackRegexProperty;
        }
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("LiteRegistration.Enable", enableLiteSignUp);
        defaultProperties.put("LiteRegistration.LockOnCreation", enableAccountLockOnCreation);
        defaultProperties.put("LiteRegistration.Notification.InternallyManage", enableNotificationInternallyManage);
        defaultProperties.put("LiteRegistration.ReCaptcha", enableLiteRegistrationReCaptcha);
        defaultProperties.put("LiteRegistration.VerificationCode.ExpiryTime", verificationCodeExpiryTime);
        defaultProperties.put("LiteRegistration.VerificationCode.SMSOTP.ExpiryTime", verificationSMSOTPExpiryTime);
        try {
            defaultProperties.put(LIST_PURPOSE_PROPERTY_KEY, "/carbon/consent/list-purposes.jsp?purposeGroup=LITE-SIGNUP&purposeGroupType=SYSTEM&callback=" + URLEncoder.encode(CALLBACK_URL, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IdentityGovernanceException("Error while encoding callback url: /carbon/idpmgt/idp-mgt-edit-local.jsp?category=User Onboarding&subCategory=Lite User Registration", (Throwable)e);
        }
        defaultProperties.put("LiteRegistration.CallbackRegex", liteRegistrationCallbackRegex);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)defaultProperties);
        return properties;
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        return null;
    }
}

