/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;

public class AdminForcedPasswordResetConfigImpl
implements IdentityConnectorConfig {
    private static final String connectorName = "admin-forced-password-reset";

    public String getName() {
        return connectorName;
    }

    public String getFriendlyName() {
        return "Password Reset";
    }

    public String getCategory() {
        return "Account Management";
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("Recovery.AdminPasswordReset.RecoveryLink", "Enable password reset via recovery e-mail");
        nameMapping.put("Recovery.AdminPasswordReset.OTP", "Enable password reset via OTP");
        nameMapping.put("Recovery.AdminPasswordReset.Offline", "Enable password reset offline");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("Recovery.AdminPasswordReset.RecoveryLink", "User gets notified with a link to reset password");
        descriptionMapping.put("Recovery.AdminPasswordReset.OTP", "User gets notified with a one time password to try with SSO login");
        descriptionMapping.put("Recovery.AdminPasswordReset.Offline", "An OTP generated and stored in users claims");
        return descriptionMapping;
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("Recovery.AdminPasswordReset.RecoveryLink");
        properties.add("Recovery.AdminPasswordReset.OTP");
        properties.add("Recovery.AdminPasswordReset.Offline");
        return properties.toArray(new String[0]);
    }

    public Properties getDefaultPropertyValues(String tenantDomain) throws IdentityGovernanceException {
        String enableAdminPasswordResetWithRecoveryLink = "false";
        String enableAdminPasswordResetWithOTP = "false";
        String enableAdminPasswordResetOffline = "false";
        String adminPasswordRecoveryWithLinkProperty = IdentityUtil.getProperty((String)"Recovery.AdminPasswordReset.RecoveryLink");
        String adminPasswordResetWithOTPProperty = IdentityUtil.getProperty((String)"Recovery.AdminPasswordReset.OTP");
        String adminPasswordResetOfflineProperty = IdentityUtil.getProperty((String)"Recovery.AdminPasswordReset.Offline");
        if (StringUtils.isNotEmpty((String)adminPasswordRecoveryWithLinkProperty)) {
            enableAdminPasswordResetWithRecoveryLink = adminPasswordRecoveryWithLinkProperty;
        }
        if (StringUtils.isNotEmpty((String)adminPasswordResetWithOTPProperty)) {
            enableAdminPasswordResetWithOTP = adminPasswordResetWithOTPProperty;
        }
        if (StringUtils.isNotEmpty((String)adminPasswordResetOfflineProperty)) {
            enableAdminPasswordResetOffline = adminPasswordResetOfflineProperty;
        }
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("Recovery.AdminPasswordReset.RecoveryLink", enableAdminPasswordResetWithRecoveryLink);
        defaultProperties.put("Recovery.AdminPasswordReset.OTP", enableAdminPasswordResetWithOTP);
        defaultProperties.put("Recovery.AdminPasswordReset.Offline", enableAdminPasswordResetOffline);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)defaultProperties);
        return properties;
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        return null;
    }
}

