/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery.confirmation;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationChannelManagerException;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.RecoverySteps;
import org.wso2.carbon.identity.recovery.bean.NotificationResponseBean;
import org.wso2.carbon.identity.recovery.dto.ResendConfirmationDTO;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.internal.service.impl.UserAccountRecoveryManager;
import org.wso2.carbon.identity.recovery.model.Property;
import org.wso2.carbon.identity.recovery.model.UserRecoveryData;
import org.wso2.carbon.identity.recovery.store.JDBCRecoveryDataStore;
import org.wso2.carbon.identity.recovery.store.UserRecoveryDataStore;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public class ResendConfirmationManager {
    private static final Log log = LogFactory.getLog(ResendConfirmationManager.class);
    private static ResendConfirmationManager instance = new ResendConfirmationManager();

    private ResendConfirmationManager() {
    }

    public static ResendConfirmationManager getInstance() {
        return instance;
    }

    public NotificationResponseBean resendConfirmationCode(User user, String recoveryScenario, String recoveryStep, String notificationType, Property[] properties) throws IdentityRecoveryException {
        return this.resendAccountRecoveryNotification(user, null, recoveryScenario, recoveryStep, notificationType, properties);
    }

    public NotificationResponseBean resendConfirmationCode(User user, String code, String recoveryScenario, String recoveryStep, String notificationType, Property[] properties) throws IdentityRecoveryException {
        if (StringUtils.isBlank((String)code)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CONFIRMATION_CODE_NOT_PROVIDED, user.getUserName());
        }
        return this.resendAccountRecoveryNotification(user, code, recoveryScenario, recoveryStep, notificationType, properties);
    }

    public ResendConfirmationDTO resendConfirmation(String tenantDomain, String resendCode, String recoveryScenario, String recoveryStep, String notificationScenario, Property[] properties) throws IdentityRecoveryException {
        RecoverySteps step = RecoverySteps.getRecoveryStep(recoveryStep);
        RecoveryScenarios scenario = RecoveryScenarios.getRecoveryScenario(recoveryScenario);
        UserAccountRecoveryManager userAccountRecoveryManager = UserAccountRecoveryManager.getInstance();
        UserRecoveryData userRecoveryData = userAccountRecoveryManager.getUserRecoveryData(resendCode, RecoverySteps.RESEND_CONFIRMATION_CODE);
        User user = userRecoveryData.getUser();
        this.validateRequestAttributes(user, scenario, userRecoveryData.getRecoveryScenario(), tenantDomain, resendCode);
        this.validateCallback(properties, user.getTenantDomain());
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        userRecoveryDataStore.invalidate(user);
        String notificationChannel = this.validateNotificationChannel(userRecoveryData.getRemainingSetIds());
        String confirmationCode = Utils.generateSecretKey(notificationChannel, user.getTenantDomain(), recoveryScenario);
        ResendConfirmationDTO resendConfirmationDTO = new ResendConfirmationDTO();
        this.addRecoveryDataObject(confirmationCode, notificationChannel, scenario, step, user);
        if (!NotificationChannels.EXTERNAL_CHANNEL.getChannelType().equals(notificationChannel)) {
            String eventName = Utils.resolveEventName(notificationChannel);
            this.triggerNotification(user, notificationChannel, notificationScenario, confirmationCode, eventName, properties);
        } else {
            resendConfirmationDTO.setExternalConfirmationCode(confirmationCode);
        }
        resendCode = this.generateResendCode(notificationChannel, scenario, userRecoveryData);
        resendConfirmationDTO.setNotificationChannel(notificationChannel);
        resendConfirmationDTO.setResendCode(resendCode);
        resendConfirmationDTO.setSuccessCode(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_RESEND_CONFIRMATION_CODE.getCode());
        resendConfirmationDTO.setSuccessMessage(IdentityRecoveryConstants.SuccessEvents.SUCCESS_STATUS_CODE_RESEND_CONFIRMATION_CODE.getMessage());
        return resendConfirmationDTO;
    }

    private void validateRequestAttributes(User recoveredUser, RecoveryScenarios scenarioInRequest, Enum recoveredScenario, String tenantDomainInRequest, String resendCode) throws IdentityRecoveryClientException {
        if (!StringUtils.equals((String)tenantDomainInRequest, (String)recoveredUser.getTenantDomain())) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USER_TENANT_DOMAIN_MISS_MATCH_WITH_CONTEXT, tenantDomainInRequest);
        }
        if (!scenarioInRequest.equals(recoveredScenario)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_RESEND_CODE, resendCode);
        }
    }

    private void triggerNotification(User user, String notificationChannel, String templateName, String code, String eventName, Property[] metaProperties) throws IdentityRecoveryException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user-name", user.getUserName());
        properties.put("tenant-domain", user.getTenantDomain());
        properties.put("userstore-domain", user.getUserStoreDomain());
        if (StringUtils.isBlank((String)notificationChannel)) {
            notificationChannel = NotificationChannels.EMAIL_CHANNEL.getChannelType();
        }
        properties.put("notification-channel", notificationChannel);
        if (StringUtils.isNotBlank((String)code)) {
            properties.put("confirmation-code", code);
        }
        if (metaProperties != null) {
            for (Property metaProperty : metaProperties) {
                if (!StringUtils.isNotBlank((String)metaProperty.getValue()) || !StringUtils.isNotBlank((String)metaProperty.getKey())) continue;
                properties.put(metaProperty.getKey(), metaProperty.getValue());
            }
        }
        properties.put("TEMPLATE_TYPE", templateName);
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_TRIGGER_NOTIFICATION, user.getUserName(), e);
        }
    }

    private String generateResendCode(String notificationChannel, RecoveryScenarios scenario, UserRecoveryData userRecoveryData) throws IdentityRecoveryServerException {
        String resendCode = UUIDGenerator.generateUUID();
        this.addRecoveryDataObject(resendCode, notificationChannel, scenario, RecoverySteps.RESEND_CONFIRMATION_CODE, userRecoveryData.getUser());
        return resendCode;
    }

    private void addRecoveryDataObject(String secretKey, String recoveryData, RecoveryScenarios recoveryScenario, RecoverySteps recoveryStep, User user) throws IdentityRecoveryServerException {
        UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, recoveryScenario, recoveryStep);
        recoveryDataDO.setRemainingSetIds(recoveryData);
        try {
            UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
            userRecoveryDataStore.store(recoveryDataDO);
        }
        catch (IdentityRecoveryException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_STORING_RECOVERY_DATA, "Error Storing Recovery Data", (Throwable)((Object)e));
        }
    }

    private void validateCallback(Property[] properties, String tenantDomain) throws IdentityRecoveryServerException {
        String callbackURL = null;
        try {
            callbackURL = Utils.getCallbackURL(properties);
            if (StringUtils.isNotBlank((String)callbackURL) && !Utils.validateCallbackURL(callbackURL, tenantDomain, "Recovery.CallbackRegex")) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException | IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CALLBACK_URL_NOT_VALID, callbackURL);
        }
    }

    private String validateNotificationChannel(String channel) throws IdentityRecoveryClientException {
        try {
            return NotificationChannels.getNotificationChannel((String)channel).getChannelType();
        }
        catch (NotificationChannelManagerException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported Notification channel : " + channel), (Throwable)e);
            }
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_UNSUPPORTED_NOTIFICATION_CHANNEL, channel);
        }
    }

    private NotificationResponseBean resendAccountRecoveryNotification(User user, String code, String recoveryScenario, String recoveryStep, String notificationType, Property[] properties) throws IdentityRecoveryException {
        this.validateRequestParameters(user, recoveryScenario, recoveryStep, notificationType);
        this.resolveUserAttributes(user);
        boolean notificationInternallyManage = this.isNotificationInternallyManage(user);
        NotificationResponseBean notificationResponseBean = new NotificationResponseBean(user);
        UserRecoveryDataStore userRecoveryDataStore = JDBCRecoveryDataStore.getInstance();
        UserRecoveryData userRecoveryData = userRecoveryDataStore.loadWithoutCodeExpiryValidation(user, RecoveryScenarios.getRecoveryScenario(recoveryScenario));
        this.validateWithOldConfirmationCode(code, recoveryScenario, recoveryStep, userRecoveryData);
        userRecoveryDataStore.invalidate(userRecoveryData.getSecret());
        String storedNotificationChannel = userRecoveryData.getRemainingSetIds();
        String preferredChannel = "";
        if (this.isServerSupportedNotificationChannel(storedNotificationChannel)) {
            preferredChannel = storedNotificationChannel;
            if (!notificationInternallyManage) {
                preferredChannel = NotificationChannels.EXTERNAL_CHANNEL.getChannelType();
            }
        }
        if (RecoveryScenarios.MOBILE_VERIFICATION_ON_UPDATE.toString().equals(recoveryScenario)) {
            preferredChannel = NotificationChannels.SMS_CHANNEL.getChannelType();
        }
        String secretKey = Utils.generateSecretKey(preferredChannel, user.getTenantDomain(), recoveryScenario);
        UserRecoveryData recoveryDataDO = new UserRecoveryData(user, secretKey, RecoveryScenarios.getRecoveryScenario(recoveryScenario), RecoverySteps.getRecoveryStep(recoveryStep));
        if (StringUtils.isNotBlank((String)preferredChannel)) {
            recoveryDataDO.setRemainingSetIds(preferredChannel);
            notificationResponseBean.setNotificationChannel(preferredChannel);
        }
        if (RecoveryScenarios.EMAIL_VERIFICATION_ON_UPDATE.toString().equals(recoveryScenario) && RecoverySteps.VERIFY_EMAIL.toString().equals(recoveryStep)) {
            String verificationPendingEmailClaimValue = userRecoveryData.getRemainingSetIds();
            properties = new Property[]{new Property("send-to", verificationPendingEmailClaimValue)};
            recoveryDataDO.setRemainingSetIds(verificationPendingEmailClaimValue);
        } else if (RecoveryScenarios.MOBILE_VERIFICATION_ON_UPDATE.toString().equals(recoveryScenario) && RecoverySteps.VERIFY_MOBILE_NUMBER.toString().equals(recoveryStep)) {
            String verificationPendingMobileNumber = userRecoveryData.getRemainingSetIds();
            properties = new Property[]{new Property("send-to", verificationPendingMobileNumber)};
            recoveryDataDO.setRemainingSetIds(verificationPendingMobileNumber);
        }
        userRecoveryDataStore.store(recoveryDataDO);
        if (notificationInternallyManage) {
            String eventName = this.resolveEventName(preferredChannel, user.getUserName(), user.getUserStoreDomain(), user.getTenantDomain());
            this.triggerNotification(user, preferredChannel, notificationType, secretKey, eventName, properties);
        } else {
            notificationResponseBean.setKey(secretKey);
        }
        return notificationResponseBean;
    }

    private String resolveEventName(String preferredChannel, String userName, String domainName, String tenantDomain) {
        String eventName = NotificationChannels.SMS_CHANNEL.getChannelType().equals(preferredChannel) ? "TRIGGER_" + preferredChannel + "_NOTIFICATION" : "TRIGGER_NOTIFICATION";
        if (log.isDebugEnabled()) {
            String message = String.format("For user : %1$s in domain : %2$s, notifications were sent from the event : %3$s", domainName + CarbonConstants.DOMAIN_SEPARATOR + userName, tenantDomain, eventName);
            log.debug((Object)message);
        }
        return eventName;
    }

    private boolean isServerSupportedNotificationChannel(String value) {
        try {
            return StringUtils.isNotBlank((String)NotificationChannels.getNotificationChannel((String)value).getChannelType());
        }
        catch (NotificationChannelManagerException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The given value : " + value + " is not a supported notification channel"), (Throwable)e);
            }
            return false;
        }
    }

    private void validateRequestParameters(User user, String recoveryScenario, String recoveryStep, String notificationType) throws IdentityRecoveryClientException {
        if (user == null) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USER_OBJECT_NOT_FOUND.getCode(), IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_USER_OBJECT_NOT_FOUND.getMessage(), null);
        }
        if (StringUtils.isBlank((String)recoveryScenario)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_RECOVERY_SCENARIO_NOT_PROVIDED, user.getUserName());
        }
        if (StringUtils.isBlank((String)recoveryStep)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_RECOVERY_STEP_NOT_PROVIDED, user.getUserName());
        }
        if (StringUtils.isBlank((String)notificationType)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NOTIFICATION_TYPE_NOT_PROVIDED, user.getUserName());
        }
    }

    private boolean isNotificationInternallyManage(User user) throws IdentityRecoveryServerException {
        return Boolean.parseBoolean(Utils.getSignUpConfigs("SelfRegistration.Notification.InternallyManage", user.getTenantDomain()));
    }

    private void resolveUserAttributes(User user) {
        if (StringUtils.isBlank((String)user.getTenantDomain())) {
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            if (StringUtils.isBlank((String)tenantDomain)) {
                tenantDomain = "carbon.super";
            }
            user.setTenantDomain(tenantDomain);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant domain is not in the request. Set super tenant domain for user : " + user.getUserName()));
            }
        }
        if (StringUtils.isBlank((String)user.getUserStoreDomain())) {
            user.setUserStoreDomain(IdentityUtil.getPrimaryDomainName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("User store domain is not in the request. Set primary user store domain for user : " + user.getUserName()));
            }
        }
    }

    private void validateWithOldConfirmationCode(String code, String recoveryScenario, String recoveryStep, UserRecoveryData userRecoveryData) throws IdentityRecoveryClientException {
        if (userRecoveryData == null || StringUtils.isBlank((String)userRecoveryData.getSecret()) || !recoveryScenario.equals(userRecoveryData.getRecoveryScenario().toString()) || !recoveryStep.equals(userRecoveryData.getRecoveryStep().toString())) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_OLD_CODE_NOT_FOUND, null);
        }
        if (code != null && !userRecoveryData.getSecret().equals(code)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PROVIDED_CONFIRMATION_CODE_NOT_VALID, code);
        }
    }
}

