/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery;

import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.util.Utils;

public enum RecoverySteps {
    NOTIFY,
    UPDATE_PASSWORD,
    VALIDATE_CHALLENGE_QUESTION,
    VALIDATE_ALL_CHALLENGE_QUESTION,
    CONFIRM_SIGN_UP,
    SEND_RECOVERY_INFORMATION,
    RESEND_CONFIRMATION_CODE,
    CONFIRM_LITE_SIGN_UP,
    VERIFY_EMAIL,
    VERIFY_MOBILE_NUMBER;


    public static RecoverySteps getRecoveryStep(String stepName) throws IdentityRecoveryClientException {
        RecoverySteps[] recoverySteps = new RecoverySteps[]{NOTIFY, UPDATE_PASSWORD, VALIDATE_CHALLENGE_QUESTION, VALIDATE_ALL_CHALLENGE_QUESTION, CONFIRM_SIGN_UP, CONFIRM_LITE_SIGN_UP, SEND_RECOVERY_INFORMATION, RESEND_CONFIRMATION_CODE, VERIFY_EMAIL, VERIFY_MOBILE_NUMBER};
        if (StringUtils.isNotEmpty((String)stepName)) {
            for (RecoverySteps step : recoverySteps) {
                if (!stepName.equals(step.name())) continue;
                return step;
            }
        }
        throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_RECOVERY_STEP, stepName);
    }
}

