/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery;

import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.util.Utils;

public enum RecoveryScenarios {
    NOTIFICATION_BASED_PW_RECOVERY,
    QUESTION_BASED_PWD_RECOVERY,
    USERNAME_RECOVERY,
    SELF_SIGN_UP,
    ASK_PASSWORD,
    ADMIN_FORCED_PASSWORD_RESET_VIA_EMAIL_LINK,
    ADMIN_FORCED_PASSWORD_RESET_VIA_OTP,
    EMAIL_VERIFICATION_ON_UPDATE,
    MOBILE_VERIFICATION_ON_UPDATE,
    LITE_SIGN_UP,
    TENANT_ADMIN_ASK_PASSWORD;


    public static RecoveryScenarios getRecoveryScenario(String scenarioName) throws IdentityRecoveryClientException {
        RecoveryScenarios[] scenarios = new RecoveryScenarios[]{NOTIFICATION_BASED_PW_RECOVERY, QUESTION_BASED_PWD_RECOVERY, USERNAME_RECOVERY, SELF_SIGN_UP, ASK_PASSWORD, ADMIN_FORCED_PASSWORD_RESET_VIA_EMAIL_LINK, ADMIN_FORCED_PASSWORD_RESET_VIA_OTP, LITE_SIGN_UP, TENANT_ADMIN_ASK_PASSWORD, EMAIL_VERIFICATION_ON_UPDATE, MOBILE_VERIFICATION_ON_UPDATE};
        if (StringUtils.isNotEmpty((String)scenarioName)) {
            for (RecoveryScenarios scenario : scenarios) {
                if (!scenarioName.equals(scenario.name())) continue;
                return scenario;
            }
        }
        throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_RECOVERY_SCENARIO, scenarioName);
    }
}

