/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.recovery;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.persistence.registry.RegistryResourceMgtService;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventClientException;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.IdentityEventServerException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.recovery.IdentityRecoveryClientException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryConstants;
import org.wso2.carbon.identity.recovery.IdentityRecoveryException;
import org.wso2.carbon.identity.recovery.IdentityRecoveryServerException;
import org.wso2.carbon.identity.recovery.internal.IdentityRecoveryServiceDataHolder;
import org.wso2.carbon.identity.recovery.model.ChallengeQuestion;
import org.wso2.carbon.identity.recovery.model.UserChallengeAnswer;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ChallengeQuestionManager {
    private static final Log log = LogFactory.getLog(ChallengeQuestionManager.class);
    private static ChallengeQuestionManager instance = new ChallengeQuestionManager();
    private IdentityRecoveryServiceDataHolder dataHolder = IdentityRecoveryServiceDataHolder.getInstance();
    private RegistryResourceMgtService resourceMgtService = this.dataHolder.getResourceMgtService();
    private static final String QUESTIONS_BASE_PATH = "/identity/questionCollection";

    private ChallengeQuestionManager() {
    }

    public static ChallengeQuestionManager getInstance() {
        return instance;
    }

    public List<ChallengeQuestion> getAllChallengeQuestions(String tenantDomain) throws IdentityRecoveryServerException {
        tenantDomain = this.validateTenantDomain(tenantDomain);
        ArrayList<ChallengeQuestion> challengeQuestions = new ArrayList<ChallengeQuestion>();
        try {
            Resource questionCollection = this.resourceMgtService.getIdentityResource(QUESTIONS_BASE_PATH, tenantDomain);
            if (questionCollection != null) {
                Collection questionSetCollection = (Collection)this.resourceMgtService.getIdentityResource(QUESTIONS_BASE_PATH, tenantDomain);
                for (String questionSetId : questionSetCollection.getChildren()) {
                    Collection questionIdCollection = (Collection)this.resourceMgtService.getIdentityResource(questionSetId, tenantDomain);
                    for (String questionIdPath : questionIdCollection.getChildren()) {
                        Collection questions = (Collection)this.resourceMgtService.getIdentityResource(questionIdPath, tenantDomain);
                        for (String question : questions.getChildren()) {
                            Resource resource = this.resourceMgtService.getIdentityResource(question, tenantDomain);
                            if (resource == null) continue;
                            challengeQuestions.add(this.createChallengeQuestion(resource));
                        }
                    }
                }
            }
            return challengeQuestions;
        }
        catch (RegistryException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_REGISTRY_EXCEPTION_GET_CHALLENGE_QUESTIONS, null, e);
        }
    }

    public List<ChallengeQuestion> getAllChallengeQuestions(String tenantDomain, String locale) throws IdentityRecoveryException {
        locale = this.validateLocale(locale);
        tenantDomain = this.validateTenantDomain(tenantDomain);
        ArrayList<ChallengeQuestion> questions = new ArrayList<ChallengeQuestion>();
        try {
            Resource questionCollection = this.resourceMgtService.getIdentityResource(QUESTIONS_BASE_PATH, tenantDomain);
            if (questionCollection != null) {
                Collection questionSetCollection = (Collection)this.resourceMgtService.getIdentityResource(QUESTIONS_BASE_PATH, tenantDomain);
                for (String questionSetId : questionSetCollection.getChildren()) {
                    Collection questionIdCollection = (Collection)this.resourceMgtService.getIdentityResource(questionSetId, tenantDomain);
                    for (String questionIdPath : questionIdCollection.getChildren()) {
                        Resource questionResource = this.resourceMgtService.getIdentityResource(questionIdPath, tenantDomain, locale);
                        if (questionResource == null) continue;
                        questions.add(this.createChallengeQuestion(questionResource));
                    }
                }
            }
        }
        catch (RegistryException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_REGISTRY_EXCEPTION_GET_CHALLENGE_QUESTIONS, null, e);
        }
        return questions;
    }

    public List<String> getAllChallengeQuestionSetsURIs(String tenantDomain) throws IdentityRecoveryServerException {
        tenantDomain = this.validateTenantDomain(tenantDomain);
        ArrayList<String> challengeQuestions = new ArrayList<String>();
        try {
            Resource questionCollection = this.resourceMgtService.getIdentityResource(QUESTIONS_BASE_PATH, tenantDomain);
            if (questionCollection != null) {
                Collection questionSetCollection = (Collection)this.resourceMgtService.getIdentityResource(QUESTIONS_BASE_PATH, tenantDomain);
                for (String questionSetId : questionSetCollection.getChildren()) {
                    challengeQuestions.add(questionSetId.replace(QUESTIONS_BASE_PATH, "http://wso2.org/claims"));
                }
            }
            return challengeQuestions;
        }
        catch (RegistryException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_REGISTRY_EXCEPTION_GET_CHALLENGE_QUESTIONS, null, e);
        }
    }

    public List<ChallengeQuestion> getAllChallengeQuestionsForUser(String tenantDomain, User user) throws IdentityRecoveryException {
        String locale = this.getLocaleOfUser(user, tenantDomain);
        List<ChallengeQuestion> challengeQuestions = this.getAllChallengeQuestions(tenantDomain, locale);
        if (challengeQuestions.isEmpty() && !StringUtils.equalsIgnoreCase((String)"en_US", (String)locale)) {
            String error = "No challenge questions available in '%s' locale in %s tenant. Sending questions of default '%s' locale";
            log.error((Object)String.format(error, locale, tenantDomain, "en_US"));
            challengeQuestions = this.getAllChallengeQuestions(tenantDomain, "en_US");
        }
        return challengeQuestions;
    }

    public void setDefaultChallengeQuestions(String tenantDomain) throws IdentityRecoveryException {
        boolean isDefaultAvailable;
        boolean bl = isDefaultAvailable = !this.getAllChallengeQuestions(tenantDomain = this.validateTenantDomain(tenantDomain)).isEmpty();
        if (isDefaultAvailable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Default Challenge Questions already available.");
            }
            return;
        }
        ChallengeQuestion[] questions = Utils.getDefaultChallengeQuestions();
        this.addChallengeQuestions(questions, tenantDomain);
        if (log.isDebugEnabled()) {
            String errorMsg = "%d default challenge questions added to registry of %s tenant.";
            log.debug((Object)String.format(errorMsg, questions.length, tenantDomain));
        }
    }

    public void addChallengeQuestions(ChallengeQuestion[] questions, String tenantDomain) throws IdentityRecoveryException {
        try {
            tenantDomain = this.validateTenantDomain(tenantDomain);
            Resource challengeQuestionCollection = this.resourceMgtService.getIdentityResource(QUESTIONS_BASE_PATH, tenantDomain);
            if (challengeQuestionCollection == null) {
                challengeQuestionCollection = new CollectionImpl();
                this.resourceMgtService.putIdentityResource(challengeQuestionCollection, QUESTIONS_BASE_PATH, tenantDomain);
            }
            for (ChallengeQuestion challengeQuestion : questions) {
                this.validateChallengeQuestionAttributes(challengeQuestion);
                String questionPath = this.getQuestionPath(challengeQuestion);
                String locale = this.validateLocale(challengeQuestion.getLocale());
                Resource resource = this.createRegistryResource(challengeQuestion);
                this.resourceMgtService.putIdentityResource(resource, questionPath, tenantDomain, locale);
            }
        }
        catch (UnsupportedEncodingException | RegistryException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_REGISTRY_EXCEPTION_SET_CHALLENGE_QUESTIONS, null, e);
        }
    }

    public void deleteChallengeQuestions(ChallengeQuestion[] challengeQuestions, String tenantDomain) throws IdentityRecoveryException {
        try {
            tenantDomain = this.validateTenantDomain(tenantDomain);
            for (ChallengeQuestion question : challengeQuestions) {
                if (!this.isChallengeQuestionExists(question, tenantDomain)) continue;
                String questionPath = this.getQuestionPath(question);
                if (StringUtils.isNotEmpty((String)question.getLocale())) {
                    String locale = question.getLocale();
                    this.resourceMgtService.deleteIdentityResource(questionPath, tenantDomain, locale);
                    continue;
                }
                this.resourceMgtService.deleteIdentityResource(questionPath, tenantDomain);
            }
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)("Error deleting challenge quesitons in " + tenantDomain));
            throw new IdentityRecoveryException("Error when deleting challenge questions.", e);
        }
    }

    public void deleteChallengeQuestionSet(String challengeQuestionUri, String locale, String tenantDomain) throws IdentityRecoveryException {
        try {
            tenantDomain = this.validateTenantDomain(tenantDomain);
            if (this.isChallengeQuestionSetExists(challengeQuestionUri, tenantDomain)) {
                String questionSetPath = this.getQuestionSetPath(challengeQuestionUri);
                if (StringUtils.isEmpty((String)locale)) {
                    this.resourceMgtService.deleteIdentityResource(questionSetPath, tenantDomain);
                } else {
                    this.deleteChallengeQuestionsByLocale(questionSetPath, tenantDomain, locale);
                }
            }
        }
        catch (IdentityRuntimeException e) {
            log.error((Object)("Error deleting challenge set in " + tenantDomain));
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_DELETING_CHALLENGE_SET, challengeQuestionUri, e);
        }
    }

    private void deleteChallengeQuestionsByLocale(String questionSetPath, String tenantDomain, String locale) throws IdentityRecoveryServerException {
        try {
            Collection questionIdCollection = (Collection)this.resourceMgtService.getIdentityResource(this.getQuestionSetPath(questionSetPath), tenantDomain);
            for (String questionIdPath : questionIdCollection.getChildren()) {
                Resource questionResource = this.resourceMgtService.getIdentityResource(questionIdPath, tenantDomain, locale);
                if (questionResource == null) continue;
                this.resourceMgtService.deleteIdentityResource(questionIdPath, tenantDomain, locale);
            }
        }
        catch (RegistryException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_REGISTRY_EXCEPTION_DELETE_CHALLENGE_QUESTIONS, locale, e);
        }
    }

    public UserChallengeAnswer[] getChallengeAnswersOfUser(User user) throws IdentityRecoveryException {
        this.validateUser(user);
        ArrayList<UserChallengeAnswer> userChallengeAnswers = new ArrayList<UserChallengeAnswer>();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving Challenge question from the user profile.");
        }
        List<String> challengesUris = this.getChallengeQuestionUris(user);
        for (String challengesUri1 : challengesUris) {
            String challengeValue;
            String challengesUri = challengesUri1.trim();
            try {
                challengeValue = Utils.getClaimFromUserStoreManager(user, challengesUri);
            }
            catch (UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_GETTING_CHALLENGE_QUESTIONS, user.getUserName(), e);
            }
            String challengeQuestionSeparator = this.getChallengeSeparator();
            String[] challengeValues = challengeValue.split(challengeQuestionSeparator);
            if (challengeValues == null || challengeValues.length != 2) continue;
            ChallengeQuestion userChallengeQuestion = new ChallengeQuestion(challengesUri, challengeValues[0].trim());
            UserChallengeAnswer userChallengeAnswer = new UserChallengeAnswer(userChallengeQuestion, challengeValues[1].trim());
            userChallengeAnswers.add(userChallengeAnswer);
        }
        if (!userChallengeAnswers.isEmpty()) {
            return userChallengeAnswers.toArray(new UserChallengeAnswer[userChallengeAnswers.size()]);
        }
        return new UserChallengeAnswer[0];
    }

    public ChallengeQuestion getUserChallengeQuestion(User user, String challengesUri) throws IdentityRecoveryException {
        String challengeQuestionSeparator;
        String[] challengeValues;
        this.validateUser(user);
        ChallengeQuestion userChallengeQuestion = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving Challenge question from the user profile.");
        }
        String challengeValue = null;
        try {
            challengeValue = Utils.getClaimFromUserStoreManager(user, challengesUri);
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_GETTING_CHALLENGE_QUESTION, user.getUserName(), e);
        }
        if (challengeValue != null && (challengeValues = challengeValue.split(challengeQuestionSeparator = this.getChallengeSeparator())) != null && challengeValues.length == 2) {
            userChallengeQuestion = new ChallengeQuestion(challengesUri, challengeValues[0].trim());
        }
        return userChallengeQuestion;
    }

    public String[] getUserChallengeQuestionIds(User user) throws IdentityRecoveryException {
        List<String> challengesUris;
        this.validateUser(user);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving answered Challenge question set ids from the user profile.");
        }
        if ((challengesUris = this.getChallengeQuestionUris(user)).isEmpty()) {
            String msg = "No associated challenge question found for the user : " + user.getUserName();
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            return new String[0];
        }
        String[] urls = new String[challengesUris.size()];
        return challengesUris.toArray(urls);
    }

    public List<String> getChallengeQuestionUris(User user) throws IdentityRecoveryException {
        this.validateUser(user);
        if (log.isDebugEnabled()) {
            String msg = String.format("Getting answered challenge question uris from %s's profile.", user.toString());
            log.debug((Object)msg);
        }
        ArrayList<String> challenges = new ArrayList<String>();
        String claimValue = null;
        try {
            claimValue = Utils.getClaimFromUserStoreManager(user, "http://wso2.org/claims/challengeQuestionUris");
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_GETTING_CHALLENGE_URIS, user.getUserName(), e);
        }
        if (claimValue != null) {
            String challengeQuestionSeparator = this.getChallengeSeparator();
            String[] challengesUris = claimValue.contains(challengeQuestionSeparator) ? claimValue.split(challengeQuestionSeparator) : new String[]{claimValue.trim()};
            for (String challengesUri : challengesUris) {
                if (!StringUtils.isNotBlank((String)challengesUri)) continue;
                challenges.add(challengesUri.trim());
            }
        }
        return challenges;
    }

    private Map<String, String> retrieveAnsweredChallenges(User user, UserChallengeAnswer[] userChallengeAnswers) throws IdentityRecoveryException {
        Map<String, String> existingQuestionAndAnswers = new HashMap<String, String>();
        if (ArrayUtils.isNotEmpty((Object[])userChallengeAnswers)) {
            ArrayList<String> claimsList = new ArrayList<String>();
            for (UserChallengeAnswer answer : userChallengeAnswers) {
                if (answer == null || answer.getQuestion() == null || !StringUtils.isNotBlank((String)answer.getQuestion().getQuestionSetId())) continue;
                claimsList.add(answer.getQuestion().getQuestionSetId().trim());
            }
            existingQuestionAndAnswers = Utils.getClaimListOfUser(user, claimsList.toArray(new String[0]));
        }
        if (log.isDebugEnabled() && MapUtils.isEmpty(existingQuestionAndAnswers)) {
            log.debug((Object)("No previous questions set for the user: " + user.getUserName()));
        }
        return existingQuestionAndAnswers;
    }

    public void setChallengesOfUser(User user, UserChallengeAnswer[] userChallengeAnswers) throws IdentityRecoveryException {
        this.validateUser(user);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Setting user challenge question answers in %s's profile.", user.toString()));
        }
        try {
            String tenantDomain = StringUtils.isBlank((String)user.getTenantDomain()) ? "carbon.super" : user.getTenantDomain();
            this.validateSecurityQuestionDuplicate(userChallengeAnswers);
            this.checkChallengeQuestionExists(userChallengeAnswers, tenantDomain);
            Map<String, String> existingQuestionAndAnswers = this.retrieveAnsweredChallenges(user, userChallengeAnswers);
            this.triggerChallengeAnswersValidation(user, userChallengeAnswers, existingQuestionAndAnswers, "PRE_SET_CHALLENGE_QUESTION_ANSWERS");
            ArrayList<String> challengesUris = new ArrayList<String>();
            String challengesUrisValue = "";
            String separator = this.getChallengeSeparator();
            HashMap<String, String> challengeQuestionToUpdate = new HashMap<String, String>();
            if (!ArrayUtils.isEmpty((Object[])userChallengeAnswers)) {
                for (UserChallengeAnswer userChallengeAnswer : userChallengeAnswers) {
                    if (!StringUtils.isNotBlank((String)userChallengeAnswer.getQuestion().getQuestionSetId()) || !StringUtils.isNotBlank((String)userChallengeAnswer.getQuestion().getQuestion()) || !StringUtils.isNotBlank((String)userChallengeAnswer.getAnswer())) continue;
                    String oldValue = existingQuestionAndAnswers.get(userChallengeAnswer.getQuestion().getQuestionSetId().trim());
                    if (oldValue != null && oldValue.contains(separator)) {
                        String oldAnswer = oldValue.split(separator)[1];
                        if (!oldAnswer.trim().equals(userChallengeAnswer.getAnswer().trim())) {
                            String claimValue = userChallengeAnswer.getQuestion().getQuestion().trim() + separator + Utils.doHash(userChallengeAnswer.getAnswer().trim().toLowerCase());
                            challengeQuestionToUpdate.put(userChallengeAnswer.getQuestion().getQuestionSetId().trim(), claimValue);
                        }
                    } else {
                        String claimValue = userChallengeAnswer.getQuestion().getQuestion().trim() + separator + Utils.doHash(userChallengeAnswer.getAnswer().trim().toLowerCase());
                        challengeQuestionToUpdate.put(userChallengeAnswer.getQuestion().getQuestionSetId().trim(), claimValue);
                    }
                    challengesUris.add(userChallengeAnswer.getQuestion().getQuestionSetId().trim());
                }
                for (String challengesUri : challengesUris) {
                    if ("".equals(challengesUrisValue)) {
                        challengesUrisValue = challengesUri;
                        continue;
                    }
                    challengesUrisValue = challengesUrisValue + separator + challengesUri;
                }
                challengeQuestionToUpdate.put("http://wso2.org/claims/challengeQuestionUris", challengesUrisValue);
                if (MapUtils.isNotEmpty(challengeQuestionToUpdate)) {
                    Utils.setClaimsListOfUser(user, challengeQuestionToUpdate);
                }
                this.triggerChallengeAnswersValidation(user, userChallengeAnswers, existingQuestionAndAnswers, "POST_SET_CHALLENGE_QUESTION_ANSWERS");
            }
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_REMOVING_CHALLENGE_QUESTIONS, user.getUserName(), e);
        }
    }

    private void triggerChallengeAnswersValidation(User user, UserChallengeAnswer[] userChallengeAnswers, Map<String, String> existingQuestionAndAnswers, String eventName) throws IdentityRecoveryClientException, IdentityRecoveryServerException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("USER", user);
        properties.put("userChallengeAnswers", userChallengeAnswers);
        properties.put("userOldChallengeAnswers", existingQuestionAndAnswers);
        try {
            UserStoreManager userStoreManager = IdentityUtil.getPrimaryDomainName().equals(user.getUserStoreDomain()) ? (UserStoreManager)CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager() : ((UserStoreManager)CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager()).getSecondaryUserStoreManager(user.getUserStoreDomain());
            properties.put("userStoreManager", userStoreManager);
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_FAILED_TO_LOAD_USER_STORE_MANAGER, null, e);
        }
        Event identityMgtEvent = new Event(eventName, properties);
        try {
            IdentityRecoveryServiceDataHolder.getInstance().getIdentityEventService().handleEvent(identityMgtEvent);
        }
        catch (IdentityEventClientException e) {
            throw new IdentityRecoveryClientException(e.getErrorCode(), e.getMessage(), e);
        }
        catch (IdentityEventServerException e) {
            throw new IdentityRecoveryServerException(e.getErrorCode(), e.getMessage(), e);
        }
        catch (IdentityEventException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_PUBLISH_EVENT, eventName, e);
        }
    }

    private String getChallengeSeparator() {
        String separator = IdentityUtil.getProperty((String)"Recovery.Question.Password.Separator");
        if (StringUtils.isEmpty((String)separator)) {
            separator = "!";
        }
        return separator;
    }

    public void setChallengeOfUser(User user, UserChallengeAnswer userChallengeAnswer) throws IdentityRecoveryException {
        this.validateUser(user);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Setting user challenge question answers in %s's profile.", user.toString()));
        }
        try {
            String tenantDomain = StringUtils.isBlank((String)user.getTenantDomain()) ? "carbon.super" : user.getTenantDomain();
            this.validateSecurityQuestionDuplicate(new UserChallengeAnswer[]{userChallengeAnswer});
            this.checkChallengeQuestionExists(new UserChallengeAnswer[]{userChallengeAnswer}, tenantDomain);
            HashSet<String> challengesUris = new HashSet<String>(this.getChallengeQuestionUris(user));
            String separator = this.getChallengeSeparator();
            if (userChallengeAnswer.getQuestion().getQuestionSetId() != null && userChallengeAnswer.getQuestion().getQuestion() != null && userChallengeAnswer.getAnswer() != null) {
                String claimValue = userChallengeAnswer.getQuestion().getQuestion().trim() + separator + Utils.doHash(userChallengeAnswer.getAnswer().trim().toLowerCase());
                Utils.setClaimInUserStoreManager(user, userChallengeAnswer.getQuestion().getQuestionSetId().trim(), claimValue);
                challengesUris.add(userChallengeAnswer.getQuestion().getQuestionSetId().trim());
                this.setUserChallengesURI(user, challengesUris, separator);
            }
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_REMOVING_CHALLENGE_QUESTIONS, user.getUserName(), e);
        }
    }

    private void setUserChallengesURI(User user, Set<String> challengesUris, String separator) throws UserStoreException {
        String challengesUrisValue = this.getUserChallengesUriValue(challengesUris, separator);
        Utils.setClaimInUserStoreManager(user, "http://wso2.org/claims/challengeQuestionUris", challengesUrisValue);
    }

    private void setUserChallengesURI(User user, Set<String> challengesUris) throws UserStoreException {
        this.setUserChallengesURI(user, challengesUris, this.getChallengeSeparator());
    }

    private String getUserChallengesUriValue(Set<String> challengesUris, String separator) {
        String challengesUrisValue = "";
        for (String challengesUri : challengesUris) {
            if ("".equals(challengesUrisValue)) {
                challengesUrisValue = challengesUri;
                continue;
            }
            challengesUrisValue = challengesUrisValue + separator + challengesUri;
        }
        return challengesUrisValue;
    }

    public void removeChallengeAnswersOfUser(User user) throws IdentityRecoveryException {
        this.validateUser(user);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing Challenge question answers from the user profile.");
        }
        List<String> challengesUris = this.getChallengeQuestionUris(user);
        challengesUris.add("http://wso2.org/claims/challengeQuestionUris");
        try {
            Utils.removeClaimFromUserStoreManager(user, challengesUris.toArray(new String[challengesUris.size()]));
        }
        catch (UserStoreException e) {
            throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_REMOVING_CHALLENGE_QUESTIONS, user.getUserName(), e);
        }
    }

    public void removeChallengeAnswerOfUser(User user, String questionURI) throws IdentityRecoveryException {
        HashSet<String> challengesUris;
        this.validateUser(user);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing a Challenge answer from the user profile.");
        }
        if ((challengesUris = new HashSet<String>(this.getChallengeQuestionUris(user))).contains(questionURI)) {
            try {
                Utils.removeClaimFromUserStoreManager(user, new String[]{questionURI});
                challengesUris.remove(questionURI);
                this.setUserChallengesURI(user, challengesUris);
            }
            catch (UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_GETTING_CHALLENGE_QUESTIONS, user.getUserName(), e);
            }
        }
    }

    public boolean verifyChallengeAnswer(User user, UserChallengeAnswer[] userChallengeAnswers) throws IdentityRecoveryException {
        this.validateUser(user);
        boolean verification = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Verifying challenge question answers for %s.", user.toString()));
        }
        UserChallengeAnswer[] storedAnswers = this.getChallengeAnswersOfUser(user);
        for (UserChallengeAnswer userChallengeAnswer : userChallengeAnswers) {
            if (StringUtils.isBlank((String)userChallengeAnswer.getAnswer())) {
                return false;
            }
            for (UserChallengeAnswer storedAnswer : storedAnswers) {
                if (!(userChallengeAnswer.getQuestion().getQuestionSetId() != null && userChallengeAnswer.getQuestion().getQuestionSetId().trim().equals(storedAnswer.getQuestion().getQuestionSetId()) || userChallengeAnswer.getQuestion().getQuestion() != null && userChallengeAnswer.getQuestion().getQuestion().trim().equals(storedAnswer.getQuestion().getQuestion()))) continue;
                String hashedAnswer = null;
                try {
                    hashedAnswer = Utils.doHash(userChallengeAnswer.getAnswer().trim().toLowerCase());
                }
                catch (UserStoreException e) {
                    throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_HASHING_ALGO, null, e);
                }
                if (hashedAnswer.equals(storedAnswer.getAnswer())) {
                    verification = true;
                    continue;
                }
                return false;
            }
        }
        return verification;
    }

    public boolean verifyUserChallengeAnswer(User user, UserChallengeAnswer userChallengeAnswer) throws IdentityRecoveryException {
        this.validateUser(user);
        boolean verification = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Verifying challenge question answer for %s.", user.toString()));
        }
        UserChallengeAnswer[] storedDto = this.getChallengeAnswersOfUser(user);
        if (StringUtils.isBlank((String)userChallengeAnswer.getAnswer())) {
            log.error((Object)"Invalid. Empty answer provided for the challenge question.");
            return false;
        }
        for (UserChallengeAnswer dto : storedDto) {
            if (!dto.getQuestion().getQuestionSetId().equals(userChallengeAnswer.getQuestion().getQuestionSetId())) continue;
            String hashedAnswer = null;
            try {
                hashedAnswer = Utils.doHash(userChallengeAnswer.getAnswer().trim().toLowerCase());
            }
            catch (UserStoreException e) {
                throw Utils.handleServerException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_NO_HASHING_ALGO, null, e);
            }
            if (hashedAnswer.equals(dto.getAnswer())) {
                verification = true;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Challenge question answer verified successfully.");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Challenge question answer verification failed.");
            }
            return false;
        }
        return verification;
    }

    private boolean isChallengeQuestionExists(ChallengeQuestion challengeQuestion, String tenantDomain) throws IdentityRecoveryClientException {
        this.validateChallengeQuestionMandatoryParams(challengeQuestion);
        String questionPath = this.getQuestionPath(challengeQuestion);
        if (StringUtils.isNotEmpty((String)challengeQuestion.getLocale())) {
            String locale = this.validateLocale(challengeQuestion.getLocale());
            return this.resourceMgtService.getIdentityResource(questionPath, tenantDomain, locale) != null;
        }
        return this.resourceMgtService.getIdentityResource(questionPath, tenantDomain) != null;
    }

    private boolean isChallengeQuestionSetExists(String questionSetID, String tenantDomain) throws IdentityRecoveryClientException {
        this.validateChallengeSetURI(questionSetID);
        String questionPath = this.getQuestionSetPath(questionSetID);
        return this.resourceMgtService.getIdentityResource(questionPath, tenantDomain) != null;
    }

    private ChallengeQuestion createChallengeQuestion(Resource resource) throws RegistryException {
        ChallengeQuestion challengeQuestion = null;
        byte[] resourceContent = (byte[])resource.getContent();
        String questionText = new String(resourceContent, Charset.forName("UTF-8"));
        String questionSetId = resource.getProperty("questionSetId");
        String questionId = resource.getProperty("questionId");
        String questionLocale = resource.getProperty("locale");
        if (questionSetId != null) {
            if (IdentityUtil.isBlank((String)questionLocale)) {
                questionLocale = "en_US";
            }
            challengeQuestion = new ChallengeQuestion(questionSetId, questionId, questionText, questionLocale);
        }
        return challengeQuestion;
    }

    private Resource createRegistryResource(ChallengeQuestion question) throws RegistryException, UnsupportedEncodingException {
        byte[] questionText = question.getQuestion().getBytes("UTF-8");
        String questionSetId = question.getQuestionSetId();
        String questionId = question.getQuestionId();
        String locale = question.getLocale();
        ResourceImpl resource = new ResourceImpl();
        resource.setContent((Object)questionText);
        resource.addProperty("questionSetId", questionSetId);
        resource.addProperty("questionId", questionId);
        resource.addProperty("locale", locale);
        resource.setMediaType("tag");
        return resource;
    }

    private String getQuestionPath(ChallengeQuestion challengeQuestion) {
        String questionSetIdUri = challengeQuestion.getQuestionSetId();
        String questionId = challengeQuestion.getQuestionId();
        return this.getQuestionSetPath(questionSetIdUri) + "/" + questionId;
    }

    private String getQuestionSetPath(String questionSetIdUri) {
        String questionSetId = Utils.getChallengeSetDirFromUri(questionSetIdUri);
        return "/identity/questionCollection/" + questionSetId;
    }

    private void validateSecurityQuestionDuplicate(UserChallengeAnswer[] userChallengeAnswers) throws IdentityRecoveryException {
        HashSet<String> tmpMap = new HashSet<String>();
        for (UserChallengeAnswer userChallengeAnswer : userChallengeAnswers) {
            UserChallengeAnswer challengeAnswer = userChallengeAnswer;
            ChallengeQuestion challengeQuestion = challengeAnswer.getQuestion();
            if (challengeQuestion == null) {
                String errorMsg = "Challenge question details not provided with the challenge answers.";
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CHALLENGE_QUESTION_NOT_FOUND, errorMsg);
            }
            if (tmpMap.contains(challengeQuestion.getQuestionSetId())) {
                log.error((Object)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DUPLICATE_ANSWERS.getMessage());
                throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_DUPLICATE_ANSWERS, null);
            }
            tmpMap.add(challengeQuestion.getQuestionSetId());
        }
    }

    private void checkChallengeQuestionExists(UserChallengeAnswer[] userChallengeAnswers, String tenantDomain) throws IdentityRecoveryException {
        for (UserChallengeAnswer challengeAnswer : userChallengeAnswers) {
            ChallengeQuestion challengeQuestion = challengeAnswer.getQuestion();
            if (challengeQuestion == null) {
                Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CHALLENG_ANSWER_MISSING, null);
            }
            if (StringUtils.isBlank((String)challengeQuestion.getQuestion())) {
                Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHALLENGE_QUESTION_VALUE, null);
            }
            String locale = this.validateLocale(challengeQuestion.getLocale());
            List<ChallengeQuestion> challengeQuestions = this.getAllChallengeQuestions(tenantDomain, locale);
            boolean isQuestionAvailable = false;
            for (ChallengeQuestion availableQuestion : challengeQuestions) {
                if (!StringUtils.equals((String)availableQuestion.getQuestionSetId(), (String)challengeQuestion.getQuestionSetId().trim()) || !StringUtils.equals((String)availableQuestion.getQuestion().trim(), (String)challengeQuestion.getQuestion().trim())) continue;
                isQuestionAvailable = true;
            }
            if (isQuestionAvailable) continue;
            String error = "Error persisting user challenge answers for user. Challenge question answered is not registered with %s domain.";
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_CHALLENGE_QUESTION_NOT_FOUND, String.format(error, tenantDomain));
        }
    }

    private String validateTenantDomain(String tenantDomain) {
        return StringUtils.isBlank((String)tenantDomain) ? "carbon.super" : tenantDomain;
    }

    private String validateLocale(String locale) throws IdentityRecoveryClientException {
        if (StringUtils.isBlank((String)locale)) {
            locale = "en_US";
        }
        if (locale.matches(".*[/\\\\].*")) {
            log.error((Object)("Invalid locale value provided : " + locale));
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_LOCALE, locale);
        }
        return locale;
    }

    private void validateUser(User user) throws IdentityRecoveryClientException {
        if (user == null || StringUtils.isBlank((String)user.getUserName())) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_USER, "Invalid User Data provided.");
        }
    }

    private void validateChallengeQuestionAttributes(ChallengeQuestion question) throws IdentityRecoveryClientException {
        String setId = question.getQuestionSetId();
        String questionId = question.getQuestionId();
        String questionText = question.getQuestion();
        String questionLocale = question.getLocale();
        if (StringUtils.isBlank((String)setId) || StringUtils.isBlank((String)questionId) || StringUtils.isBlank((String)questionText) || StringUtils.isBlank((String)questionLocale)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHALLENGE, null);
        }
        this.validateChallengePathParams(setId, questionId);
    }

    private void validateChallengeQuestionMandatoryParams(ChallengeQuestion question) throws IdentityRecoveryClientException {
        String setId = question.getQuestionSetId();
        String questionId = question.getQuestionId();
        if (StringUtils.isBlank((String)setId) || StringUtils.isBlank((String)questionId)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHALLENGE, null);
        }
        this.validateChallengePathParams(setId, questionId);
    }

    private void validateChallengePathParams(String setId, String questionId) throws IdentityRecoveryClientException {
        this.validateChallengeSetURI(setId);
        this.validateChallengePathParam(questionId, "QuestionId");
    }

    private void validateChallengeSetURI(String setId) throws IdentityRecoveryClientException {
        String challengeSetDir = Utils.getChallengeSetDirFromUri(setId);
        this.validateChallengePathParam(challengeSetDir, "ChallengeSetId");
    }

    private void validateChallengePathParam(String pathParam, String pathParamName) throws IdentityRecoveryClientException {
        if (StringUtils.isBlank((String)pathParam) || !StringUtils.isAlphanumeric((String)pathParam)) {
            throw Utils.handleClientException(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_INVALID_CHALLENGE_PATH, pathParamName);
        }
    }

    private String getLocaleOfUser(User user, String tenantDomain) throws IdentityRecoveryException {
        String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)user.getUserName());
        String locale = "en_US";
        try {
            String userLocale = Utils.getClaimFromUserStoreManager(user, "http://wso2.org/claims/locality");
            if (StringUtils.isNotBlank((String)userLocale)) {
                locale = userLocale;
            }
        }
        catch (UserStoreException e) {
            String errorMsg = String.format(IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_RETRIVING_CLAIM.getMessage(), tenantAwareUserName, tenantDomain);
            log.error((Object)errorMsg);
            throw (IdentityRecoveryServerException)IdentityException.error(IdentityRecoveryServerException.class, (String)IdentityRecoveryConstants.ErrorMessages.ERROR_CODE_ERROR_RETRIVING_CLAIM.getCode(), (String)errorMsg, (Throwable)e);
        }
        return locale;
    }
}

