/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;

@Component(name="application.mgt.dscomponent", immediate=true)
public class AppManagementServiceComponent {
    private static Log log = LogFactory.getLog(AppManagementServiceComponent.class);
    private static ApplicationManagerService applicationManager;

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activated AppManagementServiceComponent");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivated AppManagementServiceComponent");
        }
    }

    @Reference(name="application.manager", service=ApplicationManagerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAppManager")
    protected void setAppManager(ApplicationManagerService appManager) {
        applicationManager = appManager;
    }

    protected void unsetAppManager(ApplicationManagerService appManager) {
        applicationManager = null;
    }

    public static ApplicationManagerService getAppManager() throws Exception {
        if (applicationManager == null) {
            String msg = "Before activating App management service bundle, an instance of ApplicationManager should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return applicationManager;
    }
}

