/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.password.policy.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.identity.password.policy.handler.PasswordPolicyValidationHandler;
import org.wso2.carbon.identity.password.policy.internal.IdentityPasswordPolicyServiceDataHolder;

@Component(name="org.wso2.carbon.identity.password.policy.internal.IdentityPasswordPolicyServiceComponent", immediate=true)
public class IdentityPasswordPolicyServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityPasswordPolicyServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Password Policy Service component is enabled");
            }
            BundleContext bundleContext = context.getBundleContext();
            IdentityPasswordPolicyServiceDataHolder.getInstance().setBundleContext(bundleContext);
            PasswordPolicyValidationHandler handler = new PasswordPolicyValidationHandler();
            context.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)handler, null);
        }
        catch (Exception e) {
            log.error((Object)"Error while activating password policy component.", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Password Policy Service component is de-activated");
        }
    }

    protected void unsetIdentityGovernanceService(IdentityGovernanceService idpManager) {
        IdentityPasswordPolicyServiceDataHolder.getInstance().setIdentityGovernanceService(null);
    }

    @Reference(name="IdentityGovernanceService", service=IdentityGovernanceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityGovernanceService")
    protected void setIdentityGovernanceService(IdentityGovernanceService idpManager) {
        IdentityPasswordPolicyServiceDataHolder.getInstance().setIdentityGovernanceService(idpManager);
    }
}

