/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.password.policy.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.governance.common.IdentityConnectorConfig;
import org.wso2.carbon.identity.mgt.policy.PolicyEnforcer;
import org.wso2.carbon.identity.mgt.policy.PolicyRegistry;
import org.wso2.carbon.identity.mgt.policy.PolicyViolationException;
import org.wso2.carbon.identity.mgt.policy.password.DefaultPasswordLengthPolicy;
import org.wso2.carbon.identity.mgt.policy.password.DefaultPasswordNamePolicy;
import org.wso2.carbon.identity.mgt.policy.password.DefaultPasswordPatternPolicy;
import org.wso2.carbon.identity.password.policy.constants.PasswordPolicyConstants;
import org.wso2.carbon.identity.password.policy.internal.IdentityPasswordPolicyServiceDataHolder;
import org.wso2.carbon.identity.password.policy.util.Utils;

public class PasswordPolicyValidationHandler
extends AbstractEventHandler
implements IdentityConnectorConfig {
    private static final Log log = LogFactory.getLog(PasswordPolicyValidationHandler.class);

    public void handleEvent(Event event) throws IdentityEventException {
        Property[] identityProperties;
        Map eventProperties = event.getEventProperties();
        String userName = (String)eventProperties.get("user-name");
        String tenantDomain = (String)eventProperties.get("tenant-domain");
        Object credentials = eventProperties.get("CREDENTIAL");
        try {
            identityProperties = IdentityPasswordPolicyServiceDataHolder.getInstance().getIdentityGovernanceService().getConfiguration(this.getPropertyNames(), tenantDomain);
        }
        catch (IdentityGovernanceException e) {
            throw new IdentityEventException("Error while retrieving password policy properties.", (Throwable)e);
        }
        String pwMinLength = "6";
        String pwMaxLength = "12";
        String pwPattern = "^((?=.*\\\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%&*])).{0,100}$";
        String errorMsg = "Password pattern policy violated. Password should contain a digit[0-9], a lower case letter[a-z], an upper case letter[A-Z], one of !@#$%&* characters";
        for (Property identityProperty : identityProperties) {
            if (identityProperty == null) continue;
            String propertyName = identityProperty.getName();
            String propertyValue = identityProperty.getValue();
            if ("passwordPolicy.enable".equals(propertyName)) {
                boolean passwordPolicyValidation = BooleanUtils.toBoolean((String)propertyValue);
                if (passwordPolicyValidation) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Password Policy validation is disabled");
                }
                return;
            }
            if ("passwordPolicy.min.length".equals(propertyName)) {
                if (NumberUtils.isNumber((String)propertyValue) && Integer.parseInt(propertyValue) > 0) {
                    pwMinLength = propertyValue;
                    continue;
                }
                log.warn((Object)("Password Policy MIN Length is not correct hence using default value: " + pwMinLength));
                continue;
            }
            if ("passwordPolicy.max.length".equals(propertyName)) {
                if (NumberUtils.isNumber((String)propertyValue) && Integer.parseInt(propertyValue) > 0) {
                    pwMaxLength = propertyValue;
                    continue;
                }
                log.warn((Object)("Password Policy MAX Length is not correct hence using default value: " + pwMaxLength));
                continue;
            }
            if ("passwordPolicy.pattern".equals(propertyName)) {
                if (StringUtils.isNotBlank((String)propertyValue)) {
                    pwPattern = propertyValue;
                    continue;
                }
                log.warn((Object)("Password Policy Pattern is not correct hence using default value: " + pwPattern));
                continue;
            }
            if (!"passwordPolicy.errorMsg".equals(propertyName)) continue;
            if (StringUtils.isNotBlank((String)propertyValue)) {
                errorMsg = propertyValue;
                continue;
            }
            log.warn((Object)("Password Policy Error Msg cannot be Empty hence using default Msg: " + errorMsg));
        }
        PolicyRegistry policyRegistry = new PolicyRegistry();
        String pwLengthPolicyCls = this.configs.getModuleProperties().getProperty("passwordPolicy.class.PasswordLengthPolicy");
        String pwNamePolicyCls = this.configs.getModuleProperties().getProperty("passwordPolicy.class.PasswordNamePolicy");
        String pwPatternPolicyCls = this.configs.getModuleProperties().getProperty("passwordPolicy.class.PasswordPatternPolicy");
        try {
            if (StringUtils.isNotBlank((String)pwLengthPolicyCls)) {
                DefaultPasswordLengthPolicy defaultPasswordLengthPolicy = (DefaultPasswordLengthPolicy)Class.forName(pwLengthPolicyCls).newInstance();
                HashMap<String, String> pwPolicyLengthParams = new HashMap<String, String>();
                pwPolicyLengthParams.put("min.length", pwMinLength);
                pwPolicyLengthParams.put("max.length", pwMaxLength);
                defaultPasswordLengthPolicy.init(pwPolicyLengthParams);
                policyRegistry.addPolicy((PolicyEnforcer)defaultPasswordLengthPolicy);
            }
            if (StringUtils.isNotBlank((String)pwNamePolicyCls)) {
                DefaultPasswordNamePolicy defaultPasswordNamePolicy = (DefaultPasswordNamePolicy)Class.forName(pwNamePolicyCls).newInstance();
                policyRegistry.addPolicy((PolicyEnforcer)defaultPasswordNamePolicy);
            }
            if (StringUtils.isNotBlank((String)pwPatternPolicyCls)) {
                DefaultPasswordPatternPolicy defaultPasswordPatternPolicy = (DefaultPasswordPatternPolicy)Class.forName(pwPatternPolicyCls).newInstance();
                HashMap<String, String> pwPolicyPatternParams = new HashMap<String, String>();
                pwPolicyPatternParams.put("pattern", pwPattern);
                pwPolicyPatternParams.put("errorMsg", errorMsg);
                defaultPasswordPatternPolicy.init(pwPolicyPatternParams);
                policyRegistry.addPolicy((PolicyEnforcer)defaultPasswordPatternPolicy);
            }
        }
        catch (Exception e) {
            throw Utils.handleEventException(PasswordPolicyConstants.ErrorMessages.ERROR_CODE_LOADING_PASSWORD_POLICY_CLASSES, null, e);
        }
        try {
            policyRegistry.enforcePasswordPolicies(new Object[]{credentials.toString(), userName});
        }
        catch (PolicyViolationException e) {
            throw Utils.handleEventException(PasswordPolicyConstants.ErrorMessages.ERROR_CODE_VALIDATING_PASSWORD_POLICY, e.getMessage(), e);
        }
    }

    public String getName() {
        return "passwordPolicy";
    }

    public String getFriendlyName() {
        return "Password Patterns";
    }

    public String getCategory() {
        return "Password Policies";
    }

    public String getSubCategory() {
        return "DEFAULT";
    }

    public int getOrder() {
        return 0;
    }

    public Map<String, String> getPropertyNameMapping() {
        HashMap<String, String> nameMapping = new HashMap<String, String>();
        nameMapping.put("passwordPolicy.enable", "Validate passwords based on a policy pattern");
        nameMapping.put("passwordPolicy.min.length", "Minimum number of characters");
        nameMapping.put("passwordPolicy.max.length", "Maximum number of characters");
        nameMapping.put("passwordPolicy.pattern", "Password pattern regex");
        nameMapping.put("passwordPolicy.errorMsg", "Error message on pattern violation");
        return nameMapping;
    }

    public Map<String, String> getPropertyDescriptionMapping() {
        HashMap<String, String> descriptionMapping = new HashMap<String, String>();
        descriptionMapping.put("passwordPolicy.enable", "Validate user passwords against a policy");
        descriptionMapping.put("passwordPolicy.min.length", "Minimum number of characters in the password.");
        descriptionMapping.put("passwordPolicy.max.length", "Maximum number of characters in the password.");
        descriptionMapping.put("passwordPolicy.pattern", "The regular expression pattern to validate the password.");
        descriptionMapping.put("passwordPolicy.errorMsg", "This error message will be displayed when a pattern violation is detected.");
        return descriptionMapping;
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
        IdentityPasswordPolicyServiceDataHolder.getInstance().getBundleContext().registerService(IdentityConnectorConfig.class.getName(), (Object)this, null);
    }

    public String[] getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("passwordPolicy.enable");
        properties.add("passwordPolicy.min.length");
        properties.add("passwordPolicy.max.length");
        properties.add("passwordPolicy.pattern");
        properties.add("passwordPolicy.errorMsg");
        return properties.toArray(new String[0]);
    }

    public Properties getDefaultPropertyValues(String tenantDomain) throws IdentityGovernanceException {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("passwordPolicy.enable", this.configs.getModuleProperties().getProperty("passwordPolicy.enable"));
        defaultProperties.put("passwordPolicy.min.length", this.configs.getModuleProperties().getProperty("passwordPolicy.min.length"));
        defaultProperties.put("passwordPolicy.max.length", this.configs.getModuleProperties().getProperty("passwordPolicy.max.length"));
        defaultProperties.put("passwordPolicy.pattern", this.configs.getModuleProperties().getProperty("passwordPolicy.pattern"));
        defaultProperties.put("passwordPolicy.errorMsg", this.configs.getModuleProperties().getProperty("passwordPolicy.errorMsg"));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)defaultProperties);
        return properties;
    }

    public Map<String, String> getDefaultPropertyValues(String[] propertyNames, String tenantDomain) throws IdentityGovernanceException {
        return null;
    }
}

