/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.ui.util;

import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.mgt.ui.ApplicationBean;

public class ApplicationMgtUIUtil {
    private static final String SP_UNIQUE_ID_MAP = "spUniqueIdMap";
    public static final String JWKS_URI = "jwksURI";
    public static final String JWKS_DISPLAYNAME = "JWKS Endpoint";

    public static ApplicationBean getApplicationBeanFromSession(HttpSession session, String spName) {
        HashMap spUniqueIdMap;
        if (session.getAttribute(SP_UNIQUE_ID_MAP) == null) {
            spUniqueIdMap = new HashMap();
            session.setAttribute(SP_UNIQUE_ID_MAP, (Object)spUniqueIdMap);
        } else {
            spUniqueIdMap = (HashMap)session.getAttribute(SP_UNIQUE_ID_MAP);
        }
        if (spUniqueIdMap.get(spName) == null) {
            ApplicationBean applicationBean = new ApplicationBean();
            UUID uuid = UUID.randomUUID();
            spUniqueIdMap.put(spName, uuid);
            session.setAttribute(uuid.toString(), (Object)applicationBean);
        }
        return (ApplicationBean)session.getAttribute(((UUID)spUniqueIdMap.get(spName)).toString());
    }

    public static void removeApplicationBeanFromSession(HttpSession session, String spName) {
        if (session.getAttribute(SP_UNIQUE_ID_MAP) == null) {
            return;
        }
        HashMap spUniqueIdMap = (HashMap)session.getAttribute(SP_UNIQUE_ID_MAP);
        if (spUniqueIdMap.get(spName) == null) {
            return;
        }
        session.removeAttribute(((UUID)spUniqueIdMap.get(spName)).toString());
        spUniqueIdMap.remove(spName);
    }

    public static String resolveFilterString(String filterString) {
        if (!StringUtils.isNotBlank((String)filterString)) {
            return "*";
        }
        return filterString.trim();
    }

    public static String resolvePaginationValue(String filterString, String region, String item) {
        if (filterString != null) {
            return String.format("region=%s&item=%s&filterString=%s", region, item, filterString);
        }
        return String.format("region=%s&item=%s", region, item);
    }
}

