/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.ui.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.identity.application.mgt.ui.internal.ApplicationMgtServiceComponentHolder;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.identity.application.mgt.ui", immediate=true)
public class ApplicationMgtUIServiceComponent {
    private static final Log log = LogFactory.getLog(ApplicationMgtUIServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Application Management UI bundle acticated!");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Application Management UI bundle is deactivated");
        }
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        ApplicationMgtServiceComponentHolder.getInstance().setConfigurationContextService(configurationContextService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService Instance was set.");
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        ApplicationMgtServiceComponentHolder.getInstance().setConfigurationContextService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService Instance was unset.");
        }
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="consent.mgt.service", service=ConsentManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentMgtService")
    protected void setConsentMgtService(ConsentManager consentManager) {
        ApplicationMgtServiceComponentHolder.getInstance().setConsentManager(consentManager);
    }

    protected void unsetConsentMgtService(ConsentManager consentManager) {
        ApplicationMgtServiceComponentHolder.getInstance().setConsentManager(null);
    }
}

