/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.ui.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.xsd.ApplicationBasicInfo;
import org.wso2.carbon.identity.application.common.model.xsd.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.xsd.ImportResponse;
import org.wso2.carbon.identity.application.common.model.xsd.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.xsd.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.xsd.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.xsd.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.xsd.SpFileContent;
import org.wso2.carbon.identity.application.common.model.xsd.SpTemplate;
import org.wso2.carbon.identity.application.mgt.stub.IdentityApplicationManagementServiceIdentityApplicationManagementClientException;
import org.wso2.carbon.identity.application.mgt.stub.IdentityApplicationManagementServiceIdentityApplicationManagementException;
import org.wso2.carbon.identity.application.mgt.stub.IdentityApplicationManagementServiceStub;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;
import org.wso2.carbon.user.mgt.stub.types.carbon.UserStoreInfo;

public class ApplicationManagementServiceClient {
    private IdentityApplicationManagementServiceStub stub;
    private static final Log log = LogFactory.getLog(ApplicationManagementServiceClient.class);
    boolean debugEnabled = log.isErrorEnabled();
    private UserAdminStub userAdminStub;
    private static boolean paginationSupportVerified = false;
    private static boolean paginationSupported = false;

    public ApplicationManagementServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "IdentityApplicationManagementService";
        String userAdminServiceURL = backendServerURL + "UserAdmin";
        this.stub = new IdentityApplicationManagementServiceStub(configCtx, serviceURL);
        this.userAdminStub = new UserAdminStub(configCtx, userAdminServiceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        ServiceClient userAdminClient = this.userAdminStub._getServiceClient();
        Options userAdminOptions = userAdminClient.getOptions();
        userAdminOptions.setManageSession(true);
        userAdminOptions.setProperty("Cookie", (Object)cookie);
        if (this.debugEnabled) {
            log.debug((Object)("Invoking service " + serviceURL));
        }
    }

    public void createApplicationWithTemplate(ServiceProvider serviceProvider, String templateName) throws AxisFault {
        try {
            if (this.debugEnabled) {
                log.debug((Object)String.format("Registering Service Provider: %s using the SP Template: %s.", serviceProvider.getApplicationName(), templateName));
            }
            this.stub.createApplicationWithTemplate(serviceProvider, templateName);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
        }
    }

    public ServiceProvider getApplication(String applicationName) throws AxisFault {
        try {
            if (this.debugEnabled) {
                log.debug((Object)("Loading Service Provider " + applicationName));
            }
            return this.stub.getApplication(applicationName);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return null;
        }
    }

    public ApplicationBasicInfo[] getAllApplicationBasicInfo() throws Exception {
        try {
            return this.stub.getAllApplicationBasicInfo();
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new ApplicationBasicInfo[0];
        }
    }

    public ApplicationBasicInfo[] getApplicationBasicInfo(String filter) throws AxisFault {
        try {
            return this.stub.getApplicationBasicInfo(filter);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new ApplicationBasicInfo[0];
        }
    }

    public ApplicationBasicInfo[] getAllPaginatedApplicationBasicInfo(int pageNumber) throws Exception {
        try {
            return this.stub.getAllPaginatedApplicationBasicInfo(pageNumber);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new ApplicationBasicInfo[0];
        }
    }

    public ApplicationBasicInfo[] getPaginatedApplicationBasicInfo(int pageNumber, String filter) throws AxisFault {
        try {
            return this.stub.getPaginatedApplicationBasicInfo(pageNumber, filter);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new ApplicationBasicInfo[0];
        }
    }

    public int getCountOfAllApplications() throws Exception {
        try {
            return this.stub.getCountOfAllApplications();
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return 0;
        }
    }

    public int getCountOfApplications(String filter) throws AxisFault {
        try {
            return this.stub.getCountOfApplications(filter);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return 0;
        }
    }

    public void updateApplicationData(ServiceProvider serviceProvider) throws Exception {
        try {
            this.stub.updateApplication(serviceProvider);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
        }
    }

    public void deleteApplication(String applicationID) throws Exception {
        try {
            this.stub.deleteApplication(applicationID);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
        }
    }

    public IdentityProvider getFederatedIdentityProvider(String identityProviderName) throws AxisFault {
        try {
            return this.stub.getIdentityProvider(identityProviderName);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return null;
        }
    }

    public RequestPathAuthenticatorConfig[] getAllRequestPathAuthenticators() throws AxisFault {
        try {
            return this.stub.getAllRequestPathAuthenticators();
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new RequestPathAuthenticatorConfig[0];
        }
    }

    public LocalAuthenticatorConfig[] getAllLocalAuthenticators() throws AxisFault {
        try {
            return this.stub.getAllLocalAuthenticators();
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new LocalAuthenticatorConfig[0];
        }
    }

    public IdentityProvider[] getAllFederatedIdentityProvider() throws AxisFault {
        try {
            return this.stub.getAllIdentityProviders();
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new IdentityProvider[0];
        }
    }

    public String[] getAllClaimUris() throws AxisFault {
        try {
            return this.stub.getAllLocalClaimUris();
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new String[0];
        }
    }

    public String[] getUserStoreDomains() throws AxisFault {
        try {
            UserStoreInfo[] storesInfo;
            ArrayList<String> readWriteDomainNames = new ArrayList<String>();
            for (UserStoreInfo storeInfo : storesInfo = this.userAdminStub.getUserRealmInfo().getUserStoresInfo()) {
                if (storeInfo.getReadOnly()) continue;
                readWriteDomainNames.add(storeInfo.getDomainName());
            }
            return readWriteDomainNames.toArray(new String[readWriteDomainNames.size()]);
        }
        catch (RemoteException | UserAdminUserAdminException e) {
            throw new AxisFault("Error occurred while retrieving Read-Write User Store Domain IDs for logged-in user's tenant realm");
        }
    }

    public String getAuthenticationTemplatesJson() throws AxisFault {
        try {
            return this.stub.getAuthenticationTemplatesJSON();
        }
        catch (RemoteException e) {
            throw new AxisFault("Error occurred while retrieving authentication flow templates", (Throwable)e);
        }
    }

    public ImportResponse importApplication(SpFileContent spFileContent) throws AxisFault {
        try {
            if (this.debugEnabled) {
                log.debug((Object)("Importing Service Provider from file : " + spFileContent.getFileName()));
            }
            return this.stub.importApplication(spFileContent);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return new ImportResponse();
        }
    }

    public String exportApplication(String appid, boolean exportSecrets) throws AxisFault {
        try {
            if (this.debugEnabled) {
                log.debug((Object)"Exporting Service Provider to file");
            }
            return this.stub.exportApplication(appid, exportSecrets);
        }
        catch (RemoteException | IdentityApplicationManagementServiceIdentityApplicationManagementException e) {
            this.handleException((Exception)e);
            return null;
        }
    }

    public void createApplicationTemplate(SpTemplate spTemplate) throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        try {
            if (this.debugEnabled) {
                log.debug((Object)("Registering Service Provider template: " + spTemplate.getName()));
            }
            this.stub.createApplicationTemplate(spTemplate);
        }
        catch (RemoteException e) {
            this.handleException(e, "Error occurred when creating Service Provider template: " + spTemplate.getName());
        }
    }

    public void createApplicationTemplateFromSP(ServiceProvider serviceProvider, SpTemplate spTemplate) throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        try {
            if (this.debugEnabled) {
                log.debug((Object)("Adding Service Provider:" + serviceProvider.getApplicationName() + " as a template with name: " + spTemplate.getName()));
            }
            this.stub.createApplicationTemplateFromSP(serviceProvider, spTemplate);
        }
        catch (RemoteException e) {
            this.handleException(e, "Error occurred when creating Service Provider template: " + spTemplate.getName() + " from service provider: " + serviceProvider.getApplicationName());
        }
    }

    public SpTemplate getApplicationTemplate(String templateName) throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        try {
            if (this.debugEnabled) {
                log.debug((Object)("Retrieving Service Provider template: " + templateName));
            }
            return this.stub.getApplicationTemplate(templateName);
        }
        catch (RemoteException e) {
            this.handleException(e, "Error occurred when retrieving Service Provider template: " + templateName);
            return null;
        }
    }

    public void deleteApplicationTemplate(String templateName) throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        try {
            if (this.debugEnabled) {
                log.debug((Object)("Deleting Service Provider template: " + templateName));
            }
            this.stub.deleteApplicationTemplate(templateName);
        }
        catch (RemoteException e) {
            this.handleException(e, "Error occurred when deleting Service Provider template: " + templateName);
        }
    }

    public void updateApplicationTemplate(String templateName, SpTemplate spTemplate) throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        try {
            if (this.debugEnabled) {
                log.debug((Object)("Updating Service Provider template: " + templateName));
            }
            this.stub.updateApplicationTemplate(templateName, spTemplate);
        }
        catch (RemoteException e) {
            this.handleException(e, "Error occurred when updating Service Provider template: " + templateName);
        }
    }

    public boolean isExistingApplicationTemplate(String templateName) throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        try {
            if (this.debugEnabled) {
                log.debug((Object)("Checking existence of application template: " + templateName));
            }
            return this.stub.isExistingApplicationTemplate(templateName);
        }
        catch (RemoteException e) {
            this.handleException(e, "Error occurred when checking existence of Service Provider template: " + templateName);
            return false;
        }
    }

    public SpTemplate[] getAllApplicationTemplateInfo() throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        try {
            if (this.debugEnabled) {
                log.debug((Object)"Get all service provider template basic info.");
            }
            return this.stub.getAllApplicationTemplateInfo();
        }
        catch (RemoteException e) {
            this.handleException(e, "Error occurred when retrieving service provider template basic info");
            return new SpTemplate[0];
        }
    }

    private void handleException(Exception e) throws AxisFault {
        String errorMessage = "Unknown error occurred.";
        if (e instanceof IdentityApplicationManagementServiceIdentityApplicationManagementException) {
            IdentityApplicationManagementServiceIdentityApplicationManagementException exception = (IdentityApplicationManagementServiceIdentityApplicationManagementException)((Object)e);
            if (exception.getFaultMessage().getIdentityApplicationManagementException() != null) {
                errorMessage = exception.getFaultMessage().getIdentityApplicationManagementException().getMessage();
            }
        } else {
            errorMessage = e.getMessage();
        }
        throw new AxisFault(errorMessage, (Throwable)e);
    }

    private void handleException(RemoteException e, String msg) throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        log.error((Object)msg, (Throwable)e);
        throw new IdentityApplicationManagementServiceIdentityApplicationManagementClientException("Server error occurred.");
    }

    public boolean isPaginationSupported() {
        if (!paginationSupportVerified) {
            try {
                this.getCountOfAllApplications();
                paginationSupported = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"IdentityApplicationManagementService stub and backend supports for SP pagination. Set 'paginationSupported' flag to 'true'.");
                }
            }
            catch (Exception | NoSuchMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"IdentityApplicationManagementService stub or backend does not supports for SP pagination. Set 'paginationSupported' flag to 'false'.");
                }
                paginationSupported = false;
            }
            paginationSupportVerified = true;
        }
        return paginationSupported;
    }

    public InboundAuthenticationRequestConfig[] getCustomInboundAuthenticatorConfigs() throws IdentityApplicationManagementServiceIdentityApplicationManagementClientException {
        try {
            return this.stub.getCustomInboundAuthenticatorConfigs();
        }
        catch (RemoteException e) {
            this.handleException(e, "Error occurrred while retrieving inbound custom authenticator configs.");
            return new InboundAuthenticationRequestConfig[0];
        }
    }
}

