/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.mgt.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.model.Purpose;
import org.wso2.carbon.identity.application.common.model.script.xsd.AuthenticationScriptConfig;
import org.wso2.carbon.identity.application.common.model.xsd.ApplicationPermission;
import org.wso2.carbon.identity.application.common.model.xsd.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.xsd.Claim;
import org.wso2.carbon.identity.application.common.model.xsd.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.xsd.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.xsd.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.xsd.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.xsd.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.xsd.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.xsd.InboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.xsd.JustInTimeProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.xsd.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.xsd.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.xsd.LocalRole;
import org.wso2.carbon.identity.application.common.model.xsd.OutboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.xsd.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.xsd.Property;
import org.wso2.carbon.identity.application.common.model.xsd.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.xsd.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.xsd.RoleMapping;
import org.wso2.carbon.identity.application.common.model.xsd.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.xsd.ServiceProviderProperty;
import org.wso2.carbon.identity.application.mgt.ui.ApplicationPurposes;

public class ApplicationBean {
    public static final String AUTH_TYPE_DEFAULT = "default";
    public static final String AUTH_TYPE_LOCAL = "local";
    public static final String AUTH_TYPE_FEDERATED = "federated";
    public static final String AUTH_TYPE_FLOW = "flow";
    public static final String IDP_LOCAL_NAME = "LOCAL";
    public static final String LOCAL_IDP = "wso2carbon-local-idp";
    public static final String DUMB = "dumb";
    private ServiceProvider serviceProvider;
    private IdentityProvider[] federatedIdentityProviders;
    private Map<String, IdentityProvider> federatedIdentityProvidersMap = new HashMap<String, IdentityProvider>();
    private List<IdentityProvider> enabledFederatedIdentityProviders;
    private LocalAuthenticatorConfig[] localAuthenticatorConfigs;
    private RequestPathAuthenticatorConfig[] requestPathAuthenticators;
    private Map<String, String> roleMap;
    private Map<String, String> claimMap;
    private Map<String, String> requestedClaims = new HashMap<String, String>();
    private Map<String, String> mandatoryClaims = new HashMap<String, String>();
    private String samlIssuer;
    private String kerberosServiceName;
    private String oauthAppName;
    private String oauthConsumerSecret;
    private String attrConsumServiceIndex;
    private String wstrustEp;
    private String passivests;
    private String passiveSTSWReply;
    private String openid;
    private String[] claimUris;
    private List<String> claimDialectUris;
    private List<InboundAuthenticationRequestConfig> inboundAuthenticationRequestConfigs;
    private List<String> standardInboundAuthTypes = new ArrayList<String>();
    private ApplicationPurposes applicationPurposes;
    private Purpose[] sharedPurposes;
    private Map<String, InboundAuthenticationRequestConfig> customInboundAuthenticatorConfigs;
    private static final Log log = LogFactory.getLog(ApplicationBean.class);

    public ApplicationBean() {
        this.standardInboundAuthTypes.add("oauth2");
        this.standardInboundAuthTypes.add("wstrust");
        this.standardInboundAuthTypes.add("samlsso");
        this.standardInboundAuthTypes.add("openid");
        this.standardInboundAuthTypes.add("passivests");
    }

    public void reset() {
        this.serviceProvider = null;
        this.federatedIdentityProviders = null;
        this.federatedIdentityProvidersMap.clear();
        this.localAuthenticatorConfigs = null;
        this.requestPathAuthenticators = null;
        this.roleMap = null;
        this.claimMap = null;
        this.requestedClaims = new HashMap<String, String>();
        this.mandatoryClaims = new HashMap<String, String>();
        this.samlIssuer = null;
        this.kerberosServiceName = null;
        this.oauthAppName = null;
        this.wstrustEp = null;
        this.passivests = null;
        this.passiveSTSWReply = null;
        this.openid = null;
        this.oauthConsumerSecret = null;
        this.attrConsumServiceIndex = null;
        this.enabledFederatedIdentityProviders = null;
        this.inboundAuthenticationRequestConfigs = Collections.EMPTY_LIST;
        this.applicationPurposes = null;
        this.sharedPurposes = null;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public String getAuthenticationType() {
        return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationType();
    }

    public void setAuthenticationType(String type) {
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationType(type);
    }

    public String getStepZeroAuthenticatorName(String type) {
        if (AUTH_TYPE_LOCAL.equalsIgnoreCase(type) && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps() != null && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps().length > 0 && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps()[0].getLocalAuthenticatorConfigs() != null && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps()[0].getLocalAuthenticatorConfigs()[0] != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps()[0].getLocalAuthenticatorConfigs()[0].getName();
        }
        if (AUTH_TYPE_FEDERATED.equalsIgnoreCase(type) && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps() != null && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps().length > 0 && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps()[0].getFederatedIdentityProviders() != null && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps()[0].getFederatedIdentityProviders().length > 0 && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps()[0].getFederatedIdentityProviders()[0] != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps()[0].getFederatedIdentityProviders()[0].getIdentityProviderName();
        }
        return null;
    }

    public void setStepZeroAuthenticatorName(String type, String name) {
        if (AUTH_TYPE_LOCAL.equalsIgnoreCase(type)) {
            LocalAuthenticatorConfig localAuthenticator = new LocalAuthenticatorConfig();
            localAuthenticator.setName(name);
            AuthenticationStep authStep = new AuthenticationStep();
            authStep.setLocalAuthenticatorConfigs(new LocalAuthenticatorConfig[]{localAuthenticator});
        }
    }

    public IdentityProvider[] getFederatedIdentityProviders() {
        return this.federatedIdentityProviders;
    }

    public void setFederatedIdentityProviders(IdentityProvider[] federatedIdentityProviders) {
        this.federatedIdentityProviders = federatedIdentityProviders;
        if (federatedIdentityProviders != null) {
            this.federatedIdentityProvidersMap.clear();
            for (IdentityProvider identityProvider : federatedIdentityProviders) {
                this.federatedIdentityProvidersMap.put(identityProvider.getIdentityProviderName(), identityProvider);
            }
        }
    }

    public List<IdentityProvider> getEnabledFederatedIdentityProviders() {
        if (this.enabledFederatedIdentityProviders != null) {
            return this.enabledFederatedIdentityProviders;
        }
        if (this.federatedIdentityProviders != null && this.federatedIdentityProviders.length > 0) {
            this.enabledFederatedIdentityProviders = new ArrayList<IdentityProvider>();
            block0: for (IdentityProvider idp : this.federatedIdentityProviders) {
                FederatedAuthenticatorConfig[] fedAuthConfigs;
                if (!idp.getEnable() || (fedAuthConfigs = idp.getFederatedAuthenticatorConfigs()) == null || fedAuthConfigs.length <= 0) continue;
                for (FederatedAuthenticatorConfig config : fedAuthConfigs) {
                    if (!config.getEnabled()) continue;
                    this.enabledFederatedIdentityProviders.add(idp);
                    continue block0;
                }
            }
        }
        return this.enabledFederatedIdentityProviders;
    }

    public LocalAuthenticatorConfig[] getLocalAuthenticatorConfigs() {
        return this.localAuthenticatorConfigs;
    }

    public void setLocalAuthenticatorConfigs(LocalAuthenticatorConfig[] localAuthenticatorConfigs) {
        this.localAuthenticatorConfigs = localAuthenticatorConfigs;
    }

    public RequestPathAuthenticatorConfig[] getRequestPathAuthenticators() {
        return this.requestPathAuthenticators;
    }

    public void setRequestPathAuthenticators(RequestPathAuthenticatorConfig[] requestPathAuthenticators) {
        this.requestPathAuthenticators = requestPathAuthenticators;
    }

    public List<String> getPermissions() {
        ApplicationPermission[] permissions;
        PermissionsAndRoleConfig permissionAndRoleConfig;
        ArrayList<String> permList = new ArrayList<String>();
        if (this.serviceProvider != null && this.serviceProvider.getPermissionAndRoleConfig() != null && (permissionAndRoleConfig = this.serviceProvider.getPermissionAndRoleConfig()) != null && (permissions = permissionAndRoleConfig.getPermissions()) != null && permissions.length > 0) {
            for (int i = 0; i < permissions.length; ++i) {
                if (permissions[i] == null) continue;
                permList.add(permissions[i].getValue());
            }
        }
        return permList;
    }

    public void setPermissions(String[] permissions) {
        ApplicationPermission[] applicationPermission = new ApplicationPermission[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            ApplicationPermission appPermission = new ApplicationPermission();
            appPermission.setValue(permissions[i]);
        }
        this.serviceProvider.getPermissionAndRoleConfig().setPermissions(applicationPermission);
    }

    public String getRoleClaimUri() {
        if (this.serviceProvider.getClaimConfig() != null) {
            return this.serviceProvider.getClaimConfig().getRoleClaimURI();
        }
        return null;
    }

    public void setRoleClaimUri(String roleClaimUri) {
        if (roleClaimUri != null) {
            if (this.serviceProvider.getClaimConfig() != null) {
                this.serviceProvider.getClaimConfig().setRoleClaimURI(roleClaimUri);
            } else {
                ClaimConfig claimConfig = new ClaimConfig();
                claimConfig.setRoleClaimURI(roleClaimUri);
                this.serviceProvider.setClaimConfig(claimConfig);
            }
        }
    }

    public String getUserClaimUri() {
        if (this.serviceProvider.getClaimConfig() != null) {
            return this.serviceProvider.getClaimConfig().getUserClaimURI();
        }
        return null;
    }

    public void setUserClaimUri(String userClaimUri) {
        if (userClaimUri != null) {
            if (this.serviceProvider.getClaimConfig() != null) {
                this.serviceProvider.getClaimConfig().setUserClaimURI(userClaimUri);
            } else {
                ClaimConfig claimConfig = new ClaimConfig();
                claimConfig.setUserClaimURI(userClaimUri);
                this.serviceProvider.setClaimConfig(claimConfig);
            }
        }
    }

    public Map<String, String> getRoleMapping() {
        if (this.serviceProvider.getPermissionAndRoleConfig() == null) {
            return new HashMap<String, String>();
        }
        RoleMapping[] roleMapping = this.serviceProvider.getPermissionAndRoleConfig().getRoleMappings();
        if (this.roleMap != null && roleMapping != null && roleMapping.length == this.roleMap.size()) {
            return this.roleMap;
        }
        this.roleMap = new HashMap<String, String>();
        if (roleMapping != null) {
            for (int i = 0; i < roleMapping.length; ++i) {
                this.roleMap.put(roleMapping[i].getLocalRole().getLocalRoleName(), roleMapping[i].getRemoteRole());
            }
        }
        return this.roleMap;
    }

    public void addRoleMapping(String spRole, String localRole) {
        this.roleMap.put(localRole, spRole);
    }

    public Map<String, String> getClaimMapping() {
        if (this.serviceProvider.getClaimConfig() == null) {
            return new HashMap<String, String>();
        }
        ClaimMapping[] claimMapping = this.serviceProvider.getClaimConfig().getClaimMappings();
        if (this.claimMap != null && claimMapping != null && claimMapping.length == this.claimMap.size()) {
            return this.claimMap;
        }
        this.claimMap = new HashMap<String, String>();
        if (claimMapping != null) {
            for (int i = 0; i < claimMapping.length; ++i) {
                if (claimMapping[i] == null || claimMapping[i].getRemoteClaim() == null || claimMapping[i].getLocalClaim() == null) continue;
                this.claimMap.put(claimMapping[i].getLocalClaim().getClaimUri(), claimMapping[i].getRemoteClaim().getClaimUri());
                if (claimMapping[i].getRequested()) {
                    this.requestedClaims.put(claimMapping[i].getRemoteClaim().getClaimUri(), "true");
                } else {
                    this.requestedClaims.put(claimMapping[i].getRemoteClaim().getClaimUri(), "false");
                }
                if (claimMapping[i].getMandatory()) {
                    this.mandatoryClaims.put(claimMapping[i].getRemoteClaim().getClaimUri(), "true");
                    continue;
                }
                this.mandatoryClaims.put(claimMapping[i].getRemoteClaim().getClaimUri(), "false");
            }
        }
        return this.claimMap;
    }

    public boolean isLocalClaimsSelected() {
        if (this.serviceProvider.getClaimConfig() != null) {
            return this.serviceProvider.getClaimConfig().getLocalClaimDialect();
        }
        return true;
    }

    public boolean isAlwaysSendMappedLocalSubjectId() {
        if (this.serviceProvider.getClaimConfig() != null) {
            return this.serviceProvider.getClaimConfig().getAlwaysSendMappedLocalSubjectId();
        }
        return false;
    }

    public boolean isAlwaysSendBackAuthenticatedListOfIdPs() {
        if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAlwaysSendBackAuthenticatedListOfIdPs();
        }
        return false;
    }

    public boolean isUseTenantDomainInLocalSubjectIdentifier() {
        if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getUseTenantDomainInLocalSubjectIdentifier();
        }
        return false;
    }

    public boolean isUseUserstoreDomainInLocalSubjectIdentifier() {
        if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getUseUserstoreDomainInLocalSubjectIdentifier();
        }
        return false;
    }

    public boolean isSkipConsent() {
        if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getSkipConsent();
        }
        return false;
    }

    public boolean isSkipLogoutConsent() {
        if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getSkipLogoutConsent();
        }
        return false;
    }

    public boolean isEnableAuthorization() {
        return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null && this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getEnableAuthorization();
    }

    public String getSubjectClaimUri() {
        if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getSubjectClaimUri();
        }
        return null;
    }

    public String getAttributeConsumingServiceIndex() {
        if (this.attrConsumServiceIndex != null) {
            return this.attrConsumServiceIndex;
        }
        InboundAuthenticationRequestConfig[] authRequests = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequests != null) {
            for (InboundAuthenticationRequestConfig request : authRequests) {
                if (!"samlsso".equalsIgnoreCase(request.getInboundAuthType())) continue;
                if (request.getProperties() != null) {
                    for (Property property : request.getProperties()) {
                        if (!"attrConsumServiceIndex".equalsIgnoreCase(property.getName())) continue;
                        this.attrConsumServiceIndex = property.getValue();
                        return this.attrConsumServiceIndex;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setAttributeConsumingServiceIndex(String attrConsumServiceIndex) {
        this.attrConsumServiceIndex = attrConsumServiceIndex;
    }

    public String getOauthConsumerSecret() {
        if (this.oauthConsumerSecret != null) {
            return this.oauthConsumerSecret;
        }
        InboundAuthenticationRequestConfig[] authRequests = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequests != null) {
            for (InboundAuthenticationRequestConfig request : authRequests) {
                if (!"oauth2".equalsIgnoreCase(request.getInboundAuthType())) continue;
                if (request.getProperties() != null) {
                    for (Property property : request.getProperties()) {
                        if (!"oauthConsumerSecret".equalsIgnoreCase(property.getName())) continue;
                        this.oauthConsumerSecret = property.getValue();
                        return this.oauthConsumerSecret;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void setOauthConsumerSecret(String oauthConsumerSecret) {
        this.oauthConsumerSecret = oauthConsumerSecret;
    }

    public String getSAMLIssuer() {
        if (this.samlIssuer != null) {
            return this.samlIssuer;
        }
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null) {
            for (int i = 0; i < authRequest.length; ++i) {
                if (!"samlsso".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                this.samlIssuer = authRequest[i].getInboundAuthKey();
                break;
            }
        }
        return this.samlIssuer;
    }

    public String getKerberosServiceName() {
        if (this.kerberosServiceName != null) {
            return this.kerberosServiceName;
        }
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null) {
            for (int i = 0; i < authRequest.length; ++i) {
                if (!"kerberos".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                this.kerberosServiceName = authRequest[i].getInboundAuthKey();
                break;
            }
        }
        return this.kerberosServiceName;
    }

    public void setKerberosServiceName(String kerberosServiceName) {
        this.kerberosServiceName = kerberosServiceName;
    }

    public void setSAMLIssuer(String issuerName) {
        this.samlIssuer = issuerName;
    }

    public void deleteSAMLIssuer() {
        this.samlIssuer = null;
        this.attrConsumServiceIndex = null;
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null && authRequest.length > 0) {
            ArrayList<InboundAuthenticationRequestConfig> tempAuthRequest = new ArrayList<InboundAuthenticationRequestConfig>();
            for (int i = 0; i < authRequest.length; ++i) {
                if ("samlsso".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                tempAuthRequest.add(authRequest[i]);
            }
            if (CollectionUtils.isNotEmpty(tempAuthRequest)) {
                this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(tempAuthRequest.toArray(new InboundAuthenticationRequestConfig[tempAuthRequest.size()]));
            } else {
                this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(null);
            }
        }
    }

    public void setOIDCAppName(String oauthAppName) {
        this.oauthAppName = oauthAppName;
    }

    public void deleteOauthApp() {
        this.oauthAppName = null;
        this.oauthConsumerSecret = null;
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null && authRequest.length > 0) {
            ArrayList<InboundAuthenticationRequestConfig> tempAuthRequest = new ArrayList<InboundAuthenticationRequestConfig>();
            for (int i = 0; i < authRequest.length; ++i) {
                if ("oauth2".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                tempAuthRequest.add(authRequest[i]);
            }
            if (CollectionUtils.isNotEmpty(tempAuthRequest)) {
                this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(tempAuthRequest.toArray(new InboundAuthenticationRequestConfig[tempAuthRequest.size()]));
            } else {
                this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(null);
            }
        }
    }

    public void deleteKerberosApp() {
        this.kerberosServiceName = null;
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null && authRequest.length > 0) {
            ArrayList<InboundAuthenticationRequestConfig> tempAuthRequest = new ArrayList<InboundAuthenticationRequestConfig>();
            for (int i = 0; i < authRequest.length; ++i) {
                if ("kerberos".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                tempAuthRequest.add(authRequest[i]);
            }
            if (CollectionUtils.isNotEmpty(tempAuthRequest)) {
                this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(tempAuthRequest.toArray(new InboundAuthenticationRequestConfig[tempAuthRequest.size()]));
            } else {
                this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(null);
            }
        }
    }

    public void deleteWstrustEp() {
        this.wstrustEp = null;
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null && authRequest.length > 0) {
            ArrayList<InboundAuthenticationRequestConfig> tempAuthRequest = new ArrayList<InboundAuthenticationRequestConfig>();
            for (int i = 0; i < authRequest.length; ++i) {
                if ("wstrust".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                tempAuthRequest.add(authRequest[i]);
            }
            if (CollectionUtils.isNotEmpty(tempAuthRequest)) {
                this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(tempAuthRequest.toArray(new InboundAuthenticationRequestConfig[tempAuthRequest.size()]));
            } else {
                this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(null);
            }
        }
    }

    public String getOIDCClientId() {
        if (this.oauthAppName != null) {
            return this.oauthAppName;
        }
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null) {
            for (int i = 0; i < authRequest.length; ++i) {
                if (!"oauth2".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                this.oauthAppName = authRequest[i].getInboundAuthKey();
                break;
            }
        }
        return this.oauthAppName;
    }

    public String getOpenIDRealm() {
        if (this.openid != null) {
            return this.openid;
        }
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null) {
            for (int i = 0; i < authRequest.length; ++i) {
                if (!"openid".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                this.openid = authRequest[i].getInboundAuthKey();
                break;
            }
        }
        return this.openid;
    }

    public String getWstrustSP() {
        if (this.wstrustEp != null) {
            return this.wstrustEp;
        }
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null) {
            for (int i = 0; i < authRequest.length; ++i) {
                if (!"wstrust".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                this.wstrustEp = authRequest[i].getInboundAuthKey();
                break;
            }
        }
        return this.wstrustEp;
    }

    public String getPassiveSTSRealm() {
        if (this.passivests != null) {
            return this.passivests;
        }
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null) {
            for (int i = 0; i < authRequest.length; ++i) {
                if (!"passivests".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                this.passivests = authRequest[i].getInboundAuthKey();
                break;
            }
        }
        return this.passivests;
    }

    public String getPassiveSTSWReply() {
        if (this.passiveSTSWReply != null) {
            return this.passiveSTSWReply;
        }
        InboundAuthenticationRequestConfig[] authRequest = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
        if (authRequest != null) {
            block0: for (int i = 0; i < authRequest.length; ++i) {
                if (!"passivests".equalsIgnoreCase(authRequest[i].getInboundAuthType())) continue;
                Property[] properties = authRequest[i].getProperties();
                if (properties == null) break;
                for (int j = 0; j < properties.length; ++j) {
                    if (!"passiveSTSWReply".equalsIgnoreCase(properties[j].getName())) continue;
                    this.passiveSTSWReply = properties[j].getValue();
                    break block0;
                }
                break;
            }
        }
        return this.passiveSTSWReply;
    }

    public String[] getClaimUris() {
        return this.claimUris;
    }

    public void setClaimUris(String[] claimUris) {
        this.claimUris = claimUris;
    }

    public List<String> getSPClaimDialects() {
        return this.serviceProvider.getClaimConfig() != null && !ArrayUtils.isEmpty((Object[])this.serviceProvider.getClaimConfig().getSpClaimDialects()) ? Arrays.asList(this.serviceProvider.getClaimConfig().getSpClaimDialects()) : new ArrayList<String>();
    }

    public void setClaimDialectUris(List<String> claimDialectUris) {
        this.claimDialectUris = claimDialectUris;
    }

    public List<String> getClaimDialectUris() {
        return this.claimDialectUris;
    }

    private boolean isCustomInboundAuthType(String authType) {
        return !this.standardInboundAuthTypes.contains(authType);
    }

    public List<InboundAuthenticationRequestConfig> getInboundAuthenticators() {
        if (CollectionUtils.isNotEmpty(Collections.singleton(this.customInboundAuthenticatorConfigs))) {
            if (CollectionUtils.isNotEmpty(this.inboundAuthenticationRequestConfigs)) {
                return this.inboundAuthenticationRequestConfigs;
            }
            InboundAuthenticationRequestConfig[] authRequests = this.serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs();
            this.inboundAuthenticationRequestConfigs = new ArrayList<InboundAuthenticationRequestConfig>();
            if (authRequests != null) {
                for (InboundAuthenticationRequestConfig request : authRequests) {
                    if (!this.isCustomInboundAuthType(request.getInboundAuthType()) || !this.customInboundAuthenticatorConfigs.containsKey(request.getInboundAuthType() + ":" + request.getInboundConfigType())) continue;
                    this.customInboundAuthenticatorConfigs.remove(request.getInboundAuthType() + ":" + request.getInboundConfigType());
                    this.inboundAuthenticationRequestConfigs.add(request);
                }
            }
            this.inboundAuthenticationRequestConfigs.addAll(this.customInboundAuthenticatorConfigs.values());
        }
        return this.inboundAuthenticationRequestConfigs;
    }

    public void updateOutBoundAuthenticationConfig(HttpServletRequest request) {
        String[] authSteps = request.getParameterValues("auth_step");
        if (authSteps != null && authSteps.length > 0) {
            ArrayList<AuthenticationStep> authStepList = new ArrayList<AuthenticationStep>();
            for (String authstep : authSteps) {
                String[] federatedIdpNames;
                AuthenticationStep authStep = new AuthenticationStep();
                authStep.setStepOrder(Integer.parseInt(authstep));
                boolean isSubjectStep = request.getParameter("subject_step_" + authstep) != null && "on".equals(request.getParameter("subject_step_" + authstep));
                authStep.setSubjectStep(isSubjectStep);
                boolean isAttributeStep = request.getParameter("attribute_step_" + authstep) != null && "on".equals(request.getParameter("attribute_step_" + authstep));
                authStep.setAttributeStep(isAttributeStep);
                String[] localAuthenticatorNames = request.getParameterValues("step_" + authstep + "_local_auth");
                if (localAuthenticatorNames != null && localAuthenticatorNames.length > 0) {
                    ArrayList<LocalAuthenticatorConfig> localAuthList = new ArrayList<LocalAuthenticatorConfig>();
                    for (String name : localAuthenticatorNames) {
                        if (name == null) continue;
                        LocalAuthenticatorConfig localAuth = new LocalAuthenticatorConfig();
                        localAuth.setName(name);
                        if (this.localAuthenticatorConfigs != null) {
                            for (LocalAuthenticatorConfig config : this.localAuthenticatorConfigs) {
                                if (!config.getName().equals(name)) continue;
                                localAuth.setDisplayName(config.getDisplayName());
                                break;
                            }
                        }
                        localAuthList.add(localAuth);
                    }
                    if (localAuthList != null && !localAuthList.isEmpty()) {
                        authStep.setLocalAuthenticatorConfigs(localAuthList.toArray(new LocalAuthenticatorConfig[localAuthList.size()]));
                    }
                }
                if ((federatedIdpNames = request.getParameterValues("step_" + authstep + "_fed_auth")) != null && federatedIdpNames.length > 0) {
                    ArrayList<IdentityProvider> fedIdpList = new ArrayList<IdentityProvider>();
                    for (String name : federatedIdpNames) {
                        if (!StringUtils.isNotBlank((String)name)) continue;
                        IdentityProvider idp = new IdentityProvider();
                        idp.setIdentityProviderName(name);
                        IdentityProvider referringIdP = this.federatedIdentityProvidersMap.get(name);
                        String authenticatorName = request.getParameter("step_" + authstep + "_idp_" + name + "_fed_authenticator");
                        if (!StringUtils.isNotBlank((String)authenticatorName)) continue;
                        String authenticatorDisplayName = null;
                        for (FederatedAuthenticatorConfig config : referringIdP.getFederatedAuthenticatorConfigs()) {
                            if (!authenticatorName.equals(config.getName())) continue;
                            authenticatorDisplayName = config.getDisplayName();
                            break;
                        }
                        FederatedAuthenticatorConfig authenticator = new FederatedAuthenticatorConfig();
                        authenticator.setName(authenticatorName);
                        authenticator.setDisplayName(authenticatorDisplayName);
                        idp.setDefaultAuthenticatorConfig(authenticator);
                        idp.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[]{authenticator});
                        fedIdpList.add(idp);
                    }
                    if (fedIdpList != null && !fedIdpList.isEmpty()) {
                        authStep.setFederatedIdentityProviders(fedIdpList.toArray(new IdentityProvider[fedIdpList.size()]));
                    }
                }
                if ((authStep.getFederatedIdentityProviders() == null || authStep.getFederatedIdentityProviders().length <= 0) && (authStep.getLocalAuthenticatorConfigs() == null || authStep.getLocalAuthenticatorConfigs().length <= 0)) continue;
                authStepList.add(authStep);
            }
            if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() == null) {
                this.serviceProvider.setLocalAndOutBoundAuthenticationConfig(new LocalAndOutboundAuthenticationConfig());
            }
            if (CollectionUtils.isNotEmpty(authStepList)) {
                LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig = this.serviceProvider.getLocalAndOutBoundAuthenticationConfig();
                localAndOutboundAuthenticationConfig.setAuthenticationSteps(authStepList.toArray(new AuthenticationStep[authStepList.size()]));
            }
        }
    }

    public void conditionalAuthentication(HttpServletRequest request) {
        AuthenticationScriptConfig authenticationScriptConfig = new AuthenticationScriptConfig();
        LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig = this.serviceProvider.getLocalAndOutBoundAuthenticationConfig();
        String flawByScript = request.getParameter("scriptTextArea");
        if (StringUtils.isBlank((String)flawByScript)) {
            authenticationScriptConfig.setEnabled(false);
        } else if ("true".equalsIgnoreCase(request.getParameter("enableScript"))) {
            authenticationScriptConfig.setEnabled(true);
        } else {
            authenticationScriptConfig.setEnabled(false);
        }
        authenticationScriptConfig.setContent(flawByScript);
        localAndOutboundAuthenticationConfig.setAuthenticationScriptConfig(authenticationScriptConfig);
    }

    public void update(HttpServletRequest request) {
        AuthenticationStep authStep;
        String openidRealm;
        String isSasApp;
        this.serviceProvider.setApplicationName(request.getParameter("spName"));
        this.serviceProvider.setDescription(request.getParameter("sp-description"));
        this.serviceProvider.setCertificateContent(request.getParameter("sp-certificate"));
        String jwks = request.getParameter("jwksURI");
        this.serviceProvider.setJwksUri(jwks);
        if (Boolean.parseBoolean(request.getParameter("deletePublicCert"))) {
            this.serviceProvider.setCertificateContent("");
        }
        this.serviceProvider.setSaasApp((isSasApp = request.getParameter("isSaasApp")) != null && "on".equals(isSasApp));
        String isDiscoverableApp = request.getParameter("isDiscoverableApp");
        this.serviceProvider.setDiscoverable("on".equals(isDiscoverableApp));
        String accessUrl = request.getParameter("accessURL");
        this.serviceProvider.setAccessUrl(accessUrl);
        String imageUrl = request.getParameter("imageURL");
        this.serviceProvider.setImageUrl(imageUrl);
        if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() == null) {
            this.serviceProvider.setLocalAndOutBoundAuthenticationConfig(new LocalAndOutboundAuthenticationConfig());
        }
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationType(request.getParameter("auth_type"));
        String provisioningUserStore = request.getParameter("scim-inbound-userstore");
        InboundProvisioningConfig inBoundProConfig = new InboundProvisioningConfig();
        inBoundProConfig.setProvisioningUserStore(provisioningUserStore);
        inBoundProConfig.setDumbMode(Boolean.parseBoolean(request.getParameter(DUMB)));
        this.serviceProvider.setInboundProvisioningConfig(inBoundProConfig);
        String[] provisioningProviders = request.getParameterValues("provisioning_idp");
        if (provisioningProviders != null && provisioningProviders.length > 0) {
            ArrayList<Object[]> provisioningIdps = new ArrayList<Object[]>();
            for (String proProvider : provisioningProviders) {
                String connector = request.getParameter("provisioning_con_idp_" + proProvider);
                String jitEnabled = request.getParameter("provisioning_jit_" + proProvider);
                String blocking = request.getParameter("blocking_prov_" + proProvider);
                String ruleEnabled = request.getParameter("rules_enabled_" + proProvider);
                if (connector == null) continue;
                Object[] proIdp = new IdentityProvider();
                proIdp.setIdentityProviderName(proProvider);
                JustInTimeProvisioningConfig jitpro = new JustInTimeProvisioningConfig();
                if ("on".equals(jitEnabled)) {
                    jitpro.setProvisioningEnabled(true);
                }
                proIdp.setJustInTimeProvisioningConfig(jitpro);
                ProvisioningConnectorConfig proCon = new ProvisioningConnectorConfig();
                if ("on".equals(ruleEnabled)) {
                    proCon.setRulesEnabled(true);
                } else {
                    proCon.setRulesEnabled(false);
                }
                if ("on".equals(blocking)) {
                    proCon.setBlocking(true);
                } else {
                    proCon.setBlocking(false);
                }
                proCon.setName(connector);
                proIdp.setDefaultProvisioningConnectorConfig(proCon);
                provisioningIdps.add(proIdp);
            }
            if (CollectionUtils.isNotEmpty(provisioningIdps)) {
                OutboundProvisioningConfig outboundProConfig = new OutboundProvisioningConfig();
                outboundProConfig.setProvisioningIdentityProviders(provisioningIdps.toArray(new IdentityProvider[provisioningIdps.size()]));
                this.serviceProvider.setOutboundProvisioningConfig(outboundProConfig);
            }
        } else {
            this.serviceProvider.setOutboundProvisioningConfig(new OutboundProvisioningConfig());
        }
        String[] requestPathAuthenticators = request.getParameterValues("req_path_auth");
        if (requestPathAuthenticators != null && requestPathAuthenticators.length > 0) {
            ArrayList<RequestPathAuthenticatorConfig> reqAuthList = new ArrayList<RequestPathAuthenticatorConfig>();
            for (String name : requestPathAuthenticators) {
                if (name == null) continue;
                RequestPathAuthenticatorConfig reqAuth = new RequestPathAuthenticatorConfig();
                reqAuth.setName(name);
                reqAuth.setDisplayName(request.getParameter("req_path_auth_" + name));
                reqAuthList.add(reqAuth);
            }
            if (CollectionUtils.isNotEmpty(reqAuthList)) {
                this.serviceProvider.setRequestPathAuthenticatorConfigs(reqAuthList.toArray(new RequestPathAuthenticatorConfig[reqAuthList.size()]));
            } else {
                this.serviceProvider.setRequestPathAuthenticatorConfigs(null);
            }
        } else {
            this.serviceProvider.setRequestPathAuthenticatorConfigs(null);
        }
        ArrayList<Object> authRequestList = new ArrayList<Object>();
        if (this.samlIssuer != null) {
            InboundAuthenticationRequestConfig samlAuthenticationRequest = new InboundAuthenticationRequestConfig();
            samlAuthenticationRequest.setInboundAuthKey(this.samlIssuer);
            samlAuthenticationRequest.setInboundAuthType("samlsso");
            if (this.attrConsumServiceIndex != null && !this.attrConsumServiceIndex.isEmpty()) {
                Property property = new Property();
                property.setName("attrConsumServiceIndex");
                property.setValue(this.attrConsumServiceIndex);
                Property[] properties = new Property[]{property};
                samlAuthenticationRequest.setProperties(properties);
            }
            authRequestList.add(samlAuthenticationRequest);
        }
        if (this.kerberosServiceName != null) {
            InboundAuthenticationRequestConfig kerberosAuthenticationRequest = new InboundAuthenticationRequestConfig();
            kerberosAuthenticationRequest.setInboundAuthKey(this.kerberosServiceName);
            kerberosAuthenticationRequest.setInboundAuthType("kerberos");
            authRequestList.add(kerberosAuthenticationRequest);
        }
        if (this.oauthAppName != null) {
            InboundAuthenticationRequestConfig opicAuthenticationRequest = new InboundAuthenticationRequestConfig();
            opicAuthenticationRequest.setInboundAuthKey(this.oauthAppName);
            opicAuthenticationRequest.setInboundAuthType("oauth2");
            if (this.oauthConsumerSecret != null && !this.oauthConsumerSecret.isEmpty()) {
                Property property = new Property();
                property.setName("oauthConsumerSecret");
                property.setValue(this.oauthConsumerSecret);
                Property[] properties = new Property[]{property};
                opicAuthenticationRequest.setProperties(properties);
            }
            authRequestList.add(opicAuthenticationRequest);
        }
        if (this.wstrustEp != null) {
            InboundAuthenticationRequestConfig opicAuthenticationRequest = new InboundAuthenticationRequestConfig();
            opicAuthenticationRequest.setInboundAuthKey(this.wstrustEp);
            opicAuthenticationRequest.setInboundAuthType("wstrust");
            authRequestList.add(opicAuthenticationRequest);
        }
        String passiveSTSRealm = request.getParameter("passiveSTSRealm");
        String passiveSTSWReply = request.getParameter("passiveSTSWReply");
        if (StringUtils.isNotBlank((String)passiveSTSRealm)) {
            InboundAuthenticationRequestConfig opicAuthenticationRequest = new InboundAuthenticationRequestConfig();
            opicAuthenticationRequest.setInboundAuthKey(passiveSTSRealm);
            opicAuthenticationRequest.setInboundAuthType("passivests");
            if (passiveSTSWReply != null && !passiveSTSWReply.isEmpty()) {
                Property property = new Property();
                property.setName("passiveSTSWReply");
                property.setValue(passiveSTSWReply);
                Property[] properties = new Property[]{property};
                opicAuthenticationRequest.setProperties(properties);
            }
            authRequestList.add(opicAuthenticationRequest);
        }
        if (StringUtils.isNotBlank((String)(openidRealm = request.getParameter("openidRealm")))) {
            InboundAuthenticationRequestConfig opicAuthenticationRequest = new InboundAuthenticationRequestConfig();
            opicAuthenticationRequest.setInboundAuthKey(openidRealm);
            opicAuthenticationRequest.setInboundAuthType("openid");
            authRequestList.add(opicAuthenticationRequest);
        }
        if (!CollectionUtils.isEmpty(this.inboundAuthenticationRequestConfigs)) {
            for (InboundAuthenticationRequestConfig customAuthConfig : this.inboundAuthenticationRequestConfigs) {
                LocalAuthenticatorConfig[] type = customAuthConfig.getInboundAuthType();
                Object[] properties = customAuthConfig.getProperties();
                if (!ArrayUtils.isEmpty((Object[])properties)) {
                    for (Object prop : properties) {
                        String propVal = request.getParameter("custom_auth_prop_name_" + (String)type + "_" + prop.getName());
                        prop.setValue(propVal);
                    }
                }
                authRequestList.add(customAuthConfig);
            }
        }
        if (this.serviceProvider.getInboundAuthenticationConfig() == null) {
            this.serviceProvider.setInboundAuthenticationConfig(new InboundAuthenticationConfig());
        }
        if (CollectionUtils.isNotEmpty(authRequestList)) {
            this.serviceProvider.getInboundAuthenticationConfig().setInboundAuthenticationRequestConfigs(authRequestList.toArray(new InboundAuthenticationRequestConfig[authRequestList.size()]));
        }
        if (AUTH_TYPE_DEFAULT.equalsIgnoreCase(this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationType())) {
            this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationSteps(null);
            this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationScriptConfig(null);
        } else if (AUTH_TYPE_LOCAL.equalsIgnoreCase(this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationType())) {
            authStep = new AuthenticationStep();
            LocalAuthenticatorConfig localAuthenticator = new LocalAuthenticatorConfig();
            localAuthenticator.setName(request.getParameter("local_authenticator"));
            if (localAuthenticator.getName() != null && this.localAuthenticatorConfigs != null) {
                for (LocalAuthenticatorConfig config : this.localAuthenticatorConfigs) {
                    if (!config.getName().equals(localAuthenticator.getName())) continue;
                    localAuthenticator.setDisplayName(config.getDisplayName());
                    break;
                }
            }
            authStep.setLocalAuthenticatorConfigs(new LocalAuthenticatorConfig[]{localAuthenticator});
            this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationSteps(new AuthenticationStep[]{authStep});
            this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationScriptConfig(null);
        } else if (AUTH_TYPE_FEDERATED.equalsIgnoreCase(this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationType())) {
            authStep = new AuthenticationStep();
            IdentityProvider idp = new IdentityProvider();
            idp.setIdentityProviderName(request.getParameter("fed_idp"));
            authStep.setFederatedIdentityProviders(new IdentityProvider[]{idp});
            this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationSteps(new AuthenticationStep[]{authStep});
            this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAuthenticationScriptConfig(null);
        } else if (AUTH_TYPE_FLOW.equalsIgnoreCase(this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationType())) {
            // empty if block
        }
        String alwaysSendAuthListOfIdPs = request.getParameter("always_send_auth_list_of_idps");
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setAlwaysSendBackAuthenticatedListOfIdPs(alwaysSendAuthListOfIdPs != null && "on".equals(alwaysSendAuthListOfIdPs));
        String useTenantDomainInLocalSubjectIdentifier = request.getParameter("use_tenant_domain_in_local_subject_identifier");
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setUseTenantDomainInLocalSubjectIdentifier(useTenantDomainInLocalSubjectIdentifier != null && "on".equals(useTenantDomainInLocalSubjectIdentifier));
        String useUserstoreDomainInLocalSubjectIdentifier = request.getParameter("use_userstore_domain_in_local_subject_identifier");
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setUseUserstoreDomainInLocalSubjectIdentifier(useUserstoreDomainInLocalSubjectIdentifier != null && "on".equals(useUserstoreDomainInLocalSubjectIdentifier));
        String useUserstoreDomainInRoles = request.getParameter("use_userstore_domain_in_roles");
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setUseUserstoreDomainInRoles(useUserstoreDomainInRoles != null && "on".equals(useUserstoreDomainInRoles));
        boolean skipConsent = Boolean.parseBoolean(request.getParameter("skipConsent"));
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setSkipConsent(skipConsent);
        boolean skipLogoutConsent = Boolean.parseBoolean(request.getParameter("skipLogoutConsent"));
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setSkipLogoutConsent(skipLogoutConsent);
        String enableAuthorization = request.getParameter("enable_authorization");
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setEnableAuthorization(enableAuthorization != null && "on".equals(enableAuthorization));
        String subjectClaimUri = request.getParameter("subject_claim_uri");
        this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().setSubjectClaimUri(subjectClaimUri != null && !subjectClaimUri.isEmpty() ? subjectClaimUri : null);
        PermissionsAndRoleConfig permAndRoleConfig = new PermissionsAndRoleConfig();
        String[] permissions = request.getParameterValues("app_permission");
        ArrayList<ApplicationPermission> appPermList = new ArrayList<ApplicationPermission>();
        if (permissions != null && permissions.length > 0) {
            for (String permission : permissions) {
                if (permission == null || permission.trim().isEmpty()) continue;
                ApplicationPermission appPermission = new ApplicationPermission();
                appPermission.setValue(permission);
                appPermList.add(appPermission);
            }
        }
        if (CollectionUtils.isNotEmpty(appPermList)) {
            permAndRoleConfig.setPermissions(appPermList.toArray(new ApplicationPermission[appPermList.size()]));
        }
        int roleMappingCount = Integer.parseInt(request.getParameter("number_of_rolemappings"));
        ArrayList<RoleMapping> roleMappingList = new ArrayList<RoleMapping>();
        for (int i = 0; i < roleMappingCount; ++i) {
            RoleMapping mapping = new RoleMapping();
            LocalRole localRole = new LocalRole();
            localRole.setLocalRoleName(request.getParameter("idpRole_" + i));
            mapping.setLocalRole(localRole);
            mapping.setRemoteRole(request.getParameter("spRole_" + i));
            if (mapping.getLocalRole() == null || mapping.getRemoteRole() == null) continue;
            roleMappingList.add(mapping);
        }
        permAndRoleConfig.setRoleMappings(roleMappingList.toArray(new RoleMapping[roleMappingList.size()]));
        this.serviceProvider.setPermissionAndRoleConfig(permAndRoleConfig);
        if (this.serviceProvider.getClaimConfig() == null) {
            this.serviceProvider.setClaimConfig(new ClaimConfig());
        }
        if (request.getParameter("claim_dialect") != null && "custom".equals(request.getParameter("claim_dialect"))) {
            this.serviceProvider.getClaimConfig().setLocalClaimDialect(false);
        } else {
            this.serviceProvider.getClaimConfig().setLocalClaimDialect(true);
        }
        int claimCount = Integer.parseInt(request.getParameter("number_of_claim_mappings"));
        ArrayList<ClaimMapping> claimMappingList = new ArrayList<ClaimMapping>();
        for (int i = 0; i < claimCount; ++i) {
            ClaimMapping mapping = new ClaimMapping();
            Claim localClaim = new Claim();
            localClaim.setClaimUri(request.getParameter("idpClaim_" + i));
            Claim spClaim = new Claim();
            spClaim.setClaimUri(request.getParameter("spClaim_" + i));
            String requested = request.getParameter("spClaim_req_" + i);
            if (requested != null && "on".equals(requested)) {
                mapping.setRequested(true);
            } else {
                mapping.setRequested(false);
            }
            String mandatory = request.getParameter("spClaim_mand_" + i);
            if (mandatory != null && "on".equals(mandatory)) {
                mapping.setMandatory(true);
            } else {
                mapping.setMandatory(false);
            }
            mapping.setLocalClaim(localClaim);
            mapping.setRemoteClaim(spClaim);
            if (this.isLocalClaimsSelected() || mapping.getRemoteClaim().getClaimUri() == null || mapping.getRemoteClaim().getClaimUri().isEmpty()) {
                mapping.getRemoteClaim().setClaimUri(mapping.getLocalClaim().getClaimUri());
            }
            if (mapping.getLocalClaim().getClaimUri() == null || mapping.getRemoteClaim().getClaimUri() == null) continue;
            claimMappingList.add(mapping);
        }
        String spClaimDialectParam = request.getParameter("spClaimDialects");
        String[] spClaimDialects = null;
        if (StringUtils.isNotBlank((String)spClaimDialectParam)) {
            spClaimDialects = spClaimDialectParam.split(",");
        }
        this.serviceProvider.getClaimConfig().setSpClaimDialects(spClaimDialects);
        this.serviceProvider.getClaimConfig().setClaimMappings(claimMappingList.toArray(new ClaimMapping[claimMappingList.size()]));
        this.serviceProvider.getClaimConfig().setRoleClaimURI(request.getParameter("roleClaim"));
        String alwaysSendMappedLocalSubjectId = request.getParameter("always_send_local_subject_id");
        this.serviceProvider.getClaimConfig().setAlwaysSendMappedLocalSubjectId(alwaysSendMappedLocalSubjectId != null && "on".equals(alwaysSendMappedLocalSubjectId));
    }

    public void setCustomInboundAuthenticatorConfigs(InboundAuthenticationRequestConfig[] customInboundAuthenticatorConfigs) {
        HashMap<String, InboundAuthenticationRequestConfig> customInboundAuthConfigs = new HashMap<String, InboundAuthenticationRequestConfig>();
        if (customInboundAuthenticatorConfigs != null && customInboundAuthenticatorConfigs.length > 0) {
            for (InboundAuthenticationRequestConfig config : customInboundAuthenticatorConfigs) {
                customInboundAuthConfigs.put(config.getInboundAuthType() + ":" + config.getInboundConfigType(), config);
            }
        }
        this.customInboundAuthenticatorConfigs = customInboundAuthConfigs;
    }

    public Map<String, String> getRequestedClaims() {
        return this.requestedClaims;
    }

    public Map<String, String> getMandatoryClaims() {
        return this.mandatoryClaims;
    }

    public void setWstrustEp(String wstrustEp) {
        this.wstrustEp = wstrustEp;
    }

    public void setPassivests(String passivests) {
        this.passivests = passivests;
    }

    public void setPassiveSTSWReply(String passiveSTSWReply) {
        this.passiveSTSWReply = passiveSTSWReply;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public void updateLocalSp(HttpServletRequest request) {
        this.serviceProvider.setApplicationName(request.getParameter("spName"));
        this.serviceProvider.setDescription(request.getParameter("sp-description"));
        String provisioningUserStore = request.getParameter("scim-inbound-userstore");
        InboundProvisioningConfig inBoundProConfig = new InboundProvisioningConfig();
        inBoundProConfig.setProvisioningUserStore(provisioningUserStore);
        inBoundProConfig.setDumbMode(Boolean.parseBoolean(request.getParameter(DUMB)));
        this.serviceProvider.setInboundProvisioningConfig(inBoundProConfig);
        String[] provisioningProviders = request.getParameterValues("provisioning_idp");
        ArrayList<IdentityProvider> provisioningIdps = new ArrayList<IdentityProvider>();
        if (this.serviceProvider.getOutboundProvisioningConfig() == null || provisioningProviders == null || provisioningProviders.length == 0) {
            this.serviceProvider.setOutboundProvisioningConfig(new OutboundProvisioningConfig());
        }
        if (provisioningProviders != null && provisioningProviders.length > 0) {
            for (String proProvider : provisioningProviders) {
                String connector = request.getParameter("provisioning_con_idp_" + proProvider);
                String jitEnabled = request.getParameter("provisioning_jit_" + proProvider);
                String blocking = request.getParameter("blocking_prov_" + proProvider);
                String rulesEnabled = request.getParameter("rules_enabled_" + proProvider);
                JustInTimeProvisioningConfig jitpro = new JustInTimeProvisioningConfig();
                if ("on".equals(jitEnabled)) {
                    jitpro.setProvisioningEnabled(true);
                }
                if (connector == null) continue;
                IdentityProvider proIdp = new IdentityProvider();
                proIdp.setIdentityProviderName(proProvider);
                ProvisioningConnectorConfig proCon = new ProvisioningConnectorConfig();
                if ("on".equals(blocking)) {
                    proCon.setBlocking(true);
                }
                if ("on".equals(rulesEnabled)) {
                    proCon.setRulesEnabled(true);
                }
                proCon.setName(connector);
                proIdp.setJustInTimeProvisioningConfig(jitpro);
                proIdp.setDefaultProvisioningConnectorConfig(proCon);
                provisioningIdps.add(proIdp);
            }
            if (CollectionUtils.isNotEmpty(provisioningIdps)) {
                OutboundProvisioningConfig outboundProConfig = new OutboundProvisioningConfig();
                outboundProConfig.setProvisioningIdentityProviders(provisioningIdps.toArray(new IdentityProvider[provisioningIdps.size()]));
                this.serviceProvider.setOutboundProvisioningConfig(outboundProConfig);
            }
        }
    }

    public ApplicationPurposes getApplicationPurposes() {
        return this.applicationPurposes;
    }

    public void setApplicationPurposes(ApplicationPurposes applicationPurposes) {
        this.applicationPurposes = applicationPurposes;
    }

    public Purpose[] getSharedPurposes() {
        return this.sharedPurposes;
    }

    public void setSharedPurposes(Purpose[] sharedPurposes) {
        this.sharedPurposes = sharedPurposes;
    }

    public boolean isUseUserstoreDomainInRoles() {
        if (this.serviceProvider.getLocalAndOutBoundAuthenticationConfig() != null) {
            return this.serviceProvider.getLocalAndOutBoundAuthenticationConfig().getUseUserstoreDomainInRoles();
        }
        return false;
    }

    private ArrayList<ServiceProviderProperty> getServiceProviderProperties() {
        ArrayList<ServiceProviderProperty> spPropList = this.serviceProvider.getSpProperties() != null ? new ArrayList<ServiceProviderProperty>(Arrays.asList(this.serviceProvider.getSpProperties())) : new ArrayList<ServiceProviderProperty>();
        return spPropList;
    }
}

