/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.websocket.local.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.websocket.Session;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.websocket.local.WebsocketLocalOutputCallbackRegisterService;

public class WebsocketLocalOutputCallbackRegisterServiceImpl
implements WebsocketLocalOutputCallbackRegisterService {
    private ConcurrentHashMap<Integer, ConcurrentHashMap<String, CopyOnWriteArrayList<Session>>> outputEventAdaptorSessionMap = new ConcurrentHashMap();

    @Override
    public void subscribe(String adaptorName, Session session) {
        CopyOnWriteArrayList<Object> adapterSpecificSessions;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, CopyOnWriteArrayList<Object>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap == null) {
            tenantSpecificAdaptorMap = new ConcurrentHashMap();
            if (null != this.outputEventAdaptorSessionMap.putIfAbsent(tenantId, tenantSpecificAdaptorMap)) {
                tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
            }
        }
        if ((adapterSpecificSessions = tenantSpecificAdaptorMap.get(adaptorName)) == null && null != tenantSpecificAdaptorMap.putIfAbsent(adaptorName, adapterSpecificSessions = new CopyOnWriteArrayList())) {
            adapterSpecificSessions = tenantSpecificAdaptorMap.get(adaptorName);
        }
        adapterSpecificSessions.add(session);
    }

    public CopyOnWriteArrayList<Session> getSessions(int tenantId, String adaptorName) {
        ConcurrentHashMap<String, CopyOnWriteArrayList<Session>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap != null) {
            CopyOnWriteArrayList<Session> adapterSpecificSessions = tenantSpecificAdaptorMap.get(adaptorName);
            return adapterSpecificSessions;
        }
        return null;
    }

    @Override
    public void unsubscribe(String adaptorName, Session session) {
        CopyOnWriteArrayList<Session> adapterSpecificSessions;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, CopyOnWriteArrayList<Session>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap != null && (adapterSpecificSessions = tenantSpecificAdaptorMap.get(adaptorName)) != null) {
            Session sessionToRemove = null;
            for (Session thisSession : adapterSpecificSessions) {
                if (!session.getId().equals(thisSession.getId())) continue;
                sessionToRemove = session;
                break;
            }
            if (sessionToRemove != null) {
                adapterSpecificSessions.remove(sessionToRemove);
            }
        }
    }
}

