/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.websocket.local;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.websocket.local.WebsocketLocalEventAdapter;
import org.wso2.carbon.utils.CarbonUtils;

public class WebsocketLocalEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.websocket.local.i18n.Resources", Locale.getDefault());
    private int httpPort;
    private int httpsPort;
    private int portOffset = this.getPortOffset();

    public WebsocketLocalEventAdapterFactory() {
        this.httpPort = 9763 + this.portOffset;
        this.httpsPort = 9443 + this.portOffset;
    }

    public String getType() {
        return "websocket-local";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("text");
        supportedMessageFormats.add("xml");
        supportedMessageFormats.add("json");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        return null;
    }

    public List<Property> getDynamicPropertyList() {
        return null;
    }

    public String getUsageTips() {
        return this.resourceBundle.getString("websocket.local.usage.tips.prefix") + this.httpPort + this.resourceBundle.getString("websocket.local.usage.tips.mid") + this.httpsPort + this.resourceBundle.getString("websocket.local.usage.tips.postfix");
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new WebsocketLocalEventAdapter(eventAdapterConfiguration, globalProperties);
    }

    private int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }
}

