/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.websocket.local;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.output.adapter.websocket.local.internal.WebsocketLocalOutputCallbackRegisterServiceImpl;
import org.wso2.carbon.event.output.adapter.websocket.local.internal.ds.WebsocketLocalEventAdaptorServiceInternalValueHolder;

public final class WebsocketLocalEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(WebsocketLocalEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private static ThreadPoolExecutor executorService;
    private boolean doLogDroppedMessage;
    private int tenantId;

    public WebsocketLocalEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.doLogDroppedMessage = true;
    }

    public void init() throws OutputEventAdapterException {
        this.tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (executorService == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize), new ThreadFactoryBuilder().setNameFormat("Thread pool- component - WebsocketLocalEventAdapter.executorService;adapterName - " + this.eventAdapterConfiguration.getName()).build());
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        try {
            executorService.execute(new WebSocketSender(message.toString()));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return true;
    }

    private class WebSocketSender
    implements Runnable {
        private String message;

        public WebSocketSender(String message) {
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WebsocketLocalOutputCallbackRegisterServiceImpl websocketLocalOutputCallbackRegisterServiceImpl = WebsocketLocalEventAdaptorServiceInternalValueHolder.getWebsocketLocalOutputCallbackRegisterServiceImpl();
            CopyOnWriteArrayList<Session> sessions = websocketLocalOutputCallbackRegisterServiceImpl.getSessions(WebsocketLocalEventAdapter.this.tenantId, WebsocketLocalEventAdapter.this.eventAdapterConfiguration.getName());
            if (sessions != null) {
                WebsocketLocalEventAdapter.this.doLogDroppedMessage = true;
                Iterator<Session> iterator = sessions.iterator();
                while (iterator.hasNext()) {
                    Session session;
                    Session session2 = session = iterator.next();
                    synchronized (session2) {
                        try {
                            session.getBasicRemote().sendText(this.message);
                        }
                        catch (IOException e) {
                            EventAdapterUtil.logAndDrop((String)WebsocketLocalEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"Cannot send to endpoint", (Throwable)e, (Log)log, (int)WebsocketLocalEventAdapter.this.tenantId);
                        }
                    }
                }
            } else if (WebsocketLocalEventAdapter.this.doLogDroppedMessage) {
                EventAdapterUtil.logAndDrop((String)WebsocketLocalEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"No clients registered", (Log)log, (int)WebsocketLocalEventAdapter.this.tenantId);
                WebsocketLocalEventAdapter.this.doLogDroppedMessage = false;
            }
        }
    }
}

