/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.keymgt.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.KeyManager;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.dto.ExtendedJWTConfigurationDto;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.token.ClaimsRetriever;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.keymgt.MethodStats;
import org.wso2.carbon.apimgt.keymgt.MethodTimeLogger;
import org.wso2.carbon.apimgt.keymgt.model.entity.Application;
import org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator;
import org.wso2.carbon.apimgt.keymgt.token.JWTGenerator$AjcClosure1;
import org.wso2.carbon.apimgt.keymgt.token.JWTGenerator$AjcClosure3;
import org.wso2.carbon.apimgt.keymgt.token.JWTGenerator$AjcClosure5;
import org.wso2.carbon.claim.mgt.ClaimManagementException;
import org.wso2.carbon.claim.mgt.ClaimManagerHandler;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;

@MethodStats
public class JWTGenerator
extends AbstractJWTGenerator {
    private static final Log log;
    private static final String OIDC_DIALECT_URI = "http://wso2.org/oidc/claim";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        JWTGenerator.ajc$preClinit();
        log = LogFactory.getLog(JWTGenerator.class);
    }

    @Override
    public Map<String, String> populateStandardClaims(TokenValidationContext validationContext) throws APIManagementException {
        TokenValidationContext tokenValidationContext = validationContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)tokenValidationContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, tokenValidationContext, joinPoint};
            return (Map)MethodTimeLogger.aspectOf().log(new JWTGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTGenerator.populateStandardClaims_aroundBody0(this, tokenValidationContext, joinPoint);
    }

    @Override
    public Map<String, String> populateCustomClaims(TokenValidationContext validationContext) throws APIManagementException {
        TokenValidationContext tokenValidationContext = validationContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)tokenValidationContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, tokenValidationContext, joinPoint};
            return (Map)MethodTimeLogger.aspectOf().log(new JWTGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTGenerator.populateCustomClaims_aroundBody2(this, tokenValidationContext, joinPoint);
    }

    protected Map<String, String> convertClaimMap(Map<ClaimMapping, String> userAttributes, String username) throws APIManagementException {
        Map<ClaimMapping, String> map = userAttributes;
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, map, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, map, string, joinPoint};
            return (Map)MethodTimeLogger.aspectOf().log(new JWTGenerator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JWTGenerator.convertClaimMap_aroundBody4(this, map, string, joinPoint);
    }

    static final /* synthetic */ Map populateStandardClaims_aroundBody0(JWTGenerator ajc$this, TokenValidationContext validationContext, JoinPoint joinPoint) {
        long currentTime = System.currentTimeMillis();
        long expireIn = currentTime + ajc$this.getTTL() * 1000L;
        ClaimsRetriever claimsRetriever = ajc$this.getClaimsRetriever();
        String dialect = claimsRetriever != null ? claimsRetriever.getDialectURI(validationContext.getValidationInfoDTO().getEndUserName()) : ajc$this.getDialectURI();
        if (!"".equals(dialect) && !"/".equals(dialect)) {
            dialect = String.valueOf(dialect) + "/";
        }
        String subscriber = validationContext.getValidationInfoDTO().getSubscriber();
        String applicationName = validationContext.getValidationInfoDTO().getApplicationName();
        String applicationId = validationContext.getValidationInfoDTO().getApplicationId();
        String tier = validationContext.getValidationInfoDTO().getTier();
        String endUserName = validationContext.getValidationInfoDTO().getEndUserName();
        String keyType = validationContext.getValidationInfoDTO().getType();
        String userType = validationContext.getValidationInfoDTO().getUserType();
        String applicationTier = validationContext.getValidationInfoDTO().getApplicationTier();
        String enduserTenantId = String.valueOf(APIUtil.getTenantId((String)endUserName));
        String apiName = validationContext.getValidationInfoDTO().getApiName();
        Application application = ajc$this.getApplicationById(validationContext.getValidationInfoDTO().getSubscriberTenantDomain(), Integer.parseInt(applicationId));
        String uuid = null;
        Map<String, String> appAttributes = null;
        if (application != null) {
            appAttributes = application.getAttributes();
            uuid = application.getUUID();
        }
        LinkedHashMap<String, String> claims = new LinkedHashMap<String, String>(20);
        claims.put("iss", "wso2.org/products/am");
        claims.put("exp", String.valueOf(expireIn));
        claims.put(String.valueOf(dialect) + "subscriber", subscriber);
        claims.put(String.valueOf(dialect) + "applicationid", applicationId);
        claims.put(String.valueOf(dialect) + "applicationname", applicationName);
        claims.put(String.valueOf(dialect) + "applicationtier", applicationTier);
        claims.put(String.valueOf(dialect) + "apiname", apiName);
        claims.put(String.valueOf(dialect) + "apicontext", validationContext.getContext());
        claims.put(String.valueOf(dialect) + "version", validationContext.getVersion());
        claims.put(String.valueOf(dialect) + "tier", tier);
        claims.put(String.valueOf(dialect) + "keytype", keyType);
        claims.put(String.valueOf(dialect) + "usertype", userType);
        claims.put(String.valueOf(dialect) + "enduser", APIUtil.getUserNameWithTenantSuffix((String)endUserName));
        claims.put(String.valueOf(dialect) + "enduserTenantId", enduserTenantId);
        claims.put(String.valueOf(dialect) + "applicationUUId", uuid);
        try {
            if (appAttributes != null && !appAttributes.isEmpty()) {
                String stringAppAttributes = new ObjectMapper().writeValueAsString(appAttributes);
                claims.put(String.valueOf(dialect) + "applicationAttributes", stringAppAttributes);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            log.error((Object)"Error in converting Map to String");
        }
        return claims;
    }

    static final /* synthetic */ Map populateCustomClaims_aroundBody2(JWTGenerator ajc$this, TokenValidationContext validationContext, JoinPoint joinPoint) {
        ClaimsRetriever claimsRetriever;
        APIManagerConfiguration apiManagerConfiguration = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        ExtendedJWTConfigurationDto jwtConfigurationDto = apiManagerConfiguration.getJwtConfigurationDto();
        Map customClaims = new HashMap();
        HashMap<String, String> properties = new HashMap<String, String>();
        String username = validationContext.getValidationInfoDTO().getEndUserName();
        int tenantId = APIUtil.getTenantId((String)username);
        if (jwtConfigurationDto.isEnableUserClaims()) {
            String dialectURI;
            String accessToken = validationContext.getAccessToken();
            if (accessToken != null) {
                properties.put("accessToken", accessToken);
            }
            if (!StringUtils.isEmpty((CharSequence)(dialectURI = jwtConfigurationDto.getConsumerDialectUri()))) {
                properties.put("dialect", dialectURI);
                String keymanagerName = validationContext.getValidationInfoDTO().getKeyManager();
                KeyManager keymanager = KeyManagerHolder.getKeyManagerInstance((String)APIUtil.getTenantDomainFromTenantId((int)tenantId), (String)keymanagerName);
                if (keymanager != null) {
                    customClaims = keymanager.getUserClaims(username, properties);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Retrieved claims :" + customClaims));
                    }
                }
            }
        }
        if ((claimsRetriever = ajc$this.getClaimsRetriever()) != null) {
            customClaims.putAll(claimsRetriever.getClaims(username));
        }
        return customClaims;
    }

    static final /* synthetic */ Map convertClaimMap_aroundBody4(JWTGenerator ajc$this, Map userAttributes, String username, JoinPoint joinPoint) {
        HashMap<String, String> userClaims = new HashMap<String, String>();
        HashMap<String, String> userClaimsCopy = new HashMap<String, String>();
        for (Map.Entry entry : userAttributes.entrySet()) {
            Claim claimObject = ((ClaimMapping)entry.getKey()).getLocalClaim();
            if (claimObject == null) {
                claimObject = ((ClaimMapping)entry.getKey()).getRemoteClaim();
            }
            userClaims.put(claimObject.getClaimUri(), (String)entry.getValue());
            userClaimsCopy.put(claimObject.getClaimUri(), (String)entry.getValue());
        }
        String convertClaimsFromOIDCtoConsumerDialect = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getFirstProperty("JWTConfiguration.ConvertClaimsToConsumerDialect");
        if (convertClaimsFromOIDCtoConsumerDialect != null && !Boolean.parseBoolean(convertClaimsFromOIDCtoConsumerDialect)) {
            return userClaims;
        }
        int tenantId = APIUtil.getTenantId((String)username);
        String tenantDomain = APIUtil.getTenantDomainFromTenantId((int)tenantId);
        ClaimsRetriever claimsRetriever = ajc$this.getClaimsRetriever();
        String dialect = claimsRetriever != null ? claimsRetriever.getDialectURI(username) : ajc$this.getDialectURI();
        Map configuredDialectToCarbonClaimMapping = null;
        Map carbonToOIDCclaimMapping = null;
        HashSet claimUris = new HashSet(userClaims.keySet());
        try {
            carbonToOIDCclaimMapping = new ClaimMetadataHandler().getMappingsMapFromOtherDialectToCarbon(OIDC_DIALECT_URI, claimUris, tenantDomain, true);
            configuredDialectToCarbonClaimMapping = ClaimManagerHandler.getInstance().getMappingsMapFromCarbonDialectToOther(dialect, carbonToOIDCclaimMapping.keySet(), tenantDomain);
        }
        catch (ClaimMetadataException e) {
            String error = "Error while mapping claims from Carbon dialect to http://wso2.org/oidc/claim dialect";
            throw new APIManagementException(error, (Throwable)e);
        }
        catch (ClaimManagementException e) {
            String error = "Error while mapping claims from configured dialect to Carbon dialect";
            throw new APIManagementException(error, (Throwable)e);
        }
        for (Map.Entry oidcClaimValEntry : userClaims.entrySet()) {
            for (Map.Entry carbonToOIDCEntry : carbonToOIDCclaimMapping.entrySet()) {
                if (!((String)oidcClaimValEntry.getKey()).equals(carbonToOIDCEntry.getValue())) continue;
                for (Map.Entry configuredToCarbonEntry : configuredDialectToCarbonClaimMapping.entrySet()) {
                    if (!((String)configuredToCarbonEntry.getValue()).equals(carbonToOIDCEntry.getKey())) continue;
                    userClaimsCopy.remove(oidcClaimValEntry.getKey());
                    userClaimsCopy.put((String)configuredToCarbonEntry.getKey(), (String)oidcClaimValEntry.getValue());
                }
            }
        }
        return userClaimsCopy;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JWTGenerator.java", JWTGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "populateStandardClaims", "org.wso2.carbon.apimgt.keymgt.token.JWTGenerator", "org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext", "validationContext", "org.wso2.carbon.apimgt.api.APIManagementException", "java.util.Map"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "populateCustomClaims", "org.wso2.carbon.apimgt.keymgt.token.JWTGenerator", "org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext", "validationContext", "org.wso2.carbon.apimgt.api.APIManagementException", "java.util.Map"), 128);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "convertClaimMap", "org.wso2.carbon.apimgt.keymgt.token.JWTGenerator", "java.util.Map:java.lang.String", "userAttributes:username", "org.wso2.carbon.apimgt.api.APIManagementException", "java.util.Map"), 166);
    }
}

