/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.keymgt.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.dto.ExtendedJWTConfigurationDto;
import org.wso2.carbon.apimgt.impl.token.ClaimsRetriever;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.SigningUtil;
import org.wso2.carbon.apimgt.keymgt.MethodStats;
import org.wso2.carbon.apimgt.keymgt.MethodTimeLogger;
import org.wso2.carbon.apimgt.keymgt.SubscriptionDataHolder;
import org.wso2.carbon.apimgt.keymgt.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.keymgt.model.SubscriptionDataStore;
import org.wso2.carbon.apimgt.keymgt.model.entity.Application;
import org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure1;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure11;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure13;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure15;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure17;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure19;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure21;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure23;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure25;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure3;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure5;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure7;
import org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator$AjcClosure9;
import org.wso2.carbon.apimgt.keymgt.token.JWTGenerator;
import org.wso2.carbon.apimgt.keymgt.token.TokenGenerator;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public abstract class AbstractJWTGenerator
implements TokenGenerator {
    private static final Log log;
    public static final String API_GATEWAY_ID = "wso2.org/products/am";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static final String NONE = "NONE";
    private static volatile long ttl;
    private ClaimsRetriever claimsRetriever;
    private String dialectURI = "http://wso2.org/claims";
    private String signatureAlgorithm = "SHA256withRSA";
    private String userAttributeSeparator = ",";
    private boolean tenantBasedSigningEnabled;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    static {
        AbstractJWTGenerator.ajc$preClinit();
        log = LogFactory.getLog(AbstractJWTGenerator.class);
        ttl = -1L;
    }

    public AbstractJWTGenerator() {
        String claimsRetrieverImplClass;
        ExtendedJWTConfigurationDto jwtConfigurationDto = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration().getJwtConfigurationDto();
        this.dialectURI = jwtConfigurationDto.getConsumerDialectUri();
        if (this.dialectURI == null) {
            this.dialectURI = "http://wso2.org/claims";
        }
        this.signatureAlgorithm = jwtConfigurationDto.getSignatureAlgorithm();
        if (this.signatureAlgorithm == null || !NONE.equals(this.signatureAlgorithm) && !SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            this.signatureAlgorithm = SHA256_WITH_RSA;
        }
        if ((claimsRetrieverImplClass = jwtConfigurationDto.getClaimRetrieverImplClass()) != null) {
            try {
                this.claimsRetriever = (ClaimsRetriever)APIUtil.getClassForName((String)claimsRetrieverImplClass).newInstance();
                this.claimsRetriever.init();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Cannot find class: " + claimsRetrieverImplClass), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)("Error instantiating " + claimsRetrieverImplClass), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Illegal access to " + claimsRetrieverImplClass), (Throwable)e);
            }
            catch (APIManagementException e) {
                log.error((Object)("Error while initializing " + claimsRetrieverImplClass), (Throwable)e);
            }
        }
        this.tenantBasedSigningEnabled = jwtConfigurationDto.isTenantBasedSigningEnabled();
    }

    public String getDialectURI() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.dialectURI;
    }

    public ClaimsRetriever getClaimsRetriever() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (ClaimsRetriever)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.claimsRetriever;
    }

    public abstract Map<String, String> populateStandardClaims(TokenValidationContext var1) throws APIManagementException;

    public abstract Map<String, String> populateCustomClaims(TokenValidationContext var1) throws APIManagementException;

    public String encode(byte[] stringToBeEncoded) throws APIManagementException {
        byte[] byArray = stringToBeEncoded;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)byArray);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, byArray, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractJWTGenerator.encode_aroundBody4(this, byArray, joinPoint);
    }

    @Override
    public String generateToken(TokenValidationContext validationContext) throws APIManagementException {
        TokenValidationContext tokenValidationContext = validationContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)tokenValidationContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, tokenValidationContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractJWTGenerator.generateToken_aroundBody6(this, tokenValidationContext, joinPoint);
    }

    public String buildHeader() throws APIManagementException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.buildHeader("carbon.super");
    }

    public String buildHeader(String tenantDomain) throws APIManagementException {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractJWTGenerator.buildHeader_aroundBody10(this, string, joinPoint);
    }

    public String buildBody(TokenValidationContext validationContext) throws APIManagementException {
        TokenValidationContext tokenValidationContext = validationContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)tokenValidationContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, tokenValidationContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractJWTGenerator.buildBody_aroundBody12(this, tokenValidationContext, joinPoint);
    }

    public byte[] signJWT(String assertion, String tenantDomain) throws APIManagementException {
        String string = assertion;
        String string2 = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (byte[])MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractJWTGenerator.signJWT_aroundBody14(this, string, string2, joinPoint);
    }

    protected long getTTL() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.longValue((Object)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return AbstractJWTGenerator.getTTL_aroundBody16(this, joinPoint);
    }

    protected String addCertToHeader() throws APIManagementException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.addCertToHeader("carbon.super");
    }

    protected String addCertToHeader(String tenantDomain) throws APIManagementException {
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractJWTGenerator.addCertToHeader_aroundBody20(this, string, joinPoint);
    }

    protected String getMultiAttributeSeparator(int tenantId) {
        int n = tenantId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractJWTGenerator.getMultiAttributeSeparator_aroundBody22(this, n, joinPoint);
    }

    protected Application getApplicationById(String tenantDomain, int applicationId) {
        String string = tenantDomain;
        int n = applicationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, Conversions.intObject((int)n), joinPoint};
            return (Application)MethodTimeLogger.aspectOf().log(new AbstractJWTGenerator$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AbstractJWTGenerator.getApplicationById_aroundBody24(this, string, n, joinPoint);
    }

    static final /* synthetic */ String encode_aroundBody4(AbstractJWTGenerator ajc$this, byte[] stringToBeEncoded, JoinPoint joinPoint) {
        return Base64.getUrlEncoder().encodeToString(stringToBeEncoded);
    }

    static final /* synthetic */ String generateToken_aroundBody6(AbstractJWTGenerator ajc$this, TokenValidationContext validationContext, JoinPoint joinPoint) {
        String jwtHeader = ajc$this.buildHeader(validationContext.getTenantDomain());
        String base64UrlEncodedHeader = "";
        if (jwtHeader != null) {
            base64UrlEncodedHeader = ajc$this.encode(jwtHeader.getBytes(Charset.defaultCharset()));
        }
        String jwtBody = ajc$this.buildBody(validationContext);
        String base64UrlEncodedBody = "";
        if (jwtBody != null) {
            base64UrlEncodedBody = ajc$this.encode(jwtBody.getBytes());
        }
        if (SHA256_WITH_RSA.equals(ajc$this.signatureAlgorithm)) {
            String assertion = String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody;
            byte[] signedAssertion = ajc$this.signJWT(assertion, validationContext.getTenantDomain());
            if (log.isDebugEnabled()) {
                log.debug((Object)("signed assertion value : " + new String(signedAssertion, Charset.defaultCharset())));
            }
            String base64UrlEncodedAssertion = ajc$this.encode(signedAssertion);
            return String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody + '.' + base64UrlEncodedAssertion;
        }
        return String.valueOf(base64UrlEncodedHeader) + '.' + base64UrlEncodedBody + '.';
    }

    static final /* synthetic */ String buildHeader_aroundBody10(AbstractJWTGenerator ajc$this, String tenantDomain, JoinPoint joinPoint) {
        String jwtHeader = null;
        if (NONE.equals(ajc$this.signatureAlgorithm)) {
            StringBuilder jwtHeaderBuilder = new StringBuilder();
            jwtHeaderBuilder.append("{\"typ\":\"JWT\",");
            jwtHeaderBuilder.append("\"alg\":\"");
            jwtHeaderBuilder.append(APIUtil.getJWSCompliantAlgorithmCode((String)NONE));
            jwtHeaderBuilder.append('\"');
            jwtHeaderBuilder.append('}');
            jwtHeader = jwtHeaderBuilder.toString();
        } else if (SHA256_WITH_RSA.equals(ajc$this.signatureAlgorithm)) {
            jwtHeader = ajc$this.addCertToHeader(tenantDomain);
        }
        return jwtHeader;
    }

    static final /* synthetic */ String buildBody_aroundBody12(AbstractJWTGenerator ajc$this, TokenValidationContext validationContext, JoinPoint joinPoint) {
        Map<String, String> standardClaims = ajc$this.populateStandardClaims(validationContext);
        Map<String, String> customClaims = ajc$this.populateCustomClaims(validationContext);
        int tenantId = APIUtil.getTenantId((String)validationContext.getTenantDomain());
        String claimSeparator = ajc$this.getMultiAttributeSeparator(tenantId);
        if (StringUtils.isNotBlank((CharSequence)claimSeparator)) {
            ajc$this.userAttributeSeparator = claimSeparator;
        }
        if (standardClaims != null) {
            if (customClaims != null) {
                for (Map.Entry<String, String> entry : customClaims.entrySet()) {
                    if (standardClaims.containsKey(entry.getKey())) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Skip already existing claim '" + entry.getKey() + "'"));
                        continue;
                    }
                    standardClaims.put(entry.getKey(), entry.getValue());
                }
            }
            JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
            if (standardClaims != null) {
                for (String claimURI : new TreeSet<String>(standardClaims.keySet())) {
                    String claimVal = standardClaims.get(claimURI);
                    ArrayList<String> claimList = new ArrayList<String>();
                    if (claimVal != null && claimVal.contains("{")) {
                        ObjectMapper mapper = new ObjectMapper();
                        try {
                            Map map = (Map)mapper.readValue(claimVal, Map.class);
                            jwtClaimsSetBuilder.claim(claimURI, (Object)map);
                        }
                        catch (IOException e) {
                            log.error((Object)String.format("Error while reading claim values for %s", claimVal), (Throwable)e);
                        }
                        continue;
                    }
                    if (ajc$this.userAttributeSeparator != null && claimVal != null && claimVal.contains(ajc$this.userAttributeSeparator)) {
                        StringTokenizer st = new StringTokenizer(claimVal, ajc$this.userAttributeSeparator);
                        while (st.hasMoreElements()) {
                            String attValue = st.nextElement().toString();
                            if (!StringUtils.isNotBlank((CharSequence)attValue)) continue;
                            claimList.add(attValue);
                        }
                        jwtClaimsSetBuilder.claim(claimURI, claimList);
                        continue;
                    }
                    if ("exp".equals(claimURI)) {
                        jwtClaimsSetBuilder.expirationTime(new Date(Long.valueOf(standardClaims.get(claimURI))));
                        continue;
                    }
                    jwtClaimsSetBuilder.claim(claimURI, (Object)claimVal);
                }
                jwtClaimsSetBuilder.jwtID(UUID.randomUUID().toString());
            }
            return jwtClaimsSetBuilder.build().toJSONObject().toJSONString();
        }
        return null;
    }

    static final /* synthetic */ byte[] signJWT_aroundBody14(AbstractJWTGenerator ajc$this, String assertion, String tenantDomain, JoinPoint joinPoint) {
        try {
            PrivateKey privateKey;
            if (ajc$this.tenantBasedSigningEnabled) {
                privateKey = SigningUtil.getSigningKey((int)APIUtil.getTenantIdFromTenantDomain((String)tenantDomain));
            } else {
                KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)-1234);
                privateKey = keyStoreManager.getDefaultPrivateKey();
            }
            return APIUtil.signJwt((String)assertion, (PrivateKey)privateKey, (String)ajc$this.signatureAlgorithm);
        }
        catch (Exception e) {
            throw new APIManagementException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ long getTTL_aroundBody16(AbstractJWTGenerator ajc$this, JoinPoint joinPoint) {
        if (ttl != -1L) {
            return ttl;
        }
        Class<JWTGenerator> clazz = JWTGenerator.class;
        synchronized (JWTGenerator.class) {
            String ttlValue;
            String apimKeyCacheExpiry;
            if (ttl != -1L) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ttl;
            }
            APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
            String gwTokenCacheConfig = config.getFirstProperty("CacheConfigurations.EnableGatewayTokenCache");
            boolean isGWTokenCacheEnabled = Boolean.parseBoolean(gwTokenCacheConfig);
            String kmTokenCacheConfig = config.getFirstProperty("CacheConfigurations.EnableKeyManagerTokenCache");
            boolean isKMTokenCacheEnabled = Boolean.parseBoolean(kmTokenCacheConfig);
            ttl = isGWTokenCacheEnabled || isKMTokenCacheEnabled ? ((apimKeyCacheExpiry = config.getFirstProperty("CacheConfigurations.TokenCacheExpiry")) != null ? Long.parseLong(apimKeyCacheExpiry) + Long.valueOf(60L) : Long.valueOf(960L)) : ((ttlValue = config.getFirstProperty("APIKeyValidator.JWTExpiryTime")) != null ? Long.parseLong(ttlValue) + Long.valueOf(60L) : Long.valueOf(960L));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ttl;
        }
    }

    static final /* synthetic */ String addCertToHeader_aroundBody20(AbstractJWTGenerator ajc$this, String tenantDomain, JoinPoint joinPoint) {
        try {
            Certificate publicCert;
            if (ajc$this.tenantBasedSigningEnabled) {
                publicCert = SigningUtil.getPublicCertificate((int)APIUtil.getTenantIdFromTenantDomain((String)tenantDomain));
            } else {
                KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)-1234);
                publicCert = keyStoreManager.getDefaultPrimaryCertificate();
            }
            return APIUtil.generateHeader((Certificate)publicCert, (String)ajc$this.signatureAlgorithm);
        }
        catch (Exception e) {
            String error = "Error in obtaining keystore";
            throw new APIManagementException(error, (Throwable)e);
        }
    }

    static final /* synthetic */ String getMultiAttributeSeparator_aroundBody22(AbstractJWTGenerator ajc$this, int tenantId, JoinPoint joinPoint) {
        try {
            String claimSeparator;
            RealmConfiguration realmConfiguration = null;
            RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
            if (realmService != null && tenantId != -1) {
                UserStoreManager userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
                realmConfiguration = userStoreManager.getRealmConfiguration();
            }
            if (realmConfiguration != null && (claimSeparator = realmConfiguration.getUserStoreProperty("MultiAttributeSeparator")) != null && !claimSeparator.trim().isEmpty()) {
                return claimSeparator;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error occurred while getting the realm configuration, User store properties might not be returned", (Throwable)e);
        }
        return null;
    }

    static final /* synthetic */ Application getApplicationById_aroundBody24(AbstractJWTGenerator ajc$this, String tenantDomain, int applicationId, JoinPoint joinPoint) {
        SubscriptionDataStore datastore = SubscriptionDataHolder.getInstance().getTenantSubscriptionStore(tenantDomain);
        return datastore.getApplicationById(applicationId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractJWTGenerator.java", AbstractJWTGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDialectURI", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "", "", "", "java.lang.String"), 122);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClaimsRetriever", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "", "", "", "org.wso2.carbon.apimgt.impl.token.ClaimsRetriever"), 126);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addCertToHeader", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "java.lang.String", "tenantDomain", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 330);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getMultiAttributeSeparator", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "int", "tenantId", "", "java.lang.String"), 347);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getApplicationById", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "java.lang.String:int", "tenantDomain:applicationId", "", "org.wso2.carbon.apimgt.keymgt.model.entity.Application"), 372);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "encode", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "[B", "stringToBeEncoded", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 135);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateToken", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext", "validationContext", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 139);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildHeader", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "", "", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 171);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildHeader", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "java.lang.String", "tenantDomain", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 175);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildBody", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext", "validationContext", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 195);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "signJWT", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "java.lang.String:java.lang.String", "assertion:tenantDomain", "org.wso2.carbon.apimgt.api.APIManagementException", "[B"), 263);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTTL", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "", "", "", "long"), 279);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addCertToHeader", "org.wso2.carbon.apimgt.keymgt.token.AbstractJWTGenerator", "", "", "org.wso2.carbon.apimgt.api.APIManagementException", "java.lang.String"), 320);
    }
}

