/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.keymgt.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.AccessTokenInfo;
import org.wso2.carbon.apimgt.api.model.KeyManager;
import org.wso2.carbon.apimgt.api.model.subscription.URLMapping;
import org.wso2.carbon.apimgt.impl.caching.CacheProvider;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.dto.KeyManagerDto;
import org.wso2.carbon.apimgt.impl.factory.KeyManagerHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.keymgt.APIKeyMgtException;
import org.wso2.carbon.apimgt.keymgt.MethodStats;
import org.wso2.carbon.apimgt.keymgt.MethodTimeLogger;
import org.wso2.carbon.apimgt.keymgt.SubscriptionDataHolder;
import org.wso2.carbon.apimgt.keymgt.handlers.AbstractKeyValidationHandler;
import org.wso2.carbon.apimgt.keymgt.handlers.DefaultKeyValidationHandler$AjcClosure1;
import org.wso2.carbon.apimgt.keymgt.handlers.DefaultKeyValidationHandler$AjcClosure3;
import org.wso2.carbon.apimgt.keymgt.handlers.DefaultKeyValidationHandler$AjcClosure5;
import org.wso2.carbon.apimgt.keymgt.handlers.DefaultKeyValidationHandler$AjcClosure7;
import org.wso2.carbon.apimgt.keymgt.model.SubscriptionDataStore;
import org.wso2.carbon.apimgt.keymgt.model.entity.API;
import org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class DefaultKeyValidationHandler
extends AbstractKeyValidationHandler {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        DefaultKeyValidationHandler.ajc$preClinit();
        log = LogFactory.getLog(DefaultKeyValidationHandler.class);
    }

    public DefaultKeyValidationHandler() {
        log.info((Object)(String.valueOf(this.getClass().getName()) + " Initialised"));
    }

    @Override
    public boolean validateToken(TokenValidationContext validationContext) throws APIKeyMgtException {
        TokenValidationContext tokenValidationContext = validationContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)tokenValidationContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, tokenValidationContext, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new DefaultKeyValidationHandler$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return DefaultKeyValidationHandler.validateToken_aroundBody0(this, tokenValidationContext, joinPoint);
    }

    @Override
    public boolean validateScopes(TokenValidationContext validationContext) throws APIKeyMgtException {
        TokenValidationContext tokenValidationContext = validationContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)tokenValidationContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, tokenValidationContext, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new DefaultKeyValidationHandler$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return DefaultKeyValidationHandler.validateScopes_aroundBody2(this, tokenValidationContext, joinPoint);
    }

    private AccessTokenInfo getAccessTokenInfo(TokenValidationContext validationContext) throws APIManagementException {
        TokenValidationContext tokenValidationContext = validationContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)tokenValidationContext);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, tokenValidationContext, joinPoint};
            return (AccessTokenInfo)MethodTimeLogger.aspectOf().log(new DefaultKeyValidationHandler$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return DefaultKeyValidationHandler.getAccessTokenInfo_aroundBody4(this, tokenValidationContext, joinPoint);
    }

    private boolean isResourcePathMatching(String resourceString, URLMapping urlMapping) {
        String string = resourceString;
        URLMapping uRLMapping = urlMapping;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)uRLMapping);
        if (this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled() || MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, uRLMapping, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new DefaultKeyValidationHandler$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return DefaultKeyValidationHandler.isResourcePathMatching_aroundBody6(this, string, uRLMapping, joinPoint);
    }

    static final /* synthetic */ boolean validateToken_aroundBody0(DefaultKeyValidationHandler ajc$this, TokenValidationContext validationContext, JoinPoint joinPoint) {
        APIKeyValidationInfoDTO apiKeyValidationInfoDTO;
        AccessTokenInfo tokenInfo;
        block11: {
            block10: {
                if (validationContext.isCacheHit()) {
                    APIKeyValidationInfoDTO infoDTO = validationContext.getValidationInfoDTO();
                    boolean tokenExpired = APIUtil.isAccessTokenExpired((APIKeyValidationInfoDTO)infoDTO);
                    if (tokenExpired) {
                        infoDTO.setAuthorized(false);
                        infoDTO.setValidationStatus(900901);
                        log.debug((Object)("Token " + validationContext.getAccessToken() + " expired."));
                        return false;
                    }
                    return true;
                }
                if (StringUtils.isEmpty((String)validationContext.getAccessToken())) {
                    APIKeyValidationInfoDTO infoDTO = validationContext.getValidationInfoDTO();
                    infoDTO.setAuthorized(false);
                    infoDTO.setValidationStatus(900901);
                    log.debug((Object)"Token Not available");
                    return false;
                }
                try {
                    tokenInfo = ajc$this.getAccessTokenInfo(validationContext);
                    if (tokenInfo != null) break block10;
                    return false;
                }
                catch (APIManagementException e) {
                    log.error((Object)"Error while obtaining Token Metadata from Authorization Server", (Throwable)e);
                    throw new APIKeyMgtException("Error while obtaining Token Metadata from Authorization Server");
                }
            }
            validationContext.setTokenInfo(tokenInfo);
            apiKeyValidationInfoDTO = new APIKeyValidationInfoDTO();
            validationContext.setValidationInfoDTO(apiKeyValidationInfoDTO);
            if (tokenInfo.isTokenValid()) break block11;
            apiKeyValidationInfoDTO.setAuthorized(false);
            if (tokenInfo.getErrorcode() > 0) {
                apiKeyValidationInfoDTO.setValidationStatus(tokenInfo.getErrorcode());
            } else {
                apiKeyValidationInfoDTO.setValidationStatus(900900);
            }
            return false;
        }
        apiKeyValidationInfoDTO.setKeyManager(tokenInfo.getKeyManager());
        apiKeyValidationInfoDTO.setAuthorized(tokenInfo.isTokenValid());
        apiKeyValidationInfoDTO.setEndUserName(tokenInfo.getEndUserName());
        apiKeyValidationInfoDTO.setConsumerKey(tokenInfo.getConsumerKey());
        apiKeyValidationInfoDTO.setIssuedTime(tokenInfo.getIssuedTime());
        apiKeyValidationInfoDTO.setValidityPeriod(tokenInfo.getValidityPeriod());
        if (tokenInfo.getScopes() != null) {
            HashSet<String> scopeSet = new HashSet<String>(Arrays.asList(tokenInfo.getScopes()));
            apiKeyValidationInfoDTO.setScopes(scopeSet);
        }
        return tokenInfo.isTokenValid();
    }

    static final /* synthetic */ boolean validateScopes_aroundBody2(DefaultKeyValidationHandler ajc$this, TokenValidationContext validationContext, JoinPoint joinPoint) {
        if (validationContext.isCacheHit()) {
            return true;
        }
        APIKeyValidationInfoDTO apiKeyValidationInfoDTO = validationContext.getValidationInfoDTO();
        if (apiKeyValidationInfoDTO == null) {
            throw new APIKeyMgtException("Key Validation information not set");
        }
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String httpVerb = validationContext.getHttpVerb();
        Set scopesSet = apiKeyValidationInfoDTO.getScopes();
        StringBuilder scopeList = new StringBuilder();
        if (scopesSet != null && !scopesSet.isEmpty()) {
            String[] scopes = scopesSet.toArray(new String[scopesSet.size()]);
            if (log.isDebugEnabled() && scopes != null) {
                String[] stringArray = scopes;
                int n = scopes.length;
                int n2 = 0;
                while (n2 < n) {
                    String scope = stringArray[n2];
                    scopeList.append(scope);
                    scopeList.append(",");
                    ++n2;
                }
                scopeList.deleteCharAt(scopeList.length() - 1);
                log.debug((Object)("Scopes allowed for token : " + validationContext.getAccessToken() + " : " + scopeList.toString()));
            }
        }
        String resourceList = validationContext.getMatchingResource();
        ArrayList<String> resourceArray = "Query".equalsIgnoreCase(validationContext.getHttpVerb()) || "Mutation".equalsIgnoreCase(validationContext.getHttpVerb()) || "Subscription".equalsIgnoreCase(validationContext.getHttpVerb()) ? new ArrayList<String>(Arrays.asList(resourceList.split(","))) : new ArrayList<String>(Arrays.asList(resourceList));
        String actualVersion = validationContext.getVersion();
        if (actualVersion != null && actualVersion.startsWith("_default_")) {
            actualVersion = actualVersion.split("_default_")[1];
        }
        SubscriptionDataStore tenantSubscriptionStore = SubscriptionDataHolder.getInstance().getTenantSubscriptionStore(tenantDomain);
        API api = tenantSubscriptionStore.getApiByContextAndVersion(validationContext.getContext(), actualVersion);
        boolean scopesValidated = false;
        if (api != null) {
            for (String resource : resourceArray) {
                List<URLMapping> resources = api.getResources();
                URLMapping urlMapping = null;
                for (URLMapping mapping : resources) {
                    if (!Objects.equals(mapping.getHttpMethod(), httpVerb) && !"WS".equalsIgnoreCase(api.getApiType()) || !ajc$this.isResourcePathMatching(resource, mapping)) continue;
                    urlMapping = mapping;
                    break;
                }
                if (urlMapping == null) continue;
                if (urlMapping.getScopes().size() == 0) {
                    scopesValidated = true;
                    continue;
                }
                List mappingScopes = urlMapping.getScopes();
                boolean validate = false;
                for (String scope : mappingScopes) {
                    if (!scopesSet.contains(scope)) continue;
                    scopesValidated = true;
                    validate = true;
                    break;
                }
                if (!validate && urlMapping.getScopes().size() > 0) break;
            }
        }
        if (!scopesValidated) {
            apiKeyValidationInfoDTO.setAuthorized(false);
            apiKeyValidationInfoDTO.setValidationStatus(900910);
        }
        return scopesValidated;
    }

    static final /* synthetic */ AccessTokenInfo getAccessTokenInfo_aroundBody4(DefaultKeyValidationHandler ajc$this, TokenValidationContext validationContext, JoinPoint joinPoint) {
        Object cachedAccessTokenInfo = CacheProvider.createIntrospectionCache().get((Object)validationContext.getAccessToken());
        if (cachedAccessTokenInfo != null) {
            return (AccessTokenInfo)cachedAccessTokenInfo;
        }
        String electedKeyManager = null;
        if (StringUtils.isNotEmpty((String)validationContext.getTenantDomain())) {
            Map tenantKeyManagers = KeyManagerHolder.getTenantKeyManagers((String)validationContext.getTenantDomain());
            KeyManager keyManagerInstance = null;
            if (tenantKeyManagers.values().size() == 1) {
                KeyManagerDto keyManagerDto;
                Map.Entry entry = tenantKeyManagers.entrySet().iterator().next();
                if (entry != null && (keyManagerDto = (KeyManagerDto)entry.getValue()) != null && (validationContext.getKeyManagers().contains("all") || validationContext.getKeyManagers().contains(keyManagerDto.getName()))) {
                    keyManagerInstance = keyManagerDto.getKeyManager();
                    electedKeyManager = (String)entry.getKey();
                }
            } else if (tenantKeyManagers.values().size() > 1) {
                if (validationContext.getKeyManagers().contains("all")) {
                    for (Map.Entry keyManagerDtoEntry : tenantKeyManagers.entrySet()) {
                        if (((KeyManagerDto)keyManagerDtoEntry.getValue()).getKeyManager() == null || !((KeyManagerDto)keyManagerDtoEntry.getValue()).getKeyManager().canHandleToken(validationContext.getAccessToken())) continue;
                        keyManagerInstance = ((KeyManagerDto)keyManagerDtoEntry.getValue()).getKeyManager();
                        electedKeyManager = (String)keyManagerDtoEntry.getKey();
                        break;
                    }
                } else {
                    for (String selectedKeyManager : validationContext.getKeyManagers()) {
                        KeyManagerDto keyManagerDto = (KeyManagerDto)tenantKeyManagers.get(selectedKeyManager);
                        if (keyManagerDto == null || keyManagerDto.getKeyManager() == null || !keyManagerDto.getKeyManager().canHandleToken(validationContext.getAccessToken())) continue;
                        keyManagerInstance = keyManagerDto.getKeyManager();
                        electedKeyManager = selectedKeyManager;
                        break;
                    }
                }
            }
            if (keyManagerInstance != null) {
                AccessTokenInfo tokenInfo = keyManagerInstance.getTokenMetaData(validationContext.getAccessToken());
                tokenInfo.setKeyManager(electedKeyManager);
                CacheProvider.getGatewayIntrospectCache().put((Object)validationContext.getAccessToken(), (Object)tokenInfo);
                return tokenInfo;
            }
            log.debug((Object)"KeyManager not available to authorize token.");
        }
        return null;
    }

    static final /* synthetic */ boolean isResourcePathMatching_aroundBody6(DefaultKeyValidationHandler ajc$this, String resourceString, URLMapping urlMapping, JoinPoint joinPoint) {
        String urlPattern;
        String resource = resourceString.trim();
        if (resource.equalsIgnoreCase(urlPattern = urlMapping.getUrlPattern().trim())) {
            return true;
        }
        if (resource.length() + 1 == urlPattern.length() && urlPattern.endsWith("/")) {
            String urlPatternWithoutSlash = urlPattern.substring(0, urlPattern.length() - 1);
            return resource.equalsIgnoreCase(urlPatternWithoutSlash);
        }
        return false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultKeyValidationHandler.java", DefaultKeyValidationHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateToken", "org.wso2.carbon.apimgt.keymgt.handlers.DefaultKeyValidationHandler", "org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext", "validationContext", "org.wso2.carbon.apimgt.keymgt.APIKeyMgtException", "boolean"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateScopes", "org.wso2.carbon.apimgt.keymgt.handlers.DefaultKeyValidationHandler", "org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext", "validationContext", "org.wso2.carbon.apimgt.keymgt.APIKeyMgtException", "boolean"), 124);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getAccessTokenInfo", "org.wso2.carbon.apimgt.keymgt.handlers.DefaultKeyValidationHandler", "org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext", "validationContext", "org.wso2.carbon.apimgt.api.APIManagementException", "org.wso2.carbon.apimgt.api.model.AccessTokenInfo"), 214);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isResourcePathMatching", "org.wso2.carbon.apimgt.keymgt.handlers.DefaultKeyValidationHandler", "java.lang.String:org.wso2.carbon.apimgt.api.model.subscription.URLMapping", "resourceString:urlMapping", "", "boolean"), 276);
    }
}

