/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.balana.utils.exception.PolicyBuilderException;
import org.wso2.balana.utils.policy.PolicyBuilder;
import org.wso2.balana.utils.policy.dto.AllOfElementDTO;
import org.wso2.balana.utils.policy.dto.AnyOfElementDTO;
import org.wso2.balana.utils.policy.dto.ApplyElementDTO;
import org.wso2.balana.utils.policy.dto.AttributeAssignmentElementDTO;
import org.wso2.balana.utils.policy.dto.AttributeDesignatorDTO;
import org.wso2.balana.utils.policy.dto.AttributeSelectorDTO;
import org.wso2.balana.utils.policy.dto.AttributeValueElementDTO;
import org.wso2.balana.utils.policy.dto.BasicPolicyDTO;
import org.wso2.balana.utils.policy.dto.BasicRuleDTO;
import org.wso2.balana.utils.policy.dto.BasicTargetDTO;
import org.wso2.balana.utils.policy.dto.ConditionElementDT0;
import org.wso2.balana.utils.policy.dto.MatchElementDTO;
import org.wso2.balana.utils.policy.dto.ObligationElementDTO;
import org.wso2.balana.utils.policy.dto.PolicyElementDTO;
import org.wso2.balana.utils.policy.dto.RuleElementDTO;
import org.wso2.balana.utils.policy.dto.TargetElementDTO;
import org.wso2.carbon.identity.entitlement.common.EntitlementPolicyCreationException;
import org.wso2.carbon.identity.entitlement.common.PolicyEditorEngine;
import org.wso2.carbon.identity.entitlement.common.PolicyEditorException;
import org.wso2.carbon.identity.entitlement.common.dto.ExtendAttributeDTO;
import org.wso2.carbon.identity.entitlement.common.dto.ObligationDTO;
import org.wso2.carbon.identity.entitlement.common.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.common.dto.PolicyEditorDataHolder;
import org.wso2.carbon.identity.entitlement.common.dto.PolicyRefIdDTO;
import org.wso2.carbon.identity.entitlement.common.dto.PolicySetDTO;
import org.wso2.carbon.identity.entitlement.common.dto.RowDTO;
import org.wso2.carbon.identity.entitlement.common.dto.RuleDTO;
import org.wso2.carbon.identity.entitlement.common.dto.SimplePolicyEditorDTO;
import org.wso2.carbon.identity.entitlement.common.dto.SimplePolicyEditorElementDTO;
import org.wso2.carbon.identity.entitlement.common.dto.TargetDTO;

public class PolicyEditorUtil {
    private static Log log = LogFactory.getLog(PolicyEditorUtil.class);
    private static Map<String, ApplyElementDTO> applyElementMap = new HashMap<String, ApplyElementDTO>();

    public static String createSOAPolicy(SimplePolicyEditorDTO policyEditorDTO) throws PolicyEditorException {
        String function;
        List<SimplePolicyEditorElementDTO> elementDTOs;
        String selectedDataType;
        BasicPolicyDTO basicPolicyDTO = new BasicPolicyDTO();
        BasicTargetDTO basicTargetDTO = null;
        ArrayList<BasicRuleDTO> ruleElementDTOs = new ArrayList<BasicRuleDTO>();
        PolicyEditorDataHolder holder = PolicyEditorEngine.getInstance().getPolicyEditorData("RBAC");
        basicPolicyDTO.setPolicyId(policyEditorDTO.getPolicyId());
        basicPolicyDTO.setRuleAlgorithm("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable");
        basicPolicyDTO.setDescription(policyEditorDTO.getDescription());
        if ("Subject".equals(policyEditorDTO.getAppliedCategory())) {
            if (policyEditorDTO.getUserAttributeValue() != null && !"*".equals(policyEditorDTO.getUserAttributeValue().trim())) {
                basicTargetDTO = new BasicTargetDTO();
                selectedDataType = null;
                if (policyEditorDTO.getUserAttributeId() == null) {
                    basicTargetDTO.setSubjectId("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
                } else {
                    basicTargetDTO.setSubjectId(holder.getAttributeIdUri(policyEditorDTO.getUserAttributeId()));
                    selectedDataType = holder.getDataTypeUriForAttribute(policyEditorDTO.getUserAttributeId());
                    if (selectedDataType != null) {
                        basicTargetDTO.setSubjectDataType(selectedDataType);
                    }
                }
                if (basicTargetDTO.getSubjectDataType() == null) {
                    basicTargetDTO.setSubjectDataType("http://www.w3.org/2001/XMLSchema#string");
                }
                String function2 = PolicyEditorUtil.findFunction(policyEditorDTO.getUserAttributeValue(), basicTargetDTO.getSubjectDataType());
                String value = PolicyEditorUtil.findAttributeValue(policyEditorDTO.getUserAttributeValue());
                basicTargetDTO.setSubjectList(value);
                basicTargetDTO.setFunctionOnSubjects(function2);
            }
            if ((elementDTOs = policyEditorDTO.getSimplePolicyEditorElementDTOs()) != null) {
                int ruleNo = 1;
                for (SimplePolicyEditorElementDTO dto : elementDTOs) {
                    BasicRuleDTO ruleElementDTO = new BasicRuleDTO();
                    if (dto.getResourceValue() != null && dto.getResourceValue().trim().length() > 0 && !"*".equals(dto.getResourceValue().trim())) {
                        PolicyEditorUtil.addResourceElement(ruleElementDTO, dto);
                    }
                    if (dto.getActionValue() != null && dto.getActionValue().trim().length() > 0 && !"*".equals(dto.getActionValue().trim())) {
                        PolicyEditorUtil.addActionElement(ruleElementDTO, dto);
                    }
                    if (dto.getEnvironmentValue() != null && dto.getEnvironmentValue().trim().length() > 0 && !"*".equals(dto.getEnvironmentValue().trim())) {
                        PolicyEditorUtil.addEnvironmentElement(ruleElementDTO, dto);
                    }
                    ruleElementDTO.setRuleEffect("Permit");
                    ruleElementDTO.setRuleId("Rule-" + ruleNo);
                    ruleElementDTOs.add(ruleElementDTO);
                    ++ruleNo;
                }
                BasicRuleDTO ruleElementDTO = new BasicRuleDTO();
                ruleElementDTO.setRuleId("Deny-Rule");
                ruleElementDTO.setRuleEffect("Deny");
                ruleElementDTOs.add(ruleElementDTO);
            }
        } else if ("Resource".equals(policyEditorDTO.getAppliedCategory())) {
            if (policyEditorDTO.getResourceValue() != null && !"*".equals(policyEditorDTO.getResourceValue().trim())) {
                basicTargetDTO = new BasicTargetDTO();
                basicTargetDTO.setResourceId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
                basicTargetDTO.setResourceDataType("http://www.w3.org/2001/XMLSchema#string");
                function = PolicyEditorUtil.findFunction(policyEditorDTO.getResourceValue(), basicTargetDTO.getResourceDataType());
                String value = PolicyEditorUtil.findAttributeValue(policyEditorDTO.getResourceValue());
                basicTargetDTO.setResourceList(value);
                basicTargetDTO.setFunctionOnResources(function);
            }
            if ((elementDTOs = policyEditorDTO.getSimplePolicyEditorElementDTOs()) != null) {
                int ruleNo = 1;
                for (SimplePolicyEditorElementDTO dto : elementDTOs) {
                    BasicRuleDTO ruleElementDTO = new BasicRuleDTO();
                    if (dto.getResourceValue() != null && dto.getResourceValue().trim().length() > 0 && !"*".equals(dto.getResourceValue().trim())) {
                        PolicyEditorUtil.addResourceElement(ruleElementDTO, dto);
                    }
                    if (dto.getUserAttributeValue() != null && dto.getUserAttributeValue().trim().length() > 0 && !"*".equals(dto.getUserAttributeValue().trim())) {
                        PolicyEditorUtil.addSubjectElement(ruleElementDTO, dto);
                    }
                    if (dto.getActionValue() != null && dto.getActionValue().trim().length() > 0 && !"*".equals(dto.getActionValue().trim())) {
                        PolicyEditorUtil.addActionElement(ruleElementDTO, dto);
                    }
                    if (dto.getEnvironmentValue() != null && dto.getEnvironmentValue().trim().length() > 0 && !"*".equals(dto.getEnvironmentValue().trim())) {
                        PolicyEditorUtil.addEnvironmentElement(ruleElementDTO, dto);
                    }
                    ruleElementDTO.setRuleEffect("Permit");
                    ruleElementDTO.setRuleId("Rule-" + ruleNo);
                    ruleElementDTOs.add(ruleElementDTO);
                    ++ruleNo;
                }
                BasicRuleDTO ruleElementDTO = new BasicRuleDTO();
                ruleElementDTO.setRuleId("Deny-Rule");
                ruleElementDTO.setRuleEffect("Deny");
                ruleElementDTOs.add(ruleElementDTO);
            }
        } else if ("Action".equals(policyEditorDTO.getAppliedCategory())) {
            if (policyEditorDTO.getActionValue() != null && !"*".equals(policyEditorDTO.getActionValue().trim())) {
                basicTargetDTO = new BasicTargetDTO();
                basicTargetDTO.setActionId("urn:oasis:names:tc:xacml:1.0:action:action-id");
                basicTargetDTO.setActionDataType("http://www.w3.org/2001/XMLSchema#string");
                function = PolicyEditorUtil.findFunction(policyEditorDTO.getActionValue(), basicTargetDTO.getActionDataType());
                String value = PolicyEditorUtil.findAttributeValue(policyEditorDTO.getActionValue());
                basicTargetDTO.setActionList(value);
                basicTargetDTO.setFunctionOnActions(function);
            }
            if ((elementDTOs = policyEditorDTO.getSimplePolicyEditorElementDTOs()) != null) {
                int ruleNo = 1;
                for (SimplePolicyEditorElementDTO dto : elementDTOs) {
                    BasicRuleDTO ruleElementDTO = new BasicRuleDTO();
                    if (dto.getResourceValue() != null && dto.getResourceValue().trim().length() > 0 && !"*".equals(dto.getResourceValue().trim())) {
                        PolicyEditorUtil.addResourceElement(ruleElementDTO, dto);
                    }
                    if (dto.getUserAttributeValue() != null && dto.getUserAttributeValue().trim().length() > 0 && !"*".equals(dto.getUserAttributeValue().trim())) {
                        PolicyEditorUtil.addSubjectElement(ruleElementDTO, dto);
                    }
                    if (dto.getEnvironmentValue() != null && dto.getEnvironmentValue().trim().length() > 0 && !"*".equals(dto.getEnvironmentValue().trim())) {
                        PolicyEditorUtil.addEnvironmentElement(ruleElementDTO, dto);
                    }
                    ruleElementDTO.setRuleEffect("Permit");
                    ruleElementDTO.setRuleId("Rule-" + ruleNo);
                    ruleElementDTOs.add(ruleElementDTO);
                    ++ruleNo;
                }
                BasicRuleDTO ruleElementDTO = new BasicRuleDTO();
                ruleElementDTO.setRuleId("Deny-Rule");
                ruleElementDTO.setRuleEffect("Deny");
                ruleElementDTOs.add(ruleElementDTO);
            }
        } else if ("Environment".equals(policyEditorDTO.getAppliedCategory())) {
            if (policyEditorDTO.getEnvironmentValue() != null && !"*".equals(policyEditorDTO.getEnvironmentValue().trim())) {
                basicTargetDTO = new BasicTargetDTO();
                selectedDataType = null;
                if (policyEditorDTO.getEnvironmentId() == null) {
                    basicTargetDTO.setEnvironmentId("urn:oasis:names:tc:xacml:1.0:environment:environment-id");
                } else {
                    basicTargetDTO.setEnvironmentId(holder.getAttributeIdUri(policyEditorDTO.getEnvironmentId()));
                    selectedDataType = holder.getDataTypeUriForAttribute(policyEditorDTO.getEnvironmentId());
                    if (selectedDataType != null) {
                        basicTargetDTO.setEnvironmentDataType(selectedDataType);
                    }
                }
                if (basicTargetDTO.getEnvironmentDataType() == null) {
                    basicTargetDTO.setEnvironmentDataType("http://www.w3.org/2001/XMLSchema#string");
                }
                String function3 = PolicyEditorUtil.findFunction(policyEditorDTO.getEnvironmentValue(), basicTargetDTO.getEnvironmentDataType());
                String value = PolicyEditorUtil.findAttributeValue(policyEditorDTO.getEnvironmentValue());
                basicTargetDTO.setEnvironmentList(value);
                basicTargetDTO.setFunctionOnEnvironment(function3);
            }
            if ((elementDTOs = policyEditorDTO.getSimplePolicyEditorElementDTOs()) != null) {
                int ruleNo = 1;
                for (SimplePolicyEditorElementDTO dto : elementDTOs) {
                    BasicRuleDTO ruleElementDTO = new BasicRuleDTO();
                    if (dto.getResourceValue() != null && dto.getResourceValue().trim().length() > 0 && !"*".equals(dto.getResourceValue().trim())) {
                        PolicyEditorUtil.addResourceElement(ruleElementDTO, dto);
                    }
                    if (dto.getUserAttributeValue() != null && dto.getUserAttributeValue().trim().length() > 0 && !"*".equals(dto.getUserAttributeValue().trim())) {
                        PolicyEditorUtil.addSubjectElement(ruleElementDTO, dto);
                    }
                    if (dto.getActionValue() != null && dto.getActionValue().trim().length() > 0 && !"*".equals(dto.getActionValue().trim())) {
                        PolicyEditorUtil.addActionElement(ruleElementDTO, dto);
                    }
                    ruleElementDTO.setRuleEffect("Permit");
                    ruleElementDTO.setRuleId("Rule-" + ruleNo);
                    ruleElementDTOs.add(ruleElementDTO);
                    ++ruleNo;
                }
                BasicRuleDTO ruleElementDTO = new BasicRuleDTO();
                ruleElementDTO.setRuleId("Deny-Rule");
                ruleElementDTO.setRuleEffect("Deny");
                ruleElementDTOs.add(ruleElementDTO);
            }
        }
        if (basicTargetDTO != null) {
            basicPolicyDTO.setTargetDTO(basicTargetDTO);
        }
        if (ruleElementDTOs.size() > 0) {
            basicPolicyDTO.setBasicRuleDTOs(ruleElementDTOs);
        }
        try {
            return PolicyBuilder.getInstance().build(basicPolicyDTO);
        }
        catch (PolicyBuilderException e) {
            log.error((Object)e);
            throw new PolicyEditorException("Error while building policy");
        }
    }

    private static void addResourceElement(BasicRuleDTO ruleElementDTO, SimplePolicyEditorElementDTO editorElementDTO) {
        ruleElementDTO.setResourceId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        ruleElementDTO.setResourceDataType("http://www.w3.org/2001/XMLSchema#string");
        String function = PolicyEditorUtil.findFunction(editorElementDTO.getResourceValue(), ruleElementDTO.getResourceDataType());
        String value = PolicyEditorUtil.findAttributeValue(editorElementDTO.getResourceValue());
        ruleElementDTO.setResourceList(value);
        ruleElementDTO.setFunctionOnResources(function);
    }

    private static void addSubjectElement(BasicRuleDTO ruleElementDTO, SimplePolicyEditorElementDTO editorElementDTO) {
        String selectedDataType = null;
        PolicyEditorDataHolder holder = PolicyEditorEngine.getInstance().getPolicyEditorData("RBAC");
        if (editorElementDTO.getUserAttributeId() == null) {
            ruleElementDTO.setSubjectId("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
        } else {
            ruleElementDTO.setSubjectId(holder.getAttributeIdUri(editorElementDTO.getUserAttributeId()));
            selectedDataType = holder.getDataTypeUriForAttribute(editorElementDTO.getUserAttributeId());
            if (selectedDataType != null) {
                ruleElementDTO.setSubjectDataType(selectedDataType);
            }
        }
        if (ruleElementDTO.getSubjectDataType() == null) {
            ruleElementDTO.setSubjectDataType("http://www.w3.org/2001/XMLSchema#string");
        }
        String function = PolicyEditorUtil.findFunction(editorElementDTO.getUserAttributeValue(), ruleElementDTO.getSubjectDataType());
        String value = PolicyEditorUtil.findAttributeValue(editorElementDTO.getUserAttributeValue());
        ruleElementDTO.setSubjectList(value);
        ruleElementDTO.setFunctionOnSubjects(function);
    }

    private static void addActionElement(BasicRuleDTO ruleElementDTO, SimplePolicyEditorElementDTO editorElementDTO) {
        ruleElementDTO.setActionId("urn:oasis:names:tc:xacml:1.0:action:action-id");
        ruleElementDTO.setActionDataType("http://www.w3.org/2001/XMLSchema#string");
        String function = PolicyEditorUtil.findFunction(editorElementDTO.getActionValue(), ruleElementDTO.getActionDataType());
        String value = PolicyEditorUtil.findAttributeValue(editorElementDTO.getActionValue());
        ruleElementDTO.setActionList(value);
        ruleElementDTO.setFunctionOnActions(function);
    }

    private static void addEnvironmentElement(BasicRuleDTO ruleElementDTO, SimplePolicyEditorElementDTO editorElementDTO) {
        String selectedDataType = null;
        PolicyEditorDataHolder holder = PolicyEditorEngine.getInstance().getPolicyEditorData("RBAC");
        if (editorElementDTO.getEnvironmentId() == null) {
            ruleElementDTO.setEnvironmentId("urn:oasis:names:tc:xacml:1.0:environment:environment-id");
        } else {
            ruleElementDTO.setEnvironmentId(holder.getAttributeIdUri(editorElementDTO.getEnvironmentId()));
            selectedDataType = holder.getDataTypeUriForAttribute(editorElementDTO.getEnvironmentId());
            if (selectedDataType != null) {
                ruleElementDTO.setEnvironmentDataType(selectedDataType);
            }
        }
        if (ruleElementDTO.getEnvironmentDataType() == null) {
            ruleElementDTO.setEnvironmentDataType("http://www.w3.org/2001/XMLSchema#string");
        }
        String function = PolicyEditorUtil.findFunction(editorElementDTO.getEnvironmentValue(), ruleElementDTO.getEnvironmentDataType());
        String value = PolicyEditorUtil.findAttributeValue(editorElementDTO.getEnvironmentValue());
        ruleElementDTO.setEnvironmentDataType(ruleElementDTO.getEnvironmentDataType());
        ruleElementDTO.setEnvironmentList(value);
        ruleElementDTO.setFunctionOnEnvironment(function);
    }

    private static String findFunction(String value, String dataType) {
        if (value == null) {
            return "equal";
        }
        value = value.replace("&gt;", ">");
        value = value.replace("&lt;", "<");
        if ("http://www.w3.org/2001/XMLSchema#date".equals(dataType) || "http://www.w3.org/2001/XMLSchema#integer".equals(dataType) || "http://www.w3.org/2001/XMLSchema#time".equals(dataType) || "http://www.w3.org/2001/XMLSchema#dateTime".equals(dataType) || "http://www.w3.org/2001/XMLSchema#double".equals(dataType) || "http://www.w3.org/2001/XMLSchema#string".equals(dataType)) {
            if (value.startsWith("[")) {
                if (value.contains(")")) {
                    return "greater-than-or-equal-and-less-than";
                }
                return "greater-than-or-equal-and-less-than-or-equal";
            }
            if (value.startsWith("(")) {
                if (value.contains("]")) {
                    return "greater-than-and-less-than-or-equal";
                }
                return "greater-than-and-less-than";
            }
            if (value.startsWith(">")) {
                return "greater-than";
            }
            if (value.startsWith(">=")) {
                return "greater-than-or-equal";
            }
            if (value.startsWith("<")) {
                return "less-than";
            }
            if (value.startsWith("<=")) {
                return "less-than-or-equal";
            }
        }
        if (value.startsWith("{")) {
            return "regexp-match";
        }
        if (value.contains("|")) {
            return "at-least-one-member-of";
        }
        if (value.contains("&")) {
            return "set-equals";
        }
        return "equal";
    }

    private static String findAttributeValue(String value) {
        if (value == null) {
            return null;
        }
        value = value.replace("&gt;", ">");
        if ((value = value.replace("&lt;", "<")).startsWith("[") || value.startsWith("(") || value.startsWith("{")) {
            return value.substring(1, value.length() - 1).trim();
        }
        if (value.startsWith(">") || value.startsWith("<")) {
            return value.substring(1).trim();
        }
        if (value.startsWith(">=") || value.startsWith("<=")) {
            return value.substring(2).trim();
        }
        if (value.contains("&")) {
            value = value.replace("&", ",");
        }
        if (value.contains("|")) {
            value = value.replace("|", ",");
        }
        return value.trim();
    }

    public static RuleElementDTO createRuleElementDTO(RuleDTO ruleDTO) throws PolicyEditorException {
        ConditionElementDT0 conditionElementDT0;
        TargetElementDTO targetElementDTO;
        RuleElementDTO ruleElementDTO = new RuleElementDTO();
        ruleElementDTO.setRuleId(ruleDTO.getRuleId());
        ruleElementDTO.setRuleEffect(ruleDTO.getRuleEffect());
        TargetDTO targetDTO = ruleDTO.getTargetDTO();
        List<ExtendAttributeDTO> dynamicAttributeDTOs = ruleDTO.getAttributeDTOs();
        List<ObligationDTO> obligationDTOs = ruleDTO.getObligationDTOs();
        if (dynamicAttributeDTOs != null && dynamicAttributeDTOs.size() > 0) {
            HashMap<String, ExtendAttributeDTO> dtoMap = new HashMap<String, ExtendAttributeDTO>();
            for (ExtendAttributeDTO dto : dynamicAttributeDTOs) {
                dtoMap.put("${" + dto.getId().trim() + "}", dto);
            }
            for (ExtendAttributeDTO dto : dynamicAttributeDTOs) {
                ApplyElementDTO applyElementDTO = PolicyEditorUtil.createApplyElement(dto, dtoMap);
                if (applyElementDTO == null) continue;
                applyElementMap.put("${" + dto.getId().trim() + "}", applyElementDTO);
            }
        }
        if (targetDTO != null && targetDTO.getRowDTOList() != null && targetDTO.getRowDTOList().size() > 0 && (targetElementDTO = PolicyEditorUtil.createTargetElementDTO(ruleDTO.getTargetDTO())) != null) {
            ruleElementDTO.setTargetElementDTO(targetElementDTO);
        }
        if (ruleDTO.getRowDTOList() != null && ruleDTO.getRowDTOList().size() > 0 && (conditionElementDT0 = PolicyEditorUtil.createConditionDTO(ruleDTO.getRowDTOList())) != null) {
            ruleElementDTO.setConditionElementDT0(conditionElementDT0);
        }
        if (obligationDTOs != null && obligationDTOs.size() > 0) {
            for (ObligationDTO obligationDTO : obligationDTOs) {
                ObligationElementDTO elementDTO = PolicyEditorUtil.createObligationElement(obligationDTO);
                if (elementDTO == null) continue;
                ruleElementDTO.addObligationElementDTO(elementDTO);
            }
        }
        return ruleElementDTO;
    }

    public static List<ObligationElementDTO> createObligation(List<ObligationDTO> obligationDTOs) throws PolicyEditorException {
        ArrayList<ObligationElementDTO> obligationElementDTOs = new ArrayList<ObligationElementDTO>();
        if (obligationDTOs != null) {
            for (ObligationDTO obligationDTO : obligationDTOs) {
                ObligationElementDTO elementDTO = PolicyEditorUtil.createObligationElement(obligationDTO);
                if (elementDTO == null) continue;
                obligationElementDTOs.add(elementDTO);
            }
        }
        return obligationElementDTOs;
    }

    private static ApplyElementDTO createApplyElement(ExtendAttributeDTO dynamicAttributeDTO, Map<String, ExtendAttributeDTO> map) {
        if ("Category".equals(dynamicAttributeDTO.getSelector())) {
            String category = dynamicAttributeDTO.getCategory();
            String attributeId = dynamicAttributeDTO.getAttributeId();
            String attributeDataType = dynamicAttributeDTO.getDataType();
            if (category != null && category.trim().length() > 0 && attributeDataType != null && attributeDataType.trim().length() > 0) {
                AttributeDesignatorDTO designatorDTO = new AttributeDesignatorDTO();
                designatorDTO.setCategory(category);
                designatorDTO.setAttributeId(attributeId);
                designatorDTO.setDataType(attributeDataType);
                designatorDTO.setMustBePresent("true");
                ApplyElementDTO applyElementDTO = new ApplyElementDTO();
                applyElementDTO.setAttributeDesignators(designatorDTO);
                applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("bag", attributeDataType));
                return applyElementDTO;
            }
        } else {
            String[] values;
            String function = dynamicAttributeDTO.getFunction();
            String attributeValue = dynamicAttributeDTO.getAttributeValue();
            String attributeDataType = dynamicAttributeDTO.getDataType();
            if (attributeValue != null && function != null && (values = attributeValue.split(",")) != null && values.length > 0 && function.contains("concatenate")) {
                ApplyElementDTO applyElementDTO = new ApplyElementDTO();
                applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction(function, attributeDataType, "2.0"));
                for (String value : values) {
                    if (map.containsKey(value)) {
                        applyElementDTO.setApplyElement(PolicyEditorUtil.createApplyElement(map.get(value), map));
                        continue;
                    }
                    AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
                    valueElementDTO.setAttributeDataType(attributeDataType);
                    valueElementDTO.setAttributeValue(value);
                    applyElementDTO.setAttributeValueElementDTO(valueElementDTO);
                }
                return applyElementDTO;
            }
        }
        return null;
    }

    private static ObligationElementDTO createObligationElement(ObligationDTO obligationDTO) {
        String id = obligationDTO.getObligationId();
        String effect = obligationDTO.getEffect();
        String type = obligationDTO.getType();
        if (id != null && id.trim().length() > 0 && effect != null) {
            ObligationElementDTO elementDTO = new ObligationElementDTO();
            elementDTO.setId(id);
            elementDTO.setEffect(effect);
            if ("Advice".equals(type)) {
                elementDTO.setType(2);
            } else {
                elementDTO.setType(1);
            }
            String attributeValue = obligationDTO.getAttributeValue();
            String attributeDataType = obligationDTO.getAttributeValueDataType();
            String resultingAttributeId = obligationDTO.getResultAttributeId();
            if (attributeValue != null && attributeValue.trim().length() > 0 && resultingAttributeId != null && resultingAttributeId.trim().length() > 0) {
                AttributeAssignmentElementDTO assignmentElementDTO = new AttributeAssignmentElementDTO();
                assignmentElementDTO.setAttributeId(resultingAttributeId);
                if (attributeValue.contains(",")) {
                    String[] values = attributeValue.split(",");
                    ApplyElementDTO applyElementDTO = new ApplyElementDTO();
                    applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("bag", attributeDataType));
                    for (String value : values) {
                        if (applyElementMap.containsKey(value)) {
                            applyElementDTO.setApplyElement(applyElementMap.get(value));
                            continue;
                        }
                        AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
                        valueElementDTO.setAttributeDataType(attributeDataType);
                        valueElementDTO.setAttributeValue(value);
                        applyElementDTO.setAttributeValueElementDTO(valueElementDTO);
                    }
                    assignmentElementDTO.setApplyElementDTO(applyElementDTO);
                } else if (applyElementMap.containsKey(attributeValue)) {
                    assignmentElementDTO.setApplyElementDTO(applyElementMap.get(attributeValue));
                } else {
                    AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
                    valueElementDTO.setAttributeDataType(attributeDataType);
                    valueElementDTO.setAttributeValue(attributeValue);
                    assignmentElementDTO.setValueElementDTO(valueElementDTO);
                }
                elementDTO.addAssignmentElementDTO(assignmentElementDTO);
            }
            return elementDTO;
        }
        return null;
    }

    public static ConditionElementDT0 createConditionDTO(List<RowDTO> rowDTOs) throws PolicyEditorException {
        ConditionElementDT0 rootApplyDTO = new ConditionElementDT0();
        ArrayList<RowDTO> temp = new ArrayList<RowDTO>();
        HashSet<ArrayList<RowDTO>> listSet = new HashSet<ArrayList<RowDTO>>();
        for (int i = 0; i < rowDTOs.size(); ++i) {
            if (i == 0) {
                temp.add(rowDTOs.get(0));
                continue;
            }
            String combineFunction = rowDTOs.get(i - 1).getCombineFunction();
            if ("AND".equals(combineFunction)) {
                temp.add(rowDTOs.get(i));
            }
            if (!"OR".equals(combineFunction)) continue;
            listSet.add(temp);
            temp = new ArrayList();
            temp.add(rowDTOs.get(i));
        }
        listSet.add(temp);
        if (listSet.size() > 1) {
            ApplyElementDTO orApplyDTO = new ApplyElementDTO();
            orApplyDTO.setFunctionId(PolicyEditorUtil.processFunction("or"));
            for (ArrayList arrayList : listSet) {
                if (arrayList.size() > 1) {
                    ApplyElementDTO andApplyDTO = new ApplyElementDTO();
                    andApplyDTO.setFunctionId(PolicyEditorUtil.processFunction("and"));
                    for (RowDTO rowDTO : arrayList) {
                        ApplyElementDTO applyElementDTO = PolicyEditorUtil.createApplyElement(rowDTO);
                        andApplyDTO.setApplyElement(applyElementDTO);
                    }
                    orApplyDTO.setApplyElement(andApplyDTO);
                    continue;
                }
                if (arrayList.size() != 1) continue;
                RowDTO rowDTO = (RowDTO)arrayList.get(0);
                ApplyElementDTO andApplyDTO = PolicyEditorUtil.createApplyElement(rowDTO);
                orApplyDTO.setApplyElement(andApplyDTO);
            }
            rootApplyDTO.setApplyElement(orApplyDTO);
        } else if (listSet.size() == 1) {
            ArrayList rowDTOArrayList = (ArrayList)listSet.iterator().next();
            if (rowDTOArrayList.size() > 1) {
                ApplyElementDTO andApplyDTO = new ApplyElementDTO();
                andApplyDTO.setFunctionId(PolicyEditorUtil.processFunction("and"));
                for (RowDTO rowDTO : rowDTOArrayList) {
                    ApplyElementDTO applyElementDTO = PolicyEditorUtil.createApplyElement(rowDTO);
                    andApplyDTO.setApplyElement(applyElementDTO);
                }
                rootApplyDTO.setApplyElement(andApplyDTO);
            } else if (rowDTOArrayList.size() == 1) {
                RowDTO rowDTO = (RowDTO)rowDTOArrayList.get(0);
                ApplyElementDTO applyElementDTO = PolicyEditorUtil.createApplyElement(rowDTO);
                rootApplyDTO.setApplyElement(applyElementDTO);
            }
        }
        return rootApplyDTO;
    }

    public static ApplyElementDTO createApplyElement(RowDTO rowDTO) throws PolicyEditorException {
        String preFunction = rowDTO.getPreFunction();
        String function = rowDTO.getFunction();
        String dataType = rowDTO.getAttributeDataType();
        String attributeValue = rowDTO.getAttributeValue();
        if (function == null || function.trim().length() < 1) {
            throw new PolicyEditorException("Can not create Apply element:Missing required function Id");
        }
        if (attributeValue == null || attributeValue.trim().length() < 1) {
            throw new PolicyEditorException("Can not create Apply element:Missing required attribute value");
        }
        ApplyElementDTO applyElementDTO = null;
        AttributeDesignatorDTO designatorDTO = new AttributeDesignatorDTO();
        designatorDTO.setCategory(rowDTO.getCategory());
        designatorDTO.setAttributeId(rowDTO.getAttributeId());
        designatorDTO.setDataType(dataType);
        designatorDTO.setMustBePresent("true");
        applyElementDTO = rowDTO.getFunction().contains("less") || rowDTO.getFunction().contains("greater") ? PolicyEditorUtil.processGreaterLessThanFunctions(function, dataType, attributeValue, designatorDTO) : ("equal".equals(rowDTO.getFunction()) ? PolicyEditorUtil.processEqualFunctions(function, dataType, attributeValue, designatorDTO) : ("regexp-match".equals(rowDTO.getFunction()) ? PolicyEditorUtil.processRegexpFunctions(function, dataType, attributeValue, designatorDTO) : PolicyEditorUtil.processBagFunction(function, dataType, attributeValue, designatorDTO)));
        if ("not".equals(preFunction)) {
            ApplyElementDTO notApplyElementDTO = new ApplyElementDTO();
            notApplyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("not"));
            notApplyElementDTO.setApplyElement(applyElementDTO);
            applyElementDTO = notApplyElementDTO;
        }
        return applyElementDTO;
    }

    public static TargetElementDTO createTargetElementDTO(TargetDTO targetDTO) {
        AllOfElementDTO allOfElementDTO = new AllOfElementDTO();
        AnyOfElementDTO anyOfElementDTO = new AnyOfElementDTO();
        TargetElementDTO targetElementDTO = new TargetElementDTO();
        List<RowDTO> rowDTOs = targetDTO.getRowDTOList();
        ArrayList<RowDTO> tempRowDTOs = new ArrayList<RowDTO>();
        for (RowDTO rowDTO : rowDTOs) {
            if ("are".equals(rowDTO.getPreFunction())) {
                String[] attributeValues = rowDTO.getAttributeValue().split(",");
                allOfElementDTO = new AllOfElementDTO();
                for (int j = 0; j < attributeValues.length; ++j) {
                    RowDTO newDto = new RowDTO(rowDTO);
                    newDto.setAttributeValue(attributeValues[j]);
                    if (j != attributeValues.length - 1) {
                        newDto.setCombineFunction("AND");
                    }
                    tempRowDTOs.add(newDto);
                }
                continue;
            }
            tempRowDTOs.add(rowDTO);
        }
        if (tempRowDTOs.size() > 0) {
            for (int i = 0; i < tempRowDTOs.size(); ++i) {
                MatchElementDTO matchElementDTO;
                if (i == 0) {
                    MatchElementDTO matchElementDTO2 = PolicyEditorUtil.createTargetMatch((RowDTO)tempRowDTOs.get(0));
                    if (matchElementDTO2 == null) continue;
                    allOfElementDTO.addMatchElementDTO(matchElementDTO2);
                    continue;
                }
                String combineFunction = ((RowDTO)tempRowDTOs.get(i - 1)).getCombineFunction();
                if ("AND".equals(combineFunction) && (matchElementDTO = PolicyEditorUtil.createTargetMatch((RowDTO)tempRowDTOs.get(i))) != null) {
                    allOfElementDTO.addMatchElementDTO(matchElementDTO);
                }
                if (!"OR".equals(combineFunction)) continue;
                anyOfElementDTO.addAllOfElementDTO(allOfElementDTO);
                allOfElementDTO = new AllOfElementDTO();
                matchElementDTO = PolicyEditorUtil.createTargetMatch((RowDTO)tempRowDTOs.get(i));
                if (matchElementDTO == null) continue;
                allOfElementDTO.addMatchElementDTO(matchElementDTO);
            }
            anyOfElementDTO.addAllOfElementDTO(allOfElementDTO);
            targetElementDTO.addAnyOfElementDTO(anyOfElementDTO);
        }
        return targetElementDTO;
    }

    public static ApplyElementDTO processBagFunction(String function, String dataType, String attributeValue, AttributeDesignatorDTO designatorDTO) {
        if ("is-in".equals(function)) {
            ApplyElementDTO applyElementDTO = new ApplyElementDTO();
            applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("is-in", dataType));
            if (applyElementMap.containsKey(attributeValue)) {
                applyElementDTO.setApplyElement(applyElementMap.get(attributeValue));
            } else {
                AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
                valueElementDTO.setAttributeDataType(dataType);
                valueElementDTO.setAttributeValue(attributeValue);
                applyElementDTO.setAttributeValueElementDTO(valueElementDTO);
            }
            applyElementDTO.setAttributeDesignators(designatorDTO);
            return applyElementDTO;
        }
        if ("at-least-one-member-of".equals(function) || "set-equals".equals(function)) {
            ApplyElementDTO applyElementDTO = new ApplyElementDTO();
            if ("at-least-one-member-of".equals(function)) {
                applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("at-least-one-member-of", dataType));
            } else {
                applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("set-equals", dataType));
            }
            String[] values = attributeValue.split(",");
            ApplyElementDTO applyBagElementDTO = new ApplyElementDTO();
            applyBagElementDTO.setFunctionId(PolicyEditorUtil.processFunction("bag", dataType));
            for (String value : values) {
                if (applyElementMap.containsKey(value)) {
                    applyBagElementDTO.setApplyElement(applyElementMap.get(value));
                    continue;
                }
                AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
                valueElementDTO.setAttributeDataType(dataType);
                valueElementDTO.setAttributeValue(value);
                applyBagElementDTO.setAttributeValueElementDTO(valueElementDTO);
            }
            applyElementDTO.setAttributeDesignators(designatorDTO);
            applyElementDTO.setApplyElement(applyBagElementDTO);
            return applyElementDTO;
        }
        return null;
    }

    public static ApplyElementDTO processEqualFunctions(String function, String dataType, String attributeValue, AttributeDesignatorDTO designatorDTO) {
        if ("equal".equals(function)) {
            ApplyElementDTO applyElementDTO = new ApplyElementDTO();
            if ("http://www.w3.org/2001/XMLSchema#dayTimeDuration".equals(dataType) || "http://www.w3.org/2001/XMLSchema#yearMonthDuration".equals(dataType)) {
                applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("equal", dataType, "3.0"));
            } else {
                applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("equal", dataType));
            }
            ApplyElementDTO oneAndOnlyApplyElement = new ApplyElementDTO();
            oneAndOnlyApplyElement.setFunctionId(PolicyEditorUtil.processFunction("one-and-only", dataType));
            oneAndOnlyApplyElement.setAttributeDesignators(designatorDTO);
            if (applyElementMap.containsKey(attributeValue)) {
                applyElementDTO.setApplyElement(applyElementMap.get(attributeValue));
            } else {
                AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
                valueElementDTO.setAttributeDataType(dataType);
                valueElementDTO.setAttributeValue(attributeValue);
                applyElementDTO.setAttributeValueElementDTO(valueElementDTO);
            }
            applyElementDTO.setApplyElement(oneAndOnlyApplyElement);
            return applyElementDTO;
        }
        return null;
    }

    public static ApplyElementDTO processGreaterLessThanFunctions(String function, String dataType, String attributeValue, AttributeDesignatorDTO designatorDTO) throws PolicyEditorException {
        String[] values = attributeValue.split(",");
        if ("greater-than-or-equal-and-less-than-or-equal".equals(function) || "greater-than-and-less-than-or-equal".equals(function) || "greater-than-or-equal-and-less-than".equals(function) || "greater-than-and-less-than".equals(function)) {
            if (values.length != 2) {
                throw new PolicyEditorException("Can not create Apply element:Missing required attribute values for function : " + function);
            }
            String leftValue = values[0].trim();
            String rightValue = values[1].trim();
            ApplyElementDTO andApplyElement = new ApplyElementDTO();
            andApplyElement.setFunctionId(PolicyEditorUtil.processFunction("and"));
            ApplyElementDTO greaterThanApplyElement = new ApplyElementDTO();
            if ("greater-than-and-less-than".equals(function) || "greater-than-and-less-than-or-equal".equals(function)) {
                greaterThanApplyElement.setFunctionId(PolicyEditorUtil.processFunction("greater-than", dataType));
            } else {
                greaterThanApplyElement.setFunctionId(PolicyEditorUtil.processFunction("greater-than-or-equal", dataType));
            }
            ApplyElementDTO lessThanApplyElement = new ApplyElementDTO();
            if ("greater-than-and-less-than".equals(function) || "greater-than-or-equal-and-less-than".equals(function)) {
                lessThanApplyElement.setFunctionId(PolicyEditorUtil.processFunction("less-than", dataType));
            } else {
                lessThanApplyElement.setFunctionId(PolicyEditorUtil.processFunction("less-than-or-equal", dataType));
            }
            ApplyElementDTO oneAndOnlyApplyElement = new ApplyElementDTO();
            oneAndOnlyApplyElement.setFunctionId(PolicyEditorUtil.processFunction("one-and-only", dataType));
            oneAndOnlyApplyElement.setAttributeDesignators(designatorDTO);
            AttributeValueElementDTO leftValueElementDTO = new AttributeValueElementDTO();
            leftValueElementDTO.setAttributeDataType(dataType);
            leftValueElementDTO.setAttributeValue(leftValue);
            AttributeValueElementDTO rightValueElementDTO = new AttributeValueElementDTO();
            rightValueElementDTO.setAttributeDataType(dataType);
            rightValueElementDTO.setAttributeValue(rightValue);
            greaterThanApplyElement.setApplyElement(oneAndOnlyApplyElement);
            greaterThanApplyElement.setAttributeValueElementDTO(leftValueElementDTO);
            lessThanApplyElement.setApplyElement(oneAndOnlyApplyElement);
            lessThanApplyElement.setAttributeValueElementDTO(rightValueElementDTO);
            andApplyElement.setApplyElement(greaterThanApplyElement);
            andApplyElement.setApplyElement(lessThanApplyElement);
            return andApplyElement;
        }
        ApplyElementDTO applyElementDTO = new ApplyElementDTO();
        if ("greater-than".equals(function)) {
            applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("greater-than", dataType));
        } else if ("greater-than-or-equal".equals(function)) {
            applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("greater-than-or-equal", dataType));
        } else if ("less-than".equals(function)) {
            applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("less-than", dataType));
        } else if ("less-than-or-equal".equals(function)) {
            applyElementDTO.setFunctionId(PolicyEditorUtil.processFunction("less-than-or-equal", dataType));
        } else {
            throw new PolicyEditorException("Can not create Apply element:Invalid function : " + function);
        }
        ApplyElementDTO oneAndOnlyApplyElement = new ApplyElementDTO();
        oneAndOnlyApplyElement.setFunctionId(PolicyEditorUtil.processFunction("one-and-only", dataType));
        oneAndOnlyApplyElement.setAttributeDesignators(designatorDTO);
        AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
        valueElementDTO.setAttributeDataType(dataType);
        valueElementDTO.setAttributeValue(values[0]);
        applyElementDTO.setApplyElement(oneAndOnlyApplyElement);
        applyElementDTO.setAttributeValueElementDTO(valueElementDTO);
        return applyElementDTO;
    }

    public static ApplyElementDTO processRegexpFunctions(String function, String dataType, String attributeValue, AttributeDesignatorDTO designatorDTO) {
        if ("regexp-match".equals(function)) {
            ApplyElementDTO applyElementDTO = new ApplyElementDTO();
            applyElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:any-of");
            if (applyElementMap.containsKey(attributeValue)) {
                applyElementDTO.setApplyElement(applyElementMap.get(attributeValue));
            } else {
                AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
                valueElementDTO.setAttributeDataType(dataType);
                valueElementDTO.setAttributeValue(attributeValue);
                applyElementDTO.setAttributeValueElementDTO(valueElementDTO);
            }
            applyElementDTO.setFunctionFunctionId(PolicyEditorUtil.processFunction("regexp-match", dataType));
            applyElementDTO.setAttributeDesignators(designatorDTO);
            return applyElementDTO;
        }
        return null;
    }

    private static String processFunction(String function, String type, String version) {
        return "urn:oasis:names:tc:xacml:" + version + ":function:" + PolicyEditorUtil.getDataTypePrefix(type) + "-" + function;
    }

    private static String processFunction(String function) {
        return "urn:oasis:names:tc:xacml:1.0:function:" + function;
    }

    private static String processFunction(String function, String type) {
        return "urn:oasis:names:tc:xacml:1.0:function:" + PolicyEditorUtil.getDataTypePrefix(type) + "-" + function;
    }

    private static String getDataTypePrefix(String dataTypeUri) {
        if (dataTypeUri != null) {
            String[] stringArray;
            if (dataTypeUri.contains("#")) {
                return dataTypeUri.substring(dataTypeUri.indexOf("#") + 1);
            }
            if (dataTypeUri.contains(":") && (stringArray = dataTypeUri.split(":")) != null && stringArray.length > 0) {
                return stringArray[stringArray.length - 1];
            }
        }
        return dataTypeUri;
    }

    public static MatchElementDTO createTargetMatch(RowDTO rowDTO) {
        String category = rowDTO.getCategory();
        String functionId = rowDTO.getFunction();
        String attributeValue = rowDTO.getAttributeValue();
        String attributeId = rowDTO.getAttributeId();
        String dataType = rowDTO.getAttributeDataType();
        if (functionId == null || functionId.trim().length() <= 0 || attributeValue == null || attributeValue.trim().length() <= 0 || category == null || category.trim().length() <= 0 || attributeId == null || attributeId.trim().length() <= 0 || dataType == null || dataType.trim().length() <= 0) {
            return null;
        }
        functionId = PolicyEditorUtil.processFunction(functionId, dataType);
        MatchElementDTO matchElementDTO = new MatchElementDTO();
        AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
        attributeValueElementDTO.setAttributeDataType(dataType);
        attributeValueElementDTO.setAttributeValue(attributeValue.trim());
        AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
        attributeDesignatorDTO.setDataType(dataType);
        attributeDesignatorDTO.setAttributeId(attributeId);
        attributeDesignatorDTO.setCategory(category);
        matchElementDTO.setMatchId(functionId);
        matchElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
        matchElementDTO.setAttributeDesignatorDTO(attributeDesignatorDTO);
        return matchElementDTO;
    }

    public static Element createMatchElement(MatchElementDTO matchElementDTO, Document doc) throws PolicyEditorException {
        Element matchElement;
        if (matchElementDTO.getMatchId() != null && matchElementDTO.getMatchId().trim().length() > 0) {
            matchElement = doc.createElement("Match");
            matchElement.setAttribute("MatchId", matchElementDTO.getMatchId());
            if (matchElementDTO.getAttributeValueElementDTO() != null) {
                Element attributeValueElement = PolicyEditorUtil.createAttributeValueElement(matchElementDTO.getAttributeValueElementDTO(), doc);
                matchElement.appendChild(attributeValueElement);
            }
            if (matchElementDTO.getAttributeDesignatorDTO() != null) {
                Element attributeDesignatorElement = PolicyEditorUtil.createAttributeDesignatorElement(matchElementDTO.getAttributeDesignatorDTO(), doc);
                matchElement.appendChild(attributeDesignatorElement);
            } else if (matchElementDTO.getAttributeSelectorDTO() != null) {
                Element attributeSelectorElement = PolicyEditorUtil.createAttributeSelectorElement(matchElementDTO.getAttributeSelectorDTO(), doc);
                matchElement.appendChild(attributeSelectorElement);
            }
        } else {
            throw new PolicyEditorException("Can not create Match element: Required Attributes are missing");
        }
        return matchElement;
    }

    public static Element createAttributeValueElement(AttributeValueElementDTO attributeValueElementDTO, Document doc) {
        Element attributeValueElement = doc.createElement("AttributeValue");
        if (attributeValueElementDTO.getAttributeValue() != null && attributeValueElementDTO.getAttributeValue().trim().length() > 0) {
            attributeValueElement.setTextContent(attributeValueElementDTO.getAttributeValue().trim());
            if (attributeValueElementDTO.getAttributeDataType() != null && attributeValueElementDTO.getAttributeDataType().trim().length() > 0) {
                attributeValueElement.setAttribute("DataType", attributeValueElementDTO.getAttributeDataType());
            } else {
                attributeValueElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
        }
        return attributeValueElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Element createAttributeDesignatorElement(AttributeDesignatorDTO attributeDesignatorDTO, Document doc) throws PolicyEditorException {
        if (attributeDesignatorDTO == null || doc == null) throw new PolicyEditorException("Can not create AttributeDesignator element: A Null object is received");
        String category = attributeDesignatorDTO.getCategory();
        String attributeId = attributeDesignatorDTO.getAttributeId();
        String dataType = attributeDesignatorDTO.getDataType();
        String mustBe = attributeDesignatorDTO.getMustBePresent();
        if (category == null || category.trim().length() <= 0 || attributeId == null || attributeId.trim().length() <= 0 || dataType == null || dataType.trim().length() <= 0 || mustBe == null || mustBe.trim().length() <= 0) throw new PolicyEditorException("Can not create AttributeDesignator element: Required Attributes are missing");
        Element attributeDesignatorElement = doc.createElement("AttributeDesignator");
        attributeDesignatorElement.setAttribute("AttributeId", attributeId);
        attributeDesignatorElement.setAttribute("Category", category);
        attributeDesignatorElement.setAttribute("DataType", dataType);
        attributeDesignatorElement.setAttribute("MustBePresent", mustBe);
        if (attributeDesignatorDTO.getIssuer() == null || attributeDesignatorDTO.getIssuer().trim().length() <= 0) return attributeDesignatorElement;
        attributeDesignatorElement.setAttribute("Issuer", attributeDesignatorDTO.getIssuer());
        return attributeDesignatorElement;
    }

    public static Element createAttributeSelectorElement(AttributeSelectorDTO attributeSelectorDTO, Document doc) {
        Element attributeSelectorElement = doc.createElement("AttributeSelector");
        if (attributeSelectorDTO.getAttributeSelectorRequestContextPath() != null && attributeSelectorDTO.getAttributeSelectorRequestContextPath().trim().length() > 0) {
            attributeSelectorElement.setAttribute("RequestContextPath", "urn:oasis:names:tc:xacml:2.0:example:attribute:" + attributeSelectorDTO.getAttributeSelectorRequestContextPath());
            if (attributeSelectorDTO.getAttributeSelectorDataType() != null && attributeSelectorDTO.getAttributeSelectorDataType().trim().length() > 0) {
                attributeSelectorElement.setAttribute("DataType", attributeSelectorDTO.getAttributeSelectorDataType());
            } else {
                attributeSelectorElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
            if (attributeSelectorDTO.getAttributeSelectorMustBePresent() != null && attributeSelectorDTO.getAttributeSelectorMustBePresent().trim().length() > 0) {
                attributeSelectorElement.setAttribute("MustBePresent", attributeSelectorDTO.getAttributeSelectorMustBePresent());
            }
        }
        return attributeSelectorElement;
    }

    public static String[] processPolicySetData(PolicySetDTO policyDTO) {
        TargetDTO targetDTO = policyDTO.getTargetDTO();
        List<ObligationDTO> obligationDTOs = policyDTO.getObligations();
        List<PolicyRefIdDTO> policyRefIdDTOs = policyDTO.getPolicyRefIdDTOs();
        String policyOrder = policyDTO.getPolicyOrder();
        PolicyEditorDataHolder holder = PolicyEditorEngine.getInstance().getPolicyEditorData("SET");
        ArrayList<String> policyMetaDataList = new ArrayList<String>();
        ArrayList<PolicyRefIdDTO> arrangedRefIdDTOs = new ArrayList<PolicyRefIdDTO>();
        if (policyOrder != null && policyOrder.trim().length() > 0) {
            String[] ruleIds = policyOrder.split(",");
            for (String ruleId : ruleIds) {
                for (PolicyRefIdDTO dto : policyRefIdDTOs) {
                    if (!ruleId.equals(dto.getId())) continue;
                    arrangedRefIdDTOs.add(dto);
                }
            }
            policyRefIdDTOs = arrangedRefIdDTOs;
        }
        PolicyEditorUtil.createMetaDataFromPolicySet("policy", policyDTO, policyMetaDataList);
        String algorithm = policyDTO.getPolicyCombiningAlgId();
        if (algorithm != null && algorithm.trim().length() > 0) {
            policyDTO.setPolicyCombiningAlgId(holder.getPolicyAlgorithmUri(algorithm));
        } else {
            policyDTO.setPolicyCombiningAlgId(holder.getDefaultPolicyAlgorithm());
        }
        if (targetDTO != null && targetDTO.getRowDTOList() != null) {
            ArrayList<RowDTO> newRowDTOs = new ArrayList<RowDTO>();
            for (RowDTO rowDTO : targetDTO.getRowDTOList()) {
                String attributeValue;
                PolicyEditorUtil.createMetaDataFromRowDTO("target", rowDTO, policyMetaDataList);
                String category = rowDTO.getCategory();
                if (category == null || (attributeValue = rowDTO.getAttributeValue()) == null || attributeValue.trim().length() < 1) continue;
                rowDTO.setCategory(holder.getCategoryUri(category));
                if (rowDTO.getAttributeDataType() == null || rowDTO.getAttributeDataType().trim().length() < 1 || rowDTO.getAttributeDataType().trim().equals("null")) {
                    if (holder.getDefaultDataType() != null) {
                        rowDTO.setAttributeDataType(holder.getDefaultDataType());
                    } else {
                        rowDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                    }
                } else if (holder.getDataTypeUri(rowDTO.getAttributeDataType()) != null) {
                    rowDTO.setAttributeDataType(holder.getDataTypeUri(rowDTO.getAttributeDataType()));
                }
                String attributeId = rowDTO.getAttributeId();
                if (attributeId == null || attributeId.trim().length() < 1 || attributeId.trim().equals("null")) {
                    attributeId = holder.getCategoryDefaultAttributeId(category);
                }
                rowDTO.setAttributeId(holder.getAttributeIdUri(attributeId));
                rowDTO.setFunction(holder.getFunctionUri(rowDTO.getFunction()));
                rowDTO.setPreFunction(holder.getPreFunctionUri(rowDTO.getPreFunction()));
                newRowDTOs.add(rowDTO);
            }
            targetDTO.setRowDTOList(newRowDTOs);
            policyDTO.setTargetDTO(targetDTO);
        }
        if (policyRefIdDTOs != null) {
            policyDTO.setPolicyRefIdDTOs(policyRefIdDTOs);
            for (PolicyRefIdDTO dto : policyRefIdDTOs) {
                PolicyEditorUtil.createMetaDataFromReference("reference", dto, policyMetaDataList);
            }
        }
        if (obligationDTOs != null) {
            for (ObligationDTO dto : obligationDTOs) {
                PolicyEditorUtil.createMetaDataFromObligation("obligation", dto, policyMetaDataList);
                if (dto.getAttributeValueDataType() == null || dto.getAttributeValueDataType().trim().length() == 0 || dto.getAttributeValueDataType().trim().equals("null")) {
                    dto.setAttributeValueDataType("http://www.w3.org/2001/XMLSchema#string");
                }
                if (dto.getResultAttributeId() != null && dto.getResultAttributeId().trim().length() != 0 && !dto.getResultAttributeId().trim().equals("null")) continue;
                dto.setResultAttributeId(dto.getObligationId());
            }
            policyDTO.setObligations(obligationDTOs);
        }
        return policyMetaDataList.toArray(new String[policyMetaDataList.size()]);
    }

    public static String[] processPolicyData(PolicyDTO policyDTO) {
        TargetDTO targetDTO = policyDTO.getTargetDTO();
        List<RuleDTO> ruleDTOs = policyDTO.getRuleDTOs();
        List<ObligationDTO> obligationDTOs = policyDTO.getObligationDTOs();
        String ruleElementOrder = policyDTO.getRuleOrder();
        PolicyEditorDataHolder holder = PolicyEditorEngine.getInstance().getPolicyEditorData("STANDARD");
        ArrayList<String> policyMetaDataList = new ArrayList<String>();
        ArrayList<RuleDTO> arrangedRules = new ArrayList<RuleDTO>();
        if (ruleElementOrder != null && ruleElementOrder.trim().length() > 0) {
            String[] ruleIds = ruleElementOrder.split(",");
            for (String ruleId : ruleIds) {
                for (RuleDTO ruleDTO : ruleDTOs) {
                    if (!ruleId.equals(ruleDTO.getRuleId())) continue;
                    arrangedRules.add(ruleDTO);
                }
            }
            ruleDTOs = arrangedRules;
        }
        PolicyEditorUtil.createMetaDataFromPolicy("policy", policyDTO, policyMetaDataList);
        String algorithm = policyDTO.getRuleAlgorithm();
        if (algorithm != null && algorithm.trim().length() > 0) {
            policyDTO.setRuleAlgorithm(holder.getRuleAlgorithmUri(algorithm));
        } else {
            policyDTO.setRuleAlgorithm(holder.getDefaultRuleAlgorithm());
        }
        if (targetDTO != null && targetDTO.getRowDTOList() != null) {
            ArrayList<RowDTO> newRowDTOs = new ArrayList<RowDTO>();
            for (RowDTO rowDTO : targetDTO.getRowDTOList()) {
                String attributeValue;
                PolicyEditorUtil.createMetaDataFromRowDTO("target", rowDTO, policyMetaDataList);
                String category = rowDTO.getCategory();
                if (category == null || (attributeValue = rowDTO.getAttributeValue()) == null || attributeValue.trim().length() < 1) continue;
                rowDTO.setCategory(holder.getCategoryUri(category));
                if (rowDTO.getAttributeDataType() == null || rowDTO.getAttributeDataType().trim().length() < 1 || rowDTO.getAttributeDataType().trim().equals("null")) {
                    if (holder.getDefaultDataType() != null) {
                        rowDTO.setAttributeDataType(holder.getDefaultDataType());
                    } else {
                        rowDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                    }
                } else if (holder.getDataTypeUri(rowDTO.getAttributeDataType()) != null) {
                    rowDTO.setAttributeDataType(holder.getDataTypeUri(rowDTO.getAttributeDataType()));
                }
                String attributeId = rowDTO.getAttributeId();
                if (attributeId == null || attributeId.trim().length() < 1 || attributeId.trim().equals("null")) {
                    attributeId = holder.getCategoryDefaultAttributeId(category);
                }
                rowDTO.setAttributeId(holder.getAttributeIdUri(attributeId));
                rowDTO.setFunction(holder.getFunctionUri(rowDTO.getFunction()));
                rowDTO.setPreFunction(holder.getPreFunctionUri(rowDTO.getPreFunction()));
                newRowDTOs.add(rowDTO);
            }
            targetDTO.setRowDTOList(newRowDTOs);
            policyDTO.setTargetDTO(targetDTO);
        }
        if (ruleDTOs != null) {
            for (RuleDTO ruleDTO : ruleDTOs) {
                PolicyEditorUtil.createMetaDataFromRule("rule", ruleDTO, policyMetaDataList);
                ArrayList<RowDTO> newRowDTOs = new ArrayList<RowDTO>();
                for (RowDTO rowDTO : ruleDTO.getRowDTOList()) {
                    String attributeValue;
                    PolicyEditorUtil.createMetaDataFromRowDTO("ruleRow" + ruleDTO.getRuleId(), rowDTO, policyMetaDataList);
                    String category = rowDTO.getCategory();
                    if (category == null || (attributeValue = rowDTO.getAttributeValue()) == null || attributeValue.trim().length() < 1) continue;
                    rowDTO.setCategory(holder.getCategoryUri(category));
                    if (rowDTO.getAttributeDataType() == null || rowDTO.getAttributeDataType().trim().length() < 1 || rowDTO.getAttributeDataType().trim().equals("null")) {
                        if (holder.getDefaultDataType() != null) {
                            rowDTO.setAttributeDataType(holder.getDefaultDataType());
                        } else {
                            rowDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                        }
                    } else if (holder.getDataTypeUri(rowDTO.getAttributeDataType()) != null) {
                        rowDTO.setAttributeDataType(holder.getDataTypeUri(rowDTO.getAttributeDataType()));
                    }
                    String attributeId = rowDTO.getAttributeId();
                    if (attributeId == null || attributeId.trim().length() < 1 || attributeId.trim().equals("null")) {
                        attributeId = holder.getCategoryDefaultAttributeId(category);
                    }
                    rowDTO.setAttributeId(holder.getAttributeIdUri(attributeId));
                    rowDTO.setFunction(holder.getFunctionUri(rowDTO.getFunction()));
                    rowDTO.setPreFunction(holder.getPreFunctionUri(rowDTO.getPreFunction()));
                    newRowDTOs.add(rowDTO);
                }
                ruleDTO.setRowDTOList(newRowDTOs);
                TargetDTO ruleTargetDTO = ruleDTO.getTargetDTO();
                if (ruleTargetDTO == null) continue;
                ArrayList<RowDTO> newTargetRowDTOs = new ArrayList<RowDTO>();
                for (RowDTO rowDTO : ruleTargetDTO.getRowDTOList()) {
                    String attributeValue;
                    PolicyEditorUtil.createMetaDataFromRowDTO("ruleTarget" + ruleDTO.getRuleId(), rowDTO, policyMetaDataList);
                    String category = rowDTO.getCategory();
                    if (category == null || (attributeValue = rowDTO.getAttributeValue()) == null || attributeValue.trim().length() < 1) continue;
                    rowDTO.setCategory(holder.getCategoryUri(category));
                    if (rowDTO.getAttributeDataType() == null || rowDTO.getAttributeDataType().trim().length() < 1 || rowDTO.getAttributeDataType().trim().equals("null")) {
                        if (holder.getDefaultDataType() != null) {
                            rowDTO.setAttributeDataType(holder.getDefaultDataType());
                        } else {
                            rowDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                        }
                    } else if (holder.getDataTypeUri(rowDTO.getAttributeDataType()) != null) {
                        rowDTO.setAttributeDataType(holder.getDataTypeUri(rowDTO.getAttributeDataType()));
                    }
                    String attributeId = rowDTO.getAttributeId();
                    if (attributeId == null || attributeId.trim().length() < 1 || attributeId.trim().equals("null")) {
                        attributeId = holder.getCategoryDefaultAttributeId(category);
                    }
                    rowDTO.setAttributeId(holder.getAttributeIdUri(attributeId));
                    rowDTO.setFunction(holder.getFunctionUri(rowDTO.getFunction()));
                    rowDTO.setPreFunction(holder.getPreFunctionUri(rowDTO.getPreFunction()));
                    newTargetRowDTOs.add(rowDTO);
                }
                ruleTargetDTO.setRowDTOList(newTargetRowDTOs);
                List<ObligationDTO> ruleObligationDTOs = ruleDTO.getObligationDTOs();
                if (ruleObligationDTOs != null) {
                    for (ObligationDTO dto : ruleObligationDTOs) {
                        PolicyEditorUtil.createMetaDataFromObligation("ruleObligation" + ruleDTO.getRuleId(), dto, policyMetaDataList);
                        if (dto.getAttributeValueDataType() == null || dto.getAttributeValueDataType().trim().length() < 1 || dto.getAttributeValueDataType().trim().equals("null")) {
                            dto.setAttributeValueDataType("http://www.w3.org/2001/XMLSchema#string");
                        }
                        if (dto.getResultAttributeId() != null && dto.getResultAttributeId().trim().length() != 0 && !dto.getResultAttributeId().trim().equals("null")) continue;
                        dto.setResultAttributeId(dto.getObligationId());
                    }
                    ruleDTO.setObligationDTOs(ruleObligationDTOs);
                }
                ruleDTO.setTargetDTO(ruleTargetDTO);
            }
            policyDTO.setRuleDTOs(ruleDTOs);
        }
        if (obligationDTOs != null) {
            for (ObligationDTO dto : obligationDTOs) {
                PolicyEditorUtil.createMetaDataFromObligation("obligation", dto, policyMetaDataList);
                if (dto.getAttributeValueDataType() == null || dto.getAttributeValueDataType().trim().length() == 0 || dto.getAttributeValueDataType().trim().equals("null")) {
                    dto.setAttributeValueDataType("http://www.w3.org/2001/XMLSchema#string");
                }
                if (dto.getResultAttributeId() != null && dto.getResultAttributeId().trim().length() != 0 && !dto.getResultAttributeId().trim().equals("null")) continue;
                dto.setResultAttributeId(dto.getObligationId());
            }
            policyDTO.setObligationDTOs(obligationDTOs);
        }
        return policyMetaDataList.toArray(new String[policyMetaDataList.size()]);
    }

    private static void createMetaDataFromPolicy(String prefix, PolicyDTO policyDTO, List<String> metaDataList) {
        if (metaDataList != null) {
            metaDataList.add(prefix + "|" + policyDTO.getPolicyId());
            metaDataList.add(prefix + "|" + policyDTO.getRuleAlgorithm());
            if (policyDTO.getDescription() == null) {
                policyDTO.setDescription("");
            }
            metaDataList.add(prefix + "|" + policyDTO.getDescription());
            metaDataList.add(prefix + "|" + policyDTO.getVersion());
        }
    }

    private static void createMetaDataFromPolicySet(String prefix, PolicySetDTO policyDTO, List<String> metaDataList) {
        if (metaDataList != null) {
            metaDataList.add(prefix + "|" + policyDTO.getPolicySetId());
            metaDataList.add(prefix + "|" + policyDTO.getPolicyCombiningAlgId());
            if (policyDTO.getDescription() == null) {
                policyDTO.setDescription("");
            }
            metaDataList.add(prefix + "|" + policyDTO.getDescription());
            metaDataList.add(prefix + "|" + policyDTO.getVersion());
        }
    }

    private static void createMetaDataFromRule(String prefix, RuleDTO ruleDTO, List<String> metaDataList) {
        if (metaDataList != null) {
            metaDataList.add(prefix + "|" + ruleDTO.getRuleId());
            metaDataList.add(prefix + "|" + ruleDTO.getRuleEffect());
            metaDataList.add(prefix + "|" + ruleDTO.getRuleDescription());
        }
    }

    private static void createMetaDataFromRowDTO(String prefix, RowDTO rowDTO, List<String> metaDataList) {
        if (metaDataList != null) {
            metaDataList.add(prefix + "|" + rowDTO.getCategory());
            metaDataList.add(prefix + "|" + rowDTO.getPreFunction());
            metaDataList.add(prefix + "|" + rowDTO.getFunction());
            metaDataList.add(prefix + "|" + rowDTO.getAttributeValue());
            metaDataList.add(prefix + "|" + rowDTO.getAttributeId());
            metaDataList.add(prefix + "|" + rowDTO.getAttributeDataType());
            metaDataList.add(prefix + "|" + rowDTO.getCombineFunction());
        }
    }

    private static void createMetaDataFromDynamicAttribute(String prefix, ExtendAttributeDTO dto, List<String> metaDataList) {
        if (metaDataList != null) {
            metaDataList.add(prefix + "|" + dto.getCategory());
            metaDataList.add(prefix + "|" + dto.getSelector());
            metaDataList.add(prefix + "|" + dto.getFunction());
            metaDataList.add(prefix + "|" + dto.getAttributeValue());
            metaDataList.add(prefix + "|" + dto.getAttributeId());
            metaDataList.add(prefix + "|" + dto.getDataType());
            metaDataList.add(prefix + "|" + dto.getId());
        }
    }

    private static void createMetaDataFromObligation(String prefix, ObligationDTO dto, List<String> metaDataList) {
        if (metaDataList != null) {
            metaDataList.add(prefix + "|" + dto.getType());
            metaDataList.add(prefix + "|" + dto.getObligationId());
            metaDataList.add(prefix + "|" + dto.getEffect());
            metaDataList.add(prefix + "|" + dto.getAttributeValue());
            metaDataList.add(prefix + "|" + dto.getResultAttributeId());
            metaDataList.add(prefix + "|" + dto.getAttributeValueDataType());
        }
    }

    private static void createMetaDataFromReference(String prefix, PolicyRefIdDTO dto, List<String> metaDataList) {
        if (metaDataList != null) {
            metaDataList.add(prefix + "|" + dto.getId());
            metaDataList.add(prefix + "|" + dto.isPolicySet());
            metaDataList.add(prefix + "|" + dto.isReferenceOnly());
        }
    }

    public static String[] createBasicPolicyData(SimplePolicyEditorDTO policyEditorDTO) {
        ArrayList<String> metaDataList = new ArrayList<String>();
        metaDataList.add("policyId|" + policyEditorDTO.getPolicyId());
        metaDataList.add("category|" + policyEditorDTO.getAppliedCategory());
        metaDataList.add("policyDescription|" + policyEditorDTO.getDescription());
        metaDataList.add("userAttributeId|" + policyEditorDTO.getUserAttributeId());
        metaDataList.add("userAttributeValue|" + policyEditorDTO.getUserAttributeValue());
        metaDataList.add("function|" + policyEditorDTO.getFunction());
        metaDataList.add("actionValue|" + policyEditorDTO.getActionValue());
        metaDataList.add("resourceValue|" + policyEditorDTO.getResourceValue());
        metaDataList.add("category|" + policyEditorDTO.getAppliedCategory());
        metaDataList.add("environmentValue|" + policyEditorDTO.getEnvironmentValue());
        metaDataList.add("environmentId|" + policyEditorDTO.getEnvironmentId());
        List<SimplePolicyEditorElementDTO> elementDTOs = policyEditorDTO.getSimplePolicyEditorElementDTOs();
        if (elementDTOs != null && elementDTOs.size() > 0) {
            for (int i = 0; i < elementDTOs.size(); ++i) {
                SimplePolicyEditorElementDTO dto = elementDTOs.get(i);
                if (dto.getResourceValue() != null) {
                    metaDataList.add("resourceValue" + i + "|" + dto.getResourceValue());
                } else {
                    metaDataList.add("resourceValue" + i);
                }
                if (dto.getEnvironmentValue() != null) {
                    metaDataList.add("environmentValue" + i + "|" + dto.getEnvironmentValue());
                } else {
                    metaDataList.add("environmentValue" + i);
                }
                if (dto.getActionValue() != null) {
                    metaDataList.add("actionValue" + i + "|" + dto.getActionValue());
                } else {
                    metaDataList.add("actionValue" + i);
                }
                if (dto.getOperationType() != null) {
                    metaDataList.add("operationValue" + i + "|" + dto.getOperationType());
                } else {
                    metaDataList.add("operationValue" + i);
                }
                if (dto.getUserAttributeId() != null) {
                    metaDataList.add("userAttributeId" + i + "|" + dto.getUserAttributeId());
                } else {
                    metaDataList.add("userAttributeId" + i);
                }
                if (dto.getUserAttributeValue() != null) {
                    metaDataList.add("userAttributeValue" + i + "|" + dto.getUserAttributeValue());
                } else {
                    metaDataList.add("userAttributeValue" + i);
                }
                if (dto.getEnvironmentId() != null) {
                    metaDataList.add("environmentId" + i + "|" + dto.getEnvironmentId());
                } else {
                    metaDataList.add("environmentId" + i);
                }
                if (dto.getFunctionOnResources() != null) {
                    metaDataList.add("functionOnResources" + i + "|" + dto.getFunctionOnResources());
                } else {
                    metaDataList.add("functionOnResources" + i);
                }
                if (dto.getFunctionOnActions() != null) {
                    metaDataList.add("functionOnActions" + i + "|" + dto.getFunctionOnActions());
                } else {
                    metaDataList.add("functionOnActions" + i);
                }
                if (dto.getFunctionOnUsers() != null) {
                    metaDataList.add("functionOnUsers" + i + "|" + dto.getFunctionOnUsers());
                } else {
                    metaDataList.add("functionOnUsers" + i);
                }
                if (dto.getFunctionOnEnvironments() != null) {
                    metaDataList.add("functionOnEnvironments" + i + "|" + dto.getFunctionOnEnvironments());
                    continue;
                }
                metaDataList.add("functionOnEnvironments" + i);
            }
        }
        return metaDataList.toArray(new String[metaDataList.size()]);
    }

    public static SimplePolicyEditorDTO createSimplePolicyEditorDTO(String[] policyEditorData) {
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        ArrayList<SimplePolicyEditorElementDTO> SimplePolicyEditorElementDTOs = new ArrayList<SimplePolicyEditorElementDTO>();
        int i = 0;
        if (policyEditorData != null) {
            for (String data : policyEditorData) {
                if (data.contains("|")) {
                    String identifier = data.substring(0, data.indexOf("|"));
                    String value = data.substring(data.indexOf("|") + 1);
                    metaDataMap.put(identifier, value);
                }
                ++i;
            }
        }
        SimplePolicyEditorDTO policyEditorDTO = new SimplePolicyEditorDTO();
        policyEditorDTO.setPolicyId((String)metaDataMap.get("policyId"));
        policyEditorDTO.setAppliedCategory((String)metaDataMap.get("policyId"));
        policyEditorDTO.setFunction((String)metaDataMap.get("function"));
        policyEditorDTO.setActionValue((String)metaDataMap.get("actionValue"));
        policyEditorDTO.setDescription((String)metaDataMap.get("policyDescription"));
        policyEditorDTO.setUserAttributeId((String)metaDataMap.get("userAttributeId"));
        policyEditorDTO.setUserAttributeValue((String)metaDataMap.get("userAttributeValue"));
        policyEditorDTO.setResourceValue((String)metaDataMap.get("resourceValue"));
        policyEditorDTO.setEnvironmentValue((String)metaDataMap.get("environmentValue"));
        policyEditorDTO.setEnvironmentId((String)metaDataMap.get("environmentId"));
        policyEditorDTO.setAppliedCategory((String)metaDataMap.get("category"));
        i = (i - 11) / 11;
        for (int j = 0; j < i; ++j) {
            SimplePolicyEditorElementDTO elementDTO = new SimplePolicyEditorElementDTO();
            elementDTO.setResourceValue((String)metaDataMap.get("resourceValue" + j));
            elementDTO.setEnvironmentValue((String)metaDataMap.get("environmentValue" + j));
            if (metaDataMap.get("actionValue" + j) != null) {
                elementDTO.setActionValue((String)metaDataMap.get("actionValue" + j));
            }
            elementDTO.setOperationType((String)metaDataMap.get("operationValue" + j));
            elementDTO.setUserAttributeId((String)metaDataMap.get("userAttributeId" + j));
            elementDTO.setUserAttributeValue((String)metaDataMap.get("userAttributeValue" + j));
            elementDTO.setEnvironmentId((String)metaDataMap.get("environmentId" + j));
            elementDTO.setFunctionOnResources((String)metaDataMap.get("functionOnResources" + j));
            elementDTO.setFunctionOnActions((String)metaDataMap.get("functionOnActions" + j));
            elementDTO.setFunctionOnUsers((String)metaDataMap.get("functionOnUsers" + j));
            elementDTO.setFunctionOnEnvironments((String)metaDataMap.get("functionOnEnvironments" + j));
            SimplePolicyEditorElementDTOs.add(elementDTO);
        }
        if (SimplePolicyEditorElementDTOs.size() > 0) {
            policyEditorDTO.setSimplePolicyEditorElementDTOs(SimplePolicyEditorElementDTOs);
        }
        return policyEditorDTO;
    }

    public static PolicyElementDTO createPolicyElementDTO(String policy) throws EntitlementPolicyCreationException {
        OMElement omElement;
        PolicyElementDTO policyElementDTO = new PolicyElementDTO();
        try {
            omElement = AXIOMUtil.stringToOM((String)policy);
        }
        catch (XMLStreamException e) {
            throw new EntitlementPolicyCreationException("Policy can not be converted to OMElement");
        }
        if (omElement != null) {
            OMElement descriptionElement;
            policyElementDTO.setPolicyName(omElement.getAttributeValue(new QName("PolicyId")));
            String ruleCombiningAlgorithm = omElement.getAttributeValue(new QName("RuleCombiningAlgId"));
            try {
                policyElementDTO.setRuleCombiningAlgorithms(ruleCombiningAlgorithm.split("urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:")[1]);
            }
            catch (Exception ignore) {
                policyElementDTO.setRuleCombiningAlgorithms(ruleCombiningAlgorithm.split("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:")[1]);
            }
            Iterator iterator = omElement.getChildrenWithLocalName("Description");
            if (iterator.hasNext() && (descriptionElement = (OMElement)iterator.next()) != null && descriptionElement.getText() != null) {
                policyElementDTO.setPolicyDescription(descriptionElement.getText().trim());
            }
        }
        return policyElementDTO;
    }

    public static List<RuleElementDTO> createRuleElementDTOs(String policy) throws EntitlementPolicyCreationException {
        OMElement omElement;
        ArrayList<RuleElementDTO> ruleElementDTOs = new ArrayList<RuleElementDTO>();
        try {
            omElement = AXIOMUtil.stringToOM((String)policy);
        }
        catch (XMLStreamException e) {
            throw new EntitlementPolicyCreationException("Policy can not be converted to OMElement");
        }
        if (omElement != null) {
            Iterator iterator2 = omElement.getChildrenWithLocalName("Rule");
            while (iterator2.hasNext()) {
                OMElement ruleElement = (OMElement)iterator2.next();
                ruleElementDTOs.add(PolicyEditorUtil.createRuleDTO(ruleElement));
            }
        }
        return ruleElementDTOs;
    }

    public static RuleElementDTO createRuleDTO(OMElement omElement) {
        RuleElementDTO ruleElementDTO = new RuleElementDTO();
        if (omElement != null) {
            ruleElementDTO.setRuleId(omElement.getAttributeValue(new QName("RuleId")).trim());
            ruleElementDTO.setRuleEffect(omElement.getAttributeValue(new QName("Effect")).trim());
            Iterator iterator1 = omElement.getChildrenWithLocalName("Description");
            while (iterator1.hasNext()) {
                OMElement descriptionElement = (OMElement)iterator1.next();
                if (descriptionElement == null || descriptionElement.getText() == null) continue;
                ruleElementDTO.setRuleDescription(descriptionElement.getText().trim());
            }
        }
        return ruleElementDTO;
    }

    public static void processRuleRowPolicyEditorData(List<RuleDTO> rules, String[] policyEditorData) {
        for (RuleDTO ruleDTO : rules) {
            ArrayList<String> ruleList = new ArrayList<String>();
            ArrayList<String> ruleTargetList = new ArrayList<String>();
            ArrayList<String> obligationList = new ArrayList<String>();
            for (String data : policyEditorData) {
                String ruleId;
                if (!data.contains("|")) continue;
                String identifier = data.substring(0, data.indexOf("|"));
                if (identifier.startsWith("ruleTarget")) {
                    ruleId = identifier.substring(10);
                    if (ruleId == null || !ruleId.contains(ruleDTO.getRuleId())) continue;
                    ruleTargetList.add(data.substring(data.indexOf("|") + 1));
                    continue;
                }
                if (identifier.startsWith("ruleObligation")) {
                    ruleId = identifier.substring(14);
                    if (ruleId == null || !ruleId.equals(ruleDTO.getRuleId())) continue;
                    obligationList.add(data.substring(data.indexOf("|") + 1));
                    continue;
                }
                if (!identifier.startsWith("ruleRow") || (ruleId = identifier.substring(7)) == null || !ruleId.equals(ruleDTO.getRuleId())) continue;
                ruleList.add(data.substring(data.indexOf("|") + 1));
            }
            ruleDTO.setRowDTOList(PolicyEditorUtil.createRowDTO(ruleList));
            ruleDTO.getTargetDTO().setRowDTOList(PolicyEditorUtil.createRowDTO(ruleTargetList));
            ruleDTO.setObligationDTOs(PolicyEditorUtil.createObligationDTO(obligationList));
            ruleDTO.setCompletedRule(true);
        }
    }

    public static void processTargetPolicyEditorData(TargetDTO targetDTO, String[] policyEditorData) {
        ArrayList<String> targetList = new ArrayList<String>();
        if (policyEditorData != null) {
            for (String data : policyEditorData) {
                String identifier;
                if (!data.contains("|") || !"target".equals(identifier = data.substring(0, data.indexOf("|")))) continue;
                targetList.add(data.substring(data.indexOf("|") + 1));
            }
            targetDTO.setRowDTOList(PolicyEditorUtil.createRowDTO(targetList));
        }
    }

    public static void processPolicyEditorData(PolicyElementDTO policyElementDTO, String[] policyEditorData) {
        ArrayList<String> targetList = new ArrayList<String>();
        if (policyEditorData != null) {
            for (String data : policyEditorData) {
                String identifier;
                if (!data.contains("|") || !"policy".equals(identifier = data.substring(0, data.indexOf("|")))) continue;
                targetList.add(data.substring(data.indexOf("|") + 1));
            }
            policyElementDTO.setPolicyName((String)targetList.get(0));
            policyElementDTO.setRuleCombiningAlgorithms((String)targetList.get(1));
            if (targetList.get(2) != null) {
                policyElementDTO.setPolicyDescription((String)targetList.get(2));
            }
            policyElementDTO.setVersion((String)targetList.get(3));
        }
    }

    public static void processObligationPolicyEditorData(List<ObligationDTO> obligationDTOs, String[] policyEditorData) {
        ArrayList<String> targetList = new ArrayList<String>();
        if (policyEditorData != null) {
            for (String data : policyEditorData) {
                String identifier;
                if (!data.contains("|") || !"obligation".equals(identifier = data.substring(0, data.indexOf("|")))) continue;
                targetList.add(data.substring(data.indexOf("|") + 1));
            }
            obligationDTOs.addAll(PolicyEditorUtil.createObligationDTO(targetList));
        }
    }

    public static void processRulePolicyEditorData(List<RuleDTO> ruleDTOs, String[] policyEditorData) {
        ArrayList<String> targetList = new ArrayList<String>();
        if (policyEditorData != null) {
            for (String data : policyEditorData) {
                String identifier;
                if (!data.contains("|") || !"rule".equals(identifier = data.substring(0, data.indexOf("|")))) continue;
                targetList.add(data.substring(data.indexOf("|") + 1));
            }
            ruleDTOs.addAll(PolicyEditorUtil.createRuleDTO(targetList));
            if (ruleDTOs.size() > 0) {
                PolicyEditorUtil.processRuleRowPolicyEditorData(ruleDTOs, policyEditorData);
            }
        }
    }

    public static void processReferencePolicyEditorData(List<PolicyRefIdDTO> policyRefIdDTOs, String[] policyEditorData) {
        ArrayList<String> targetList = new ArrayList<String>();
        if (policyEditorData != null) {
            for (String data : policyEditorData) {
                String identifier;
                if (!data.contains("|") || !"reference".equals(identifier = data.substring(0, data.indexOf("|")))) continue;
                targetList.add(data.substring(data.indexOf("|") + 1));
            }
            policyRefIdDTOs.addAll(PolicyEditorUtil.createReferenceDTO(targetList));
        }
    }

    private static List<RowDTO> createRowDTO(List<String> list) {
        ArrayList<RowDTO> rowDTOs = new ArrayList<RowDTO>();
        for (int i = 0; i < list.size(); i += 7) {
            List<String> newList = list.subList(i, i + 7);
            if (newList == null) continue;
            RowDTO rowDTO = new RowDTO();
            rowDTO.setCategory(newList.get(0));
            rowDTO.setPreFunction(newList.get(1));
            rowDTO.setFunction(newList.get(2));
            rowDTO.setAttributeValue(newList.get(3));
            rowDTO.setAttributeId(newList.get(4));
            rowDTO.setAttributeDataType(newList.get(5));
            rowDTO.setCombineFunction(newList.get(6));
            rowDTOs.add(rowDTO);
        }
        return rowDTOs;
    }

    private static List<ObligationDTO> createObligationDTO(List<String> list) {
        ArrayList<ObligationDTO> rowDTOs = new ArrayList<ObligationDTO>();
        for (int i = 0; i < list.size(); i += 6) {
            List<String> newList = list.subList(i, i + 6);
            if (newList == null) continue;
            ObligationDTO rowDTO = new ObligationDTO();
            rowDTO.setType(newList.get(0));
            rowDTO.setObligationId(newList.get(1));
            rowDTO.setEffect(newList.get(2));
            rowDTO.setAttributeValue(newList.get(3));
            rowDTO.setResultAttributeId(newList.get(4));
            rowDTO.setAttributeValueDataType(newList.get(5));
            rowDTOs.add(rowDTO);
        }
        return rowDTOs;
    }

    private static List<RuleDTO> createRuleDTO(List<String> list) {
        ArrayList<RuleDTO> rowDTOs = new ArrayList<RuleDTO>();
        for (int i = 0; i < list.size(); i += 3) {
            List<String> newList = list.subList(i, i + 3);
            if (newList == null) continue;
            RuleDTO rowDTO = new RuleDTO();
            rowDTO.setRuleId(newList.get(0));
            rowDTO.setRuleEffect(newList.get(1));
            rowDTO.setRuleDescription(newList.get(2));
            rowDTOs.add(rowDTO);
        }
        return rowDTOs;
    }

    private static List<PolicyRefIdDTO> createReferenceDTO(List<String> list) {
        ArrayList<PolicyRefIdDTO> rowDTOs = new ArrayList<PolicyRefIdDTO>();
        for (int i = 0; i < list.size(); i += 3) {
            List<String> newList = list.subList(i, i + 3);
            if (newList == null) continue;
            PolicyRefIdDTO rowDTO = new PolicyRefIdDTO();
            rowDTO.setId(newList.get(0));
            rowDTO.setPolicySet(Boolean.parseBoolean(newList.get(1)));
            rowDTO.setReferenceOnly(Boolean.parseBoolean(newList.get(2)));
            rowDTOs.add(rowDTO);
        }
        return rowDTOs;
    }

    public static String[] generateBasicPolicyEditorData(BasicPolicyDTO basicPolicyDTO, String ruleElementOrder) {
        ArrayList<BasicRuleDTO> basicRuleDTOs = basicPolicyDTO.getBasicRuleDTOs();
        BasicTargetDTO basicTargetDTO = basicPolicyDTO.getTargetDTO();
        PolicyEditorDataHolder holder = PolicyEditorEngine.getInstance().getPolicyEditorData("BASIC");
        ArrayList<BasicRuleDTO> arrangedRules = new ArrayList<BasicRuleDTO>();
        if (ruleElementOrder != null && ruleElementOrder.trim().length() > 0) {
            String[] ruleIds;
            for (String ruleId : ruleIds = ruleElementOrder.split(",")) {
                for (BasicRuleDTO ruleDTO : basicRuleDTOs) {
                    if (!ruleId.equals(ruleDTO.getRuleId())) continue;
                    arrangedRules.add(ruleDTO);
                }
            }
            basicRuleDTOs = arrangedRules;
        }
        int ruleEditorDataConstant = 23;
        int targetEditorDataConstant = 20;
        int i = 0;
        String[] policyEditorData = basicRuleDTOs != null ? new String[targetEditorDataConstant + basicRuleDTOs.size() * ruleEditorDataConstant] : new String[targetEditorDataConstant];
        policyEditorData[i++] = basicPolicyDTO.getPolicyId();
        policyEditorData[i++] = basicPolicyDTO.getRuleAlgorithm();
        String algorithm = basicPolicyDTO.getRuleAlgorithm();
        if (algorithm != null && algorithm.trim().length() > 0) {
            basicPolicyDTO.setRuleAlgorithm(holder.getRuleAlgorithmUri(algorithm));
        } else {
            basicPolicyDTO.setRuleAlgorithm(holder.getRuleAlgorithmUri(holder.getDefaultRuleAlgorithm()));
        }
        policyEditorData[i++] = basicPolicyDTO.getVersion();
        policyEditorData[i++] = basicPolicyDTO.getDescription();
        policyEditorData[i++] = basicTargetDTO.getFunctionOnResources();
        policyEditorData[i++] = basicTargetDTO.getResourceList();
        policyEditorData[i++] = basicTargetDTO.getResourceId();
        String resourceId = basicTargetDTO.getResourceId();
        policyEditorData[i++] = basicTargetDTO.getResourceDataType();
        basicTargetDTO.setFunctionOnResources(holder.getFunctionUri(basicTargetDTO.getFunctionOnResources()));
        basicTargetDTO.setResourceId(holder.getAttributeIdUri(resourceId));
        String selectedDataType = holder.getDataTypeUriForAttribute(resourceId);
        if (selectedDataType != null) {
            basicTargetDTO.setResourceDataType(selectedDataType);
        }
        policyEditorData[i++] = basicTargetDTO.getFunctionOnSubjects();
        policyEditorData[i++] = basicTargetDTO.getSubjectList();
        policyEditorData[i++] = basicTargetDTO.getSubjectId();
        policyEditorData[i++] = basicTargetDTO.getSubjectDataType();
        String subjectId = basicTargetDTO.getSubjectId();
        basicTargetDTO.setFunctionOnSubjects(holder.getFunctionUri(basicTargetDTO.getFunctionOnSubjects()));
        basicTargetDTO.setSubjectId(holder.getAttributeIdUri(subjectId));
        selectedDataType = holder.getDataTypeUriForAttribute(subjectId);
        if (selectedDataType != null) {
            basicTargetDTO.setSubjectDataType(selectedDataType);
        }
        policyEditorData[i++] = basicTargetDTO.getFunctionOnActions();
        policyEditorData[i++] = basicTargetDTO.getActionList();
        policyEditorData[i++] = basicTargetDTO.getActionId();
        String actionId = basicTargetDTO.getActionId();
        policyEditorData[i++] = basicTargetDTO.getActionDataType();
        basicTargetDTO.setFunctionOnActions(holder.getFunctionUri(basicTargetDTO.getFunctionOnActions()));
        basicTargetDTO.setActionId(holder.getAttributeIdUri(actionId));
        selectedDataType = holder.getDataTypeUriForAttribute(actionId);
        if (selectedDataType != null) {
            basicTargetDTO.setActionDataType(selectedDataType);
        }
        policyEditorData[i++] = basicTargetDTO.getFunctionOnEnvironment();
        policyEditorData[i++] = basicTargetDTO.getEnvironmentList();
        policyEditorData[i++] = basicTargetDTO.getEnvironmentId();
        policyEditorData[i++] = basicTargetDTO.getEnvironmentDataType();
        String environmentId = basicTargetDTO.getEnvironmentId();
        basicTargetDTO.setFunctionOnEnvironment(holder.getFunctionUri(basicTargetDTO.getFunctionOnEnvironment()));
        basicTargetDTO.setEnvironmentId(holder.getAttributeIdUri(environmentId));
        selectedDataType = holder.getDataTypeUriForAttribute(environmentId);
        if (selectedDataType != null) {
            basicTargetDTO.setEnvironmentDataType(selectedDataType);
        }
        if (basicRuleDTOs != null && basicRuleDTOs.size() > 0) {
            for (BasicRuleDTO basicRuleDTO : basicRuleDTOs) {
                PolicyEditorUtil.generateBasicPolicyEditorDataForRule(basicRuleDTO, policyEditorData, i);
                i += ruleEditorDataConstant;
                if (basicRuleDTO.getRuleId() == null || basicRuleDTO.getRuleId().trim().length() == 0) {
                    basicRuleDTO.setRuleId(UUID.randomUUID().toString());
                }
                if (basicRuleDTO.getRuleEffect() != null && basicRuleDTO.getRuleEffect().trim().length() != 0) continue;
                basicRuleDTO.setRuleEffect(holder.getDefaultEffect());
            }
        }
        if (holder.isAddLastRule()) {
            if (basicRuleDTOs == null) {
                basicRuleDTOs = new ArrayList();
            }
            BasicRuleDTO basicRuleDTO = new BasicRuleDTO();
            basicRuleDTO.setRuleId(UUID.randomUUID().toString());
            if (holder.getLastRuleEffect() != null) {
                basicRuleDTO.setRuleEffect(holder.getLastRuleEffect());
            } else {
                basicRuleDTO.setRuleEffect(holder.getDefaultEffect());
            }
            basicRuleDTOs.add(basicRuleDTO);
        }
        basicPolicyDTO.setBasicRuleDTOs(basicRuleDTOs);
        return policyEditorData;
    }

    public static String[] generateBasicPolicyEditorDataForRule(BasicRuleDTO basicRuleDTO, String[] policyEditorData, int currentArrayIndex) {
        int i = currentArrayIndex;
        PolicyEditorDataHolder holder = PolicyEditorEngine.getInstance().getPolicyEditorData("BASIC");
        policyEditorData[i++] = basicRuleDTO.getRuleId();
        policyEditorData[i++] = basicRuleDTO.getRuleEffect();
        policyEditorData[i++] = basicRuleDTO.getRuleDescription();
        basicRuleDTO.setRuleEffect(holder.getRuleEffectUri(basicRuleDTO.getRuleEffect()));
        policyEditorData[i++] = basicRuleDTO.getPreFunctionOnResources();
        policyEditorData[i++] = basicRuleDTO.getFunctionOnResources();
        policyEditorData[i++] = basicRuleDTO.getResourceList();
        policyEditorData[i++] = basicRuleDTO.getResourceId();
        String resourceId = basicRuleDTO.getResourceId();
        policyEditorData[i++] = basicRuleDTO.getResourceDataType();
        basicRuleDTO.setPreFunctionOnResources(holder.getPreFunctionUri(basicRuleDTO.getPreFunctionOnResources()));
        basicRuleDTO.setFunctionOnResources(holder.getFunctionUri(basicRuleDTO.getFunctionOnResources()));
        basicRuleDTO.setResourceId(holder.getAttributeIdUri(resourceId));
        String selectedDataType = holder.getDataTypeUriForAttribute(resourceId);
        if (selectedDataType != null) {
            basicRuleDTO.setResourceDataType(selectedDataType);
        }
        policyEditorData[i++] = basicRuleDTO.getPreFunctionOnSubjects();
        policyEditorData[i++] = basicRuleDTO.getFunctionOnSubjects();
        policyEditorData[i++] = basicRuleDTO.getSubjectList();
        policyEditorData[i++] = basicRuleDTO.getSubjectId();
        policyEditorData[i++] = basicRuleDTO.getSubjectDataType();
        String subjectId = basicRuleDTO.getSubjectId();
        basicRuleDTO.setPreFunctionOnSubjects(holder.getPreFunctionUri(basicRuleDTO.getPreFunctionOnSubjects()));
        basicRuleDTO.setFunctionOnSubjects(holder.getFunctionUri(basicRuleDTO.getFunctionOnSubjects()));
        basicRuleDTO.setSubjectId(holder.getAttributeIdUri(subjectId));
        selectedDataType = holder.getDataTypeUriForAttribute(subjectId);
        if (selectedDataType != null) {
            basicRuleDTO.setSubjectDataType(selectedDataType);
        }
        policyEditorData[i++] = basicRuleDTO.getPreFunctionOnActions();
        policyEditorData[i++] = basicRuleDTO.getFunctionOnActions();
        policyEditorData[i++] = basicRuleDTO.getActionList();
        policyEditorData[i++] = basicRuleDTO.getActionId();
        String actionId = basicRuleDTO.getActionId();
        policyEditorData[i++] = basicRuleDTO.getActionDataType();
        basicRuleDTO.setPreFunctionOnActions(holder.getPreFunctionUri(basicRuleDTO.getPreFunctionOnActions()));
        basicRuleDTO.setFunctionOnActions(holder.getFunctionUri(basicRuleDTO.getFunctionOnActions()));
        basicRuleDTO.setActionId(holder.getAttributeIdUri(actionId));
        selectedDataType = holder.getDataTypeUriForAttribute(actionId);
        if (selectedDataType != null) {
            basicRuleDTO.setActionDataType(selectedDataType);
        }
        policyEditorData[i++] = basicRuleDTO.getPreFunctionOnEnvironment();
        policyEditorData[i++] = basicRuleDTO.getFunctionOnEnvironment();
        policyEditorData[i++] = basicRuleDTO.getEnvironmentList();
        policyEditorData[i++] = basicRuleDTO.getEnvironmentId();
        policyEditorData[i++] = basicRuleDTO.getEnvironmentDataType();
        String environmentId = basicRuleDTO.getSubjectId();
        basicRuleDTO.setPreFunctionOnEnvironment(holder.getPreFunctionUri(basicRuleDTO.getPreFunctionOnEnvironment()));
        basicRuleDTO.setFunctionOnEnvironment(holder.getFunctionUri(basicRuleDTO.getFunctionOnEnvironment()));
        basicRuleDTO.setEnvironmentId(holder.getAttributeIdUri(environmentId));
        selectedDataType = holder.getDataTypeUriForAttribute(environmentId);
        if (selectedDataType != null) {
            basicRuleDTO.setEnvironmentDataType(selectedDataType);
        }
        return policyEditorData;
    }

    public static BasicPolicyDTO createBasicPolicyDTO(String[] policyEditorData) {
        BasicPolicyDTO basicPolicyDTO = new BasicPolicyDTO();
        int i = 0;
        if (policyEditorData[i] != null) {
            basicPolicyDTO.setPolicyId(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicPolicyDTO.setRuleAlgorithm(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicPolicyDTO.setVersion(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicPolicyDTO.setDescription(policyEditorData[i]);
        }
        BasicTargetDTO basicTargetDTO = new BasicTargetDTO();
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setFunctionOnResources(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setResourceList(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setResourceId(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setResourceDataType(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setFunctionOnSubjects(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setSubjectList(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setSubjectId(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setSubjectDataType(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setFunctionOnActions(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setActionList(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setActionId(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setActionDataType(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setFunctionOnEnvironment(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setEnvironmentList(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setEnvironmentId(policyEditorData[i]);
        }
        if (policyEditorData[++i] != null) {
            basicTargetDTO.setEnvironmentDataType(policyEditorData[i]);
        }
        basicPolicyDTO.setTargetDTO(basicTargetDTO);
        List<BasicRuleDTO> basicRuleDTOs = PolicyEditorUtil.createBasicRuleDTOs(policyEditorData, ++i);
        if (basicRuleDTOs != null && basicRuleDTOs.size() > 0) {
            basicPolicyDTO.setBasicRuleDTOs(basicRuleDTOs);
        }
        return basicPolicyDTO;
    }

    public static List<BasicRuleDTO> createBasicRuleDTOs(String[] policyEditorData, int nextIndex) {
        ArrayList<BasicRuleDTO> basicRuleDTOs = new ArrayList<BasicRuleDTO>();
        if (policyEditorData != null) {
            while (policyEditorData.length != nextIndex) {
                BasicRuleDTO basicRuleDTO = PolicyEditorUtil.createBasicRuleDTO(policyEditorData, nextIndex);
                nextIndex += 23;
                basicRuleDTO.setCompletedRule(true);
                basicRuleDTOs.add(basicRuleDTO);
            }
        }
        return basicRuleDTOs;
    }

    public static BasicRuleDTO createBasicRuleDTO(String[] policyEditorDataForRule, int nextIndex) {
        BasicRuleDTO basicRuleDTO = new BasicRuleDTO();
        int i = nextIndex;
        if (policyEditorDataForRule[i] != null) {
            basicRuleDTO.setRuleId(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setRuleEffect(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setRuleDescription(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setPreFunctionOnResources(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setFunctionOnResources(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setResourceList(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setResourceId(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setResourceDataType(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setPreFunctionOnSubjects(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setFunctionOnSubjects(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setSubjectList(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setSubjectId(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setSubjectDataType(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setPreFunctionOnActions(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setFunctionOnActions(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setActionList(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setActionId(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setActionDataType(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setPreFunctionOnEnvironment(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setFunctionOnEnvironment(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setEnvironmentList(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setEnvironmentId(policyEditorDataForRule[i]);
        }
        if (policyEditorDataForRule[++i] != null) {
            basicRuleDTO.setEnvironmentDataType(policyEditorDataForRule[i]);
        }
        return basicRuleDTO;
    }
}

