/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.balana.utils.policy.dto.AttributeElementDTO;
import org.wso2.balana.utils.policy.dto.AttributesElementDTO;
import org.wso2.balana.utils.policy.dto.RequestElementDTO;
import org.wso2.carbon.identity.entitlement.common.dto.RequestDTO;
import org.wso2.carbon.identity.entitlement.common.dto.RowDTO;

public class PolicyCreatorUtil {
    public static RequestElementDTO createRequestElementDTO(RequestDTO requestDTO) {
        RequestElementDTO requestElement = new RequestElementDTO();
        List<RowDTO> rowDTOs = requestDTO.getRowDTOs();
        if (rowDTOs == null || rowDTOs.size() < 1) {
            return requestElement;
        }
        HashMap<String, AttributesElementDTO> dtoMap = new HashMap<String, AttributesElementDTO>();
        ArrayList<Object> dtoList = new ArrayList<Object>();
        for (RowDTO rowDTO : rowDTOs) {
            String category = rowDTO.getCategory();
            String value = rowDTO.getAttributeValue();
            String attributeId = rowDTO.getAttributeId();
            if (category == null || category.trim().length() <= 0 || value == null || value.trim().length() <= 0 || attributeId == null || attributeId.trim().length() <= 0) continue;
            if (requestDTO.isMultipleRequest()) {
                String[] values;
                for (String attributeValue : values = value.split(",")) {
                    AttributesElementDTO attributesElementDTO = new AttributesElementDTO();
                    attributesElementDTO.setCategory(category);
                    AttributeElementDTO attributeElementDTO = new AttributeElementDTO();
                    attributeElementDTO.addAttributeValue(attributeValue);
                    attributeElementDTO.setAttributeId(attributeId);
                    attributeElementDTO.setIncludeInResult(rowDTO.isNotCompleted());
                    attributesElementDTO.addAttributeElementDTO(attributeElementDTO);
                    if (rowDTO.getAttributeDataType() != null && rowDTO.getAttributeDataType().trim().length() > 0) {
                        attributeElementDTO.setDataType(rowDTO.getAttributeDataType());
                    } else {
                        attributeElementDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
                    }
                    dtoList.add(attributesElementDTO);
                }
                continue;
            }
            AttributesElementDTO attributesElementDTO = (AttributesElementDTO)dtoMap.get(category);
            if (attributesElementDTO == null) {
                attributesElementDTO = new AttributesElementDTO();
                attributesElementDTO.setCategory(category);
            }
            String[] values = value.split(",");
            AttributeElementDTO attributeElementDTO = new AttributeElementDTO();
            attributeElementDTO.setAttributeValues(Arrays.asList(values));
            attributeElementDTO.setAttributeId(attributeId);
            attributeElementDTO.setIncludeInResult(rowDTO.isNotCompleted());
            attributesElementDTO.addAttributeElementDTO(attributeElementDTO);
            if (rowDTO.getAttributeDataType() != null && rowDTO.getAttributeDataType().trim().length() > 0) {
                attributeElementDTO.setDataType(rowDTO.getAttributeDataType());
            } else {
                attributeElementDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            }
            dtoMap.put(category, attributesElementDTO);
        }
        requestElement.setMultipleRequest(requestDTO.isMultipleRequest());
        requestElement.setCombinedDecision(requestDTO.isCombinedDecision());
        requestElement.setReturnPolicyIdList(requestDTO.isReturnPolicyIdList());
        if (!requestDTO.isMultipleRequest()) {
            dtoList = new ArrayList();
            for (Map.Entry entry : dtoMap.entrySet()) {
                dtoList.add(entry.getValue());
            }
        }
        requestElement.setAttributesElementDTOs(dtoList);
        return requestElement;
    }
}

