/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.wso2.balana.utils.policy.dto.BasicRuleDTO;
import org.wso2.balana.utils.policy.dto.BasicTargetDTO;
import org.wso2.carbon.identity.entitlement.common.dto.ExtendAttributeDTO;
import org.wso2.carbon.identity.entitlement.common.dto.ObligationDTO;
import org.wso2.carbon.identity.entitlement.common.dto.PolicyRefIdDTO;
import org.wso2.carbon.identity.entitlement.common.dto.PolicySetDTO;
import org.wso2.carbon.identity.entitlement.common.dto.RuleDTO;
import org.wso2.carbon.identity.entitlement.common.dto.SimplePolicyEditorDTO;
import org.wso2.carbon.identity.entitlement.common.dto.TargetDTO;
import org.wso2.carbon.identity.entitlement.stub.dto.EntitlementFinderDataHolder;
import org.wso2.carbon.identity.entitlement.stub.dto.EntitlementTreeNodeDTO;

public class EntitlementPolicyBean {
    public Map<String, String> functionIdMap = new HashMap<String, String>();
    public Map<String, String> functionIdElementValueMap = new HashMap<String, String>();
    private String policyName;
    private String algorithmName;
    private String policyDescription;
    private String userInputData;
    private List<String> subscribersList = new ArrayList<String>();
    private SimplePolicyEditorDTO SimplePolicyEditorDTO;
    private Map<String, String> categoryMap = new HashMap<String, String>();
    private Map<String, String> targetFunctionMap = new HashMap<String, String>();
    private Map<String, String> attributeIdMap = new HashMap<String, String>();
    private Map<String, String> ruleFunctionMap = new HashMap<String, String>();
    private boolean editPolicy;
    private String[] policyCombiningAlgorithms = new String[0];
    private Map<String, EntitlementFinderDataHolder> entitlementFinders = new HashMap<String, EntitlementFinderDataHolder>();
    private Map<Integer, String> selectedEntitlementData = new HashMap<Integer, String>();
    private Map<Integer, EntitlementTreeNodeDTO> entitlementLevelData = new HashMap<Integer, EntitlementTreeNodeDTO>();
    private BasicTargetDTO basicTargetDTO = null;
    private TargetDTO targetDTO = null;
    private PolicySetDTO policySetDTO = null;
    private List<BasicRuleDTO> basicRuleDTOs = new ArrayList<BasicRuleDTO>();
    private List<RuleDTO> ruleDTOs = new ArrayList<RuleDTO>();
    private List<ExtendAttributeDTO> extendAttributeDTOs = new ArrayList<ExtendAttributeDTO>();
    private List<ObligationDTO> obligationDTOs = new ArrayList<ObligationDTO>();
    private String ruleElementOrder;
    private String policyReferenceOrder;
    private Set<String> preFunctions = new HashSet<String>();
    private List<PolicyRefIdDTO> policyRefIds = new ArrayList<PolicyRefIdDTO>();

    public void cleanEntitlementPolicyBean() {
        this.policyName = null;
        this.algorithmName = null;
        this.policyDescription = null;
        this.userInputData = null;
        this.editPolicy = false;
        this.policySetDTO = null;
        this.functionIdMap.clear();
        this.functionIdElementValueMap.clear();
        this.basicRuleDTOs.clear();
        this.removeBasicTargetElementDTO();
        this.targetDTO = null;
        this.ruleDTOs.clear();
        this.extendAttributeDTOs.clear();
        this.obligationDTOs.clear();
        this.SimplePolicyEditorDTO = null;
        this.basicTargetDTO = null;
        this.policyReferenceOrder = null;
        this.policyRefIds.clear();
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getPolicyDescription() {
        return this.policyDescription;
    }

    public void setPolicyDescription(String policyDescription) {
        this.policyDescription = policyDescription;
    }

    public String getUserInputData() {
        return this.userInputData;
    }

    public void setUserInputData(String userInputData) {
        this.userInputData = userInputData;
    }

    public List<BasicRuleDTO> getBasicRuleDTOs() {
        return this.basicRuleDTOs;
    }

    public void setBasicRuleDTOs(List<BasicRuleDTO> basicRuleDTOs) {
        this.basicRuleDTOs = basicRuleDTOs;
    }

    public void setBasicRuleElementDTOs(BasicRuleDTO basicRuleDTO) {
        if (this.basicRuleDTOs.size() > 0) {
            ListIterator<BasicRuleDTO> iterator = this.basicRuleDTOs.listIterator();
            while (iterator.hasNext()) {
                BasicRuleDTO elementDTO = (BasicRuleDTO)iterator.next();
                if (!elementDTO.getRuleId().equals(basicRuleDTO.getRuleId())) continue;
                if (elementDTO.isCompletedRule()) {
                    basicRuleDTO.setCompletedRule(true);
                }
                iterator.remove();
            }
        }
        this.basicRuleDTOs.add(basicRuleDTO);
    }

    public BasicRuleDTO getBasicRuleElement(String ruleId) {
        if (this.basicRuleDTOs.size() > 0) {
            for (BasicRuleDTO basicRuleDTO : this.basicRuleDTOs) {
                if (!basicRuleDTO.getRuleId().equals(ruleId)) continue;
                return basicRuleDTO;
            }
        }
        return null;
    }

    public boolean removeBasicRuleElement(String ruleId) {
        if (this.basicRuleDTOs.size() > 0 && ruleId != null) {
            for (BasicRuleDTO basicRuleDTO : this.basicRuleDTOs) {
                if (!ruleId.equals(basicRuleDTO.getRuleId())) continue;
                return this.basicRuleDTOs.remove(basicRuleDTO);
            }
        }
        return false;
    }

    public void removeBasicRuleElements() {
        if (this.basicRuleDTOs.size() > 0) {
            ListIterator<BasicRuleDTO> iterator = this.basicRuleDTOs.listIterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public List<RuleDTO> getRuleDTOs() {
        return this.ruleDTOs;
    }

    public void setRuleDTOs(List<RuleDTO> ruleDTOs) {
        this.ruleDTOs = ruleDTOs;
    }

    public void setRuleDTO(RuleDTO ruleDTO) {
        if (this.ruleDTOs.size() > 0) {
            ListIterator<RuleDTO> iterator = this.ruleDTOs.listIterator();
            while (iterator.hasNext()) {
                RuleDTO elementDTO = (RuleDTO)iterator.next();
                if (!elementDTO.getRuleId().equals(ruleDTO.getRuleId())) continue;
                if (elementDTO.isCompletedRule()) {
                    ruleDTO.setCompletedRule(true);
                }
                iterator.remove();
            }
        }
        this.ruleDTOs.add(ruleDTO);
    }

    public RuleDTO getRuleDTO(String ruleId) {
        if (this.ruleDTOs.size() > 0) {
            for (RuleDTO ruleDTO : this.ruleDTOs) {
                if (!ruleDTO.getRuleId().equals(ruleId)) continue;
                return ruleDTO;
            }
        }
        return null;
    }

    public boolean removeRuleDTO(String ruleId) {
        if (this.ruleDTOs.size() > 0) {
            for (RuleDTO ruleDTO : this.ruleDTOs) {
                if (!ruleDTO.getRuleId().equals(ruleId)) continue;
                return this.ruleDTOs.remove(ruleDTO);
            }
        }
        return false;
    }

    public void removeRuleDTOs() {
        if (this.ruleDTOs.size() > 0) {
            ListIterator<RuleDTO> iterator = this.ruleDTOs.listIterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public List<ExtendAttributeDTO> getExtendAttributeDTOs() {
        return this.extendAttributeDTOs;
    }

    public void setExtendAttributeDTOs(List<ExtendAttributeDTO> extendAttributeDTOs) {
        this.extendAttributeDTOs = extendAttributeDTOs;
    }

    public List<ObligationDTO> getObligationDTOs() {
        return this.obligationDTOs;
    }

    public void setObligationDTOs(List<ObligationDTO> obligationDTOs) {
        this.obligationDTOs = obligationDTOs;
    }

    public void addExtendAttributeDTO(ExtendAttributeDTO extendAttributeDTO) {
        this.extendAttributeDTOs.add(extendAttributeDTO);
    }

    public BasicTargetDTO getBasicTargetDTO() {
        return this.basicTargetDTO;
    }

    public void setBasicTargetDTO(BasicTargetDTO basicTargetDTO) {
        this.basicTargetDTO = basicTargetDTO;
    }

    public void removeBasicTargetElementDTO() {
        this.basicTargetDTO = null;
    }

    public boolean isEditPolicy() {
        return this.editPolicy;
    }

    public void setEditPolicy(boolean editPolicy) {
        this.editPolicy = editPolicy;
    }

    public String[] getPolicyCombiningAlgorithms() {
        return Arrays.copyOf(this.policyCombiningAlgorithms, this.policyCombiningAlgorithms.length);
    }

    public void setPolicyCombiningAlgorithms(String[] policyCombiningAlgorithms) {
        this.policyCombiningAlgorithms = Arrays.copyOf(policyCombiningAlgorithms, policyCombiningAlgorithms.length);
    }

    public PolicySetDTO getPolicySetDTO() {
        return this.policySetDTO;
    }

    public void setPolicySetDTO(PolicySetDTO policySetDTO) {
        this.policySetDTO = policySetDTO;
    }

    public String getRuleElementOrder() {
        return this.ruleElementOrder;
    }

    public void setRuleElementOrder(String ruleElementOrder) {
        this.ruleElementOrder = ruleElementOrder;
    }

    public TargetDTO getTargetDTO() {
        return this.targetDTO;
    }

    public void setTargetDTO(TargetDTO targetDTO) {
        this.targetDTO = targetDTO;
    }

    public Map<String, String> getCategoryMap() {
        return this.categoryMap;
    }

    public void setCategoryMap(Map<String, String> categoryMap) {
        this.categoryMap = categoryMap;
    }

    public Set<String> getCategorySet() {
        return this.categoryMap.keySet();
    }

    public Map<String, String> getRuleFunctionMap() {
        return this.ruleFunctionMap;
    }

    public void setRuleFunctionMap(Map<String, String> ruleFunctionMap) {
        this.ruleFunctionMap = ruleFunctionMap;
    }

    public Map<String, String> getTargetFunctionMap() {
        return this.targetFunctionMap;
    }

    public void setTargetFunctionMap(Map<String, String> targetFunctionMap) {
        this.targetFunctionMap = targetFunctionMap;
    }

    public Map<String, String> getAttributeIdMap() {
        return this.attributeIdMap;
    }

    public void setAttributeIdMap(Map<String, String> attributeIdMap) {
        this.attributeIdMap = attributeIdMap;
    }

    public Set<String> getPreFunctions() {
        return this.preFunctions;
    }

    public void addPreFunction(String preFunction) {
        this.preFunctions.add(preFunction);
    }

    public SimplePolicyEditorDTO getSimplePolicyEditorDTO() {
        return this.SimplePolicyEditorDTO;
    }

    public void setSimplePolicyEditorDTO(SimplePolicyEditorDTO simplePolicyEditorDTO) {
        this.SimplePolicyEditorDTO = simplePolicyEditorDTO;
    }

    public Map<String, EntitlementFinderDataHolder> getEntitlementFinders() {
        return this.entitlementFinders;
    }

    public Set<EntitlementFinderDataHolder> getEntitlementFinders(String category) {
        HashSet<EntitlementFinderDataHolder> holders = new HashSet<EntitlementFinderDataHolder>();
        for (Map.Entry<String, EntitlementFinderDataHolder> entry : this.entitlementFinders.entrySet()) {
            EntitlementFinderDataHolder holder = entry.getValue();
            if (!Arrays.asList(holder.getSupportedCategory()).contains(category)) continue;
            holders.add(holder);
        }
        return holders;
    }

    public void setEntitlementFinders(String name, EntitlementFinderDataHolder entitlementFinders) {
        this.entitlementFinders.put(name, entitlementFinders);
    }

    public Map<Integer, String> getSelectedEntitlementData() {
        return this.selectedEntitlementData;
    }

    public Map<Integer, EntitlementTreeNodeDTO> getEntitlementLevelData() {
        return this.entitlementLevelData;
    }

    public List<PolicyRefIdDTO> getPolicyRefIds() {
        return this.policyRefIds;
    }

    public void setPolicyRefIds(List<PolicyRefIdDTO> policyRefIds) {
        this.policyRefIds = policyRefIds;
    }

    public void addPolicyRefId(PolicyRefIdDTO policyRefId) {
        ListIterator<PolicyRefIdDTO> iterator = this.policyRefIds.listIterator();
        while (iterator.hasNext()) {
            PolicyRefIdDTO dto = (PolicyRefIdDTO)iterator.next();
            if (policyRefId == null || !dto.getId().equalsIgnoreCase(policyRefId.getId())) continue;
            iterator.remove();
        }
        this.policyRefIds.add(policyRefId);
    }

    public void removePolicyRefId(String policyRefId) {
        ListIterator<PolicyRefIdDTO> iterator = this.policyRefIds.listIterator();
        while (iterator.hasNext()) {
            PolicyRefIdDTO dto = (PolicyRefIdDTO)iterator.next();
            if (policyRefId == null || !dto.getId().equalsIgnoreCase(policyRefId)) continue;
            iterator.remove();
        }
    }

    public String getPolicyReferenceOrder() {
        return this.policyReferenceOrder;
    }

    public void setPolicyReferenceOrder(String policyReferenceOrder) {
        this.policyReferenceOrder = policyReferenceOrder;
    }

    public List<String> getSubscribersList() {
        return this.subscribersList;
    }

    public void setSubscribersList(String[] subscribersList) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(subscribersList));
        this.subscribersList.addAll(list);
    }
}

