/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.keymgt.client.internal;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.apimgt.keymgt.client.internal.ServiceReferenceHolder;
import org.wso2.carbon.base.ServerConfiguration;

@Component(name="api.keymgt.client.component", immediate=true)
public class APIMKeyMgtClientComponent {
    private static final Log log = LogFactory.getLog(APIMKeyMgtClientComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            ConfigurationContext ctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.getClientRepoLocation(), (String)this.getAxis2ClientXmlLocation());
            ServiceReferenceHolder.getInstance().setAxis2ConfigurationContext(ctx);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Failed to initialize APIMKeyMgtClientComponent", (Throwable)axisFault);
        }
    }

    private String getAxis2ClientXmlLocation() {
        String axis2ClientXml = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.clientAxis2XmlLocation");
        return axis2ClientXml;
    }

    private String getClientRepoLocation() {
        String axis2ClientXml = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.ClientRepositoryLocation");
        return axis2ClientXml;
    }
}

