/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.core.Property;
import org.wso2.carbon.event.output.adapter.websocket.WebsocketEventAdapter;

public class WebsocketEventAdapterFactory
extends OutputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.output.adapter.websocket.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "websocket";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportedMessageFormats = new ArrayList<String>();
        supportedMessageFormats.add("text");
        supportedMessageFormats.add("xml");
        supportedMessageFormats.add("json");
        return supportedMessageFormats;
    }

    public List<Property> getStaticPropertyList() {
        ArrayList<Property> staticPropertyList = new ArrayList<Property>();
        Property adapterServerURL = new Property("websocket.server.url");
        adapterServerURL.setDisplayName(this.resourceBundle.getString("websocket.server.url"));
        adapterServerURL.setHint(this.resourceBundle.getString("websocket.server.url.hint"));
        adapterServerURL.setRequired(true);
        staticPropertyList.add(adapterServerURL);
        return staticPropertyList;
    }

    public List<Property> getDynamicPropertyList() {
        return null;
    }

    public String getUsageTips() {
        return null;
    }

    public OutputEventAdapter createEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new WebsocketEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

