/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.websocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.tyrus.client.ClientManager;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.output.adapter.websocket.internal.WebsocketClient;

public final class WebsocketEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(WebsocketEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private boolean doLogDroppedMessage;
    private Session session;
    private String socketServerUrl;
    private static ThreadPoolExecutor executorService;
    private int tenantId;

    public WebsocketEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.doLogDroppedMessage = true;
    }

    public void init() throws OutputEventAdapterException {
        this.validateOutputEventAdapterConfigurations();
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (executorService == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        this.connect();
    }

    public void connect() {
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().build();
        ClientManager client = ClientManager.createClient();
        this.socketServerUrl = (String)this.eventAdapterConfiguration.getStaticProperties().get("websocket.server.url");
        try {
            this.session = client.connectToServer((Endpoint)new WebsocketClient(), clientEndpointConfig, new URI(this.socketServerUrl));
        }
        catch (DeploymentException e) {
            throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " failed to connect to the websocket server " + this.socketServerUrl, (Throwable)e);
        }
        catch (IOException e) {
            throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " failed to connect to the websocket server " + this.socketServerUrl, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new OutputEventAdapterRuntimeException("The adapter " + this.eventAdapterConfiguration.getName() + " failed to connect to the websocket server " + this.socketServerUrl, (Throwable)e);
        }
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        try {
            if (this.session == null) {
                throw new ConnectionUnavailableException("Session was not available when trying to publish via adapter: " + this.eventAdapterConfiguration.getName() + ", tenant ID: " + this.tenantId + "\n Event: \n" + message);
            }
            if (!this.session.isOpen()) {
                throw new ConnectionUnavailableException("Session was not open when trying to publish via adapter: " + this.eventAdapterConfiguration.getName() + ", for tenant ID: " + this.tenantId + ". Session ID: " + this.session.getId() + " \n Event: \n" + message);
            }
            executorService.execute(new WebSocketSender(message.toString()));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (IOException e) {
            throw new OutputEventAdapterRuntimeException("The adapter " + this.eventAdapterConfiguration.getName() + " failed to disconnect from the websocket server " + this.socketServerUrl, (Throwable)e);
        }
    }

    public void destroy() {
    }

    public boolean isPolled() {
        return false;
    }

    private void validateOutputEventAdapterConfigurations() throws OutputEventAdapterException {
        String socketServerUrl = (String)this.eventAdapterConfiguration.getStaticProperties().get("websocket.server.url");
        if (!socketServerUrl.startsWith("ws://")) {
            throw new OutputEventAdapterException("Provided websocket URL - " + socketServerUrl + " is invalid for websocket output adapter with name" + this.eventAdapterConfiguration.getName() + ". The websocket URL should start with 'ws://' prefix.");
        }
    }

    private class WebSocketSender
    implements Runnable {
        private String message;

        public WebSocketSender(String message) {
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (WebsocketEventAdapter.this.session != null) {
                WebsocketEventAdapter.this.doLogDroppedMessage = true;
                Session session = WebsocketEventAdapter.this.session;
                synchronized (session) {
                    try {
                        WebsocketEventAdapter.this.session.getBasicRemote().sendText(this.message);
                    }
                    catch (IOException e) {
                        EventAdapterUtil.logAndDrop((String)WebsocketEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"Cannot send to endpoint", (Throwable)e, (Log)log, (int)WebsocketEventAdapter.this.tenantId);
                    }
                    catch (IllegalStateException ise) {
                        EventAdapterUtil.logAndDrop((String)WebsocketEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"Cannot send to endpoint", (Throwable)ise, (Log)log, (int)WebsocketEventAdapter.this.tenantId);
                    }
                }
            }
            if (WebsocketEventAdapter.this.doLogDroppedMessage) {
                EventAdapterUtil.logAndDrop((String)WebsocketEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"Cannot send as session not available", (Log)log, (int)WebsocketEventAdapter.this.tenantId);
                WebsocketEventAdapter.this.doLogDroppedMessage = false;
            }
        }
    }
}

