/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.ws.client.registry;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.security.components.crypto.Merlin;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.authenticator.stub.LogoutAuthenticationExceptionException;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.LogEntryCollection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.ws.client.internal.WSClientDataHolder;
import org.wso2.carbon.registry.ws.client.registry.PWCBHandler;
import org.wso2.carbon.registry.ws.client.registry.WSRegistryClientUtils;
import org.wso2.carbon.registry.ws.client.resource.OnDemandContentCollectionImpl;
import org.wso2.carbon.registry.ws.client.resource.OnDemandContentResourceImpl;
import org.wso2.carbon.registry.ws.stub.WSRegistryServiceStub;
import org.wso2.carbon.registry.ws.stub.xsd.WSAssociation;
import org.wso2.carbon.registry.ws.stub.xsd.WSCollection;
import org.wso2.carbon.registry.ws.stub.xsd.WSComment;
import org.wso2.carbon.registry.ws.stub.xsd.WSLogEntry;
import org.wso2.carbon.registry.ws.stub.xsd.WSResource;
import org.wso2.carbon.registry.ws.stub.xsd.WSTag;
import org.wso2.carbon.registry.ws.stub.xsd.WSTaggedResourcePath;
import org.wso2.carbon.utils.CarbonUtils;

public class WSRegistryServiceClient
implements Registry {
    private static final Log log = LogFactory.getLog(WSRegistryServiceClient.class);
    private WSRegistryServiceStub stub;
    AuthenticationAdminStub authenticationAdminStub;
    private String cookie;
    private String epr;

    public WSRegistryServiceClient(String backendServerURL, String cookie, long timeoutInMilliSeconds) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.initWithCookie(backendServerURL, cookie, timeoutInMilliSeconds);
    }

    public WSRegistryServiceClient(String backendServerURL, String cookie) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.initWithCookie(backendServerURL, cookie, 1000000L);
    }

    private void initWithCookie(String backendServerURL, String cookie, long timeOutInMilliSeconds) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.epr = backendServerURL + "WSRegistryService";
        this.setCookie(cookie);
        try {
            this.stub = CarbonUtils.isRunningOnLocalTransportMode() ? new WSRegistryServiceStub(WSClientDataHolder.getInstance().getConfigurationContext(), this.epr) : new WSRegistryServiceStub(this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
            this.stub._getServiceClient().getOptions().setProperty("enableMTOM", (Object)"true");
            this.stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(timeOutInMilliSeconds);
        }
        catch (Exception axisFault) {
            String msg = "Failed to initiate WSRegistry Service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)axisFault);
        }
    }

    public WSRegistryServiceClient(String serverURL, String username, String password, long timeOutInMilliSeconds, ConfigurationContext configContext) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.initWithUserNameAndPassword(serverURL, username, password, timeOutInMilliSeconds, configContext);
    }

    public WSRegistryServiceClient(String serverURL, String username, String password, ConfigurationContext configContext) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.initWithUserNameAndPassword(serverURL, username, password, 100000L, configContext);
    }

    public void initWithUserNameAndPassword(String serverURL, String username, String password, long timeOutInMilliSeconds, ConfigurationContext configContext) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.epr = serverURL + "WSRegistryService";
        try {
            this.authenticate(configContext, serverURL, username, password);
            this.stub = new WSRegistryServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)this.cookie);
            this.stub._getServiceClient().getOptions().setProperty("enableMTOM", (Object)"true");
            this.stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(timeOutInMilliSeconds);
        }
        catch (Exception axisFault) {
            String msg = "Failed to initiate WSRegistry Service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)axisFault);
        }
    }

    public WSRegistryServiceClient(String serverURL, String username, String password, String backendServerURL, long timeOutInMilliSeconds, ConfigurationContext configContext) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.initWithBackendURLUserNameAndPassword(serverURL, username, password, backendServerURL, timeOutInMilliSeconds, configContext);
    }

    public WSRegistryServiceClient(String serverURL, String username, String password, String backendServerURL, ConfigurationContext configContext) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.initWithBackendURLUserNameAndPassword(serverURL, username, password, backendServerURL, 1000000L, configContext);
    }

    private void initWithBackendURLUserNameAndPassword(String serverURL, String username, String password, String backendServerURL, long timeOutInMilliSeconds, ConfigurationContext configContext) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        this.epr = backendServerURL + "WSRegistryService";
        String policyPath = "META-INF/policy.xml";
        try {
            this.authenticate(configContext, serverURL, username, password);
            this.stub = new WSRegistryServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)this.cookie);
            this.stub._getServiceClient().getOptions().setProperty("enableMTOM", (Object)"true");
            this.stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(timeOutInMilliSeconds);
        }
        catch (Exception axisFault) {
            String msg = "Failed to initiate WSRegistry Service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)axisFault);
        }
    }

    public boolean authenticate(ConfigurationContext ctx, String serverURL, String username, String password) throws AxisFault, AuthenticationException {
        String serviceEPR = serverURL + "AuthenticationAdmin";
        this.authenticationAdminStub = new AuthenticationAdminStub(ctx, serviceEPR);
        ServiceClient client = this.authenticationAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        try {
            boolean result = this.authenticationAdminStub.login(username, password, new URL(serviceEPR).getHost());
            if (result) {
                this.setCookie((String)this.authenticationAdminStub._getServiceClient().getServiceContext().getProperty("Cookie"));
            }
            return result;
        }
        catch (Exception e) {
            String msg = "Error occurred while logging in";
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }

    public void logut() throws RemoteException, LogoutAuthenticationExceptionException {
        this.authenticationAdminStub.logout();
    }

    private static Policy loadPolicy(String xmlPath) throws FileNotFoundException, XMLStreamException {
        StAXOMBuilder builder = new StAXOMBuilder(xmlPath);
        return PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
    }

    public void addSecurityOptions(String policyPath, String keyStore, String userName, String password) throws AxisFault, FileNotFoundException, XMLStreamException {
        ServiceClient client = this.stub._getServiceClient();
        Policy policy = WSRegistryServiceClient.loadPolicy(policyPath);
        Properties merlinProp = new Properties();
        merlinProp.put("org.apache.ws.security.crypto.merlin.keystore.type", "JKS");
        merlinProp.put("org.apache.ws.security.crypto.merlin.file", keyStore);
        merlinProp.put("org.apache.ws.security.crypto.merlin.keystore.password", "wso2carbon");
        CryptoConfig sigCryptoConfig = new CryptoConfig();
        sigCryptoConfig.setProvider(Merlin.class.getName());
        sigCryptoConfig.setProp(merlinProp);
        CryptoConfig encCryptoConfig = new CryptoConfig();
        encCryptoConfig.setProvider(Merlin.class.getName());
        encCryptoConfig.setProp(merlinProp);
        RampartConfig rampartConfig = new RampartConfig();
        rampartConfig.setEncryptionUser("wso2carbon");
        rampartConfig.setUserCertAlias("wso2carbon");
        rampartConfig.setPwCbClass(PWCBHandler.class.getName());
        rampartConfig.setSigCryptoConfig(sigCryptoConfig);
        rampartConfig.setEncrCryptoConfig(encCryptoConfig);
        policy.addAssertion((Assertion)rampartConfig);
        Options options = client.getOptions();
        options.setProperty("rampartPolicy", (Object)policy);
        options.setUserName(userName);
        options.setPassword(password);
        client.engageModule("rampart");
    }

    public Resource newResource() {
        return new ResourceImpl();
    }

    public org.wso2.carbon.registry.core.Collection newCollection() {
        return new CollectionImpl(new String[0]);
    }

    public Resource get(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            Resource resource;
            String[] pathParts;
            if (path.contains(";comments")) {
                String[] pathParts2 = path.split(";comments");
                if (pathParts2.length < 2) {
                    Comment[] comments = this.getComments(pathParts2[0]);
                    CollectionImpl resource2 = new CollectionImpl();
                    resource2.setContent((Object)comments);
                    return resource2;
                }
                return this.getSingleComment(path);
            }
            if (path.contains(";ratings") && (pathParts = path.split(";ratings:")).length > 1) {
                int rating = this.getRating(pathParts[0], pathParts[1]);
                Resource resource3 = this.getMetaData(pathParts[0]);
                resource3.setContent((Object)rating);
                return resource3;
            }
            WSResource wsResource = this.stub.wSget(path);
            Object content = null;
            if (wsResource.getCollection()) {
                resource = WSRegistryClientUtils.transformWSCollectiontoCollection(this, (WSCollection)wsResource, content);
                ((OnDemandContentCollectionImpl)resource).setPathWithVersion(path);
            } else {
                resource = WSRegistryClientUtils.transformWSResourcetoResource(this, wsResource, content);
                ((OnDemandContentResourceImpl)resource).setPathWithVersion(path);
            }
            return resource;
        }
        catch (Exception e) {
            String msg = "Failed to perform get operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    private Comment getSingleComment(String commentPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSComment wsComment = this.stub.wSgetSingleComment(commentPath);
            return WSRegistryClientUtils.WSCommenttoRegistryComment(wsComment);
        }
        catch (Exception e) {
            String msg = "Failed to perform the operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void setTenantId(int tenantId) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.setTenantId(tenantId);
        }
        catch (Exception e) {
            String msg = "Failed to perform the operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public Resource getMetaData(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSResource wsResource = this.stub.wSgetMetaData(path);
            Object content = null;
            Resource resource = WSRegistryClientUtils.transformWSResourcetoResource(this, wsResource, content);
            return resource;
        }
        catch (Exception e) {
            String msg = "Failed to perform getMetaData operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public org.wso2.carbon.registry.core.Collection get(String path, int start, int pageSize) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSCollection wsCollection = this.stub.wSgetWithPageSize(path, start, pageSize);
            Object content = null;
            org.wso2.carbon.registry.core.Collection collection = WSRegistryClientUtils.transformWSCollectiontoCollection(this, wsCollection, content);
            ((OnDemandContentCollectionImpl)collection).setPathWithVersion(path + ";start=" + start + ";pageSize=" + pageSize);
            return collection;
        }
        catch (Exception e) {
            String msg = "Failed to perform get operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public boolean resourceExists(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.resourceExists(path);
        }
        catch (Exception e) {
            String msg = "Failed to perform resourceExists operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String put(String path, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            String string;
            File tempFile = File.createTempFile("wsResource", "tmp");
            tempFile.deleteOnExit();
            DataHandler dataHandler = WSRegistryClientUtils.makeDataHandler(resource, tempFile);
            if (resource instanceof org.wso2.carbon.registry.core.Collection) {
                WSResource wsCollection = WSRegistryClientUtils.transformResourceToWSResource(resource, dataHandler);
                wsCollection.setCollection(true);
                string = this.stub.wSput(path, wsCollection);
            } else {
                WSResource wsResource = WSRegistryClientUtils.transformResourceToWSResource(resource, dataHandler);
                string = this.stub.wSput(path, wsResource);
            }
            return string;
        }
        catch (Exception e) {
            String msg = "Failed to perform put operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void delete(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.delete(path);
        }
        catch (Exception e) {
            String msg = "Failed to perform delete operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String importResource(String suggestedPath, String sourceURL, Resource resource) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            DataHandler dataHandler = null;
            File tempFile = File.createTempFile("wsResource", "tmp");
            tempFile.deleteOnExit();
            try {
                dataHandler = WSRegistryClientUtils.makeDataHandler(resource, tempFile);
            }
            catch (IOException e) {
                log.error((Object)"WSGet failed - Unable to generate temp file", (Throwable)e);
            }
            WSResource wsResource = WSRegistryClientUtils.transformResourceToWSResource(resource, dataHandler);
            return this.stub.wSimportResource(suggestedPath, sourceURL, wsResource);
        }
        catch (Exception e) {
            String msg = "Failed to perform importResource operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String rename(String currentPath, String newName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.rename(currentPath, newName);
        }
        catch (Exception e) {
            String msg = "Failed to perform rename operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String move(String currentPath, String newPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.move(currentPath, newPath);
        }
        catch (Exception e) {
            String msg = "Failed to perform move operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String copy(String currentPath, String targetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.copy(currentPath, targetPath);
        }
        catch (Exception e) {
            String msg = "Failed to perform copy operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void createVersion(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.createVersion(path);
        }
        catch (Exception e) {
            String msg = "Failed to perform createVersion operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String[] getVersions(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.getVersions(path);
        }
        catch (Exception e) {
            String msg = "Failed to perform getVersions operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void restoreVersion(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.restoreVersion(path);
        }
        catch (Exception e) {
            String msg = "Failed to perform restoreVersion operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void addAssociation(String resourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.addAssociation(resourcePath, targetPath, associationType);
        }
        catch (Exception e) {
            String msg = "Failed to perform addAssociation operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void removeAssociation(String resourcePath, String targetPath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.removeAssociation(resourcePath, targetPath, associationType);
        }
        catch (Exception e) {
            String msg = "Failed to perform removeAssociation operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public Association[] getAllAssociations(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSAssociation[] wsAssociations = this.stub.wSgetAllAssociations(path);
            if (null == wsAssociations) {
                return new Association[0];
            }
            Association[] associations = new Association[wsAssociations.length];
            for (int i = 0; i < associations.length; ++i) {
                associations[i] = WSRegistryClientUtils.transformWSAssociationToAssociation(wsAssociations[i]);
            }
            return associations;
        }
        catch (Exception e) {
            String msg = "Failed to perform getAllAssociations operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public Association[] getAssociations(String resourcePath, String associationType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSAssociation[] wsAssociations = this.stub.wSgetAssociations(resourcePath, associationType);
            if (null == wsAssociations) {
                return new Association[0];
            }
            Association[] associations = new Association[wsAssociations.length];
            for (int i = 0; i < associations.length; ++i) {
                associations[i] = WSRegistryClientUtils.transformWSAssociationToAssociation(wsAssociations[i]);
            }
            return associations;
        }
        catch (Exception e) {
            String msg = "Failed to perform getAssociations operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void applyTag(String resourcePath, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.applyTag(resourcePath, tag);
        }
        catch (Exception e) {
            String msg = "Failed to perform applyTag operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public TaggedResourcePath[] getResourcePathsWithTag(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSTaggedResourcePath[] wsTaggedResourcePaths = this.stub.wSgetResourcePathsWithTag(path);
            return WSRegistryClientUtils.exchangeWSResourcePath(wsTaggedResourcePaths);
        }
        catch (Exception e) {
            String msg = "Failed to perform getResourcePathsWithTag operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public Tag[] getTags(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSTag[] wsTags;
            if (PaginationContext.getInstance() == null) {
                wsTags = this.stub.wSgetTags(resourcePath);
            } else {
                PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
                wsTags = this.stub.wSgetTags(resourcePath);
                int n = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            }
            if (null == wsTags) {
                Tag[] tagArray = new Tag[]{};
                return tagArray;
            }
            Tag[] tags = new Tag[wsTags.length];
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = WSRegistryClientUtils.transformWSTagToTag(wsTags[i]);
            }
            Tag[] tagArray = tags;
            return tagArray;
        }
        catch (Exception e) {
            String msg = "Failed to perform getTags operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
        finally {
            PaginationContext.destroy();
        }
    }

    public void removeTag(String path, String tag) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.removeTag(path, tag);
        }
        catch (Exception e) {
            String msg = "Failed to perform removeTag operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String addComment(String resourcePath, Comment comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSComment wsComment = WSRegistryClientUtils.RegistryCommenttoWSComment(comment);
            return this.stub.wSaddComment(resourcePath, wsComment);
        }
        catch (Exception e) {
            String msg = "Failed to perform addComment operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void editComment(String commentPath, String text) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.editComment(commentPath, text);
        }
        catch (Exception e) {
            String msg = "Failed to perform editComment operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public Comment[] getComments(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSComment[] wsComment;
            if (PaginationContext.getInstance() == null) {
                wsComment = this.stub.wSgetComments(resourcePath);
            } else {
                PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
                wsComment = this.stub.wSgetComments(resourcePath);
                int n = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            }
            if (null == wsComment) {
                return new Comment[0];
            }
            Comment[] comment = new Comment[wsComment.length];
            for (int i = 0; i < wsComment.length; ++i) {
                comment[i] = WSRegistryClientUtils.WSCommenttoRegistryComment(wsComment[i]);
            }
            return comment;
        }
        catch (Exception e) {
            String msg = "Failed to perform getComments operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void rateResource(String resourcePath, int rating) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.rateResource(resourcePath, rating);
        }
        catch (Exception e) {
            String msg = "Failed to perform rateResource operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public float getAverageRating(String resourcePath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.getAverageRating(resourcePath);
        }
        catch (Exception e) {
            String msg = "Failed to perform getAverageRating operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public int getRating(String path, String username) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.getRating(path, username);
        }
        catch (Exception e) {
            String msg = "Failed to perform getRating operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public org.wso2.carbon.registry.core.Collection executeQuery(String path, Map parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            LinkedList<String> value = new LinkedList<String>();
            LinkedList<String> key = new LinkedList<String>();
            Iterator iterator = parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e;
                Map.Entry entry = e = iterator.next();
                value.add((String)entry.getValue());
                key.add((String)entry.getKey());
            }
            WSCollection wsCollection = this.stub.wSexecuteQuery(path, key.toArray(new String[key.size()]), value.toArray(new String[value.size()]));
            Object content = null;
            return WSRegistryClientUtils.transformWSCollectiontoCollection(this, wsCollection, content);
        }
        catch (Exception e) {
            String msg = "Failed to perform executeQuery operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public LogEntry[] getLogs(String resourcePath, int action, String userName, Date from, Date to, boolean recentFirst) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSLogEntry[] wsLogEntries;
            if (PaginationContext.getInstance() == null) {
                wsLogEntries = this.stub.wSgetLogs(resourcePath, action, userName, from, to, recentFirst);
            } else {
                PaginationUtils.copyPaginationContext((ServiceClient)this.stub._getServiceClient());
                wsLogEntries = this.stub.wSgetLogs(resourcePath, action, userName, from, to, recentFirst);
                int n = PaginationUtils.getRowCount((ServiceClient)this.stub._getServiceClient());
            }
            if (null == wsLogEntries) {
                return new LogEntry[0];
            }
            LogEntry[] logEntries = new LogEntry[wsLogEntries.length];
            for (int i = 0; i < logEntries.length; ++i) {
                logEntries[i] = WSRegistryClientUtils.transformWSLogEntryToLogEntry(wsLogEntries[i]);
            }
            return logEntries;
        }
        catch (Exception e) {
            String msg = "Failed to perform getLogs operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String[] getAvailableAspects() {
        try {
            return this.stub.getAvailableAspects();
        }
        catch (Exception e) {
            String msg = "Failed to perform getAvailableAspects operation.";
            log.error((Object)msg, (Throwable)e);
            return new String[0];
        }
    }

    public void associateAspect(String resourcePath, String aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.associateAspect(resourcePath, aspect);
        }
        catch (Exception e) {
            String msg = "Failed to perform associateAspect operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void invokeAspect(String resourcePath, String aspectName, String action) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.invokeAspectNoParam(resourcePath, aspectName, action);
        }
        catch (Exception e) {
            String msg = "Failed to perform invokeAspect operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void invokeAspect(String resourcePath, String aspectName, String action, Map<String, String> parameters) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            Set<String> keys = parameters.keySet();
            Collection<String> values = parameters.values();
            this.stub.invokeAspectWithParam(resourcePath, aspectName, action, keys.toArray(new String[keys.size()]), values.toArray(new String[values.size()]));
        }
        catch (Exception e) {
            String msg = "Failed to perform invokeAspect operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String[] getAspectActions(String resourcePath, String aspectName) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.getAspectActions(resourcePath, aspectName);
        }
        catch (Exception e) {
            String msg = "Failed to perform getAspectActions operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public org.wso2.carbon.registry.core.Collection searchContent(String keyword) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            WSCollection wsCollection = this.stub.wSsearchContent(keyword);
            Object content = null;
            return WSRegistryClientUtils.transformWSCollectiontoCollection(this, wsCollection, content);
        }
        catch (Exception e) {
            String msg = "Failed to perform searchContent operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void createLink(String path, String target) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.createLinkWithSubTarget(path, target, null);
        }
        catch (Exception e) {
            String msg = "Failed to perform createLink operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void createLink(String path, String target, String subTargetPath) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.createLinkWithSubTarget(path, target, subTargetPath);
        }
        catch (Exception e) {
            String msg = "Failed to perform createLink operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void removeLink(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.removeLink(path);
        }
        catch (Exception e) {
            String msg = "Failed to perform removeLink operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public String getEventingServiceURL(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.getEventingServiceURL(path);
        }
        catch (Exception e) {
            String msg = "Failed to perform getEventingServiceURL operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void setEventingServiceURL(String path, String serviceURL) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.setEventingServiceURL(path, serviceURL);
        }
        catch (Exception e) {
            String msg = "Failed to perform setEventingServiceURL operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public boolean removeAspect(String name) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.removeAspect(name);
        }
        catch (Exception e) {
            String msg = "Failed to perform removeAspect operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void removeComment(String comment) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            this.stub.removeComment(comment);
        }
        catch (Exception e) {
            String msg = "Failed to perform removeComment operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public boolean removeVersionHistory(String path, long regVersion) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            return this.stub.removeVersionHistory(path, regVersion);
        }
        catch (Exception e) {
            String msg = "Failed to remove version: " + regVersion + " of the resource " + path;
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void dumpLite(String s, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }

    public void beginTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }

    public void commitTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }

    public void rollbackTransaction() throws org.wso2.carbon.registry.core.exceptions.RegistryException {
    }

    public String importResource(String suggestedPath, String sourceURL, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.importResource(suggestedPath, sourceURL, (Resource)resource);
    }

    public String addComment(String resourcePath, org.wso2.carbon.registry.api.Comment comment) throws RegistryException {
        return this.addComment(resourcePath, (Comment)comment);
    }

    public String put(String suggestedPath, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        return this.put(suggestedPath, (Resource)resource);
    }

    public boolean addAspect(String s, Aspect aspect) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public void dump(String s, Writer writer) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            String inputLine;
            DataHandler dataHandler = this.stub.wsDump(s);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(WSRegistryClientUtils.makeBytesFromDataHandler(dataHandler));
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((inputLine = reader.readLine()) != null) {
                writer.append(inputLine);
            }
            writer.flush();
            reader.close();
        }
        catch (Exception e) {
            String msg = "Failed to perform dump operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public void restore(String path, Reader reader) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            String inputLine;
            BufferedReader bufferedReader = new BufferedReader(reader);
            File tempFile = new File("tempFile");
            tempFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            OutputStreamWriter writer = new OutputStreamWriter(fileOutputStream);
            while ((inputLine = bufferedReader.readLine()) != null) {
                ((Writer)writer).append(inputLine);
            }
            ((Writer)writer).flush();
            fileOutputStream.close();
            ((Writer)writer).close();
            bufferedReader.close();
            DataHandler handler = new DataHandler((DataSource)new FileDataSource(tempFile));
            this.stub.wsRestore(path, handler);
            boolean bl = tempFile.delete();
        }
        catch (Exception e) {
            String msg = "Failed to perform restore operation.";
            log.error((Object)msg, (Throwable)e);
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
        }
    }

    public LogEntryCollection getLogCollection(String s, int i, String s1, Date date, Date date1, boolean b) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public RegistryContext getRegistryContext() {
        return RegistryContext.getBaseInstance();
    }

    public byte[] getContent(String path) throws Exception {
        DataHandler dataHandler = this.stub.getContent(path);
        return WSRegistryClientUtils.makeBytesFromDataHandler(dataHandler);
    }

    public String[] getCollectionContent(String path) throws Exception {
        return this.stub.getCollectionContent(path);
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public void setStub(WSRegistryServiceStub stub) {
        this.stub = stub;
    }

    public WSRegistryServiceStub getStub() {
        return this.stub;
    }

    public void setEpr(String epr) {
        this.epr = epr;
    }
}

