/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.helpers;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.base.CharMatcher;

public abstract class HexStringFormatAttribute
extends AbstractFormatAttribute {
    private static final CharMatcher HEX_CHARS = CharMatcher.anyOf((CharSequence)"0123456789abcdefABCDEF").precomputed();
    protected final int length;

    protected HexStringFormatAttribute(String fmt, int length) {
        super(fmt, NodeType.STRING, new NodeType[0]);
        this.length = length;
    }

    @Override
    public final void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (this.length != input.length()) {
            report.error(this.newMsg(data, bundle, "err.format.hexString.badLength").putArgument("actual", input.length()).putArgument("expected", this.length));
            return;
        }
        if (HEX_CHARS.matchesAllOf((CharSequence)input)) {
            return;
        }
        int index = HEX_CHARS.negate().indexIn((CharSequence)input);
        report.error(this.newMsg(data, bundle, "err.format.hexString.illegalChar").putArgument("character", Character.toString(input.charAt(index))).putArgument("index", index));
    }
}

