/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.extra;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.base.CharMatcher;
import java.util.regex.Pattern;

public final class Base64FormatAttribute
extends AbstractFormatAttribute {
    private static final Pattern PATTERN = Pattern.compile("==?$");
    private static final CharMatcher NOT_BASE64 = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"+/")).negate();
    private static final FormatAttribute instance = new Base64FormatAttribute();

    public static FormatAttribute getInstance() {
        return instance;
    }

    private Base64FormatAttribute() {
        super("base64", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (input.length() % 4 != 0) {
            report.error(this.newMsg(data, bundle, "err.format.base64.badLength").putArgument("length", input.length()));
            return;
        }
        int index = NOT_BASE64.indexIn((CharSequence)PATTERN.matcher(input).replaceFirst(""));
        if (index == -1) {
            return;
        }
        report.error(this.newMsg(data, bundle, "err.format.base64.illegalChars").putArgument("character", Character.toString(input.charAt(index))).putArgument("index", index));
    }
}

