/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.authentication.analytics.session.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.session.AnalyticsSessionDataPublishHandler;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.session.internal.SessionDataPublishServiceHolder;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;

@Component(name="identity.data.publisher.authentication.analytics.session", immediate=true)
public class SessionDataPublishServiceComponent {
    private static final Log log = LogFactory.getLog(SessionDataPublishServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            bundleContext.registerService(AbstractEventHandler.class, (Object)new AnalyticsSessionDataPublishHandler(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"org.wso2.carbon.identity.data.publisher.authentication.analytics.session bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating org.wso2.carbon.identity.data.publisher.authentication.analytics.session", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"org.wso2.carbon.identity.data.publisher.authentication.analytics.session bundle is deactivated");
        }
    }

    @Reference(name="EventStreamService", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Event Stream Service");
        }
        SessionDataPublishServiceHolder.getInstance().setPublisherService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the Event Stream Service");
        }
        SessionDataPublishServiceHolder.getInstance().setPublisherService(null);
    }
}

