/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.authentication.analytics.session;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.data.publisher.application.authentication.AuthnDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.session.model.SessionData;
import org.wso2.carbon.identity.event.event.Event;

public class SessionDataPublisherUtil {
    private static final Log LOG = LogFactory.getLog(SessionDataPublisherUtil.class);

    public static SessionData buildSessionData(Event event) {
        Map properties = event.getEventProperties();
        HttpServletRequest request = (HttpServletRequest)properties.get("request");
        Map params = (Map)properties.get("params");
        SessionContext sessionContext = (SessionContext)properties.get("sessionContext");
        AuthenticationContext context = (AuthenticationContext)properties.get("context");
        SessionData sessionData = new SessionData();
        Object userObj = params.get("user");
        SessionDataPublisherUtil.setUserDataToSessionObject(sessionData, userObj);
        String sessionId = (String)params.get("sessionId");
        sessionData.setSessionId(sessionId);
        sessionData.setSessionContext(sessionContext);
        sessionData.setIdentityProviders(SessionDataPublisherUtil.getCommaSeparatedIDPs(sessionContext));
        if (sessionContext != null) {
            sessionData.setIsRememberMe(sessionContext.isRememberMe());
        }
        if (context != null) {
            SessionDataPublisherUtil.setTenantDataToSessionObject(context, sessionData);
            sessionData.setServiceProvider(context.getServiceProviderName());
        }
        if (request != null) {
            sessionData.setUserAgent(request.getHeader("User-Agent"));
            sessionData.setRemoteIP(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        }
        if (params.containsKey("activeSessionCount")) {
            int activeSessionCount = (Integer)params.get("activeSessionCount");
            sessionData.setActiveSessionCount(activeSessionCount);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("A Session data object created for event :" + event.getEventName()));
        }
        return sessionData;
    }

    private static void setTenantDataToSessionObject(AuthenticationContext context, SessionData sessionData) {
        if (context.getSequenceConfig() != null) {
            if (context.getSequenceConfig().getApplicationConfig().isSaaSApp()) {
                sessionData.addParameter("tenantId", AuthnDataPublisherUtils.getTenantDomains((String)context.getTenantDomain(), (String)sessionData.getTenantDomain()));
            } else {
                sessionData.addParameter("tenantId", new String[]{sessionData.getTenantDomain()});
            }
        }
    }

    private static void setUserDataToSessionObject(SessionData sessionData, Object userObj) {
        String userName = null;
        String userStoreDomain = null;
        String tenantDomain = null;
        if (userObj != null && userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            userName = user.getUserName();
            userStoreDomain = user.getUserStoreDomain();
            tenantDomain = user.getTenantDomain();
        }
        sessionData.setUser(userName);
        sessionData.setUserStoreDomain(userStoreDomain);
        sessionData.setTenantDomain(tenantDomain);
    }

    public static void updateTimeStamps(SessionData sessionData, int actionId) {
        SessionContext sessionContext = null;
        if (sessionData != null) {
            sessionContext = sessionData.getSessionContext();
        }
        Long createdTime = null;
        Long terminationTime = null;
        Long updatedTime = null;
        if (sessionContext != null) {
            Object createdTimeObj = sessionContext.getProperty("CreatedTimestamp");
            createdTime = (Long)createdTimeObj;
            if (actionId == 1) {
                terminationTime = AuthnDataPublisherUtils.getSessionExpirationTime((long)createdTime, (long)createdTime, (String)sessionData.getTenantDomain(), (boolean)sessionContext.isRememberMe());
                updatedTime = createdTime;
            } else if (actionId == 2) {
                Long currentTime = System.currentTimeMillis();
                terminationTime = AuthnDataPublisherUtils.getSessionExpirationTime((long)createdTime, (long)createdTime, (String)sessionData.getTenantDomain(), (boolean)sessionContext.isRememberMe());
                updatedTime = currentTime;
            } else if (actionId == 0) {
                Long currentTime;
                terminationTime = currentTime = Long.valueOf(System.currentTimeMillis());
                updatedTime = currentTime;
            }
        }
        if (sessionData != null) {
            sessionData.setCreatedTimestamp(createdTime);
            sessionData.setUpdatedTimestamp(updatedTime);
            sessionData.setTerminationTimestamp(terminationTime);
        }
    }

    private static String getCommaSeparatedIDPs(SessionContext sessionContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Retrieving current IDPw for user ");
        }
        if (sessionContext == null || sessionContext.getAuthenticatedIdPs() == null || sessionContext.getAuthenticatedIdPs().isEmpty()) {
            return "";
        }
        Iterator iterator = sessionContext.getAuthenticatedIdPs().entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry pair = iterator.next();
            sb.append(",").append(pair.getKey());
        }
        if (sb.length() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning roles, " + sb.substring(1)));
            }
            return sb.substring(1);
        }
        return "";
    }
}

