/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.authentication.analytics.session;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.AbstractIdentityMessageHandler;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.data.publisher.application.authentication.AuthnDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.session.SessionDataPublisherUtil;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.session.internal.SessionDataPublishServiceHolder;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.session.model.SessionData;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;

public class AnalyticsSessionDataPublishHandler
extends AbstractEventHandler {
    private static final Log LOG = LogFactory.getLog(AnalyticsSessionDataPublishHandler.class);

    public String getName() {
        return "analyticsSessionDataPublisher";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        boolean isEnabled = this.isAnalyticsSessionDataPublishingEnabled(event);
        if (!isEnabled) {
            return;
        }
        SessionData sessionData = SessionDataPublisherUtil.buildSessionData(event);
        if (IdentityEventConstants.EventName.SESSION_CREATE.name().equals(event.getEventName())) {
            this.doPublishSessionCreation(sessionData);
        } else if (IdentityEventConstants.EventName.SESSION_TERMINATE.name().equals(event.getEventName())) {
            this.doPublishSessionTermination(sessionData);
        } else if (IdentityEventConstants.EventName.SESSION_UPDATE.name().equals(event.getEventName())) {
            this.doPublishSessionUpdate(sessionData);
        } else {
            LOG.error((Object)("Event " + event.getEventName() + " cannot be handled"));
        }
    }

    protected void doPublishSessionCreation(SessionData sessionData) {
        this.publishSessionData(sessionData, 1);
    }

    protected void doPublishSessionTermination(SessionData sessionData) {
        this.publishSessionData(sessionData, 0);
    }

    protected void doPublishSessionUpdate(SessionData sessionData) {
        this.publishSessionData(sessionData, 2);
    }

    protected void publishSessionData(SessionData sessionData, int actionId) {
        block4: {
            SessionDataPublisherUtil.updateTimeStamps(sessionData, actionId);
            try {
                if (this.isPublishingSessionCountEnabled()) {
                    Object[] payloadData = this.createPayloadWithSessionCount(sessionData, actionId);
                    this.publishToAnalytics(sessionData, payloadData, "org.wso2.is.analytics.stream.OverallSession:1.0.1");
                } else {
                    Object[] payloadData = this.createPayload(sessionData, actionId);
                    this.publishToAnalytics(sessionData, payloadData, "org.wso2.is.analytics.stream.OverallSession:1.0.0");
                }
            }
            catch (IdentityRuntimeException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.error((Object)"Error while publishing session information", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishToAnalytics(SessionData sessionData, Object[] payloadData, String eventStreamName) {
        String[] publishingDomains = (String[])sessionData.getParameter("tenantId");
        if (publishingDomains != null && publishingDomains.length > 0) {
            try {
                FrameworkUtils.startTenantFlow((String)"carbon.super");
                for (String publishingDomain : publishingDomains) {
                    Object[] metadataArray = AuthnDataPublisherUtils.getMetaDataArray((String)publishingDomain);
                    org.wso2.carbon.databridge.commons.Event event = new org.wso2.carbon.databridge.commons.Event(eventStreamName, System.currentTimeMillis(), metadataArray, null, payloadData);
                    SessionDataPublishServiceHolder.getInstance().getPublisherService().publish(event);
                    if (!LOG.isDebugEnabled() || event == null) continue;
                    LOG.debug((Object)("Sending out to publishing domain:" + publishingDomain + " \n event : " + event.toString()));
                }
            }
            finally {
                FrameworkUtils.endTenantFlow();
            }
        }
    }

    private Object[] createPayload(SessionData sessionData, int actionId) {
        Object[] payloadData = new Object[]{AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.sessionId", (String)sessionData.getSessionId()), sessionData.getCreatedTimestamp(), sessionData.getUpdatedTimestamp(), sessionData.getTerminationTimestamp(), actionId, AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userName", (String)sessionData.getUser()), AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userStoreDomain", (String)sessionData.getUserStoreDomain()), sessionData.getRemoteIP(), "NOT_AVAILABLE", sessionData.getTenantDomain(), sessionData.getServiceProvider(), sessionData.getIdentityProviders(), sessionData.isRememberMe(), sessionData.getUserAgent(), System.currentTimeMillis()};
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The created payload :" + Arrays.asList(payloadData)));
        }
        return payloadData;
    }

    private Object[] createPayloadWithSessionCount(SessionData sessionData, int actionId) {
        Object[] payloadData = new Object[]{AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.sessionId", (String)sessionData.getSessionId()), sessionData.getCreatedTimestamp(), sessionData.getUpdatedTimestamp(), sessionData.getTerminationTimestamp(), actionId, AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userName", (String)sessionData.getUser()), AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userStoreDomain", (String)sessionData.getUserStoreDomain()), sessionData.getRemoteIP(), "NOT_AVAILABLE", sessionData.getTenantDomain(), sessionData.getServiceProvider(), sessionData.getIdentityProviders(), sessionData.isRememberMe(), sessionData.getUserAgent(), sessionData.getActiveSessionCount(), System.currentTimeMillis()};
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The created payload :" + Arrays.asList(payloadData)));
        }
        return payloadData;
    }

    public boolean isEnabled(MessageContext messageContext) {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)AbstractIdentityMessageHandler.class.getName(), (String)((Object)((Object)this)).getClass().getName());
        if (identityEventListenerConfig == null) {
            return false;
        }
        return Boolean.parseBoolean(identityEventListenerConfig.getEnable());
    }

    private boolean isAnalyticsSessionDataPublishingEnabled(Event event) throws IdentityEventException {
        if (this.configs.getModuleProperties() != null) {
            String handlerEnabled = this.configs.getModuleProperties().getProperty("analyticsSessionDataPublisher.enable");
            return Boolean.parseBoolean(handlerEnabled);
        }
        return false;
    }

    private boolean isPublishingSessionCountEnabled() {
        String isPublishingSessionCountEnabledValue = IdentityUtil.getProperty((String)"Analytics.PublishActiveSessionCount");
        return Boolean.parseBoolean(isPublishingSessionCountEnabledValue);
    }
}

