/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.email;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.email.EmailEventAdapter;

public class EmailEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.email.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "email";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("xml");
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("text");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property emailAddress = new Property("transport.mail.Address");
        emailAddress.setDisplayName(this.resourceBundle.getString("transport.mail.Address"));
        emailAddress.setRequired(true);
        emailAddress.setHint(this.resourceBundle.getString("transport.mail.Address.hint"));
        propertyList.add(emailAddress);
        Property userName = new Property("mail.protocol.user");
        userName.setDisplayName(this.resourceBundle.getString("mail.protocol.user"));
        userName.setRequired(true);
        userName.setHint(this.resourceBundle.getString("mail.protocol.user.hint"));
        propertyList.add(userName);
        Property password = new Property("mail.protocol.password");
        password.setDisplayName(this.resourceBundle.getString("mail.protocol.password"));
        password.setRequired(true);
        password.setSecured(true);
        password.setEncrypted(true);
        password.setHint(this.resourceBundle.getString("mail.protocol.password.hint"));
        propertyList.add(password);
        Property subject = new Property("email.in.subject");
        subject.setDisplayName(this.resourceBundle.getString("email.in.subject"));
        subject.setRequired(true);
        subject.setHint(this.resourceBundle.getString("email.in.subject.hint"));
        propertyList.add(subject);
        Property host = new Property("mail.protocol.host");
        host.setDisplayName(this.resourceBundle.getString("mail.protocol.host"));
        host.setRequired(true);
        host.setHint(this.resourceBundle.getString("mail.protocol.host.hint"));
        propertyList.add(host);
        Property port = new Property("mail.protocol.port");
        port.setDisplayName(this.resourceBundle.getString("mail.protocol.port"));
        port.setRequired(true);
        port.setHint(this.resourceBundle.getString("mail.protocol.port.hint"));
        propertyList.add(port);
        Property protocol = new Property("transport.mail.Protocol");
        protocol.setDisplayName(this.resourceBundle.getString("transport.mail.Protocol"));
        protocol.setOptions(new String[]{"pop3", "imap"});
        protocol.setDefaultValue("imap");
        protocol.setHint(this.resourceBundle.getString("transport.mail.Protocol.hint"));
        propertyList.add(protocol);
        Property pollInterval = new Property("transport.PollInterval");
        pollInterval.setDisplayName(this.resourceBundle.getString("transport.PollInterval"));
        pollInterval.setRequired(true);
        pollInterval.setHint(this.resourceBundle.getString("transport.PollInterval.hint"));
        propertyList.add(pollInterval);
        return propertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new EmailEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

