/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.email;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;

public class EmailEventAdapter
implements InputEventAdapter {
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private InputEventAdapterListener eventAdaptorListener;
    private final String id = UUID.randomUUID().toString();
    private static final Log log = LogFactory.getLog(EmailEventAdapter.class);
    private long pollIntervalInSeconds = 5L;
    private String moveToFolderName;
    private Timer timer;
    private AtomicBoolean isThreadOccupied = new AtomicBoolean(false);
    private int tenantId;

    public EmailEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.timer = new Timer("PollTimer");
        this.moveToFolderName = globalProperties.get("moveToFolderName");
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public void init(InputEventAdapterListener eventAdaptorListener) throws InputEventAdapterException {
        this.validateInputEventAdapterConfigurations();
        this.eventAdaptorListener = eventAdaptorListener;
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        String interval = (String)this.eventAdapterConfiguration.getProperties().get("transport.PollInterval");
        if (interval != null) {
            try {
                this.pollIntervalInSeconds = Long.parseLong(interval);
            }
            catch (NumberFormatException e) {
                this.pollIntervalInSeconds = 5L;
            }
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    EmailEventAdapter.this.pollForMail();
                }
                catch (Throwable e) {
                    log.error((Object)"Unexpected error when running polling task for email adapter.", e);
                }
            }
        };
        this.timer.scheduleAtFixedRate(timerTask, this.pollIntervalInSeconds * 1000L, this.pollIntervalInSeconds * 1000L);
    }

    public void disconnect() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
    }

    public void destroy() {
    }

    public InputEventAdapterListener getEventAdaptorListener() {
        return this.eventAdaptorListener;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailEventAdapter)) {
            return false;
        }
        EmailEventAdapter that = (EmailEventAdapter)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isEventDuplicatedInCluster() {
        return false;
    }

    public boolean isPolling() {
        return true;
    }

    private Properties getServerProperties(String protocol, String host, String port) {
        Properties properties = new Properties();
        properties.put(String.format("mail.%s.host", protocol), host);
        properties.put(String.format("mail.%s.port", protocol), port);
        properties.setProperty(String.format("mail.%s.socketFactory.class", protocol), "javax.net.ssl.SSLSocketFactory");
        properties.setProperty(String.format("mail.%s.socketFactory.fallback", protocol), "false");
        properties.setProperty(String.format("mail.%s.socketFactory.port", protocol), String.valueOf(port));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollForMail() {
        if (this.isThreadOccupied.compareAndSet(false, true)) {
            String emailAddress = null;
            Store store = null;
            Folder folder = null;
            boolean connected = false;
            try {
                emailAddress = (String)this.eventAdapterConfiguration.getProperties().get("transport.mail.Address");
                String userName = (String)this.eventAdapterConfiguration.getProperties().get("mail.protocol.user");
                String password = (String)this.eventAdapterConfiguration.getProperties().get("mail.protocol.password");
                String subject = (String)this.eventAdapterConfiguration.getProperties().get("email.in.subject");
                String host = (String)this.eventAdapterConfiguration.getProperties().get("mail.protocol.host");
                String port = (String)this.eventAdapterConfiguration.getProperties().get("mail.protocol.port");
                String protocol = (String)this.eventAdapterConfiguration.getProperties().get("transport.mail.Protocol");
                Properties properties = this.getServerProperties(protocol, host, port);
                try {
                    Session session = Session.getDefaultInstance((Properties)properties);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Attempting to connect to POP3/IMAP server for : " + emailAddress + " using " + session.getProperties()));
                    }
                    store = session.getStore(protocol);
                    if (userName != null && password != null) {
                        store.connect(userName, password);
                    } else {
                        log.error((Object)"Unable to locate username and password for mail login");
                    }
                    connected = store.isConnected();
                    if (connected) {
                        folder = store.getFolder("INBOX");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error connecting to mail server for address : " + emailAddress), (Throwable)e);
                }
                if (!connected) {
                    log.warn((Object)("Connection to mail server for account : " + emailAddress + " failed. Retrying in : " + this.pollIntervalInSeconds + " seconds"));
                } else if (folder != null) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Connecting to folder : " + folder.getName() + " of email account : " + emailAddress));
                        }
                        folder.open(2);
                        int total = folder.getMessageCount();
                        Message[] messages = folder.getMessages();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(messages.length + " messages in folder : " + folder));
                        }
                        for (int i = 0; i < total; ++i) {
                            try {
                                String[] status = messages[i].getHeader("Status");
                                if (status != null && status.length == 1 && status[0].equals("RO")) {
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)("Skipping message # : " + messages[i].getMessageNumber() + " : " + messages[i].getSubject() + " - Status: RO"));
                                    continue;
                                }
                                if (messages[i].isSet(Flags.Flag.SEEN)) {
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)("Skipping message # : " + messages[i].getMessageNumber() + " : " + messages[i].getSubject() + " - already marked SEEN"));
                                    continue;
                                }
                                if (messages[i].isSet(Flags.Flag.DELETED)) {
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)("Skipping message # : " + messages[i].getMessageNumber() + " : " + messages[i].getSubject() + " - already marked DELETED"));
                                    continue;
                                }
                                this.processMessage(messages[i], subject);
                                if (!"imap".equalsIgnoreCase(protocol)) continue;
                                this.moveOrDeleteAfterProcessing(this.moveToFolderName, store, folder, messages[i]);
                                continue;
                            }
                            catch (MessageRemovedException ignore) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("Skipping message # : " + messages[i].getMessageNumber() + " as it has been DELETED by another thread after processing"));
                            }
                        }
                    }
                    catch (MessagingException me) {
                        log.error((Object)("Error checking mail for account : " + emailAddress + " :: " + me.getMessage()), (Throwable)me);
                    }
                }
                this.cleanupResources(folder, store, emailAddress);
                this.isThreadOccupied.set(false);
            }
            catch (Throwable throwable) {
                this.cleanupResources(folder, store, emailAddress);
                this.isThreadOccupied.set(false);
                throw throwable;
            }
        }
    }

    private void cleanupResources(Folder folder, Store store, String emailAddress) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing onCompletion task for the mail download of : " + emailAddress));
        }
        if (folder != null) {
            try {
                folder.close(true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Mail folder closed, and deleted mail expunged");
                }
            }
            catch (MessagingException e) {
                log.warn((Object)("Error closing mail folder : " + folder + " for account : " + emailAddress + " :: " + e.getMessage()));
            }
        }
        if (store != null) {
            try {
                store.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mail store closed for : " + emailAddress));
                }
            }
            catch (MessagingException e) {
                log.warn((Object)("Error closing mail store for account : " + emailAddress + " :: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void moveOrDeleteAfterProcessing(String moveToFolder, Store store, Folder folder, Message message) {
        try {
            if (moveToFolder != null) {
                Folder dFolder;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Moving processed email to folder :" + moveToFolder));
                }
                if (!(dFolder = store.getFolder(moveToFolder)).exists()) {
                    dFolder.create(1);
                }
                folder.copyMessages(new Message[]{message}, dFolder);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting email :" + message.getMessageNumber()));
            }
            message.setFlag(Flags.Flag.DELETED, true);
        }
        catch (MessagingException e) {
            log.error((Object)("Error deleting or resolving folder to move after processing : " + moveToFolder), (Throwable)e);
        }
    }

    private void processMessage(Message msg, String expectedSubject) {
        try {
            String mailSubject = msg.getSubject();
            if (mailSubject == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipping message because the subject field is null. Expected subject : " + expectedSubject));
                }
                return;
            }
            if (mailSubject.equalsIgnoreCase(expectedSubject)) {
                String contentType = msg.getContentType();
                if (contentType != null && contentType.toLowerCase().startsWith("text/plain")) {
                    Object content = msg.getContent();
                    this.pushEvent(content);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipping message because content type " + msg.getContentType() + " is not accepted"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping message because subject does not match expected value:" + expectedSubject));
            }
        }
        catch (MessagingException e) {
            log.error((Object)"Exception when trying to identify the content type", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Exception when trying to read the mail content", (Throwable)e);
        }
    }

    private void pushEvent(Object obj) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
            this.eventAdaptorListener.onEvent(obj);
        }
        catch (Throwable e) {
            log.error((Object)"Exception when pushing event to CEP ", e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void validateInputEventAdapterConfigurations() throws InputEventAdapterException {
        String mailAddress = (String)this.eventAdapterConfiguration.getProperties().get("transport.mail.Address");
        try {
            InternetAddress emailAddr = new InternetAddress(mailAddress);
            emailAddr.validate();
        }
        catch (AddressException e) {
            throw new InputEventAdapterException("Invalid value set for property 'Receiving Mail Address': " + mailAddress, (Throwable)e);
        }
        String pollIntervalProperty = (String)this.eventAdapterConfiguration.getProperties().get("transport.PollInterval");
        try {
            Integer.parseInt(pollIntervalProperty);
        }
        catch (NumberFormatException e) {
            throw new InputEventAdapterException("Invalid value set for property 'Poll Interval': " + pollIntervalProperty, (Throwable)e);
        }
        String portProperty = (String)this.eventAdapterConfiguration.getProperties().get("mail.protocol.port");
        try {
            Integer.parseInt(portProperty);
        }
        catch (NumberFormatException e) {
            throw new InputEventAdapterException("Invalid value set for property 'Mail Protocol Port': " + portProperty, (Throwable)e);
        }
    }
}

