/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.http.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.http.HTTPEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.http.internal.ds.HTTPEventAdapterServiceValueHolder;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="input.httpEventAdapterService.component", immediate=true)
public class HTTPEventAdapterServiceDS {
    private static final Log log = LogFactory.getLog(HTTPEventAdapterServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            HTTPEventAdapterFactory httpEventEventAdapterFactory = new HTTPEventAdapterFactory();
            context.getBundleContext().registerService(InputEventAdapterFactory.class.getName(), (Object)httpEventEventAdapterFactory, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the input HTTP adapter service");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create the input HTTP adapter service ", (Throwable)e);
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        HTTPEventAdapterServiceValueHolder.registerRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        HTTPEventAdapterServiceValueHolder.registerRealmService(null);
    }

    @Reference(name="http.service", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        HTTPEventAdapterServiceValueHolder.registerHTTPService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        HTTPEventAdapterServiceValueHolder.registerHTTPService(null);
    }
}

