/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.http.HTTPEventAdapter;
import org.wso2.carbon.event.input.adapter.http.internal.ds.HTTPEventAdapterServiceValueHolder;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class HTTPMessageServlet
extends HttpServlet {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTH_MESSAGE_STORE_TENANT_ID = "AUTH_MESSAGE_STORE_TENANT_ID";
    private static final String AUTH_FAILURE_RESPONSE = "_AUTH_FAILURE_";
    private static Log log = LogFactory.getLog(HTTPMessageServlet.class);
    private InputEventAdapterListener eventAdaptorListener;
    private int tenantId;
    private String exposedTransports;
    private boolean isBasicAuthEnabled;

    public HTTPMessageServlet(InputEventAdapterListener eventAdaptorListener, int tenantId, String exposedTransports, boolean isBasicAuthEnabled) {
        this.eventAdaptorListener = eventAdaptorListener;
        this.tenantId = tenantId;
        this.exposedTransports = exposedTransports;
        this.isBasicAuthEnabled = isBasicAuthEnabled;
    }

    private String[] getUserPassword(HttpServletRequest req) {
        String authHeader = req.getHeader(AUTHORIZATION_HEADER);
        if (authHeader == null) {
            return null;
        }
        if (!authHeader.startsWith("Basic ")) {
            return null;
        }
        String[] userPassword = new String(Base64.decode((String)authHeader.substring(6))).split(":");
        if (userPassword.length != 2) {
            return null;
        }
        return userPassword;
    }

    private int checkAuthentication(HttpServletRequest req) {
        Object tidObj = req.getSession().getAttribute(AUTH_MESSAGE_STORE_TENANT_ID);
        if (tidObj != null) {
            return (Integer)tidObj;
        }
        String[] userPassword = this.getUserPassword(req);
        if (userPassword == null) {
            return -1;
        }
        String username = userPassword[0];
        String password = userPassword[1];
        String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
        String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)username);
        username = (tenantAwareUserName + "@" + tenantDomain).toLowerCase();
        RealmService realmService = HTTPEventAdapterServiceValueHolder.getRealmService();
        try {
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            if (tenantId == -1) {
                return -1;
            }
            UserStoreManager usm = realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            boolean success = usm.authenticate(tenantAwareUserName, (Object)password);
            if (success) {
                req.getSession().setAttribute(AUTH_MESSAGE_STORE_TENANT_ID, (Object)tenantId);
                return tenantId;
            }
            return -1;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("checkAuthentication() fail: " + e.getMessage()), (Throwable)e);
            }
            return -1;
        }
    }

    private String inputStreamToString(InputStream in) throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((i = in.read(buff)) > 0) {
            out.write(buff, 0, i);
        }
        out.close();
        return out.toString();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String data = this.inputStreamToString((InputStream)req.getInputStream());
        if (data == null) {
            log.warn((Object)"Event Object is empty/null");
            return;
        }
        if (this.exposedTransports.equalsIgnoreCase("https")) {
            if (!req.isSecure()) {
                res.setStatus(403);
                log.error((Object)"Only Secured endpoint is enabled for requests");
                return;
            }
            if (this.isBasicAuthEnabled) {
                int tenantId = this.checkAuthentication(req);
                if (tenantId == -1) {
                    res.getOutputStream().write(AUTH_FAILURE_RESPONSE.getBytes());
                    res.setStatus(401);
                    log.error((Object)"Authentication failed for the request");
                    return;
                }
                if (tenantId != this.tenantId) {
                    res.getOutputStream().write(AUTH_FAILURE_RESPONSE.getBytes());
                    res.setStatus(401);
                    log.error((Object)"Authentication failed for the request");
                    return;
                }
            }
        } else if (this.exposedTransports.equalsIgnoreCase("http")) {
            if (req.isSecure()) {
                res.setStatus(403);
                log.error((Object)"Only unsecured endpoint is enabled for requests");
                return;
            }
        } else if (req.isSecure() && this.isBasicAuthEnabled) {
            int tenantId = this.checkAuthentication(req);
            if (tenantId == -1) {
                res.getOutputStream().write(AUTH_FAILURE_RESPONSE.getBytes());
                res.setStatus(401);
                log.error((Object)"Authentication failed for the request");
                return;
            }
            if (tenantId != this.tenantId) {
                res.getOutputStream().write(AUTH_FAILURE_RESPONSE.getBytes());
                res.setStatus(401);
                log.error((Object)"Authentication failed for the request");
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message : " + data));
        }
        HTTPEventAdapter.executorService.submit(new HTTPRequestProcessor(this.eventAdaptorListener, data, this.tenantId));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.doPost(req, res);
    }

    public class HTTPRequestProcessor
    implements Runnable {
        private InputEventAdapterListener inputEventAdapterListener;
        private String payload;
        private int tenantId;

        public HTTPRequestProcessor(InputEventAdapterListener inputEventAdapterListener, String payload, int tenantId) {
            this.inputEventAdapterListener = inputEventAdapterListener;
            this.payload = payload;
            this.tenantId = tenantId;
        }

        @Override
        public void run() {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in HTTP Event Adapter - " + this.payload));
                }
                if (this.payload.trim() != null) {
                    this.inputEventAdapterListener.onEvent((Object)this.payload);
                } else {
                    log.warn((Object)"Dropping the empty/null event received through http adapter");
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while parsing http request for processing: " + e.getMessage()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }
}

