/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.http.HTTPEventAdapter;
import org.wso2.carbon.utils.CarbonUtils;

public class HTTPEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.http.i18n.Resources", Locale.getDefault());
    private int httpPort;
    private int httpsPort;
    private int portOffset = this.getPortOffset();

    public HTTPEventAdapterFactory() {
        this.httpPort = 9763 + this.portOffset;
        this.httpsPort = 9443 + this.portOffset;
    }

    public String getType() {
        return "http";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("xml");
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("text");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property exposedTransportsProperty = new Property("transports");
        exposedTransportsProperty.setRequired(true);
        exposedTransportsProperty.setDisplayName(this.resourceBundle.getString("transports"));
        exposedTransportsProperty.setOptions(new String[]{"https", "http", "local", "all"});
        exposedTransportsProperty.setDefaultValue("all");
        Property basicAuthEnabledProperty = new Property("basicAuthEnabled");
        basicAuthEnabledProperty.setRequired(false);
        basicAuthEnabledProperty.setOptions(new String[]{"true", "false"});
        basicAuthEnabledProperty.setDefaultValue("true");
        basicAuthEnabledProperty.setDisplayName(this.resourceBundle.getString("basicAuthEnabled"));
        propertyList.add(exposedTransportsProperty);
        propertyList.add(basicAuthEnabledProperty);
        return propertyList;
    }

    public String getUsageTips() {
        return this.resourceBundle.getString("http.usage.tips_prefix") + this.httpPort + this.resourceBundle.getString("http.usage.tips_mid1") + this.httpsPort + this.resourceBundle.getString("http.usage.tips_mid2") + this.httpPort + this.resourceBundle.getString("http.usage.tips_mid3") + this.httpsPort + this.resourceBundle.getString("http.usage.tips_postfix");
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new HTTPEventAdapter(eventAdapterConfiguration, globalProperties);
    }

    private int getPortOffset() {
        return CarbonUtils.getPortFromServerConfig((String)"Ports.Offset") + 1;
    }
}

