/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.http;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.http.HTTPMessageServlet;
import org.wso2.carbon.event.input.adapter.http.internal.ds.HTTPEventAdapterServiceValueHolder;

public final class HTTPEventAdapter
implements InputEventAdapter {
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private InputEventAdapterListener eventAdaptorListener;
    private final String id = UUID.randomUUID().toString();
    public static ExecutorService executorService;
    private static final Log log;
    private boolean isConnected = false;

    public HTTPEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init(InputEventAdapterListener eventAdaptorListener) throws InputEventAdapterException {
        this.eventAdaptorListener = eventAdaptorListener;
        if (executorService == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 10000;
            RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)("Exception while adding event to executor queue : " + e.getMessage()), (Throwable)e);
                    }
                }
            };
            executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueueSize), new ThreadFactoryBuilder().setNameFormat("Thread pool- component - HTTPEventAdapter.executorService;adapterName - " + this.eventAdapterConfiguration.getName()).build(), rejectedExecutionHandler);
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        this.registerDynamicEndpoint(this.eventAdapterConfiguration.getName());
        this.isConnected = true;
    }

    public void disconnect() {
        if (this.isConnected) {
            this.isConnected = false;
            this.unregisterDynamicEndpoint(this.eventAdapterConfiguration.getName());
        }
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HTTPEventAdapter)) {
            return false;
        }
        HTTPEventAdapter that = (HTTPEventAdapter)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isEventDuplicatedInCluster() {
        return false;
    }

    public boolean isPolling() {
        return false;
    }

    private void registerDynamicEndpoint(String adapterName) {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String endpoint = "carbon.super".equals(tenantDomain) ? "/endpoints/" + adapterName : "/endpoints/t/" + tenantDomain + "/" + adapterName;
        try {
            HttpService httpService;
            String basicAuthEnabledValue = (String)this.eventAdapterConfiguration.getProperties().get("basicAuthEnabled");
            boolean isBasicAuthEnabled = true;
            if (basicAuthEnabledValue != null) {
                isBasicAuthEnabled = Boolean.parseBoolean(basicAuthEnabledValue);
            }
            if ((httpService = HTTPEventAdapterServiceValueHolder.getHTTPService()) == null) {
                throw new InputEventAdapterRuntimeException("HttpService not available, Error in registering endpoint " + endpoint);
            }
            httpService.registerServlet(endpoint, (Servlet)new HTTPMessageServlet(this.eventAdaptorListener, tenantId, (String)this.eventAdapterConfiguration.getProperties().get("transports"), isBasicAuthEnabled), new Hashtable(), httpService.createDefaultHttpContext());
        }
        catch (ServletException | NamespaceException e) {
            throw new InputEventAdapterRuntimeException("Error in registering endpoint " + endpoint, e);
        }
    }

    private void unregisterDynamicEndpoint(String adapterName) {
        HttpService httpService = HTTPEventAdapterServiceValueHolder.getHTTPService();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String endpoint = "carbon.super".equals(tenantDomain) ? "/endpoints/" + adapterName : "/endpoints/t/" + tenantDomain + "/" + adapterName;
        if (httpService != null) {
            httpService.unregister(endpoint);
        }
    }

    static {
        log = LogFactory.getLog(HTTPEventAdapter.class);
    }
}

