/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.mqtt.internal.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.event.input.adapter.mqtt.internal.util.MQTTBrokerConnectionConfiguration;
import org.wso2.carbon.event.input.adapter.mqtt.internal.util.MQTTEventAdapterConstants;

public class MQTTAdapterListener
implements MqttCallback,
Runnable {
    private static final Log log = LogFactory.getLog(MQTTAdapterListener.class);
    private MqttClient mqttClient;
    private MqttConnectOptions connectionOptions;
    private boolean cleanSession;
    private int keepAlive;
    private MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration;
    private String mqttClientId;
    private String topic;
    private int tenantId;
    private boolean connectionSucceeded = false;
    private InputEventAdapterListener eventAdapterListener = null;

    public MQTTAdapterListener(MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration, String topic, String mqttClientId, InputEventAdapterListener inputEventAdapterListener, int tenantId) {
        if (mqttClientId == null || mqttClientId.trim().isEmpty()) {
            mqttClientId = MqttClient.generateClientId();
        }
        this.mqttClientId = mqttClientId;
        this.mqttBrokerConnectionConfiguration = mqttBrokerConnectionConfiguration;
        this.cleanSession = mqttBrokerConnectionConfiguration.isCleanSession();
        this.keepAlive = mqttBrokerConnectionConfiguration.getKeepAlive();
        this.topic = topic;
        this.eventAdapterListener = inputEventAdapterListener;
        this.tenantId = tenantId;
        String temp_directory = System.getProperty("java.io.tmpdir");
        MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(temp_directory);
        try {
            this.connectionOptions = new MqttConnectOptions();
            this.connectionOptions.setCleanSession(this.cleanSession);
            this.connectionOptions.setKeepAliveInterval(this.keepAlive);
            if (this.mqttBrokerConnectionConfiguration.getBrokerPassword() != null) {
                this.connectionOptions.setPassword(this.mqttBrokerConnectionConfiguration.getBrokerPassword().toCharArray());
            }
            if (this.mqttBrokerConnectionConfiguration.getBrokerUsername() != null) {
                this.connectionOptions.setUserName(this.mqttBrokerConnectionConfiguration.getBrokerUsername());
            }
            this.mqttClient = new MqttClient(this.mqttBrokerConnectionConfiguration.getBrokerUrl(), this.mqttClientId, (MqttClientPersistence)dataStore);
            this.mqttClient.setCallback((MqttCallback)this);
        }
        catch (MqttException e) {
            log.error((Object)("Exception occurred while subscribing to MQTT broker at " + mqttBrokerConnectionConfiguration.getBrokerUrl()));
            throw new InputEventAdapterRuntimeException((Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)("Exception occurred while subscribing to MQTT broker at " + mqttBrokerConnectionConfiguration.getBrokerUrl()));
            throw new InputEventAdapterRuntimeException(e);
        }
    }

    public void startListener() throws MqttException {
        this.mqttClient.connect(this.connectionOptions);
        this.mqttClient.subscribe(this.topic);
    }

    public void stopListener(String adapterName) {
        if (this.connectionSucceeded) {
            try {
                if (!ServerStatus.getCurrentStatus().equals("SHUTTING_DOWN") || this.cleanSession) {
                    this.mqttClient.unsubscribe(this.topic);
                }
                this.mqttClient.disconnect(3000L);
            }
            catch (MqttException e) {
                log.error((Object)("Can not unsubscribe from the destination " + this.topic + " with the event adapter " + adapterName), (Throwable)e);
            }
        }
        this.connectionSucceeded = true;
    }

    public void connectionLost(Throwable throwable) {
        log.warn((Object)("MQTT connection not reachable " + throwable));
        this.connectionSucceeded = false;
        new Thread(this).start();
    }

    public void messageArrived(String s, MqttMessage mqttMessage) throws Exception {
        try {
            String msgText = mqttMessage.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)msgText);
            }
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event received in MQTT Event Adapter - " + msgText));
            }
            this.eventAdapterListener.onEvent((Object)msgText);
        }
        catch (InputEventAdapterRuntimeException e) {
            throw new InputEventAdapterRuntimeException((Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    @Override
    public void run() {
        while (!this.connectionSucceeded) {
            try {
                Thread.sleep(MQTTEventAdapterConstants.initialReconnectDuration *= 2);
                this.startListener();
                this.connectionSucceeded = true;
                log.info((Object)"MQTT Connection successful");
            }
            catch (InterruptedException e) {
                log.error((Object)"Interruption occurred while waiting for reconnection", (Throwable)e);
            }
            catch (MqttException e) {
                log.error((Object)"MQTT Exception occurred when starting listener", (Throwable)e);
            }
        }
    }

    public void createConnection() {
        new Thread(this).start();
    }
}

