/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.mqtt;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.mqtt.MQTTEventAdapter;

public class MQTTEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.mqtt.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "mqtt";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("text");
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("xml");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property topicProperty = new Property("topic");
        topicProperty.setDisplayName(this.resourceBundle.getString("topic"));
        topicProperty.setRequired(true);
        topicProperty.setHint(this.resourceBundle.getString("topic.hint"));
        propertyList.add(topicProperty);
        Property brokerUrl = new Property("url");
        brokerUrl.setDisplayName(this.resourceBundle.getString("url"));
        brokerUrl.setRequired(true);
        brokerUrl.setHint(this.resourceBundle.getString("url.hint"));
        propertyList.add(brokerUrl);
        Property userName = new Property("username");
        userName.setDisplayName(this.resourceBundle.getString("username"));
        userName.setRequired(false);
        userName.setHint(this.resourceBundle.getString("username.hint"));
        propertyList.add(userName);
        Property password = new Property("password");
        password.setDisplayName(this.resourceBundle.getString("password"));
        password.setSecured(true);
        password.setEncrypted(true);
        password.setRequired(false);
        password.setHint(this.resourceBundle.getString("password.hint"));
        propertyList.add(password);
        Property clearSession = new Property("cleanSession");
        clearSession.setDisplayName(this.resourceBundle.getString("cleanSession"));
        clearSession.setRequired(false);
        clearSession.setOptions(new String[]{"true", "false"});
        clearSession.setDefaultValue("true");
        clearSession.setHint(this.resourceBundle.getString("cleanSession.hint"));
        propertyList.add(clearSession);
        Property clientId = new Property("clientId");
        clientId.setDisplayName(this.resourceBundle.getString("clientId"));
        clientId.setRequired(false);
        clientId.setHint(this.resourceBundle.getString("clientId.hint"));
        propertyList.add(clientId);
        return propertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new MQTTEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

