/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.mqtt;

import java.util.Map;
import java.util.UUID;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.mqtt.internal.util.MQTTAdapterListener;
import org.wso2.carbon.event.input.adapter.mqtt.internal.util.MQTTBrokerConnectionConfiguration;

public class MQTTEventAdapter
implements InputEventAdapter {
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private InputEventAdapterListener eventAdapterListener;
    private final Map<String, String> globalProperties;
    private final String id = UUID.randomUUID().toString();
    private MQTTAdapterListener mqttAdapterListener;
    private MQTTBrokerConnectionConfiguration mqttBrokerConnectionConfiguration;

    public MQTTEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
    }

    public void init(InputEventAdapterListener eventAdapterListener) throws InputEventAdapterException {
        this.eventAdapterListener = eventAdapterListener;
        try {
            int keepAlive = this.globalProperties.get("keepAlive") != null ? Integer.parseInt(this.globalProperties.get("keepAlive")) : 60000;
            this.mqttBrokerConnectionConfiguration = new MQTTBrokerConnectionConfiguration((String)this.eventAdapterConfiguration.getProperties().get("url"), (String)this.eventAdapterConfiguration.getProperties().get("username"), (String)this.eventAdapterConfiguration.getProperties().get("password"), (String)this.eventAdapterConfiguration.getProperties().get("cleanSession"), String.valueOf(keepAlive));
            this.mqttAdapterListener = new MQTTAdapterListener(this.mqttBrokerConnectionConfiguration, (String)this.eventAdapterConfiguration.getProperties().get("topic"), (String)this.eventAdapterConfiguration.getProperties().get("clientId"), eventAdapterListener, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        }
        catch (Throwable t) {
            throw new InputEventAdapterException(t.getMessage(), t);
        }
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("not-supported");
    }

    public void connect() {
        this.mqttAdapterListener.createConnection();
    }

    public void disconnect() {
        if (this.mqttAdapterListener != null) {
            this.mqttAdapterListener.stopListener(this.eventAdapterConfiguration.getName());
        }
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MQTTEventAdapter)) {
            return false;
        }
        MQTTEventAdapter that = (MQTTEventAdapter)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isEventDuplicatedInCluster() {
        return true;
    }

    public boolean isPolling() {
        return true;
    }
}

