/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.authenticator.proxy;

import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.authenticator.stub.RememberMeData;
import org.wso2.carbon.core.common.AuthenticationException;

public class AuthenticationAdminClient {
    private static final Log log = LogFactory.getLog(AuthenticationAdminClient.class);
    private static final String USER_NOT_FOUND_ERROR_CODE = "17001";
    private static final String ACCOUNT_LOCK_ERROR_CODE = "17003";
    private AuthenticationAdminStub stub;
    private HttpSession session;
    private boolean doManageSession;
    private static final String ACCOUNT_LOCK_ERROR_MESSAGE = "Cannot login until the account is unlocked.";

    public AuthenticationAdminClient(ConfigurationContext ctx, String serverURL, String cookie, HttpSession session, boolean doManageSession) throws AxisFault {
        this.session = session;
        this.doManageSession = doManageSession;
        String serviceEPR = serverURL + "AuthenticationAdmin";
        this.stub = new AuthenticationAdminStub(ctx, serviceEPR);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(this.doManageSession);
        if (cookie != null && this.doManageSession) {
            options.setProperty("Cookie", (Object)cookie);
        }
    }

    public boolean login(String username, String password, String remoteAddress) throws AuthenticationException {
        try {
            boolean result = this.stub.login(username, password, remoteAddress);
            this.setAdminCookie(result, null);
            return result;
        }
        catch (Exception e) {
            String msg = "Error occurred while logging in";
            if (e.getMessage() == null || !e.getMessage().contains(USER_NOT_FOUND_ERROR_CODE) && !e.getMessage().contains(ACCOUNT_LOCK_ERROR_CODE) && !e.getMessage().contains(ACCOUNT_LOCK_ERROR_MESSAGE)) {
                log.error((Object)msg, (Throwable)e);
            }
            throw new AuthenticationException((Throwable)e);
        }
    }

    public RememberMeData loginWithRememberMeOption(String username, String password, String remoteAddress) throws AuthenticationException {
        try {
            RememberMeData data = this.stub.loginWithRememberMeOption(username, password, remoteAddress);
            if (data != null && data.getValue() != null && data.getValue().length() > 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(13, data.getMaxAge());
                Date date = calendar.getTime();
                String expires = date.toString();
                String rmeCookieString = "wso2.carbon.rememberme=" + data.getValue() + "; Expires=" + expires + "; Secure;  Path=/;";
                this.setAdminCookie(true, rmeCookieString);
            }
            return data;
        }
        catch (Exception e) {
            String msg = "Error occurred while logging in";
            log.error((Object)msg, (Throwable)e);
            throw new AuthenticationException((Throwable)e);
        }
    }

    public boolean loginWithRememberMeCookie(String rememberMeString) throws AuthenticationException {
        try {
            if (this.stub.loginWithRememberMeCookie(rememberMeString)) {
                this.setAdminCookie(true, rememberMeString);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthenticationException((Throwable)e);
        }
    }

    public String getAdminCookie() {
        return (String)this.stub._getServiceClient().getServiceContext().getProperty("Cookie");
    }

    private void setAdminCookie(boolean result, String rmeCookie) throws AxisFault {
        if (result && this.doManageSession) {
            String cookie = (String)this.stub._getServiceClient().getServiceContext().getProperty("Cookie");
            if (rmeCookie != null) {
                cookie = cookie + "; " + rmeCookie;
            }
            if (this.session != null) {
                this.session.setAttribute("wso2carbon.admin.service.cookie", (Object)cookie);
            }
        }
    }

    public void logout() throws AuthenticationException {
        try {
            this.session.removeAttribute("wso2carbon.admin.service.cookie");
            this.stub.logout();
        }
        catch (Exception e) {
            String msg = "Error occurred while logging out";
            log.error((Object)msg, (Throwable)e);
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }
}

