/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.keystore.mgt;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.keystore.mgt.KeyStoreMgtException;
import org.wso2.carbon.keystore.mgt.util.RealmServiceHolder;
import org.wso2.carbon.keystore.mgt.util.RegistryServiceHolder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class KeyStoreGenerator {
    private static Log log = LogFactory.getLog(KeyStoreGenerator.class);
    private UserRegistry govRegistry;
    private int tenantId;
    private String tenantDomain;
    private String password;

    public KeyStoreGenerator(int tenantId) throws KeyStoreMgtException {
        try {
            this.tenantId = tenantId;
            this.tenantDomain = this.getTenantDomainName();
            this.govRegistry = RegistryServiceHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
            if (this.govRegistry == null) {
                log.error((Object)"Governance registry instance is null");
                throw new KeyStoreMgtException("Governance registry instance is null");
            }
        }
        catch (RegistryException e) {
            String errorMsg = "Error while obtaining the governance registry for tenant : " + tenantId;
            log.error((Object)errorMsg, (Throwable)e);
            throw new KeyStoreMgtException(errorMsg, e);
        }
    }

    public void generateKeyStore() throws KeyStoreMgtException {
        try {
            this.password = this.generatePassword();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, this.password.toCharArray());
            X509Certificate pubCert = this.generateKeyPair(keyStore);
            this.persistKeyStore(keyStore, pubCert);
        }
        catch (Exception e) {
            String msg = "Error while instantiating a keystore";
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
    }

    public void generateTrustStore(String trustStoreName) throws KeyStoreMgtException {
        try {
            this.password = this.generatePassword();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, this.password.toCharArray());
            this.persistTrustStore(keyStore, trustStoreName);
        }
        catch (Exception e) {
            String msg = "Error while instantiating a keystore";
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
    }

    public boolean isKeyStoreExists(int tenantId) throws KeyStoreMgtException {
        String keyStoreName = this.generateKSNameFromDomainName();
        boolean isKeyStoreExists = false;
        try {
            isKeyStoreExists = this.govRegistry.resourceExists("/repository/security/key-stores/" + keyStoreName);
        }
        catch (RegistryException e) {
            String msg = "Error while checking the existance of keystore.  ";
            log.error((Object)(msg + e.getMessage()));
        }
        return isKeyStoreExists;
    }

    private X509Certificate generateKeyPair(KeyStore keyStore) throws KeyStoreMgtException {
        try {
            CryptoUtil.getDefaultCryptoUtil();
            KeyPairGenerator keyPairGenerator = null;
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            String commonName = "CN=" + this.tenantDomain + ", OU=None, O=None L=None, C=None";
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("MD5WithRSAEncryption");
            AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
            AsymmetricKeyParameter privateKeyAsymKeyParam = PrivateKeyFactory.createKey((byte[])keyPair.getPrivate().getEncoded());
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(privateKeyAsymKeyParam);
            Date notBefore = new Date(System.currentTimeMillis() - 2592000000L);
            Date notAfter = new Date(System.currentTimeMillis() + 315360000000L);
            X509v3CertificateBuilder v3CertBuilder = new X509v3CertificateBuilder(new X500Name(commonName), BigInteger.valueOf(new SecureRandom().nextInt()), notBefore, notAfter, new X500Name(commonName), subPubKeyInfo);
            X509CertificateHolder certificateHolder = v3CertBuilder.build(sigGen);
            X509Certificate PKCertificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateHolder);
            keyStore.setKeyEntry(this.tenantDomain, keyPair.getPrivate(), this.password.toCharArray(), new Certificate[]{PKCertificate});
            return PKCertificate;
        }
        catch (Exception ex) {
            String msg = "Error while generating the certificate for tenant :" + this.tenantDomain + ".";
            log.error((Object)msg, (Throwable)ex);
            throw new KeyStoreMgtException(msg, ex);
        }
    }

    private void persistKeyStore(KeyStore keyStore, X509Certificate PKCertificate) throws KeyStoreMgtException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            keyStore.store(outputStream, this.password.toCharArray());
            outputStream.flush();
            outputStream.close();
            String keyStoreName = this.generateKSNameFromDomainName();
            KeyStoreAdmin keystoreAdmin = new KeyStoreAdmin(this.tenantId, (Registry)this.govRegistry);
            keystoreAdmin.addKeyStore(outputStream.toByteArray(), keyStoreName, this.password, " ", "JKS", this.password);
            Resource pubKeyResource = this.govRegistry.newResource();
            pubKeyResource.setContent((Object)PKCertificate.getEncoded());
            pubKeyResource.addProperty("tenant.pub.key.file.name.appender", this.generatePubKeyFileNameAppender());
            this.govRegistry.put("/repository/security/pub-key", pubKeyResource);
            this.govRegistry.addAssociation("/repository/security/key-stores/" + keyStoreName, "/repository/security/pub-key", "assoc.tenant.ks.pub.key");
        }
        catch (RegistryException e) {
            String msg = "Error when writing the keystore/pub.cert to registry";
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
        catch (Exception e) {
            String msg = "Error when processing keystore/pub. cert to be stored in registry";
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
    }

    private void persistTrustStore(KeyStore trustStore, String trustStoreName) throws KeyStoreMgtException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            trustStore.store(outputStream, this.password.toCharArray());
            outputStream.flush();
            outputStream.close();
            KeyStoreAdmin keystoreAdmin = new KeyStoreAdmin(this.tenantId, (Registry)this.govRegistry);
            keystoreAdmin.addTrustStore(outputStream.toByteArray(), trustStoreName, this.password, " ", "JKS");
        }
        catch (Exception e) {
            String msg = "Error when processing keystore/pub. cert to be stored in registry";
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
    }

    private String generatePassword() {
        SecureRandom random = new SecureRandom();
        String randString = new BigInteger(130, random).toString(12);
        return randString.substring(randString.length() - 10, randString.length());
    }

    private String generatePubKeyFileNameAppender() {
        String uuid = UUIDGenerator.getUUID();
        return uuid.substring(uuid.length() - 6, uuid.length() - 1);
    }

    private String generateKSNameFromDomainName() {
        String ksName = this.tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }

    private String getTenantDomainName() throws KeyStoreMgtException {
        RealmService realmService = RealmServiceHolder.getRealmService();
        if (realmService == null) {
            String msg = "Error in getting the domain name, realm service is null.";
            log.error((Object)msg);
            throw new KeyStoreMgtException(msg);
        }
        try {
            return realmService.getTenantManager().getDomain(this.tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the domain name for the tenant id: " + this.tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
    }
}

