/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.servlet.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.abdera.protocol.server.servlet.AbderaServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.registry.app.ResourceServlet;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.servlet.UDDIServlet;
import org.wso2.carbon.utils.CarbonUtils;

@Component(name="org.wso2.carbon.registry.servlet", immediate=true)
public class RegistryAtomServiceComponent {
    private static Log log = LogFactory.getLog(RegistryAtomServiceComponent.class);
    private RegistryService registryService = null;
    private HttpService httpService = null;
    private UDDIServlet juddiRegistryServlet = null;
    private boolean juddiRegistryServletRegistered = false;
    private HttpContext defaultHttpContext = null;

    @Activate
    protected void activate(ComponentContext context) {
        try {
            this.registerServlet();
            log.debug((Object)"******* Registry APP bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Failed to activate Registry APP bundle ******* ", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.httpService.unregister("/registry/atom");
        this.httpService.unregister("/registry/tags");
        this.httpService.unregister("/registry/resource");
        if (this.juddiRegistryServletRegistered) {
            this.httpService.unregister("/juddiv3");
            this.juddiRegistryServletRegistered = false;
        }
        log.debug((Object)"******* Registry APP bundle is deactivated ******* ");
    }

    private void registerServlet() throws Exception {
        if (this.registryService == null) {
            String msg = "Unable to Register Servlet. Registry Service Not Found.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        if (!CarbonUtils.isRemoteRegistry()) {
            Hashtable<String, String> servletParam = new Hashtable<String, String>(2);
            ((Dictionary)servletParam).put("org.apache.abdera.protocol.server.Provider", "org.wso2.carbon.registry.app.RegistryProvider");
            this.httpService.registerServlet("/registry/atom", (Servlet)new AbderaServlet(), servletParam, this.defaultHttpContext);
            this.httpService.registerServlet("/registry/tags", (Servlet)new AbderaServlet(), servletParam, this.defaultHttpContext);
        }
        this.registerJUDDIServlet();
        this.httpService.registerServlet("/registry/resource", (Servlet)new ResourceServlet(), null, this.defaultHttpContext);
    }

    private void registerJUDDIServlet() {
        if (this.juddiRegistryServlet != null && this.httpService != null) {
            try {
                this.httpService.registerServlet("/juddiv3", (Servlet)this.juddiRegistryServlet, null, this.defaultHttpContext);
            }
            catch (Exception e) {
                log.error((Object)"Unable to register jUDDI servlet", (Throwable)e);
            }
            this.juddiRegistryServletRegistered = true;
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.registryService = null;
    }

    @Reference(name="http.service", service=HttpService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
        this.defaultHttpContext = httpService.createDefaultHttpContext();
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    @Reference(name="registry.uddi", service=UDDIServlet.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetJUDDIRegistryServlet")
    protected void setJUDDIRegistryServlet(UDDIServlet juddiRegistryServlet) {
        this.juddiRegistryServlet = juddiRegistryServlet;
        this.registerJUDDIServlet();
    }

    protected void unsetJUDDIRegistryServlet(UDDIServlet juddiRegistryServlet) {
        this.juddiRegistryServlet = null;
    }
}

